# -*- coding: utf-8 -*-
"""
Created on Tue Nov 18 09:14:39 2025
This is the code to process the CenBASE data
Note: the processing is based on 10-min EC flux data
@author: ydong
"""
# 
import os
import sys
from pathlib import Path
import numpy as np
import pandas as pd
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.dates as mdates
import scipy
from scipy.io import loadmat
from scipy import interpolate
from scipy.optimize import curve_fit,minimize
from scipy.stats import linregress
import scipy.signal as sig
import scipy.io as scio
from scipy.interpolate import RegularGridInterpolator as RGI
import sympy
from sympy import symbols, Eq, solve,re
import datetime as dt
from datetime import datetime
import time, math, glob, csv
from netCDF4 import Dataset
from sklearn.metrics import mean_squared_error, r2_score
from sklearn.linear_model import LinearRegression
from sklearn.gaussian_process import GaussianProcessRegressor
from sklearn.gaussian_process.kernels import RBF, ConstantKernel as C, WhiteKernel
from sklearn.preprocessing import StandardScaler
import xarray as xr
from mpl_toolkits.basemap import Basemap
os.chdir('C:/Users/ydong/Python Scripts/Humboldt')
#
# In[Define functions that will be used]
def file_read(filePath,headerline=0):
  import numpy as np  
  import datetime as dt
  with open(filePath,'r') as f:
    contents_bak = f.readlines()[headerline::1]
    if len(contents_bak[0]) ==1 :
        contents = contents_bak[1::2]
    elif len(contents_bak[1]) ==1:
        contents = contents_bak[0::2]
    else:
        contents = contents_bak
        
  var_len = len(contents[0].split('\t'))
  var = np.zeros((len(contents),var_len))
  for i in range(0,var_len):
    var[:,i] = np.array([float(row.split('\t')[i]) for row in contents]) 
       
  return var
# 
# 
def func_010(x, a, b):
  return a * x
def func_011(x, a, b):
  return a * x + b
def func_201(x, a, b, c):
  return a * x**2 + c
def func_211(x, a, b, c):
  return a * x**2 + b * x + c
def func_e(x, a, b, c):
  return a * x**b + c
def func_e0(x, a, b):
  return a * x**b
def func_e_dec(x, a, b, c):
  return 1-a * np.exp(-b*x) 
# 
def data_fit_CenBASE(var1, var2, ifbin, fit_method,interv,ave_min):
  from sklearn.metrics import mean_squared_error, r2_score
  from scipy.optimize import curve_fit
  import numpy as np
  max_var = int(np.ceil(np.nanmax(var1))); 
  min_var = int(np.floor(np.nanmin(var1)))
  var2_std = np.zeros(int((max_var - min_var)/interv)+1); 
  var2_median = np.zeros(int((max_var - min_var)/interv)+1); 
  var2_std[:] = np.nan
  var2_median[:] = np.nan
  var2_std_qc = np.nan
  var2_median_qc = np.nan
  var1_range = np.arange(min_var, max_var, 0.1)
  R2 = np.nan
  if ifbin == 0:
      var1_qc = var1[np.where((np.isnan(var1)==0)&(np.isnan(var2)==0))]
      var2_qc = var2[np.where((np.isnan(var1)==0)&(np.isnan(var2)==0))]
      popt, pcov = curve_fit(fit_method, var1_qc, var2_qc)
      if len(popt)==4:
          var_fit = fit_method(var1_range, popt[0], popt[1], popt[2], popt[3])
          R2 = r2_score(var2_qc, fit_method(var1_qc, popt[0], popt[1], popt[2], popt[3]))

      elif len(popt)==3:
          var_fit = fit_method(var1_range, popt[0], popt[1], popt[2])
          R2 = r2_score(var2[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], fit_method(var1[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], popt[0], popt[1], popt[2]))

      elif len(popt)==2:
          var_fit = fit_method(var1_range, popt[0], popt[1])         
          R2 = r2_score(var2_qc, fit_method(var1_qc, popt[0], popt[1]))

  else:
    var1_bin = np.zeros(int((max_var - min_var)/interv)+1); var1_bin[:] = np.nan
    var2_bin = np.zeros(int((max_var - min_var)/interv)+1); var2_bin[:] = np.nan
    num = np.zeros(int((max_var - min_var)/interv)+1); 
    j = 0
    for i in np.arange(min_var, max_var, interv):
      num[j] = len(np.array(np.where((var1 >= i)&(var1 < i + interv)))[0])
      if num[j] >= 1: 
        if len(var2[np.where(np.isnan(var2[np.where((var1 >= i)&(var1 < i + interv))])==0)])>=2:
          var1_bin[j] = np.nanmean(var1[np.where((var1 >= i)&(var1 < i + interv))])
          var2_bin[j] = np.nanmean(var2[np.where((var1 >= i)&(var1 < i + interv))])
          var2_std[j] = np.nanstd(var2[np.where((var1 >= i)&(var1 < i + interv))])
#          /len(np.where((var1 >= i)&(var1 < i + interv))[0])      
          var2_median[j] = np.nanmedian(var2[np.where((var1 >= i)&(var1 < i + interv))])   
      j += 1
      
    var1_qc = var1_bin[np.where((np.isnan(var1_bin)==0)&(np.isnan(var2_bin)==0))]
    var2_qc = var2_bin[np.where((np.isnan(var2_bin)==0)&(np.isnan(var2_bin)==0))]
    var2_std_qc = var2_std[np.where((np.isnan(var1_bin)==0)&(np.isnan(var2_std)==0))]
    var2_median_qc = var2_median[np.where((np.isnan(var1_bin)==0)&(np.isnan(var2_std)==0))]
    ST=ave_min; ED=len(var1_qc)
    var1_qc = np.hstack((np.mean(var1_qc[:ST]),var1_qc[ST:ED]))
    var2_qc = np.hstack((np.mean(var2_qc[:ST]),var2_qc[ST:ED]))
    var2_std_qc = np.hstack((np.nanstd(var2[np.where((var1 >= 0)&(var1 < 4))]),var2_std_qc[ST:ED]))
    var2_median_qc = np.hstack((np.mean(var2_median_qc[:ST]),var2_median_qc[ST:ED]))
##-----------careful here--------
    # var2_qc = var2_median_qc  #-
#-----------careful here--------
    popt, pcov = curve_fit(fit_method, var1_qc[np.where(np.isnan(var2_qc)==0)], var2_qc[np.where(np.isnan(var2_qc)==0)])
   
    if len(popt) == 3:
        var_fit = fit_method(var1_range, popt[0],popt[1],popt[2]) 
        R2 = r2_score(var2[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], fit_method(var1[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], popt[0], popt[1], popt[2]))
    elif len(popt) == 2:
        var_fit = fit_method(var1_range, popt[0],popt[1]) 
        R2 = r2_score(var2[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], fit_method(var1[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], popt[0], popt[1]))
    elif len(popt) == 4:
        var_fit = fit_method(var1_range, popt[0],popt[1],popt[2], popt[3]) 
        R2 = r2_score(var2[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], fit_method(var1[np.where((np.isnan(var2)==0)&(np.isnan(var1)==0))], popt[0], popt[1], popt[2], popt[3]))
# 
  return var1_qc, var2_qc, var1_range, var_fit,var2_std_qc, popt, R2
# 
# 
# In[Read files]
CenBase_add = 'C:/Users/ydong/Online/08_Baltic Sea paper/Writing/Submission/'
cenBASE_file = CenBase_add + 'CenBASE observations.txt'
CenBASE_data = file_read(cenBASE_file,1)
CenBASE_DT = CenBASE_data[:,0]; CenBASE_DT = np.array([datetime.strptime(str(row),"%Y%m%d%H%M%S.%f") for row in CenBASE_DT])
CenBASE_data[1486:,:] =np.nan
CenBASE_lat = CenBASE_data[:,1]; CenBASE_lon = CenBASE_data[:,2]
CenBASE_U10N = CenBASE_data[:,3]; CenBASE_windDirection = CenBASE_data[:,4]
CenBASE_Tair = CenBASE_data[:,5]; CenBASE_SST = CenBASE_data[:,6]
CenBASE_sal = CenBASE_data[:,7]; CenBASE_Pair = CenBASE_data[:,8]
CenBASE_pco2w = CenBASE_data[:,9]; CenBASE_pco2a = CenBASE_data[:,10]
CenBASE_dpco2 = CenBASE_pco2w - CenBASE_pco2a
CenBASE_bulkco2 = CenBASE_data[:,11]; CenBASE_ECco2 = CenBASE_data[:,12]
CenBASE_K660QC = CenBASE_data[:,13]; CenBASE_ustarQC = CenBASE_data[:,14]
CenBASE_usr_COARE = CenBASE_data[:,15]; CenBASE_Hs = CenBASE_data[:,16]
CenBASE_inv_Waveage = CenBASE_data[:,17]; CenBASE_SA = CenBASE_data[:,18]
# Read Dual tracer K600 data
file_path = 'C:\\Users\ydong\\Fellowship_research\\CenBASE\\L2\\time_k600_tracer_CenBASE_ver6.csv'
df = pd.read_csv(file_path, skiprows=0, usecols=[2,3,4,5])
# Convert the selected column to a NumPy array
data_array = df.to_numpy()
dual_tracer_wind  = data_array[:,0]
dual_tracer_ustar  = data_array[:,1]
dual_tracer_k660  = data_array[:,2]*(600/660)**(0.5)
dual_tracer_err  = data_array[:,3]*(600/660)**(0.5)
# 
# In[Figure 2: Time series]
# 
fig,axe = plt.subplots(nrows = 6, ncols = 1, figsize = (9,9))
fig.subplots_adjust(right = 0.92,left = 0.11,bottom = 0.05,top = 0.995, wspace=0.1, hspace=0.07)
line1=axe[0].scatter(CenBASE_DT, CenBASE_U10N,s=6,linestyle = '-',color='#FF1F5B',linewidth=1,label='Speed')
axe[0].grid(linestyle='--',alpha=0.5)
axe[0].set_ylabel('$U$$\mathrm{_{10N}}$ (m s$\mathrm{^{-1}}$)')
axe[0].set_xticklabels([])
axe[0].set_xlim([dt.datetime(2022, 7, 4, 10, 0),dt.datetime(2022, 7, 17, 15, 0)])
axe_0 = axe[0].twinx()
line2= axe_0.scatter(CenBASE_DT, CenBASE_windDirection,color='#009ade',s=6,label='Direction')
axe_0.set_ylabel('Wind direction (o)')
axe_0.set_xticklabels([])
lines = [line1, line2]
labels = [line.get_label() for line in lines]
axe[0].legend(lines, labels, loc=3,handlelength=1.3)
axe[0].annotate('A', xy=(-0.13, 0.93),fontsize=12.5, xycoords='axes fraction', weight='bold') 	
# 
# 
axe[1].scatter(CenBASE_DT, CenBASE_SST,color='#af58ba',linewidth=1,s=6)
axe[1].scatter(CenBASE_DT, CenBASE_Tair,color='#00cd6c',linewidth=1,s=6)
axe[1].grid(linestyle='--',alpha=0.5)
axe[1].set_ylabel('Temperature ($\mathrm{^{O}}$C)')
axe[1].legend(['Water','Air' ],ncol=2,loc=2,handlelength=1.3)
axe[1].set_xlim([dt.datetime(2022, 7, 4, 10, 0),dt.datetime(2022, 7, 17, 15, 0)])
axe[1].set_xticklabels([])
axe[1].set_ylim(14,25)
axe[1].annotate('B', xy=(-0.13, 0.95),fontsize=12.5, xycoords='axes fraction', weight='bold')
# 
# 
line1 = axe[2].scatter(CenBASE_DT, CenBASE_sal,s=6,color='#B1624E',linewidth=1,label='Salinity')
axe[2].grid(linestyle='--',alpha=0.5)
axe[2].set_ylabel('Salinity (psu)')
axe[2].set_ylim(5,13)
axe[2].set_xlim([dt.datetime(2022, 7, 4, 10, 0),dt.datetime(2022, 7, 17, 15, 0)])
axe[2].set_xticklabels([])
axe_2 = axe[2].twinx()
line2 = axe_2.scatter(CenBASE_DT,CenBASE_Pair,s=6,color='#5CC8D7',linewidth=1,label='Air pressure')
axe_2.set_ylabel('Pressure (hPa)')
axe[2].set_ylim(5,10)
lines = [line1, line2]
labels = [line.get_label() for line in lines]
axe[2].legend(lines, labels, ncol=2,loc=3,handlelength=1.3)
axe[2].annotate('C', xy=(-0.13, 0.95),fontsize=12.5, xycoords='axes fraction', weight='bold')	
#
# 
line1 = axe[3].scatter(CenBASE_DT,CenBASE_pco2w,s=6,color='#F65058FF',label='$f$CO$\mathrm{_{2w}}$')
line2 = axe[3].scatter(CenBASE_DT,CenBASE_pco2a,s=6,color='#FBDE44FF',label='$f$CO$\mathrm{_{2a}}$')
axe[3].grid(linestyle='--',alpha=0.5)
axe[3].set_ylabel('$f$CO$\mathrm{_2}$ ($\mu$atm)')
axe[3].set_xlim([dt.datetime(2022, 7, 4, 10, 0),dt.datetime(2022, 7, 17, 15, 0)])
axe_3 = axe[3].twinx()
axe[3].set_xticklabels([])
line3 = axe_3.scatter(CenBASE_DT,CenBASE_dpco2,s=3,color='#28334AFF',label='$\Delta$fCO$\mathrm{_2}$')
axe_3.set_ylabel('$\Delta$$f$CO$\mathrm{_2}$ ($\mu$atm)')
lines = [line1, line2,line3]
labels = [line.get_label() for line in lines]
axe[3].legend(lines, labels, loc=6,ncol=3,handlelength=1.3)
axe[3].set_ylim([50,450])
axe_3.set_ylim([-300,-100])
axe_3.set_yticks([-300,-200,-100])
axe_3.set_yticklabels(['-300','-200','-100'])
axe[3].annotate('D', xy=(-0.13, 0.95),fontsize=12.5, xycoords='axes fraction', weight='bold')
# 
line1 = axe[4].scatter(CenBASE_DT,CenBASE_SA,color='#CBCE91FF',marker='s',label='Surfactants')
axe[4].set_ylabel('SA (mg L$\mathrm{^{-1}}$ T-X-100)')
axe[4].set_xlim([dt.datetime(2022, 7, 4, 10, 0),dt.datetime(2022, 7, 17, 15, 0)])
axe[4].grid(linestyle='--',alpha=0.5)
axe_4 = axe[4].twinx() 
line2= axe_4.scatter(CenBASE_DT,CenBASE_Hs,color='#EA738DFF',s=8,label='Significant wave height')
axe_4.set_ylabel('$H$$\mathrm{_{s}}$ (m)') 
lines = [line1, line2] 
labels = [line.get_label() for line in lines]
axe[4].legend(lines, labels, ncol=2,loc=3,handlelength=1.3)
axe[4].set_xticklabels([])
axe[4].set_ylim(0,0.75)
axe_4.set_ylim(0,1.8)
axe[4].annotate('E', xy=(-0.13, 0.95), xycoords='axes fraction', weight='bold',fontsize=12.5)
# 
axe[5].scatter(CenBASE_DT,CenBASE_bulkco2,color='#00A4CC',s=8,label='Bulk flux')
axe[5].scatter(CenBASE_DT, CenBASE_ECco2,color='#F95700',s=8,label='EC flux')
axe[5].grid(linestyle='--',alpha=0.5)
axe[5].set_ylabel('CO$\mathrm{_2}$ flux\n(mmol m$\mathrm{^{-2}}$ day$\mathrm{^{-1}}$)')
axe[5].set_xlim([dt.datetime(2022, 7, 4, 10, 0),dt.datetime(2022, 7, 17, 15, 0)])
axe[5].legend( loc=8,handlelength=1.3,ncol=2)       
axe[5].set_ylim([-100,10])
axe[5].set_xlabel('Month-day')
date_format = mdates.DateFormatter('%m-%d')
axe[5].xaxis.set_major_formatter(date_format) 
axe[5].fill_between([dt.datetime(2022, 7, 7, 14, 25),dt.datetime(2022, 7, 13, 17, 45)], [-110,-110], [10,10], color='gray', alpha=0.15)
axe[5].annotate('F', xy=(-0.13, 0.95),fontsize=12.5, xycoords='axes fraction', weight='bold')
# 
# fname = 'C:\\Users\\ydong\\Online\\08_Baltic Sea paper\\Writing\\' + 'Figure_2'
# plt.savefig(fname, dpi=300, facecolor='w', edgecolor='w',orientation='portrait', format=None,\
# transparent=False, bbox_inches=None, pad_inches=0.1)
# # 
# In[Figure 3： EC ustar and inverse wave age]
wave_OS = np.load(CenBase_add + 'wave_open_ocean.npz')
# 
id_ustar = np.where((CenBASE_U10N<13)&(np.isnan(CenBASE_ustarQC)==0))[0]
U10N_bin_ustar, ustar_bin_usr, U10N_range, ustar_fit, ustar_std, coeff, R2 = \
data_fit_CenBASE(CenBASE_U10N[id_ustar],CenBASE_ustarQC[id_ustar],ifbin=1, fit_method=func_211, interv=1,ave_min = 2)
# 
U10N_bin2, usr_bin, U10N_range2, usr_fit, usr_std, coeff_usr, R2 = \
data_fit_CenBASE(CenBASE_U10N[id_ustar],CenBASE_usr_COARE[id_ustar],ifbin=1, fit_method=func_201, interv=1,ave_min = 1)
# 
windwa_bs_bin,wa_bs_bin, U10N_range, cp_fit, wa_bs_std, coeff_wa_bs, R2_wa_bs = \
data_fit_CenBASE(CenBASE_U10N,CenBASE_inv_Waveage,ifbin=1, fit_method=func_011, interv=2,ave_min = 1)
windHs_bs_bin,Hs_bs_bin, U10N_range, cp_fit, Hs_bs_std, coeff_Hs_bs, R2_Hs_bs = \
data_fit_CenBASE(CenBASE_U10N,CenBASE_Hs,ifbin=1, fit_method=func_011, interv=2,ave_min = 1)
# 
windwa_os_bin,wa_os_bin, U10N_range, cp_fit, wa_os_std, coeff_wa_os, R2_wa_os = \
data_fit_CenBASE(wave_OS['wind'],1/wave_OS['waveage'],ifbin=1, fit_method=func_e, interv=2,ave_min = 1)
windHs_os_bin,Hs_os_bin, U10N_range, cp_fit, Hs_os_std, coeff_Hs_os, R2_Hs_os = \
data_fit_CenBASE(wave_OS['wind'],wave_OS['Hs_tot'],ifbin=1, fit_method=func_e, interv=2,ave_min = 1)
# 
usr_coare = 0.019239+0.017939*np.arange(0,12,0.5)+0.0017627*np.arange(0,12,0.5)**2+-1.2849e-05*np.arange(0,12,0.5)**3

# 
fig,axe = plt.subplots(nrows = 1, ncols = 2, figsize = (8,3.3))
fig.subplots_adjust(right = 0.985,left = 0.07,bottom = 0.15,top = 0.98, wspace=0.35, hspace=0.35)
h=axe[0].scatter(CenBASE_U10N,CenBASE_ustarQC,s=10,marker='o',color='#009ade',alpha=1,label='EC obs. (568)')
axe[0].scatter(U10N_bin_ustar[1:], ustar_bin_usr[1:],s=70,color='#f28522')
axe[0].errorbar(U10N_bin_ustar[1:], ustar_bin_usr[1:], fmt="o",markersize=7, yerr=ustar_std[1:],ecolor='#ff1f5b',color='#ff1f5b',elinewidth=1.5,capsize=3.5,label='Bin ave.')
axe[0].plot(U10N_bin2, usr_bin,color='#ff1f5b',linestyle='-',linewidth=1.2,label= 'COARE (Baltic)')
axe[0].plot(np.arange(0,12,0.5), usr_coare,color='k',linestyle='--',linewidth=1.5,label= 'COARE (Open)')
axe[0].set_ylim(0,0.65)
axe[0].set_xlim(0,12)
axe[0].set_xlabel('$U$$\mathrm{_{10N}}$ (m s$\mathrm{^{-1}}$)')
axe[0].set_ylabel('$u$$\mathrm{_{⁎}}$ (m s$\mathrm{^{-1}}$)')
handles, labels = axe[0].get_legend_handles_labels()
axe[0].legend([handles[0],handles[3],handles[1],handles[2]],[labels[0],labels[3],labels[1],labels[2]],framealpha=1, handlelength=1.1,labelspacing=0.8,loc=2,facecolor='none',fontsize='small')
axe[0].grid(linestyle='--',alpha=0.3)
axe[0].annotate('A', xy=(-0.18, 0.97),fontsize=11, xycoords='axes fraction', weight='bold')	
# 
# 
axe[1].errorbar(windwa_bs_bin,wa_bs_bin, fmt="o",markersize=8, yerr= wa_bs_std,ecolor='#ff1f5b',color='#ff1f5b',linewidth=1.0,elinewidth=1.0,capsize=3.5,label='Baltic Sea')
axe[1].errorbar(windwa_os_bin,wa_os_bin, fmt="s",markersize=7, yerr= wa_os_std,ecolor='k',color='none',markeredgecolor='k',linewidth=1.0,elinewidth=1.0,capsize=3.5,label='Open ocean')
axe[1].set_ylim(0,1.5)
axe[1].set_xlim(0,12)
axe[1].set_xlabel('$U$$\mathrm{_{10N}}$ (m s$\mathrm{^{-1}}$)')
axe[1].set_ylabel('Inverse wave age')
axe[1].legend(framealpha=1, handlelength=1.1,labelspacing=0.8,loc=2,facecolor='none',fontsize='small')
axe[1].grid(linestyle='--',alpha=0.3)
axe[1].set_yticks([0,0.3, 0.6,0.9, 1.2,1.5])
axe[1].annotate('B', xy=(-0.2, 0.97),fontsize=11, xycoords='axes fraction', weight='bold')	
# 
# fname = 'C:\\Users\\ydong\\Online\\08_Baltic Sea paper\\Writing\\' + 'Figure_3'
# plt.savefig(fname, dpi=300, facecolor='w', edgecolor='w',orientation='portrait', format=None,\
# transparent=False, bbox_inches=None, pad_inches=0.1)
# 
# 
# In[Figure 4： gas transfer velocity]
# 
id_qc = np.where(np.isnan(CenBASE_K660QC)==0)[0]
K660_Yang_i = 360000*(1.52*10**(-4) * CenBASE_ustarQC)
K660_Yang_b = 360000*(2.90*10**(-5)*CenBASE_ustarQC*CenBASE_Hs)
K660_Yang = K660_Yang_i + K660_Yang_b
# 
U10N_bin = []; K_bin = []; K_std = []; K_Yang_bin = []; K_Yang_std = []
for i in range(4,11,1):
    if i == 4:
        id_c = np.where((CenBASE_U10N>=i-4)&(CenBASE_U10N<i+1)&(np.isnan(CenBASE_K660QC)==0))
    elif i != 4 and i < 10:
        id_c = np.where((CenBASE_U10N>=i)&(CenBASE_U10N<i+1)&(np.isnan(CenBASE_K660QC)==0))
    else:
        id_c = np.where((CenBASE_U10N>=i)&(CenBASE_U10N<i+2)&(np.isnan(CenBASE_K660QC)==0))
    print(i)
    U10N_bin.append(np.nanmean(CenBASE_U10N[id_c]))
    K_bin.append(np.nanmean(CenBASE_K660QC[id_c]))
    K_std.append(np.nanstd(CenBASE_K660QC[id_c]))
    K_Yang_bin.append(np.nanmean(K660_Yang[id_c]))
    K_Yang_std.append(np.nanstd(K660_Yang[id_c]))    
# 
ustar_bin = []; K_ustar_bin = []; K_ustar_std = []; K660_Yang_b_bin = [];
Hs_bin = []; ustar_binmedian = []; K_ustar_binmedian = []
# 
for i in np.arange(0.1,0.50,0.05):
    if i < 0.4:
        id_c = np.where((CenBASE_ustarQC>=i)&(CenBASE_ustarQC<i+0.05)&(np.isnan(CenBASE_K660QC)==0))
    else:
        id_c = np.where((CenBASE_ustarQC>=i)&(CenBASE_ustarQC<i+0.15)&(np.isnan(CenBASE_K660QC)==0))
    print(i)
    ustar_bin.append(np.nanmean(CenBASE_ustarQC[id_c]))
    K_ustar_bin.append(np.nanmean(CenBASE_K660QC[id_c]))
    K660_Yang_b_bin.append(np.nanmean(K660_Yang_b[id_c]))
    ustar_binmedian.append(np.nanmedian(CenBASE_ustarQC[id_c]))
    K_ustar_binmedian.append(np.nanmedian(CenBASE_K660QC[id_c]))
    K_ustar_std.append(np.nanstd(CenBASE_K660QC[id_c]))
    Hs_bin.append(np.nanmean(CenBASE_Hs[id_c]))
# 
U10N_bin = np.array(U10N_bin);ustar_bin = np.array(ustar_bin)
K660_Yang_b_bin = np.array(K660_Yang_b_bin);K_bin = np.array(K_bin)
K_std = np.array(K_std);Hs_bin = np.array(Hs_bin)
K_ustar_bin = np.array(K_ustar_bin);K_ustar_std = np.array(K_ustar_std)
# 
fit_m = func_e
popt_u10, pcov = curve_fit(fit_m, U10N_bin[np.where(np.isnan(K_bin)==0)], K_bin[np.where(np.isnan(K_bin)==0)])
var_fit = fit_m(np.arange(0,13), popt_u10[0],popt_u10[1],popt_u10[2]) 
R2 = r2_score(CenBASE_K660QC[id_qc], fit_m(CenBASE_U10N[id_qc], popt_u10[0], popt_u10[1], popt_u10[2]))
print(popt_u10,R2)
# 
# 
fit_m_ustar = func_011
popt_ustar, pcov = curve_fit(fit_m_ustar, ustar_bin[np.where(np.isnan(ustar_bin)==0)[0]], K_ustar_bin[np.where(np.isnan(ustar_bin)==0)[0]])
var_fit = fit_m_ustar(np.arange(0.1,0.5), popt_ustar[0],popt_ustar[1]) 
R2_ustar = r2_score(CenBASE_K660QC[id_qc], fit_m_ustar(CenBASE_ustarQC[id_qc], popt_ustar[0], popt_ustar[1]))
print(popt_ustar,R2_ustar)
# 
popt_yang, pcov = curve_fit(func_e, ustar_bin, K660_Yang_b_bin)
var_fit = func_e(np.arange(0.1,0.6), popt_yang[0],popt_yang[1],popt_yang[2])
# 
label_u10 = '$K$$\mathrm{_{660}}$ = '+ str(round(popt_u10[0],2))+'$U$$\mathrm{_{10N}^{' +str(round(popt_u10[1],2))+'}}$' + ' + '+str(round(popt_u10[2],2))
label_ustar = '$K$$\mathrm{_{660}}$ = '+ str(round(popt_ustar[0],2))+'$u$$\mathrm{_{⁎}}$' + ' - '+str(-round(popt_ustar[1],2))
# 
fig,axe = plt.subplots(nrows = 1, ncols = 2, figsize = (8,3.3))
fig.subplots_adjust(right = 0.985,left = 0.07,bottom = 0.15,top = 0.98, wspace=0.35, hspace=0.35)
h=axe[0].scatter(CenBASE_U10N,CenBASE_K660QC,s=10,marker='o',color='#009ade',label='EC obs. ('+str(len(CenBASE_K660QC[id_qc])) +')')
axe[0].scatter(U10N_bin, K_bin,s=70,color='#ff1f5b',edgecolor='#ff1f5b',linewidth=1.5,zorder=3)
axe[0].errorbar(U10N_bin, K_bin, fmt="o", yerr=K_std,ecolor='#ff1f5b',color='#ff1f5b',markersize=7,elinewidth=1.1,capsize=3.5,label='EC bin averages',zorder=3)
axe[0].plot(np.arange(0,13),popt_u10[0]*np.arange(0,13)**popt_u10[1]+popt_u10[2],'#ff1f5b',linewidth=1.5,label=label_u10)
axe[0].errorbar((dual_tracer_wind), dual_tracer_k660, fmt="d", yerr=dual_tracer_err,ecolor='#ffc61e',color='#ffc61e',markeredgecolor='#ffc61e',markersize=8,elinewidth=1,capsize=3.5,label='Dual-tracer obs.',zorder=1)
axe[0].plot(np.arange(0,13),0.254*np.arange(0,13)**2,linestyle = '--',color='C1',linewidth=1.5,label='Ho et al. (2006)')
axe[0].plot(np.arange(0,13),0.167*np.arange(0,13)**2+1.203*np.arange(0,13)+0.36,linestyle = '-',color='k',linewidth=1.2,label='Yang et al. (2022)')

axe[0].set_ylim(-5,45)
axe[0].set_xlim(0,12)
axe[0].set_xlabel('$U$$\mathrm{_{10N}}$ (m s$\mathrm{^{-1}}$)')
axe[0].set_ylabel('$K$$\mathrm{_{660}}$ (cm hr$\mathrm{^{-1}}$)')
axe[0].legend(loc=2,fontsize='small',framealpha=0, handlelength=0.9,labelspacing=0.7)
handles, labels = axe[0].get_legend_handles_labels()
axe[0].legend([handles[0],handles[4],handles[1],handles[5],handles[2],handles[3]],[labels[0],labels[4],labels[1],labels[5],labels[2],labels[3]], handlelength=1.1,labelspacing=0.8,facecolor='none',loc=2,fontsize='small')
axe[0].grid(linestyle='--',alpha=0.5)
axe[0].set_yticks([0,10, 20, 30, 40])
axe[0].annotate('A', xy=(-0.17, 0.97),fontsize=11, xycoords='axes fraction', weight='bold')
# 
h=axe[1].scatter(CenBASE_ustarQC,CenBASE_K660QC,s=10,marker='o',color='#009ade',label='EC obs. ('+str(len(CenBASE_K660QC[id_qc])) +')')
axe[1].scatter(ustar_bin, K_ustar_bin,s=70,color='#ff1f5b',edgecolor='#ff1f5b',linewidth=1.5,zorder=3)
axe[1].errorbar(ustar_bin, K_ustar_bin, fmt="o", yerr=K_ustar_std,ecolor='#ff1f5b',color='#ff1f5b',markersize=7,elinewidth=1,capsize=3.5,label='EC bin averages',zorder=3)
axe[1].plot(np.arange(0.0,0.7,0.1),popt_ustar[0]*np.arange(0.0,0.7,0.1)+popt_ustar[1],'#ff1f5b',zorder=3,linewidth=1.7,label=label_ustar)
axe[1].errorbar(dual_tracer_ustar, dual_tracer_k660, fmt="d", yerr=dual_tracer_err,ecolor='#ffc61e',color='#ffc61e',markeredgecolor='#ffc61e',markersize=8,elinewidth=1,capsize=3.5,label='Dual-tracer obs.',zorder=1)
K660_Yang2024 =  55*np.arange(0.0,0.6,0.05) +10*np.arange(0.0,0.6,0.05)*(1.37*np.arange(0.0,0.6,0.05)**2+3.66*np.arange(0.0,0.6,0.05)+1.11)
axe[1].plot(np.arange(0.0,0.6,0.05),K660_Yang2024,linestyle='-',color='k',linewidth=1.2,label='Yang et al. (2024)')

axe[1].set_ylim(-5,50)
axe[1].set_xlim(0.05,0.55)
axe[1].set_xlabel('$u$$\mathrm{_{⁎}}$ (m s$\mathrm{^{-1}}$)')
axe[1].set_ylabel('$K$$\mathrm{_{660}}$ (cm hr$\mathrm{^{-1}}$)')
handles, labels = axe[1].get_legend_handles_labels()
axe[1].legend([handles[0],handles[3],handles[1],handles[4],handles[2]],[labels[0],labels[3],labels[1],labels[4],labels[2]],framealpha=1, handlelength=1.1,labelspacing=0.8,loc=2,facecolor='none',fontsize='small')
axe[1].grid(linestyle='--',alpha=0.5)
axe[1].set_yticks([0,10, 20, 30, 40,50])
axe[1].annotate('B', xy=(-0.19, 0.97),fontsize=11, xycoords='axes fraction', weight='bold')
# 
fname = 'C:\\Users\\ydong\\Online\\08_Baltic Sea paper\\Writing\\' + 'Figure 4'
plt.savefig(fname, dpi=300, facecolor='w', edgecolor='w',orientation='portrait', format=None,\
transparent=False, bbox_inches=None, pad_inches=0.1)
# 
# In[Figure 5-data processing: Hs impact on K660]
# Open Sea K and usr data
# Extracted from Yang et al 2022
Yang_2022_extra = np.array([0.080, 4.494,0.150, 10.424,0.250, 19.000,0.350, 28.000,0.451, 
37.212,0.551, 44.518,0.651, 52.988,0.751, 70.988,0.851, 80.729])
Yang_2022_std = np.array([0.081, 6.506,0.150, 12.541,0.250, 22.494,0.350, 32.871
,0.451, 42.188,0.551, 54.682,0.651, 65.059,0.751, 81.047,0.851, 101.376]) 
K660_yang2022_OS_fit_ustar = -1.74 + 76.67*np.arange(0.,0.6,0.05)+ 20.48*np.arange(0.,0.6,0.05)**2
# Data from previous EC data
wave_OS = np.load(CenBase_add + 'wave_open_ocean.npz')
Hs_OS = wave_OS['Hs_tot']; U10N_OS = wave_OS['wind']
ustar_OS = wave_OS['EC_usr']; K660_OS = wave_OS['EC_K660']
# 
Hs_OS_bin = [];Hs_BS_bin = [];ustar_OS_bin = [];ustar_BS_bin = [];
u10_OS_bin = [];Hs_OS_u10_bin = [];K660_OS_bin = [];K660_OS_std = [];
# 
for i in np.arange(0,1,0.05):
    id_OS = np.where((ustar_OS>=i)&(ustar_OS<i+0.05))
    Hs_OS_bin.append(np.nanmean(Hs_OS[id_OS]))
    ustar_OS_bin.append(np.nanmean(ustar_OS[id_OS]))
    K660_OS_bin.append(np.nanmean(K660_OS[id_OS]))
    K660_OS_std.append(np.nanstd(K660_OS[id_OS]))
# 
for i in np.arange(0,13,1):
    id_OS = np.where((U10N_OS>=i)&(U10N_OS<i+1))
    Hs_OS_u10_bin.append(np.nanmean(Hs_OS[id_OS]))
    u10_OS_bin.append(np.nanmean(U10N_OS[id_OS]))
# 
Hs_OS_bin = np.array(Hs_OS_bin); ustar_OS_bin = np.array(ustar_OS_bin)
u10_OS_bin = np.array(u10_OS_bin); Hs_OS_u10_bin = np.array(Hs_OS_u10_bin)
# 
K660_Yang_OS_i = 360000*(1.52*10**(-4) * ustar_OS_bin)
K660_Yang_OS_b = 360000*( 2.90*10**(-5)*ustar_OS_bin*Hs_OS_bin)
popt_yb_OS, pcovs = curve_fit(func_211, ustar_OS_bin, K660_Yang_OS_b)
K660_Yang_b_OS = func_211(np.arange(0,0.6,0.05), popt_yb_OS[0],popt_yb_OS[1],popt_yb_OS[2]) 
# 
usrHs_bs_bin,Hsusr_bs_bin, U10N_range, cp_fit, Hsusr_bs_std, coeff_Hs_bs, R2_Hs_bs = \
data_fit_CenBASE(CenBASE_ustarQC,CenBASE_Hs,ifbin=1, fit_method=func_011, interv=0.05,ave_min = 0)
usrHs_os_bin,Hsusr_os_bin, U10N_range, cp_fit, Hsusr_os_std, coeff_Hsusr_os, R2_Hsusr_os = \
data_fit_CenBASE(wave_OS['EC_usr'],wave_OS['Hs_tot'],ifbin=1, fit_method=func_e, interv=0.05,ave_min = 0)
# 
K660_Yang_BS_i = 360000*(1.52*10**(-4) * ustar_bin)
K660_Yang_BS_b = 360000*( 2.90*10**(-5)*ustar_bin*Hs_bin)
popt_y, pcovs = curve_fit(func_211, ustar_bin, K660_Yang_BS_b+K660_Yang_BS_i)
K660_Yang_BS = func_211(np.arange(0,0.6,0.05), popt_y[0],popt_y[1],popt_y[2]) 
popt_yb, pcovs = curve_fit(func_211, ustar_bin, K660_Yang_BS_b)
K660_Yang_b_BS = func_211(np.arange(0,0.6,0.05), popt_yb[0],popt_yb[1],popt_yb[2]) 
popt_ustar_HS, pcovs = curve_fit(func_211, ustar_OS_bin, Hs_OS_bin)
HS_fit_ustar = func_211(np.arange(0.0,0.6,0.05), popt_ustar_HS[0],popt_ustar_HS[1],popt_ustar_HS[2])
K660_Yang2024 = 55*np.arange(0.0,0.6,0.05) +10*np.arange(0.0,0.6,0.05)*HS_fit_ustar

# In[Figure 5-plot: Hs impact on K660]
fig,axe = plt.subplots(nrows = 1, ncols = 2, figsize = (8,3.3))
fig.subplots_adjust(right = 0.985,left = 0.06,bottom = 0.15,top = 0.98, wspace=0.35, hspace=0.35)
axe[0].errorbar(usrHs_bs_bin,Hsusr_bs_bin, fmt="o",markersize=8, yerr=Hsusr_bs_std,ecolor='#ff1f5b',color='#ff1f5b',elinewidth=1.0,linewidth=1,capsize=3.5,label='Baltic Sea')
axe[0].errorbar(usrHs_os_bin,Hsusr_os_bin, fmt="s",markersize=7, yerr=Hsusr_os_std,ecolor='k',color='none',markeredgecolor='k',elinewidth=1.0,linewidth=1,capsize=3.5,label='Open ocean')
axe[0].set_ylim(0,5)
axe[0].set_xlim(0.05,0.55)
axe[0].set_yticks([0,1, 2, 3, 4,5]) 
axe[0].set_xlabel('$u$$\mathrm{_{⁎}}$ (m s$\mathrm{^{-1}}$)')
axe[0].set_ylabel('$H$$\mathrm{_{s}}$ (m)')
axe[0].legend(framealpha=1, handlelength=1.1,labelspacing=0.8,loc=2,facecolor='none',fontsize='small')
axe[0].grid(linestyle='--',alpha=0.5)
axe[0].annotate('A', xy=(-0.15, 0.97), fontsize=11,xycoords='axes fraction', weight='bold')
#
# 
axe[1].scatter(ustar_bin, K_ustar_bin,s=70,color='#ff1f5b',edgecolor='#ff1f5b',zorder=3)
axe[1].errorbar(ustar_bin, K_ustar_bin, fmt="o", yerr=K_ustar_std,ecolor='#ff1f5b',color='#ff1f5b',markersize=7,elinewidth=1.3,capsize=3.5,label='EC obs. (Baltic)',zorder=3)
axe[1].errorbar(Yang_2022_extra[2:10:2], Yang_2022_extra[3:10:2], fmt="s", yerr=Yang_2022_std[3:10:2]-Yang_2022_extra[3:10:2],ecolor='k',color='none',markeredgecolor='k',markersize=7,linewidth=1,elinewidth=1,capsize=3.5,label='EC obs. (Open)',zorder=3)
axe[1].plot(np.arange(0.0,0.6,0.05),K660_Yang2024,linestyle='-',color='k',linewidth=1.2,label='Yang24 ($H$$\mathrm{_{s}}$_$\mathrm{_{Open}}$)')
axe[1].plot(np.arange(0.0,0.6,0.05),K660_Yang_BS[0:],linestyle='-',color='#009ADE',linewidth=1.2,label='Yang24 ($H$$\mathrm{_{s}}$_$\mathrm{_{Baltic}}$)')
axe[1].plot(np.arange(0.0,0.6,0.05),K660_Yang_b_OS[0:],linestyle='--',color='k',linewidth=1.2, label='Yang24 ($k$$\mathrm{_{b}}$_$\mathrm{_{Open}}$)')
axe[1].plot(np.arange(0.0,0.6,0.05),K660_Yang_b_BS[0:],linestyle='--',color='#ff1f5b',linewidth=1.2, label='Yang24 ($k$$\mathrm{_{b}}$_$\mathrm{_{Baltic}}$)')
axe[1].set_ylim(0,45)
axe[1].set_xlim(0.05,0.55)
axe[1].set_yticks([0,10, 20, 30, 40]) 
axe[1].set_xlabel('$u$$\mathrm{_{⁎}}$ (m s$\mathrm{^{-1}}$)')
axe[1].set_ylabel('$K$$\mathrm{_{660}}$ (cm hr$\mathrm{^{-1}}$)')
handles, labels = axe[1].get_legend_handles_labels() 
axe[1].legend([handles[4],handles[5],handles[0],handles[1],handles[2],handles[3]],[labels[4],labels[5],labels[0],labels[1],labels[2],labels[3]],framealpha=1, handlelength=1.1,labelspacing=0.8,loc=2,facecolor='none',fontsize='small')
axe[1].grid(linestyle='--',alpha=0.5)
axe[1].annotate('B', xy=(-0.19,0.97),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# fname = 'C:\\Users\\ydong\\Online\\08_Baltic Sea paper\\Writing\\' + 'Figure 5'
# plt.savefig(fname, dpi=300, facecolor='w', edgecolor='w',orientation='portrait', format=None,\
# transparent=False, bbox_inches=None, pad_inches=0.1)
# 
# In[Figure 6-Data processing: SA from different literatures]
# 
f_Yang21 = np.array([5.0, -67.6,7.0, -30.8,9.0, -21.1,11.0, -2.7,13.0, -9.9])
f_M15_1 = np.array([2.081, -65.649,3.043, -59.695,6.589, -45.954,9.394, -22.443,13.207, -9.924])
f_M15_2 = np.array([2.1, -70.0,3.0, -66.7,4.6, -54.9,9.4, -60.1,6.6, -75.4,13.2, -34.7])
f_Frew04 = np.array([3.0, -90.2,5.0, -80.0])
f_Salter04 = np.array([5.0, -39.1,7.2, -55.1,10.8, -24.2,10.7, -5.6])
f_B99 = np.array([7.1, -59.9,8.0, -52.8,8.8, -46.3,10.0, -36.9,10.9, -29.8,11.8, -22.6])
# 
coe_f = (CenBASE_K660QC/func_211(CenBASE_ustarQC, popt_y[0],popt_y[1],popt_y[2]))
ustar_f_bin = np.zeros(len( np.arange(0.1,0.50,0.05)))
f_bin = np.zeros(len( np.arange(0.1,0.50,0.05)))
f_bin_ste = np.zeros(len( np.arange(0.1,0.50,0.05)))
k=0
for i in np.arange(0.1,0.50,0.05):
    ustar_f_bin[k] = np.nanmean(CenBASE_ustarQC[np.where((CenBASE_ustarQC>i)&(CenBASE_ustarQC<i+0.05)&(np.isnan(CenBASE_K660QC)==0))])
    f_bin[k] = np.nanmean(coe_f[np.where((CenBASE_ustarQC>i)&(CenBASE_ustarQC<i+0.05)&(np.isnan(CenBASE_K660QC)==0))])
    f_bin_ste[k] = np.nanstd(coe_f[np.where((CenBASE_ustarQC>i)&(CenBASE_ustarQC<i+0.05)&(np.isnan(CenBASE_K660QC)==0))])
    k+=1
# 
popt_f, pcovs = curve_fit(func_e_dec, ustar_f_bin,f_bin)
f_fit = func_e_dec(np.arange(0.05,0.55,0.01), popt_f[0],popt_f[1],popt_f[2]) 
f_fit_BS = func_e_dec(CenBASE_ustarQC, popt_f[0],popt_f[1],popt_f[2]) 
r2_score(f_bin, func_e_dec(ustar_f_bin, popt_f[0],popt_f[1],popt_f[2]) )

# 
ustar_fit_Yang21 = 0.019239+0.017939*f_Yang21[0::2]+0.0017627*f_Yang21[0::2]**2+-1.2849e-05*f_Yang21[0::2]**3
ustar_fit_Salter04 = 0.019239+0.017939*f_Salter04[0::2]+0.0017627*f_Salter04[0::2]**2+-1.2849e-05*f_Salter04[0::2]**3
ustar_fit_M15 = 0.019239+0.017939*f_M15_2[0::2]+0.0017627*f_M15_2[0::2]**2+-1.2849e-05*f_M15_2[0::2]**3
ustar_fit_Frew04 = 0.019239+0.017939*f_Frew04[0::2]+0.0017627*f_Frew04[0::2]**2+-1.2849e-05*f_Frew04[0::2]**3
ustar_fit_B99 = 0.019239+0.017939*f_B99[0::2]+0.0017627*f_B99[0::2]**2+-1.2849e-05*f_B99[0::2]**3
# 
# 
# 
f_Pereira18 = np.array([0.155, 6.647,0.201, 7.386,0.208, 16.043,0.237, 1.846,0.238, 9.848,
0.360, 19.162,0.384, 15.264,0.430, 25.234,0.438, 8.206,0.450, 19.039,0.641, 19.367,
0.662, 17.931,0.669, 31.635])
popt_f_P, pcovs = curve_fit(func_010, f_Pereira18[0::2],f_Pereira18[1::2])
fP_fit = func_010(np.arange(0.1,0.7,0.01), popt_f_P[0],popt_f_P[1]) 
r2_score(f_Pereira18[1::2], func_010(f_Pereira18[0::2], popt_f_P[0], popt_f_P[1]))
# 
# u10 0-13 m/s
K_Mustaffa20_HW = np.array([63.307, 45.187,83.465, 49.965,90.394, 58.276,74.646, 30.021,109.291, 31.579,69.606, 11.427,77.165, 12.777,131.339, 25.242,134.488, 24.931,145.197, 28.670,147.087, 27.112,97.953, 2.493,
104.252, 2.181,132.598, 2.181,106.772, 13.504,152.756, 22.957,152.756, 20.776,176.693, 2.805,225.827, 3.532,234.646, 4.571,397.165, 10.596,484.094, 7.375,487.437, 7.483])
K_Mustaffa20_MW = np.array([59.528, 54.848,85.354, 62.950,58.898, 40.928,72.756, 42.175,77.795, 25.554,67.087, 13.816,97.953, 11.115,109.291, 6.752,118.740, 5.402,130.709, 14.439,
157.795, 32.825,194.331, 32.722,210.709, 9.453,325.354, 12.673,337.323, 7.583,339.843, 8.414,528.819, 4.155,569.134, 4.882,532.663, 4.289,572.864, 5.093])
K_Mustaffa20_LW = np.array([72.756, 14.231,63.307, 6.856,71.496, 4.051,80.315, 5.609,90.394, 5.402,95.433, 2.078,97.323, 2.285,109.291, 13.504,137.638, 10.492,140.157, 2.389,165.984, 4.986,
223.937, 4.155,249.134, 4.778,261.732, 5.090,273.701, 3.428,278.110, 1.974,289.449, 2.078,299.528, 2.285,310.866, 1.766,305.197, 6.337,568.504, 1.350,567.839, 1.492])
# 
k660_st_HW =9.4 + 0.6 *6**2
k660_st_MW =9.4 + 0.6 *3.75**2
k660_st_LW =9.4 + 0.6 *1.25**2
# 
s_HW = K_Mustaffa20_HW[0::2]
f_HW = K_Mustaffa20_HW[1::2]/k660_st_HW
s_MW = K_Mustaffa20_MW[0::2]
f_MW = K_Mustaffa20_MW[1::2]/k660_st_MW
s_LW = K_Mustaffa20_LW[0::2]
f_LW = K_Mustaffa20_LW[1::2]/k660_st_LW
s_all = np.hstack((s_HW,s_MW,s_LW))
f_all = np.hstack((f_HW,f_MW,f_LW))
# 
# Sample data
k=0
intv=100
s_HW_bin = np.zeros(len(range(0,700,intv)))*np.nan
s_MW_bin = np.zeros(len(range(0,700,intv)))*np.nan
s_LW_bin = np.zeros(len(range(0,700,intv)))*np.nan
f_HW_bin = np.zeros(len(range(0,700,intv)))*np.nan
f_MW_bin = np.zeros(len(range(0,700,intv)))*np.nan
f_LW_bin = np.zeros(len(range(0,700,intv)))*np.nan
s_all_bin = np.zeros(len(range(0,700,intv)))*np.nan
f_all_bin = np.zeros(len(range(0,700,intv)))*np.nan
# 
for i in range(0,700,intv):
    s_HW_bin[k] = np.nanmean(s_HW[np.where((s_HW>=i)&((s_HW<i+intv)))])
    f_HW_bin[k] = np.nanmean(f_HW[np.where((s_HW>=i)&((s_HW<i+intv)))])
    s_MW_bin[k] = np.nanmean(s_MW[np.where((s_MW>=i)&((s_MW<i+intv)))])
    f_MW_bin[k] = np.nanmean(f_MW[np.where((s_MW>=i)&((s_MW<i+intv)))])
    s_LW_bin[k] = np.nanmean(s_LW[np.where((s_LW>=i)&((s_LW<i+intv)))])
    f_LW_bin[k] = np.nanmean(f_LW[np.where((s_LW>=i)&((s_LW<i+intv)))])
    s_all_bin[k] = np.nanmedian(s_all[np.where((s_all>=i)&((s_all<i+intv)))])
    f_all_bin[k] = np.nanmedian(f_all[np.where((s_all>=i)&((s_all<i+intv)))])
    k+=1
    
# plt.scatter(s_all_bin,f_all_bin)
s_M15 = [0.033,0.167]
f_M15 = [(100+np.nanmean(f_M15_1[1::2]))/100,(100+np.nanmean(f_M15_2[1::2]))/100]
# 
s_RR18 = [0.43,0.57,0.81]
f_RR18 = [1-0.46,1-0.53,1-0.54]
# 
# In[Figure 6-Data processing: SA from different literatures]
# 
fig,axe = plt.subplots(nrows = 1, ncols = 2, figsize = (8,3.3))
fig.subplots_adjust(right = 0.985,left = 0.07,bottom = 0.15,top = 0.98, wspace=0.35, hspace=0.35)
axe[1].errorbar(ustar_f_bin, 1-f_bin, fmt="o", yerr=f_bin_ste,ecolor='#009ade',color='none',markeredgecolor='#009ade',markersize=7,elinewidth=1,capsize=3.5,label='This study',zorder=1)
axe[1].plot(np.arange(0.05,0.55,0.01), 1-f_fit, color='#009ade',linestyle='-',zorder=3)
axe[1].scatter(ustar_fit_Yang21,1-(100+f_Yang21[1::2])/100,label='Yang21',marker='s',s=40,color='#ff1f5b')
axe[1].plot(np.arange(0.2,0.33,0.03),np.zeros(len(np.arange(0.2,0.33,0.03)))+0.23, linestyle='',marker='+',markersize=7,linewidth=2,color='C1',zorder=3,label='Mustaffa20')
axe[1].scatter(ustar_fit_Salter04,1-(100+f_Salter04[1::2])/100,label = 'Salter11',marker='^',s=50,color='#00cd6c')
axe[1].scatter(ustar_fit_M15,1-(100+f_M15_2[1::2])/100,label = 'Mesarchaki15',marker='D',s=35,color='#af58ba')
axe[1].scatter(ustar_fit_Frew04,1-(100+f_Frew04[1::2])/100,label = 'Frew04',marker='x',s=40,color='#ffc61e')
axe[1].plot(ustar_fit_B99,1-(100+f_B99[1::2])/100,label = 'Bock99',linestyle='--',linewidth=2,color='gray')
axe[1].grid(linestyle='--',alpha=0.3)
handles, labels = axe[1].get_legend_handles_labels()
axe[1].legend([handles[6],handles[0],handles[1],handles[2],handles[3],handles[4],handles[5]],[labels[6],labels[0],labels[1],labels[2],labels[3],labels[4],labels[5]],labelspacing=0.5,ncol=1,handlelength=0.8,loc=1,facecolor='none',fontsize='small')
axe[1].set_xlabel('$u$$\mathrm{_{⁎}}$ (m s$\mathrm{^{-1}}$)')
axe[1].set_ylabel('Suppression fraction')
axe[1].set_ylim(0,1)
axe[1].set_xlim(0,0.6)
axe[1].annotate('B', xy=(-0.17,0.97),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# 
axe[0].scatter(f_Pereira18[0::2], f_Pereira18[1::2]/100, marker='s',s=35,color='#ff1f5b',zorder=3,label='Pereira18')
axe[0].plot(np.arange(0.1,0.7,0.01),fP_fit/100,linestyle='-',color='#ff1f5b',zorder=3)
axe[0].plot(np.arange(0.2,0.6,0.05),np.zeros(len(np.arange(0.2,0.6,0.05)))+0.23, linestyle='',marker='+',markersize=7,linewidth=2,color='C1',zorder=3,label='Mustaffa20')
axe[0].scatter(s_M15,1-np.array(f_M15), marker='D',s=40,color='#af58ba',zorder=3,label='Mesarchaki15')
axe[0].scatter(s_RR18,1-np.array(f_RR18), marker='D',color='none',s=40,edgecolor = '#af58ba',zorder=3,label='Ribas-Ribas18')
axe[0].scatter(0.28,0.6,label = 'Bock99', marker='_',linewidth = 4,s=90,color='gray')
axe[0].errorbar(0.54, 0.25, xerr=0.08, yerr=0.21, fmt='o', 
             ecolor='#009ade', capsize=5, capthick=0.1, 
             markeredgewidth=1.4,markersize=8,markeredgecolor='#009ade',color='none', label='This study')
axe[0].grid(linestyle='--',alpha=0.3)
handles, labels = axe[0].get_legend_handles_labels()
axe[0].legend([handles[5],handles[0],handles[1],handles[2],handles[3],handles[4]],[labels[5],labels[0],labels[1],labels[2],labels[3],labels[4]],labelspacing=0.5,handlelength=0.8,loc=1,ncol=2,facecolor='none',fontsize='small')
axe[0].set_xlabel('SA (mg L$\mathrm{^{-1}}$ T-X-100)')
axe[0].set_ylabel('Suppression fraction')
axe[0].set_ylim(0,1)
axe[0].set_xlim(0,0.9)
axe[0].annotate('A', xy=(-0.17,0.97),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# fname = 'C:\\Users\\ydong\\Online\\08_Baltic Sea paper\\Writing\\' + 'Figure 6'
# plt.savefig(fname, dpi=300, facecolor='w', edgecolor='w',orientation='portrait', format=None,\
# transparent=False, bbox_inches=None, pad_inches=0.1)
# 
# In[Fig. 7: Upscale to the Baltic Sea]
Upscale = np.load(CenBase_add + 'Baltic Sea implications .npz')
month = np.arange(1,13,1)
# 
fig,axe = plt.subplots(nrows = 2, ncols = 2, figsize = (8,5.5))
fig.subplots_adjust(right = 0.93,left = 0.075,bottom = 0.08,top = 0.98, wspace=0.55, hspace=0.3)
line1,=axe[0,0].plot(month,Upscale['u10_m'],marker='o',color='#009ade',label='$U$$\mathrm{_{10N}}$')
axe[0,0].set_xlim(0,13)
axe[0,0].set_ylim(5,8.5)
axe[0,0].set_xticks(range(1,13,2))
axe[0,0].set_xlabel('Month')
axe[0,0].set_ylabel('$U$$\mathrm{_{10N}}$ (m s$\mathrm{^{-1}}$)')
axe[0,0].grid(linestyle='--',alpha=0.3)
axe00_2 = axe[0,0].twinx()
line2,=axe00_2.plot(month,Upscale['pco2w_m'],linestyle='--',color='#ff1f5b',marker='o',markerfacecolor='None',markeredgecolor='#ff1f5b',label='$f$CO$\mathrm{_2w}$')
axe00_2.set_ylim(200,500)
axe00_2.set_ylabel('$f$CO$\mathrm{_{2w}}$ ($\mu$atm)')
lines = [line1, line2]
labels = [line.get_label() for line in lines]
axe[0,0].legend(lines, labels, loc=4,handlelength=1.3)
axe[0,0].annotate('A', xy=(-0.2, 0.99),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# 
line1,=axe[0,1].plot(month,Upscale['ustar_m'],marker='o',color='#009ade',label='$u$$\mathrm{_{⁎}}$')
axe[0,1].set_xlim(0,13)
axe[0,1].set_ylim(0.15,0.36)
axe[0,1].set_xticks(range(1,13,2))
axe[0,1].set_xlabel('Month')
axe[0,1].set_ylabel('$u$$\mathrm{_{⁎}}$ (m s$\mathrm{^{-1}}$)')
axe[0,1].grid(linestyle='--',alpha=0.3)
axe00_2 = axe[0,1].twinx()
line2,=axe00_2.plot(month,Upscale['swh_m'],linestyle='--',color='#ff1f5b',marker='o',markerfacecolor='None',markeredgecolor='#ff1f5b',label='$H$$\mathrm{_{s}}$')
axe00_2.set_ylim(0.5,1.4)
axe00_2.set_ylabel('$H$$\mathrm{_{s}}$ (m)')
lines = [line1, line2]
labels = [line.get_label() for line in lines]
axe[0,1].legend(lines, labels, loc=4,handlelength=1.3)
axe[0,1].annotate('B', xy=(-0.23, 0.99),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# 
line1,=axe[1,0].plot(month,Upscale['CHL_m'],marker='o',color='#009ade',label='Chl-$a$')
axe[1,0].set_xlim(0,13)
axe[1,0].set_ylim(0,3.5)
axe[1,0].set_xticks(range(1,13,2))
axe[1,0].set_xlabel('Month')
axe[1,0].set_ylabel('Chl-$a$ (mg m$\mathrm{^{-3}}$)')
axe[1,0].grid(linestyle='--',alpha=0.3)
axe00_2 = axe[1,0].twinx()
cf = (1-0.38*np.exp(-1.25*Upscale['ustar_m']))*((1-Upscale['sf_SA'])/0.79)
line2,=axe00_2.plot(month,1-cf,linestyle='--',color='#ff1f5b',marker='o',markerfacecolor='None',markeredgecolor='#ff1f5b',label='$sf$')
axe00_2.set_ylim(0,0.35)
axe00_2.set_ylabel('Suppression fraction')
lines = [line1, line2]
labels = [line.get_label() for line in lines]
axe[1,0].legend(lines, labels, loc=1,handlelength=1.3)
axe[1,0].annotate('C', xy=(-0.2, 0.99),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# 
line1,=axe[1,1].plot(month,0.251*Upscale['u10_m']**2,marker='o',color='#009ade',label='$K$$\mathrm{_{660}}$($U$$\mathrm{_{10N}}$)')
line1,=axe[1,1].plot(month,55*Upscale['ustar_m']+10*Upscale['ustar_m']*Upscale['swh_m'],linestyle='-',color='#ff1f5b',marker='o',markerfacecolor='#ff1f5b',markeredgecolor='#ff1f5b',label='$K$$\mathrm{_{660}}$($u$$\mathrm{_{⁎}}$, $H$$\mathrm{_{s}}$)')
line1,=axe[1,1].plot(month,cf*(55*Upscale['ustar_m']+10*Upscale['ustar_m']*Upscale['swh_m']),linestyle='--',color='#ff1f5b',marker='o',markerfacecolor='none',markeredgecolor='#ff1f5b',label='$K$$\mathrm{_{660}}$($u$$\mathrm{_{⁎}}$, $H$$\mathrm{_{s}}$, SA)')
axe[1,1].set_xlim(0,13)
axe[1,1].set_ylim(5,30)
axe[1,1].set_xticks(range(1,13,2))
axe[1,1].set_xlabel('Month')
axe[1,1].set_ylabel('$K$$\mathrm{_{660}}$ (cm hr$\mathrm{^{-1}}$)')
axe[1,1].grid(linestyle='--',alpha=0.3)
axe[1,1].legend(loc=9,handlelength=1.3)
axe[1,1].annotate('D', xy=(-0.23, 0.99),fontsize=11, xycoords='axes fraction', weight='bold')
# 
# 
# fname = 'C:\\Users\\ydong\\Online\\08_Baltic Sea paper\\Writing\\' + 'Figure 7'
# plt.savefig(fname, dpi=300, facecolor='w', edgecolor='w',orientation='portrait', format=None,\
# transparent=False, bbox_inches=None, pad_inches=0.1)
# In[Table 1: Statistic metrics]
# EC ustar is 10.14% higher than COARE3.6
# usr_coare_cenbase = 0.019239+0.017939*CenBASE_U10N[id_qc]+0.0017627*CenBASE_U10N[id_qc]**2+-1.2849e-05*CenBASE_U10N[id_qc]**3
# print(str(round(np.nanmean(CenBASE_ustarQC[id_qc] - usr_coare_cenbase)/np.nanmean(usr_coare_cenbase)*100,2))+'%')
# #
# # The mean EC-derived K660 during CenABSE: 14.9 cm/hr
# print(np.nanmean(CenBASE_K660QC))
# # 
# # Hs in the Baltic sea is 0.99 m, in the Open ocean under the same wind speed is 2.3 m
# popt_u10_HS, pcovs = curve_fit(func_211, u10_OS_bin, Hs_OS_u10_bin)
# HS_u10_fit = func_211(CenBASE_U10N[id_qc], popt_u10_HS[0],popt_u10_HS[1],popt_u10_HS[2])
# print(np.nanmean(HS_u10_fit))
# print(np.nanmean(CenBASE_Hs[id_qc]))
# # 
# # Absolute value of Ki is 12.1 cm/hr in open ocean under the same wind speed
# K660_Yang_ki_open = 360000*(1.52*10**(-4) * usr_coare_cenbase)
# print(round(np.nanmean(K660_Yang_ki_open),2))
# # 
# # Absolute value of Kb is 7.0 cm/hr in open ocean under the same wind speed
# K660_Yang_kb_open = 360000*( 2.90*10**(-5)*usr_coare_cenbase*HS_u10_fit)
# print(round(np.nanmean(K660_Yang_kb_open),3))
# # 
# # Absolute value of K is 22.1 cm/hr in open ocean under the same wind speed
# print(round(np.nanmean(K660_Yang_ki_open)+np.nanmean(K660_Yang_kb_open),2))
# # 
# # The observed K660 during Cenbase is 29.3% lower than Open under the same U10
# print((np.nanmean(K660_Yang_ki_open)+np.nanmean(K660_Yang_kb_open)-np.nanmean(CenBASE_K660QC))/(np.nanmean(K660_Yang_ki_open)+np.nanmean(K660_Yang_kb_open)))
# # 
# # Due to Hs, 
# K660_Yang_kb_open_BSHs = 360000*( 2.90*10**(-5)*usr_coare_cenbase*CenBASE_Hs[id_qc])
# print(np.nanmean(K660_Yang_kb_open)-np.nanmean(K660_Yang_kb_open_BSHs))
# print((1-np.nanmean(K660_Yang_kb_open_BSHs)/np.nanmean(K660_Yang_kb_open)))
# # 
# # Absolute value of Ki + Kb in open ocean under the same wind speed
# print(round(np.nanmean(K660_Yang_ki_open + K660_Yang_kb_open),2))
# #~~~~~~~~~~~~~~
# # Absolute and percentage values of fetch-ustar impact on Ki in the Baltic Sea
# K660_Yang_ki_BS = 360000*(1.52*10**(-4) * CenBASE_ustarQC)
# print(round(np.nanmean(K660_Yang_ki_BS - K660_Yang_ki_open),2))
# print(str(round(np.nanmean(K660_Yang_ki_BS - K660_Yang_ki_open)/np.nanmean(K660_Yang_ki_open)*100,2))+'%')
# # 
# # Absolute and percentage value of fetch-ustar impact on Kb in the Baltic Sea
# # Percentage the same as impact on Ki
# a_usr = np.nanmean(K660_Yang_ki_BS - K660_Yang_ki_open)/np.nanmean(K660_Yang_ki_open)
# print(str(round(a_usr*100,2))+'%')
# # Absolute value calculated by Kb*percentage
# print(round(np.nanmean(K660_Yang_kb_open)*a_usr,2))
# # 
# #~~~~~~~~~~~~~~
# # Hs does not impact Ki
# # Absolute and percentage value of fetch-Hs impact on Kb in the Baltic Sea
# #  the same ustar, but different Hs
