clc;clear;
close all;
mydata = readmatrix("res70x70x50ENDh=200.txt");
data = readmatrix('SaltDome70x70x50Result(h=200).txt');
% mydata = readmatrix("res70x70x60END.txt");
% data = readmatrix('SaltDome70x70x50Result(h=0).txt');
xx = reshape(mydata(:, 1), 70, 70) * 1e-1;
yy = reshape(mydata(:, 2), 70, 70) * 1e-1;

m = 'spline';
sc = 5;
xx = interpolate2D(xx, sc, m);
yy = interpolate2D(yy, sc, m);

%%
dg1  = reshape(mydata(:, 3), 70, 70);
gxx1 = reshape(mydata(:, 4), 70, 70);
gyy1 = reshape(mydata(:, 5), 70, 70);
gzz1 = reshape(mydata(:, 6), 70, 70);
gxy1 = reshape(mydata(:, 7), 70, 70);
gxz1 = reshape(mydata(:, 8), 70, 70);
gyz1 = reshape(mydata(:, 9), 70, 70);

dg1  = interpolate2D(dg1 , sc, m);
gxx1 = interpolate2D(gxx1, sc, m);
gyy1 = interpolate2D(gyy1, sc, m);
gzz1 = interpolate2D(gzz1, sc, m);
gxy1 = interpolate2D(gxy1, sc, m);
gxz1 = interpolate2D(gxz1, sc, m);
gyz1 = interpolate2D(gyz1, sc, m);

% Storage conversion between data and text
dg2  = reshape(data(:,  3), 70, 70);
gxx2 = reshape(data(:, 11), 70, 70);
gyy2 = reshape(data(:,  5), 70, 70);
gzz2 = reshape(data(:, 15), 70, 70);
gxy2 = reshape(data(:,  7), 70, 70);
gxz2 = reshape(data(:, 13), 70, 70);
gyz2 = reshape(data(:,  9), 70, 70);

dg2  = interpolate2D(dg2 , sc, m);
gxx2 = interpolate2D(gxx2, sc, m);
gyy2 = interpolate2D(gyy2, sc, m);
gzz2 = interpolate2D(gzz2, sc, m);
gxy2 = interpolate2D(gxy2, sc, m);
gxz2 = interpolate2D(gxz2, sc, m);
gyz2 = interpolate2D(gyz2, sc, m);

err_dg  = abs(dg1  - dg2 );
err_gxx = abs(gxx1 + gxx2);
err_gyy = abs(gyy1 + gyy2);
err_gzz = abs(gzz1 + gzz2);
err_gxy = abs(gxy1 + gxy2);
err_gxz = abs(gxz1 + gxz2);
err_gyz = abs(gyz1 + gyz2);

figure;
ax1 = subplot(331);
ax2 = subplot(332);
ax3 = subplot(333);
ax5 = subplot(335);
ax6 = subplot(336);
ax7 = subplot(337);
ax9 = subplot(339);
axs = {ax7, ax1, ax2, ax3, ax5, ax6, ax9};
vars = {err_dg, err_gxx, err_gxy, err_gxz, err_gyy, err_gyz, err_gzz};
% vars = {dg1, gxx1, gxy1, gxz1, gyy1, gyz1, gzz1};
% vars = {dg2, gxx2, gxy2, gxz2, gyy2, gyz2, gzz2};
cmtitles = {'\DeltaV_{z}(mGal)', '\DeltaV_{xx}(E)', '\DeltaV_{xy}(E)', '\DeltaV_{xz}(E)', ...
    '\DeltaV_{yy}(E)', '\DeltaV_{yz}(E)', '\DeltaV_{zz}(E)'};
for ii=1:7
    pcolor(axs{ii}, xx, yy, vars{ii});
    shading(axs{ii}, 'interp');
    hold(axs{ii}, "on");
% contourf(axs{ii}, xx, yy, vars{ii}, 15, '-');
    title(colorbar(axs{ii}), cmtitles{ii}, 'Interpreter', 'tex');
    axis(axs{ii}, "square");
    set(axs{ii},'FontName','Times New Roman','FontWeight','n','FontSize',18);
    xlabel(axs{ii}, 'x(km)');ylabel(axs{ii}, 'y(km)');
end

set(ax1, 'Position', [0.10, 0.70, 0.23, 0.23]);
set(ax5, 'Position', [0.32, 0.40, 0.23, 0.23]);
set(ax9, 'Position', [0.54, 0.10, 0.23, 0.23]);
set(ax2, 'Position', [0.32, 0.70, 0.23, 0.23]);
set(ax3, 'Position', [0.54, 0.70, 0.23, 0.23]);
set(ax6, 'Position', [0.54, 0.40, 0.23, 0.23]);
set(ax7, 'Position', [0.10, 0.10, 0.23, 0.23]);

colormap(flipud(jet));
set(gcf, "Units","centimeters", "Position", [0, 1.2700, 45.1556, 25.0472]);
% exportgraphics(gcf, 'resFIG.jpg', 'Resolution', 300);
exportgraphics(gcf, 'errFIG.jpg', 'Resolution', 300);

%%
function [output] = interpolate2D(input, scaleFactor, method)
    if nargin < 3
        method = 'linear';
    end
    
    [rows, cols] = size(input);
    
    newRows = round(rows * scaleFactor);
    newCols = round(cols * scaleFactor);
    [X, Y] = meshgrid(1:cols, 1:rows);
    [Xq, Yq] = meshgrid(linspace(1, cols, newCols), linspace(1, rows, newRows));
    
    output = interp2(X, Y, double(input), Xq, Yq, method);
    
    if isinteger(input)
        output = cast(output, class(input));
    end
end