clc;clear;
close all;
mydata = readmatrix("res50x50x50END.txt");
data = readmatrix('BlockOne50x50x50Result.txt');
xx = reshape(mydata(:, 1), 50, 50) * 1e-1;
yy = reshape(mydata(:, 2), 50, 50) * 1e-1;

%%
dg1  = reshape(mydata(:, 3), 50, 50);
gxx1 = reshape(mydata(:, 4), 50, 50);
gyy1 = reshape(mydata(:, 5), 50, 50);
gzz1 = reshape(mydata(:, 6), 50, 50);
gxy1 = reshape(mydata(:, 7), 50, 50);
gxz1 = reshape(mydata(:, 8), 50, 50);
gyz1 = reshape(mydata(:, 9), 50, 50);

% Storage conversion between data and text
dg2  = reshape(data(:,  3), 50, 50);
gxx2 = reshape(data(:, 11), 50, 50);
gyy2 = reshape(data(:,  5), 50, 50);
gzz2 = reshape(data(:, 15), 50, 50);
gxy2 = reshape(data(:,  7), 50, 50);
gxz2 = reshape(data(:, 13), 50, 50);
gyz2 = reshape(data(:,  9), 50, 50);

err_dg  = (dg1  - dg2 );
err_gxx = (gxx1 + gxx2);
err_gyy = (gyy1 + gyy2);
err_gzz = (gzz1 + gzz2);
err_gxy = (gxy1 + gxy2);
err_gxz = (gxz1 + gxz2);
err_gyz = (gyz1 + gyz2);

figure;
ax1 = subplot(331);
ax2 = subplot(332);
ax3 = subplot(333);
ax5 = subplot(335);
ax6 = subplot(336);
ax7 = subplot(337);
ax9 = subplot(339);
axs = {ax7, ax1, ax2, ax3, ax5, ax6, ax9};
vars = {err_dg, err_gxx, err_gxy, err_gxz, err_gyy, err_gyz, err_gzz};
cmtitles = {'\DeltaV_{z}(mGal)', '\DeltaV_{xx}(E)', '\DeltaV_{xy}(E)', '\DeltaV_{xz}(E)', ...
    '\DeltaV_{yy}(E)', '\DeltaV_{yz}(E)', '\DeltaV_{zz}(E)'};
for ii=1:7
    pcolor(axs{ii}, xx, yy, vars{ii});
    shading(axs{ii}, 'interp');
    title(colorbar(axs{ii}), cmtitles{ii}, 'Interpreter', 'tex');
    axis(axs{ii}, "square");
    set(axs{ii},'FontName','Times New Roman','FontWeight','bold','FontSize',18);
    xlabel(axs{ii}, 'x(km)');ylabel(axs{ii}, 'y(km)');
end

set(ax1, 'Position', [0.10, 0.70, 0.23, 0.23]);
set(ax5, 'Position', [0.32, 0.40, 0.23, 0.23]);
set(ax9, 'Position', [0.54, 0.10, 0.23, 0.23]);
set(ax2, 'Position', [0.32, 0.70, 0.23, 0.23]);
set(ax3, 'Position', [0.54, 0.70, 0.23, 0.23]);
set(ax6, 'Position', [0.54, 0.40, 0.23, 0.23]);
set(ax7, 'Position', [0.10, 0.10, 0.23, 0.23]);

colormap(flipud(jet));
set(gcf, "Units","centimeters", "Position", [0, 1.2700, 45.1556, 25.0472]);