function Ta = magneticFwd(xobs, yobs, zobs, ...
    xmin, ymin, zmin, xmax, ymax, zmax, M, MI, MD, mode)
    % Forward modeling of magnetic anomalies

    % 磁化强度 :: M (unit: A m-1)
    % 磁异常   :: deltaT (unit: nT)

    % Vacuum permeability
    mu0 = 4*pi * 1e-7;  % (unit: H m-1)==(unit: T m A-1)

    % Magnetization direction
    n = [cosd(MI)*cosd(MD);
         cosd(MI)*sind(MD);
         sind(MI)];
    Mvec = M*n;

    % 
    result = solTensor(xobs, yobs, zobs, xmin, ymin, zmin, ...
        xmax, ymax, zmax, mode, []);

    % 
    Ta = mu0/(4*pi) * result * Mvec;
    
end

