function result = gravityFwd(xobs, yobs, zobs, ...
    xmin, ymin, zmin, xmax, ymax, zmax)

    ix = [xmin; xmax] - xobs;
    jy = [ymin; ymax] - yobs;
    kz = [zmin; zmax] - zobs;
    % Gravitational potential
    val = zeros(7, 1);
    for i=1:2
        for j=1:2
            for k=1:2
                r = sqrt(ix(i)^2+jy(j)^2+kz(k)^2);
                mu_ijk = (-1)^(i+j+k);
                valXX = atan2(ix(i)*r, jy(j)*kz(k));
                valYY = atan2(jy(j)*r, ix(i)*kz(k));
                valZZ = atan2(kz(k)*r, ix(i)*jy(j));
                valXY = -log(kz(k) + r);
                valXZ = -log(jy(j) + r);
                valYZ = -log(ix(i) + r);
                valZ = -ix(i)*valXZ - jy(j)*valYZ + kz(k)*atan2(ix(i)*jy(j), kz(k)*r);
                val(:, 1) = val(:, 1) + mu_ijk * [
                        valXX; ...
                        valYY; ...
                        valZZ; ...
                        valXY; ...
                        valXZ; ...
                        valYZ; ...
                        valZ
                        ];
            end
        end
    end
    % Second derivative
    result.GG = [val(1, 1), val(4, 1), val(5, 1);
              val(4, 1), val(2, 1), val(6, 1);
              val(5, 1), val(6, 1), val(3, 1)];
    result.Gz = val(7, 1);
end

