%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Gravity forward main program
% Used to check the accuracy of GM3D
% [Wang DengKang]
% number: 50 x 50 x 50
% area: 500hm x 500hm x 500hm
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
clc;clear;
close all;

% 1 cm/s^2 = 10^3 mgal
% 1 g/cm3 = 10^-3 kg / 10^-6 m3 = 10^3 kg/m3
% >> MAIN
% constant
iu2mGal = 1e5;      % m/s^2 --> mGal
iu2E = 1e9;         % 1/s^2 --> E
G = 6.67*1e-11;

% user-defined-------------------------------------------------------------
NX = 50;                    % 测点数量NX, NY, NZ
XA = 0;                     % 测点起点XA, YA, ZA
XB = 500 * 1e2;             % 测点终点XB, YB, ZB

NY = 50;
YA = 0;
YB = 500 * 1e2;

NZ = 50;
ZA = 0;
ZB = 500 * 1e2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%模型3
XIdxSeq = [14;
           38];             % 异常体边界X方向索引
YIdxSeq = [16;
           35];             % 异常体边界Y方向索引
ZIdxSeq = [14;
           38];              % 异常体边界Z方向索引
rhoSeq = [1];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% -------------------------------------------------------------------------

% 离散网格间距DX, DY, DZ
DX = (XB-XA)/(NX);
DY = (YB-YA)/(NY);
DZ = (ZB-ZA)/(NZ);

% 离散网格中心坐标矢量 X, Y, Z
X = XA + transpose((1:NX)-0.5)*DX;
Y = YA + transpose((1:NY)-0.5)*DY;
Z = ZA + transpose((1:NZ)-0.5)*DZ;

% 离散单元总数
Ncell = NX*NY*NZ;

% 观测网格
XNode = X;
YNode = Y;
NXobs = length(X);
NYobs = length(Y);
Nobs = NXobs*NYobs;

% 离散网格的中心坐标 Xc, Yc, Zc
Xc = zeros(Ncell, 1);
Yc = zeros(Ncell, 1);
Zc = zeros(Ncell, 1);
for iz=1:NZ
    for iy=1:NY
        for ix=1:NX
            idx = NX*NY*(iz-1)+NX*(iy-1)+ix;
            Xc(idx, 1) = X(ix, 1);
            Yc(idx, 1) = Y(iy, 1);
            Zc(idx, 1) = Z(iz, 1);
        end
    end
end


% 剩余密度的空间分布 rho(unit: kg m-3)
% 磁异常的空间分布 M(unit: A m-1)
bodyNum = min([size(XIdxSeq, 2), size(YIdxSeq, 2), size(ZIdxSeq, 2)]);
rho = zeros(NX, NY, NZ);
M = zeros(NX, NY, NZ);
for iNum=1:bodyNum
    for ix=XIdxSeq(1, iNum):XIdxSeq(2, iNum)
        for iy=YIdxSeq(1, iNum):YIdxSeq(2, iNum)
            for iz=ZIdxSeq(1, iNum):ZIdxSeq(2, iNum)
                rho(ix, iy, iz) = rhoSeq(iNum, 1);
%                 M(ix, iy, iz) = MSeq(iNum, 1);
            end
        end
    end
end
rho = rho * 1e3;

gz = zeros(NXobs, NYobs);
Zobs = 0;
spaceIdx = find(rho);
for ii=1:NYobs
    for jj=1:NXobs
        Xobs = XNode(jj, 1);
        Yobs = YNode(ii, 1);
        NG = NXobs*(ii-1) + jj;

        dgz = 0;
        dgg = 0;
        for iNum=1:size(spaceIdx, 1)
            icell = spaceIdx(iNum, 1);
            x_min = Xc(icell, 1) - DX/2;
            x_max = Xc(icell, 1) + DX/2;
            y_min = Yc(icell, 1) - DY/2;
            y_max = Yc(icell, 1) + DY/2;
            z_min = Zc(icell, 1) - DZ/2;
            z_max = Zc(icell, 1) + DZ/2;
            res = solTensor(Xobs, Yobs, Zobs, x_min, y_min, z_min, ...
                x_max, y_max, z_max, 'G', rho(icell));
            dgz = dgz + res.Gz * iu2mGal;
            dgg = dgg + res.GG * iu2E;
        end
        gz(jj, ii) = dgz;
        gg.gxx(jj, ii) = dgg(1, 1);
        gg.gyy(jj, ii) = dgg(2, 2);
        gg.gzz(jj, ii) = dgg(3, 3);
        gg.gxy(jj, ii) = dgg(1, 2);
        gg.gyz(jj, ii) = dgg(2, 3);
        gg.gxz(jj, ii) = dgg(1, 3);
    end
end

fid = fopen('res50x50x50END.txt', 'w');

fprintf(fid, 'x(hm)	y(hm)	g	gxx	gyy	gzz	gxy	gxz	gyz	\n\n');

[YYY, XXX] = meshgrid(YNode, XNode);
for i=1:NXobs
    for j=1:NYobs
        fprintf(fid, '%g %g %g %g %g %g %g %g %g \n\n', ...
            XXX(i, jj)/1e2, YYY(i, j)/1e2, gz(i, j), ...
            gg.gxx(i, j), gg.gyy(i, j), gg.gzz(i, j), gg.gxy(i, j), gg.gxz(i, j), gg.gyz(i, j));
    end
end
fclose(fid);
%%
[YYY, XXX] = meshgrid(YNode, XNode);
figure;
subplot(3, 3, 1);
contourf(XXX, YYY, gg.gxx', 20);
title(colorbar, 'g_{xx}(E)');
axis square;
set(gca, 'Position', [0.1, 0.7, 0.24, 0.24]);
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
subplot(3, 3, 5);
contourf(XXX, YYY, gg.gyy', 20);
title(colorbar, 'g_{yy}(E)');
axis square;
set(gca, 'Position', [0.32, 0.4, 0.24, 0.24]);
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
subplot(3, 3, 9);
contourf(XXX, YYY, gg.gzz', 20);
title(colorbar, 'g_{zz}(E)');
axis square;
set(gca, 'Position', [0.54, 0.1, 0.24, 0.24]);
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
subplot(3, 3, 2);
contourf(XXX, YYY, gg.gxy', 20);
title(colorbar, 'g_{xy}(E)');
axis square;
set(gca, 'Position', [0.32, 0.7, 0.24, 0.24]);
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
subplot(3, 3, 3);
contourf(XXX, YYY, gg.gxz', 20);
title(colorbar, 'g_{xz}(E)');
axis square;
set(gca, 'Position', [0.54, 0.7, 0.24, 0.24]);
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
subplot(3, 3, 6);
contourf(XXX, YYY, gg.gyz', 20);
title(colorbar, 'g_{yz}(E)');
axis square;
set(gca, 'Position', [0.54, 0.4, 0.24, 0.24]);
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
subplot(3, 3, 7);
contourf(XXX, YYY, gz, 20);
title(colorbar, 'g_{z}(mGal)');
set(gca,'FontName','Times New Roman','FontWeight','bold','FontSize',12);
xlabel('x(m)');ylabel('y(m)');
axis square;
set(gca, 'Position', [0.1, 0.1, 0.24, 0.24]);

colormap(flipud(jet));
set(gcf, "Units","centimeters", "Position", [0, 1.2700, 45.1556, 25.0472]);