#pragma once
#include "main_header.h"
#include <math.h>
using yakl::SArray;

namespace TransformMatrices {

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,2> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,2> &rslt) {
    rslt(0) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,2,2> &rslt) {
    rslt(0,0) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,1) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,2,2> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,2,2> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,2> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,2,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,2,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,3> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(2) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,3> &rslt) {
    rslt(0) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1) = static_cast<FP>(0.66666666666666666666666666666666666667);
    rslt(2) = static_cast<FP>(0.16666666666666666666666666666666666667);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(0,1) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(1,2) = -static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(2.0000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,3> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,3,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,3,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_coefs(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,1) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,0) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(1,1) = 0;
    rslt(1,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(2,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_sten(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(1.0833333333333333333333333333333333333);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,3,1> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,0) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,3,2> &rslt) {
    rslt(0,0) = static_cast<FP>(0.33333333333333333333333333333333333333);
    rslt(0,1) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,0) = static_cast<FP>(0.83333333333333333333333333333333333333);
    rslt(1,1) = static_cast<FP>(0.83333333333333333333333333333333333333);
    rslt(2,0) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,1) = static_cast<FP>(0.33333333333333333333333333333333333333);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,3,3> &rslt) {
    rslt(0,0) = static_cast<FP>(0.33333333333333333333333333333333333333);
    rslt(0,1) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,2) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,0) = static_cast<FP>(0.83333333333333333333333333333333333333);
    rslt(1,1) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(1,2) = static_cast<FP>(0.83333333333333333333333333333333333333);
    rslt(2,0) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,1) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,2) = static_cast<FP>(0.33333333333333333333333333333333333333);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void weno_lower_sten_to_coefs(SArray<FP,3,2,2,2> &rslt) {
    rslt(0,0,0) = 0;
    rslt(0,0,1) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0,1) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1,0) = 0;
    rslt(1,1,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,4> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(3) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,4> &rslt) {
    rslt(0) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(1) = static_cast<FP>(0.41666666666666666666666666666666666667);
    rslt(2) = static_cast<FP>(0.41666666666666666666666666666666666667);
    rslt(3) = static_cast<FP>(0.083333333333333333333333333333333333333);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,4,4> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(0.25000000000000000000000000000000000002);
    rslt(0,2) = static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(0,3) = -static_cast<FP>(5.0000000000000000000000000000000000001);
    rslt(1,0) = static_cast<FP>(0.62500000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(2.7950849718747371205114670859140952943);
    rslt(1,2) = -static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(1,3) = static_cast<FP>(11.180339887498948482045868343656381177);
    rslt(2,0) = static_cast<FP>(0.62500000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(2.7950849718747371205114670859140952943);
    rslt(2,2) = -static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(2,3) = -static_cast<FP>(11.180339887498948482045868343656381177);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.25000000000000000000000000000000000001);
    rslt(3,2) = static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(3,3) = static_cast<FP>(5.0000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,4,4> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,4,4> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,4> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.000000000000000000000000000000000000)*(a(3)*a(3));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,4,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,4,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,4,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,4,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,5> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(2) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(4) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,5> &rslt) {
    rslt(0) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(1) = static_cast<FP>(0.27222222222222222222222222222222222222);
    rslt(2) = static_cast<FP>(0.35555555555555555555555555555555555556);
    rslt(3) = static_cast<FP>(0.27222222222222222222222222222222222222);
    rslt(4) = static_cast<FP>(0.050000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(0.74999999999999999999999999999999999998);
    rslt(0,2) = -static_cast<FP>(1.5000000000000000000000000000000000001);
    rslt(0,3) = -static_cast<FP>(6.9999999999999999999999999999999999999);
    rslt(0,4) = static_cast<FP>(14.000000000000000000000000000000000000);
    rslt(1,0) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(2.6731691553909066705096941963413382852);
    rslt(1,2) = static_cast<FP>(8.1666666666666666666666666666666666668);
    rslt(1,3) = static_cast<FP>(10.692676621563626682038776785365353141);
    rslt(1,4) = -static_cast<FP>(32.666666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(2,1) = -static_cast<FP>(2.3509887016445750159374730744444913556e-38);
    rslt(2,2) = -static_cast<FP>(13.333333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(9.4039548065783000637498922977779654225e-38);
    rslt(2,4) = static_cast<FP>(37.333333333333333333333333333333333334);
    rslt(3,0) = 0;
    rslt(3,1) = static_cast<FP>(2.6731691553909066705096941963413382853);
    rslt(3,2) = static_cast<FP>(8.1666666666666666666666666666666666667);
    rslt(3,3) = -static_cast<FP>(10.692676621563626682038776785365353141);
    rslt(3,4) = -static_cast<FP>(32.666666666666666666666666666666666667);
    rslt(4,0) = 0;
    rslt(4,1) = -static_cast<FP>(0.75000000000000000000000000000000000002);
    rslt(4,2) = -static_cast<FP>(1.5000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(7.0000000000000000000000000000000000001);
    rslt(4,4) = static_cast<FP>(14.000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,5> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.80000000000000000000000000000000000)*(a(4)*a(4));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,5,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,5,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,5,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,5,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_coefs(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(0,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(0,3) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(1,1) = -static_cast<FP>(0.70833333333333333333333333333333333333);
    rslt(1,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(1,3) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(2,1) = 0;
    rslt(2,2) = -static_cast<FP>(1.3750000000000000000000000000000000000);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(3,1) = static_cast<FP>(0.70833333333333333333333333333333333333);
    rslt(3,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(3,3) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(4,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(4,1) = -static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(4,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_sten(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,4) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,4) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,4) = static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,4) = static_cast<FP>(18.012500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,5,1> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(4,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,5,2> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(1,0) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(3,1) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(4,1) = -static_cast<FP>(0.050000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,5,3> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(1,0) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(1,2) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(3,1) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(3,2) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(4,1) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(4,2) = -static_cast<FP>(0.050000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,5,4> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(0,1) = -static_cast<FP>(0.020694013108331230297425070020646095688);
    rslt(0,2) = static_cast<FP>(0.024027346441664563630758403353979429021);
    rslt(0,3) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(1,0) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.13319142509165194541530882347785600315);
    rslt(1,2) = -static_cast<FP>(0.17985809175831861208197549014452266981);
    rslt(1,3) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(1.0433333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(1.0433333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(3,1) = -static_cast<FP>(0.17985809175831861208197549014452266981);
    rslt(3,2) = static_cast<FP>(0.13319142509165194541530882347785600315);
    rslt(3,3) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(4,1) = static_cast<FP>(0.024027346441664563630758403353979429021);
    rslt(4,2) = -static_cast<FP>(0.020694013108331230297425070020646095688);
    rslt(4,3) = -static_cast<FP>(0.050000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,5,5> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(0,1) = -static_cast<FP>(0.032704596564325442221687395875700738020);
    rslt(0,2) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(0.029643372074529523854340457100190533939);
    rslt(0,4) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(1,0) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.24403859720020299352219960649338817378);
    rslt(1,2) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(1,3) = -static_cast<FP>(0.20798417543149551052900232758182354793);
    rslt(1,4) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(2,0) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(0.96700680272108843537414965986394557823);
    rslt(2,2) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(0.96700680272108843537414965986394557823);
    rslt(2,4) = static_cast<FP>(0.78333333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(0.21666666666666666666666666666666666667);
    rslt(3,1) = -static_cast<FP>(0.20798417543149551052900232758182354793);
    rslt(3,2) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(3,3) = static_cast<FP>(0.24403859720020299352219960649338817378);
    rslt(3,4) = static_cast<FP>(0.45000000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(4,1) = static_cast<FP>(0.029643372074529523854340457100190533939);
    rslt(4,2) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(4,3) = -static_cast<FP>(0.032704596564325442221687395875700738020);
    rslt(4,4) = -static_cast<FP>(0.050000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void weno_lower_sten_to_coefs(SArray<FP,3,3,3,3> &rslt) {
    rslt(0,0,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,0,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,0,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,1,0) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(0,1,1) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(0,1,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2,0) = static_cast<FP>(0.95833333333333333333333333333333333333);
    rslt(0,2,1) = static_cast<FP>(1.5000000000000000000000000000000000000);
    rslt(0,2,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,0,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,0,1) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,0,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1,0) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(1,1,1) = 0;
    rslt(1,1,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,2,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,2,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,2,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0,0) = static_cast<FP>(0.95833333333333333333333333333333333333);
    rslt(2,0,1) = -static_cast<FP>(1.5000000000000000000000000000000000000);
    rslt(2,0,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,1,0) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,1,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,1,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(2,2,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,2,1) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,2,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,6> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(5) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,6> &rslt) {
    rslt(0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(1) = static_cast<FP>(0.18923747814892349015830640410601232624);
    rslt(2) = static_cast<FP>(0.27742918851774317650836026256065434043);
    rslt(3) = static_cast<FP>(0.27742918851774317650836026256065434043);
    rslt(4) = static_cast<FP>(0.18923747814892349015830640410601232624);
    rslt(5) = static_cast<FP>(0.033333333333333333333333333333333333333);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,6,6> &rslt) {
    rslt(0,0) = static_cast<FP>(0.062500000000000000000000000000000000024);
    rslt(0,1) = -static_cast<FP>(0.12499999999999999999999999999999999994);
    rslt(0,2) = -static_cast<FP>(3.5000000000000000000000000000000000002);
    rslt(0,3) = static_cast<FP>(6.9999999999999999999999999999999999988);
    rslt(0,4) = static_cast<FP>(21.000000000000000000000000000000000001);
    rslt(0,5) = -static_cast<FP>(41.999999999999999999999999999999999996);
    rslt(1,0) = -static_cast<FP>(0.19464864235384227976587746150613444156);
    rslt(1,1) = static_cast<FP>(0.50884854013979301136506301232055682986);
    rslt(1,2) = static_cast<FP>(10.348691760959919419130251199327596383);
    rslt(1,3) = -static_cast<FP>(27.053446822138658849852158166074844493);
    rslt(1,4) = -static_cast<FP>(38.280388766178201200266965413212234468);
    rslt(1,5) = static_cast<FP>(100.07221064631794721756762446717046870);
    rslt(2,0) = static_cast<FP>(0.63214864235384227976587746150613444154);
    rslt(2,1) = -static_cast<FP>(4.4325301085494728380317530910930682714);
    rslt(2,2) = -static_cast<FP>(6.8486917609599194191302511993275963830);
    rslt(2,3) = static_cast<FP>(48.021984705358812363345676306066266186);
    rslt(2,4) = static_cast<FP>(17.280388766178201200266965413212234468);
    rslt(2,5) = -static_cast<FP>(121.16745708464368404487465576677597240);
    rslt(3,0) = static_cast<FP>(0.63214864235384227976587746150613444150);
    rslt(3,1) = static_cast<FP>(4.4325301085494728380317530910930682715);
    rslt(3,2) = -static_cast<FP>(6.8486917609599194191302511993275963843);
    rslt(3,3) = -static_cast<FP>(48.021984705358812363345676306066266187);
    rslt(3,4) = static_cast<FP>(17.280388766178201200266965413212234473);
    rslt(3,5) = static_cast<FP>(121.16745708464368404487465576677597241);
    rslt(4,0) = -static_cast<FP>(0.19464864235384227976587746150613444152);
    rslt(4,1) = -static_cast<FP>(0.50884854013979301136506301232055682998);
    rslt(4,2) = static_cast<FP>(10.348691760959919419130251199327596384);
    rslt(4,3) = static_cast<FP>(27.053446822138658849852158166074844495);
    rslt(4,4) = -static_cast<FP>(38.280388766178201200266965413212234473);
    rslt(4,5) = -static_cast<FP>(100.07221064631794721756762446717046870);
    rslt(5,0) = static_cast<FP>(0.062500000000000000000000000000000000003);
    rslt(5,1) = static_cast<FP>(0.12499999999999999999999999999999999998);
    rslt(5,2) = -static_cast<FP>(3.5000000000000000000000000000000000002);
    rslt(5,3) = -static_cast<FP>(7.0000000000000000000000000000000000002);
    rslt(5,4) = static_cast<FP>(21.000000000000000000000000000000000001);
    rslt(5,5) = static_cast<FP>(42.000000000000000000000000000000000002);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,6,6> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,6,6> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,6> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.80000000000000000000000000000000000)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(63.000000000000000000000000000000000000)*a(3)*a(5)+static_cast<FP>(15645.000000000000000000000000000000000)*(a(5)*a(5));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,6,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,6,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,6,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,6,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,6,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,6,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,7> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(3) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(6) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,7> &rslt) {
    rslt(0) = static_cast<FP>(0.023809523809523809523809523809523809524);
    rslt(1) = static_cast<FP>(0.13841302368078297400535020314503314675);
    rslt(2) = static_cast<FP>(0.21587269060493131170893551114068113897);
    rslt(3) = static_cast<FP>(0.24380952380952380952380952380952380952);
    rslt(4) = static_cast<FP>(0.21587269060493131170893551114068113897);
    rslt(5) = static_cast<FP>(0.13841302368078297400535020314503314675);
    rslt(6) = static_cast<FP>(0.023809523809523809523809523809523809524);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = static_cast<FP>(6.0611427464274199629637977700522042756e-39);
    rslt(0,1) = -static_cast<FP>(0.62499999999999999999999999999999999999);
    rslt(0,2) = static_cast<FP>(1.2499999999999999999999999999999999997);
    rslt(0,3) = static_cast<FP>(15.000000000000000000000000000000000001);
    rslt(0,4) = -static_cast<FP>(29.999999999999999999999999999999999995);
    rslt(0,5) = -static_cast<FP>(66.000000000000000000000000000000000004);
    rslt(0,6) = static_cast<FP>(131.99999999999999999999999999999999999);
    rslt(1,0) = -static_cast<FP>(1.4613950617201271315489180017428114521e-38);
    rslt(1,1) = static_cast<FP>(1.8150889425376418376405588664029345352);
    rslt(1,2) = -static_cast<FP>(4.3725287857255818563724614843961589201);
    rslt(1,3) = -static_cast<FP>(40.289117874735898058375669436598805635);
    rslt(1,4) = static_cast<FP>(97.056030440293657473130876672558066695);
    rslt(1,5) = static_cast<FP>(132.11504841834132283125373588394826998);
    rslt(1,6) = -static_cast<FP>(318.26366118956532019056412293989372406);
    rslt(2,0) = static_cast<FP>(1.8250636265057723293267458679459437086e-38);
    rslt(2,1) = -static_cast<FP>(4.0139384811775061791440990040136220996);
    rslt(2,2) = static_cast<FP>(17.122528785725581856372461484396158919);
    rslt(2,3) = static_cast<FP>(39.349548674357579636378835701023537479);
    rslt(2,4) = -static_cast<FP>(167.85603044029365747313087667255806669);
    rslt(2,5) = -static_cast<FP>(93.175178998590219679209758739876196321);
    rslt(2,6) = static_cast<FP>(397.46366118956532019056412293989372404);
    rslt(3,0) = static_cast<FP>(0.99999999999999999999999999999999999998);
    rslt(3,1) = static_cast<FP>(1.3518185034456306341640470178055825295e-37);
    rslt(3,2) = -static_cast<FP>(27.999999999999999999999999999999999999);
    rslt(3,3) = -static_cast<FP>(9.4039548065783000637498922977779654225e-37);
    rslt(3,4) = static_cast<FP>(201.59999999999999999999999999999999999);
    rslt(3,5) = static_cast<FP>(2.6331073458419240178499698433778303183e-36);
    rslt(3,6) = -static_cast<FP>(422.39999999999999999999999999999999998);
    rslt(4,0) = static_cast<FP>(1.8250636265057723293267458679459437086e-38);
    rslt(4,1) = static_cast<FP>(4.0139384811775061791440990040136220996);
    rslt(4,2) = static_cast<FP>(17.122528785725581856372461484396158919);
    rslt(4,3) = -static_cast<FP>(39.349548674357579636378835701023537482);
    rslt(4,4) = -static_cast<FP>(167.85603044029365747313087667255806669);
    rslt(4,5) = static_cast<FP>(93.175178998590219679209758739876196333);
    rslt(4,6) = static_cast<FP>(397.46366118956532019056412293989372404);
    rslt(5,0) = -static_cast<FP>(1.4613950617201271315489180017428114521e-38);
    rslt(5,1) = -static_cast<FP>(1.8150889425376418376405588664029345356);
    rslt(5,2) = -static_cast<FP>(4.3725287857255818563724614843961589194);
    rslt(5,3) = static_cast<FP>(40.289117874735898058375669436598805643);
    rslt(5,4) = static_cast<FP>(97.056030440293657473130876672558066695);
    rslt(5,5) = -static_cast<FP>(132.11504841834132283125373588394827000);
    rslt(5,6) = -static_cast<FP>(318.26366118956532019056412293989372407);
    rslt(6,0) = static_cast<FP>(6.0611427464274199629637977700522042771e-39);
    rslt(6,1) = static_cast<FP>(0.62500000000000000000000000000000000009);
    rslt(6,2) = static_cast<FP>(1.2499999999999999999999999999999999999);
    rslt(6,3) = -static_cast<FP>(15.000000000000000000000000000000000002);
    rslt(6,4) = -static_cast<FP>(30.000000000000000000000000000000000005);
    rslt(6,5) = static_cast<FP>(66.000000000000000000000000000000000008);
    rslt(6,6) = static_cast<FP>(132.00000000000000000000000000000000002);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,7> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.892857142857142857142857142857143)*(a(5)*a(5))+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6071428571428571428571428571428571)*a(4)*a(6)+static_cast<FP>(563252.14285714285714285714285714285714)*(a(6)*a(6));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_coefs(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(0,1) = -static_cast<FP>(0.022482638888888888888888888888888888889);
    rslt(0,2) = static_cast<FP>(0.0096354166666666666666666666666666666667);
    rslt(0,3) = static_cast<FP>(0.024305555555555555555555555555555555556);
    rslt(0,4) = -static_cast<FP>(0.0086805555555555555555555555555555555555);
    rslt(0,5) = -static_cast<FP>(0.0041666666666666666666666666666666666667);
    rslt(0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(1,0) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(1,1) = static_cast<FP>(0.19409722222222222222222222222222222222);
    rslt(1,2) = -static_cast<FP>(0.12031250000000000000000000000000000000);
    rslt(1,3) = -static_cast<FP>(0.18055555555555555555555555555555555556);
    rslt(1,4) = static_cast<FP>(0.093750000000000000000000000000000000000);
    rslt(1,5) = static_cast<FP>(0.016666666666666666666666666666666666667);
    rslt(1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(2,0) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(2,1) = -static_cast<FP>(0.82074652777777777777777777777777777778);
    rslt(2,2) = static_cast<FP>(0.89453125000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.28819444444444444444444444444444444444);
    rslt(2,4) = -static_cast<FP>(0.29687500000000000000000000000000000000);
    rslt(2,5) = -static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(3,0) = static_cast<FP>(1.1254092261904761904761904761904761905);
    rslt(3,1) = 0;
    rslt(3,2) = -static_cast<FP>(1.5677083333333333333333333333333333333);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.42361111111111111111111111111111111111);
    rslt(3,5) = 0;
    rslt(3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(4,0) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(4,1) = static_cast<FP>(0.82074652777777777777777777777777777778);
    rslt(4,2) = static_cast<FP>(0.89453125000000000000000000000000000000);
    rslt(4,3) = -static_cast<FP>(0.28819444444444444444444444444444444444);
    rslt(4,4) = -static_cast<FP>(0.29687500000000000000000000000000000000);
    rslt(4,5) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(5,0) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(5,1) = -static_cast<FP>(0.19409722222222222222222222222222222222);
    rslt(5,2) = -static_cast<FP>(0.12031250000000000000000000000000000000);
    rslt(5,3) = static_cast<FP>(0.18055555555555555555555555555555555556);
    rslt(5,4) = static_cast<FP>(0.093750000000000000000000000000000000000);
    rslt(5,5) = -static_cast<FP>(0.016666666666666666666666666666666666667);
    rslt(5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(6,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(6,1) = static_cast<FP>(0.022482638888888888888888888888888888889);
    rslt(6,2) = static_cast<FP>(0.0096354166666666666666666666666666666667);
    rslt(6,3) = -static_cast<FP>(0.024305555555555555555555555555555555556);
    rslt(6,4) = -static_cast<FP>(0.0086805555555555555555555555555555555555);
    rslt(6,5) = static_cast<FP>(0.0041666666666666666666666666666666666667);
    rslt(6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_sten(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,5) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,6) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,4) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,5) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,6) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,2) = -static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,5) = static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,6) = static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(4,4) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,5) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,6) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,2) = -static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,5) = static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,6) = static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,1) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,2) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,3) = static_cast<FP>(0.0022321428571428571428571428571428571429);
    rslt(6,4) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,5) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,6) = static_cast<FP>(831.93973214285714285714285714285714286);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,1> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(1,0) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(2,0) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(3,0) = static_cast<FP>(1.1254092261904761904761904761904761905);
    rslt(4,0) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(5,0) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(6,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,2> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0095238095238095238095238095238095238095);
    rslt(0,1) = -static_cast<FP>(0.0071428571428571428571428571428571428572);
    rslt(1,0) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(1,1) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(2,0) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(2,1) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(3,0) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(3,1) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(4,0) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(4,1) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(5,0) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(5,1) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(6,0) = -static_cast<FP>(0.0071428571428571428571428571428571428571);
    rslt(6,1) = static_cast<FP>(0.0095238095238095238095238095238095238095);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,3> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0095238095238095238095238095238095238095);
    rslt(0,1) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(0,2) = -static_cast<FP>(0.0071428571428571428571428571428571428572);
    rslt(1,0) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(1,1) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(1,2) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(2,0) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(2,1) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(2,2) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(3,0) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(3,1) = static_cast<FP>(1.1254092261904761904761904761904761905);
    rslt(3,2) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(4,0) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(4,1) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(4,2) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(5,0) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(5,1) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(5,2) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(6,0) = -static_cast<FP>(0.0071428571428571428571428571428571428571);
    rslt(6,1) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(6,2) = static_cast<FP>(0.0095238095238095238095238095238095238095);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,4> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0095238095238095238095238095238095238095);
    rslt(0,1) = static_cast<FP>(0.0045205541648229652191055512744988504661);
    rslt(0,2) = -static_cast<FP>(0.0049951573394261398222801544491020250692);
    rslt(0,3) = -static_cast<FP>(0.0071428571428571428571428571428571428572);
    rslt(1,0) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(1,1) = -static_cast<FP>(0.038301626593019916570672671944038322949);
    rslt(1,2) = static_cast<FP>(0.044482578973972297523053624324990703901);
    rslt(1,3) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(2,0) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(2,1) = static_cast<FP>(0.15342118004275089849496356397733438246);
    rslt(2,2) = -static_cast<FP>(0.20720689432846518420924927826304866818);
    rslt(2,3) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(3,0) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(3,1) = static_cast<FP>(1.0480793650793650793650793650793650794);
    rslt(3,2) = static_cast<FP>(1.0480793650793650793650793650793650794);
    rslt(3,3) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(4,0) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(4,1) = -static_cast<FP>(0.20720689432846518420924927826304866818);
    rslt(4,2) = static_cast<FP>(0.15342118004275089849496356397733438246);
    rslt(4,3) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(5,0) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(5,1) = static_cast<FP>(0.044482578973972297523053624324990703901);
    rslt(5,2) = -static_cast<FP>(0.038301626593019916570672671944038322949);
    rslt(5,3) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(6,0) = -static_cast<FP>(0.0071428571428571428571428571428571428571);
    rslt(6,1) = -static_cast<FP>(0.0049951573394261398222801544491020250692);
    rslt(6,2) = static_cast<FP>(0.0045205541648229652191055512744988504660);
    rslt(6,3) = static_cast<FP>(0.0095238095238095238095238095238095238095);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,5> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0095238095238095238095238095238095238095);
    rslt(0,1) = static_cast<FP>(0.0067592944475906129021529745246007247484);
    rslt(0,2) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(0,3) = -static_cast<FP>(0.0062855335146460064881588054283908122120);
    rslt(0,4) = -static_cast<FP>(0.0071428571428571428571428571428571428572);
    rslt(1,0) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(1,1) = -static_cast<FP>(0.060215535287632500244293463070313549550);
    rslt(1,2) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(1,3) = static_cast<FP>(0.054311745200168943392981509717543870250);
    rslt(1,4) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(2,0) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(2,1) = static_cast<FP>(0.28020387410287909010293532459744136020);
    rslt(2,2) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(2,3) = -static_cast<FP>(0.23704303834000251089982550924272804630);
    rslt(2,4) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(3,0) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(3,1) = static_cast<FP>(0.96226919339164237123420796890184645287);
    rslt(3,2) = static_cast<FP>(1.1254092261904761904761904761904761905);
    rslt(3,3) = static_cast<FP>(0.96226919339164237123420796890184645287);
    rslt(3,4) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(4,0) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(4,1) = -static_cast<FP>(0.23704303834000251089982550924272804630);
    rslt(4,2) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(4,3) = static_cast<FP>(0.28020387410287909010293532459744136020);
    rslt(4,4) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(5,0) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(5,1) = static_cast<FP>(0.054311745200168943392981509717543870250);
    rslt(5,2) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(5,3) = -static_cast<FP>(0.060215535287632500244293463070313549550);
    rslt(5,4) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(6,0) = -static_cast<FP>(0.0071428571428571428571428571428571428571);
    rslt(6,1) = -static_cast<FP>(0.0062855335146460064881588054283908122120);
    rslt(6,2) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(6,3) = static_cast<FP>(0.0067592944475906129021529745246007247484);
    rslt(6,4) = static_cast<FP>(0.0095238095238095238095238095238095238095);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,6> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0095238095238095238095238095238095238095);
    rslt(0,1) = static_cast<FP>(0.0078047395779391306220065922058313560372);
    rslt(0,2) = static_cast<FP>(0.0026309745533436474346395019640175078498);
    rslt(0,3) = -static_cast<FP>(0.0036412681191317261806052182192743359119);
    rslt(0,4) = -static_cast<FP>(0.0067430056829329448801561022880230876460);
    rslt(0,5) = -static_cast<FP>(0.0071428571428571428571428571428571428572);
    rslt(1,0) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(1,1) = -static_cast<FP>(0.071028608702437210028081426436627816373);
    rslt(1,2) = -static_cast<FP>(0.020694154467180853327747007383821452716);
    rslt(1,3) = static_cast<FP>(0.033622982822397660699048224898535067717);
    rslt(1,4) = static_cast<FP>(0.057526588107361496131207016682055294846);
    rslt(1,5) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(2,0) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(2,1) = static_cast<FP>(0.35172068798091596034209313776625882365);
    rslt(2,2) = static_cast<FP>(0.063408277319203865028832810617352013979);
    rslt(2,3) = -static_cast<FP>(0.16902502748284959033609899041792503156);
    rslt(2,4) = -static_cast<FP>(0.24427413182079757189549715196921314293);
    rslt(2,5) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(3,0) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(3,1) = static_cast<FP>(0.90499373053995113970842793403971857241);
    rslt(3,2) = static_cast<FP>(1.0936982153742169966819306785411162306);
    rslt(3,3) = static_cast<FP>(1.0936982153742169966819306785411162306);
    rslt(3,4) = static_cast<FP>(0.90499373053995113970842793403971857241);
    rslt(3,5) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(4,0) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(4,1) = -static_cast<FP>(0.24427413182079757189549715196921314293);
    rslt(4,2) = -static_cast<FP>(0.16902502748284959033609899041792503156);
    rslt(4,3) = static_cast<FP>(0.063408277319203865028832810617352013979);
    rslt(4,4) = static_cast<FP>(0.35172068798091596034209313776625882365);
    rslt(4,5) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(5,0) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(5,1) = static_cast<FP>(0.057526588107361496131207016682055294846);
    rslt(5,2) = static_cast<FP>(0.033622982822397660699048224898535067717);
    rslt(5,3) = -static_cast<FP>(0.020694154467180853327747007383821452716);
    rslt(5,4) = -static_cast<FP>(0.071028608702437210028081426436627816373);
    rslt(5,5) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(6,0) = -static_cast<FP>(0.0071428571428571428571428571428571428571);
    rslt(6,1) = -static_cast<FP>(0.0067430056829329448801561022880230876460);
    rslt(6,2) = -static_cast<FP>(0.0036412681191317261806052182192743359119);
    rslt(6,3) = static_cast<FP>(0.0026309745533436474346395019640175078498);
    rslt(6,4) = static_cast<FP>(0.0078047395779391306220065922058313560373);
    rslt(6,5) = static_cast<FP>(0.0095238095238095238095238095238095238095);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,7,7> &rslt) {
    rslt(0,0) = static_cast<FP>(0.0095238095238095238095238095238095238095);
    rslt(0,1) = static_cast<FP>(0.0083577256691733430138833990091901121371);
    rslt(0,2) = static_cast<FP>(0.0047662893482324828565307753961952534868);
    rslt(0,3) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(0,4) = -static_cast<FP>(0.0051543239436376358378731626532159089609);
    rslt(0,5) = -static_cast<FP>(0.0069334033639267611828476992489395980612);
    rslt(0,6) = -static_cast<FP>(0.0071428571428571428571428571428571428572);
    rslt(1,0) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(1,1) = -static_cast<FP>(0.076980259687731275883765451799459251329);
    rslt(1,2) = -static_cast<FP>(0.040644108967488740525373217290077699323);
    rslt(1,3) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(1,4) = static_cast<FP>(0.045729635966791081323495230868582898760);
    rslt(1,5) = static_cast<FP>(0.058744040405505247203277869904972512770);
    rslt(1,6) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(2,0) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(2,1) = static_cast<FP>(0.39489886688139945417808185934196782635);
    rslt(2,2) = static_cast<FP>(0.16609085727057309131149264069933011168);
    rslt(2,3) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(2,4) = -static_cast<FP>(0.21131918945773330320491838242414076184);
    rslt(2,5) = -static_cast<FP>(0.24578829434505674434182759627623914105);
    rslt(2,6) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(3,0) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(3,1) = static_cast<FP>(0.86770132444063673701319761906850753919);
    rslt(3,2) = static_cast<FP>(1.0405308397832630240766461154033261062);
    rslt(3,3) = static_cast<FP>(1.1254092261904761904761904761904761905);
    rslt(3,4) = static_cast<FP>(1.0405308397832630240766461154033261062);
    rslt(3,5) = static_cast<FP>(0.86770132444063673701319761906850753919);
    rslt(3,6) = static_cast<FP>(0.75952380952380952380952380952380952381);
    rslt(4,0) = -static_cast<FP>(0.24047619047619047619047619047619047619);
    rslt(4,1) = -static_cast<FP>(0.24578829434505674434182759627623914105);
    rslt(4,2) = -static_cast<FP>(0.21131918945773330320491838242414076184);
    rslt(4,3) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(4,4) = static_cast<FP>(0.16609085727057309131149264069933011168);
    rslt(4,5) = static_cast<FP>(0.39489886688139945417808185934196782635);
    rslt(4,6) = static_cast<FP>(0.50952380952380952380952380952380952381);
    rslt(5,0) = static_cast<FP>(0.059523809523809523809523809523809523809);
    rslt(5,1) = static_cast<FP>(0.058744040405505247203277869904972512770);
    rslt(5,2) = static_cast<FP>(0.045729635966791081323495230868582898760);
    rslt(5,3) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(5,4) = -static_cast<FP>(0.040644108967488740525373217290077699323);
    rslt(5,5) = -static_cast<FP>(0.076980259687731275883765451799459251329);
    rslt(5,6) = -static_cast<FP>(0.090476190476190476190476190476190476190);
    rslt(6,0) = -static_cast<FP>(0.0071428571428571428571428571428571428571);
    rslt(6,1) = -static_cast<FP>(0.0069334033639267611828476992489395980612);
    rslt(6,2) = -static_cast<FP>(0.0051543239436376358378731626532159089609);
    rslt(6,3) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(6,4) = static_cast<FP>(0.0047662893482324828565307753961952534868);
    rslt(6,5) = static_cast<FP>(0.0083577256691733430138833990091901121371);
    rslt(6,6) = static_cast<FP>(0.0095238095238095238095238095238095238095);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void weno_lower_sten_to_coefs(SArray<FP,3,4,4,4> &rslt) {
    rslt(0,0,0) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,0,1) = -static_cast<FP>(0.29166666666666666666666666666666666667);
    rslt(0,0,2) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,0,3) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(0,1,0) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(0,1,1) = static_cast<FP>(1.3750000000000000000000000000000000000);
    rslt(0,1,2) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(0,1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,2,0) = static_cast<FP>(0.20833333333333333333333333333333333333);
    rslt(0,2,1) = -static_cast<FP>(2.8750000000000000000000000000000000000);
    rslt(0,2,2) = -static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(0,2,3) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,3,0) = static_cast<FP>(0.91666666666666666666666666666666666667);
    rslt(0,3,1) = static_cast<FP>(1.7916666666666666666666666666666666667);
    rslt(0,3,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3,3) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,0,0) = 0;
    rslt(1,0,1) = static_cast<FP>(0.20833333333333333333333333333333333333);
    rslt(1,0,2) = 0;
    rslt(1,0,3) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,1,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,1,1) = -static_cast<FP>(1.1250000000000000000000000000000000000);
    rslt(1,1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,2,0) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(1,2,1) = static_cast<FP>(0.62500000000000000000000000000000000000);
    rslt(1,2,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,2,3) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,3,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,3,1) = static_cast<FP>(0.29166666666666666666666666666666666667);
    rslt(1,3,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,3,3) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,0,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,0,1) = -static_cast<FP>(0.29166666666666666666666666666666666667);
    rslt(2,0,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0,3) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,1,0) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,1,1) = -static_cast<FP>(0.62500000000000000000000000000000000000);
    rslt(2,1,2) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(2,1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,2,0) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,2,1) = static_cast<FP>(1.1250000000000000000000000000000000000);
    rslt(2,2,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,2,3) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,3,0) = 0;
    rslt(2,3,1) = -static_cast<FP>(0.20833333333333333333333333333333333333);
    rslt(2,3,2) = 0;
    rslt(2,3,3) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,0,0) = static_cast<FP>(0.91666666666666666666666666666666666667);
    rslt(3,0,1) = -static_cast<FP>(1.7916666666666666666666666666666666667);
    rslt(3,0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(3,0,3) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,1,0) = static_cast<FP>(0.20833333333333333333333333333333333333);
    rslt(3,1,1) = static_cast<FP>(2.8750000000000000000000000000000000000);
    rslt(3,1,2) = -static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(3,1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(3,2,0) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,2,1) = -static_cast<FP>(1.3750000000000000000000000000000000000);
    rslt(3,2,2) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(3,2,3) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(3,3,0) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,3,1) = static_cast<FP>(0.29166666666666666666666666666666666667);
    rslt(3,3,2) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(3,3,3) = static_cast<FP>(0.16666666666666666666666666666666666667);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,8> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(7) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,8> &rslt) {
    rslt(0) = static_cast<FP>(0.017857142857142857142857142857142857143);
    rslt(1) = static_cast<FP>(0.10535211357175301969149603288787816223);
    rslt(2) = static_cast<FP>(0.17056134624175218238212033855387408589);
    rslt(3) = static_cast<FP>(0.20622939732935194078352648570110489474);
    rslt(4) = static_cast<FP>(0.20622939732935194078352648570110489474);
    rslt(5) = static_cast<FP>(0.17056134624175218238212033855387408589);
    rslt(6) = static_cast<FP>(0.10535211357175301969149603288787816223);
    rslt(7) = static_cast<FP>(0.017857142857142857142857142857142857143);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,8,8> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.039062500000000000000000000000000000062);
    rslt(0,1) = static_cast<FP>(0.078125000000000000000000000000000000274);
    rslt(0,2) = static_cast<FP>(4.2187500000000000000000000000000000019);
    rslt(0,3) = -static_cast<FP>(8.4374999999999999999999999999999999946);
    rslt(0,4) = -static_cast<FP>(61.875000000000000000000000000000000018);
    rslt(0,5) = static_cast<FP>(123.74999999999999999999999999999999995);
    rslt(0,6) = static_cast<FP>(214.50000000000000000000000000000000004);
    rslt(0,7) = -static_cast<FP>(428.99999999999999999999999999999999989);
    rslt(1,0) = static_cast<FP>(0.10884002339880918167461514219128443294);
    rslt(1,1) = -static_cast<FP>(0.24970749273138418440031484122782813184);
    rslt(1,2) = -static_cast<FP>(11.617188293937950904550790870920273373);
    rslt(1,3) = static_cast<FP>(26.652869697006800120188995582417326748);
    rslt(1,4) = static_cast<FP>(158.27283010354932063905513336163459985);
    rslt(1,5) = -static_cast<FP>(363.11928588844878007471046574762694369);
    rslt(1,6) = -static_cast<FP>(454.18206920871385571058324861205622913);
    rslt(1,7) = static_cast<FP>(1042.0125079364949061774380835104115472);
    rslt(2,0) = -static_cast<FP>(0.20402935346955608879459056579913553417);
    rslt(2,1) = static_cast<FP>(0.68963762348485904841641409579408726292);
    rslt(2,2) = static_cast<FP>(20.520250197949282301518197851422770413);
    rslt(2,3) = -static_cast<FP>(69.360297129697321871956631826346158892);
    rslt(2,4) = -static_cast<FP>(176.87911419227302497588054076542633330);
    rslt(2,5) = static_cast<FP>(597.86736506944621514068542736253812850);
    rslt(2,6) = static_cast<FP>(392.25033222395517276208479365008568079);
    rslt(2,7) = -static_cast<FP>(1325.8415141056586897100861023594355565);
    rslt(3,0) = static_cast<FP>(0.63425183007074690711997542360785110123);
    rslt(3,1) = -static_cast<FP>(6.0607185867867979654765087694717481307);
    rslt(3,2) = -static_cast<FP>(13.121811904011331396967406980502497031);
    rslt(3,3) = static_cast<FP>(125.38806437514089839889884820190898562);
    rslt(3,4) = static_cast<FP>(80.481284088723704336825407403791733384);
    rslt(3,5) = -static_cast<FP>(769.05480006354587887061252745193458045);
    rslt(3,6) = -static_cast<FP>(152.56826301524131705150154503802945154);
    rslt(3,7) = static_cast<FP>(1457.8961598062842108905650998233864322);
    rslt(4,0) = static_cast<FP>(0.63425183007074690711997542360785110107);
    rslt(4,1) = static_cast<FP>(6.0607185867867979654765087694717481298);
    rslt(4,2) = -static_cast<FP>(13.121811904011331396967406980502497039);
    rslt(4,3) = -static_cast<FP>(125.38806437514089839889884820190898561);
    rslt(4,4) = static_cast<FP>(80.481284088723704336825407403791733373);
    rslt(4,5) = static_cast<FP>(769.05480006354587887061252745193458038);
    rslt(4,6) = -static_cast<FP>(152.56826301524131705150154503802945132);
    rslt(4,7) = -static_cast<FP>(1457.8961598062842108905650998233864320);
    rslt(5,0) = -static_cast<FP>(0.20402935346955608879459056579913553404);
    rslt(5,1) = -static_cast<FP>(0.68963762348485904841641409579408726101);
    rslt(5,2) = static_cast<FP>(20.520250197949282301518197851422770415);
    rslt(5,3) = static_cast<FP>(69.360297129697321871956631826346158887);
    rslt(5,4) = -static_cast<FP>(176.87911419227302497588054076542633325);
    rslt(5,5) = -static_cast<FP>(597.86736506944621514068542736253812850);
    rslt(5,6) = static_cast<FP>(392.25033222395517276208479365008568052);
    rslt(5,7) = static_cast<FP>(1325.8415141056586897100861023594355564);
    rslt(6,0) = static_cast<FP>(0.10884002339880918167461514219128443292);
    rslt(6,1) = static_cast<FP>(0.24970749273138418440031484122782812974);
    rslt(6,2) = -static_cast<FP>(11.617188293937950904550790870920273379);
    rslt(6,3) = -static_cast<FP>(26.652869697006800120188995582417326733);
    rslt(6,4) = static_cast<FP>(158.27283010354932063905513336163459986);
    rslt(6,5) = static_cast<FP>(363.11928588844878007471046574762694355);
    rslt(6,6) = -static_cast<FP>(454.18206920871385571058324861205622907);
    rslt(6,7) = -static_cast<FP>(1042.0125079364949061774380835104115467);
    rslt(7,0) = -static_cast<FP>(0.039062500000000000000000000000000000002);
    rslt(7,1) = -static_cast<FP>(0.078124999999999999999999999999999999707);
    rslt(7,2) = static_cast<FP>(4.2187500000000000000000000000000000009);
    rslt(7,3) = static_cast<FP>(8.4375000000000000000000000000000000008);
    rslt(7,4) = -static_cast<FP>(61.874999999999999999999999999999999990);
    rslt(7,5) = -static_cast<FP>(123.74999999999999999999999999999999999);
    rslt(7,6) = static_cast<FP>(214.49999999999999999999999999999999995);
    rslt(7,7) = static_cast<FP>(428.99999999999999999999999999999999992);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,8,8> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,8,8> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,8> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.892857142857142857142857142857143)*(a(5)*a(5))+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6071428571428571428571428571428571)*a(4)*a(6)+static_cast<FP>(563252.14285714285714285714285714285714)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(32.625000000000000000000000000000000000)*a(3)*a(7)+static_cast<FP>(52976.250000000000000000000000000000000)*a(5)*a(7)+static_cast<FP>(2.7599355000000000000000000000000000000e7)*(a(7)*a(7));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,8,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,9> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(4) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(8) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,9> &rslt) {
    rslt(0) = static_cast<FP>(0.013888888888888888888888888888888888889);
    rslt(1) = static_cast<FP>(0.082747680780402762523169860014604152919);
    rslt(2) = static_cast<FP>(0.13726935625008086764035280928968636297);
    rslt(3) = static_cast<FP>(0.17321425548652317255756576606985914397);
    rslt(4) = static_cast<FP>(0.18575963718820861678004535147392290249);
    rslt(5) = static_cast<FP>(0.17321425548652317255756576606985914397);
    rslt(6) = static_cast<FP>(0.13726935625008086764035280928968636297);
    rslt(7) = static_cast<FP>(0.082747680780402762523169860014604152919);
    rslt(8) = static_cast<FP>(0.013888888888888888888888888888888888889);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = -static_cast<FP>(3.2831189876481858132720571254449439768e-38);
    rslt(0,1) = static_cast<FP>(0.54687499999999999999999999999999999946);
    rslt(0,2) = -static_cast<FP>(1.0937500000000000000000000000000000079);
    rslt(0,3) = -static_cast<FP>(24.062500000000000000000000000000000044);
    rslt(0,4) = static_cast<FP>(48.125000000000000000000000000000000006);
    rslt(0,5) = static_cast<FP>(250.25000000000000000000000000000000060);
    rslt(0,6) = -static_cast<FP>(500.49999999999999999999999999999999927);
    rslt(0,7) = -static_cast<FP>(715.00000000000000000000000000000000168);
    rslt(0,8) = static_cast<FP>(1429.9999999999999999999999999999999973);
    rslt(1,0) = static_cast<FP>(8.0136576713409163237392405573761714971e-38);
    rslt(1,1) = -static_cast<FP>(1.4835647958325084811527985406883634051);
    rslt(1,2) = static_cast<FP>(3.2976973884051409580460662718232845207);
    rslt(1,3) = static_cast<FP>(63.880922737948244780684791876642398764);
    rslt(1,4) = -static_cast<FP>(141.99578789791234957040216058259124883);
    rslt(1,5) = -static_cast<FP>(624.35558801477337109521249213837651099);
    rslt(1,6) = static_cast<FP>(1387.8300414085344971340552138702560928);
    rslt(1,7) = static_cast<FP>(1570.2757351852021106836724051312829216);
    rslt(1,8) = -static_cast<FP>(3490.4401921254694167247345275562545987);
    rslt(2,0) = -static_cast<FP>(7.9704364978773488700944829482686557854e-38);
    rslt(2,1) = static_cast<FP>(2.5388261727162990648431481864550176391);
    rslt(2,2) = -static_cast<FP>(7.4981618781484551860909359318346546631);
    rslt(2,3) = -static_cast<FP>(99.718606678432675483142687592697593162);
    rslt(2,4) = static_cast<FP>(294.50864465381270287876653748721280215);
    rslt(2,5) = static_cast<FP>(738.79928340719556092349753109520557893);
    rslt(2,6) = -static_cast<FP>(2181.9676675699122622370491319632943544);
    rslt(2,7) = -static_cast<FP>(1522.1843018277025761136686068307819540);
    rslt(2,8) = static_cast<FP>(4495.6147160201469347977518276951904814);
    rslt(3,0) = static_cast<FP>(1.1594304093243018862690819905881245735e-37);
    rslt(3,1) = -static_cast<FP>(5.3186204351478359858567106563152719969);
    rslt(3,2) = static_cast<FP>(29.294214489743314228044869660011370154);
    rslt(3,3) = static_cast<FP>(93.945361116427901157982282933233355335);
    rslt(3,4) = -static_cast<FP>(517.43785675590035330836437690462155300);
    rslt(3,5) = -static_cast<FP>(519.90285388744727000173496873165018077);
    rslt(3,6) = static_cast<FP>(2863.5519118756634793887082038073239710);
    rslt(3,7) = static_cast<FP>(916.87734553640416457405282999904444560);
    rslt(3,8) = -static_cast<FP>(5050.0316667518203752158744429960787257);
    rslt(4,0) = static_cast<FP>(0.99999999999999999999999999999999999988);
    rslt(4,1) = -static_cast<FP>(4.4081038155835781548827620145834212918e-37);
    rslt(4,2) = -static_cast<FP>(48.000000000000000000000000000000000010);
    rslt(4,3) = -static_cast<FP>(3.7728666683992139855764567898685197275e-34);
    rslt(4,4) = static_cast<FP>(633.59999999999999999999999999999999934);
    rslt(4,5) = static_cast<FP>(3.9075313012294152424893552475727001924e-33);
    rslt(4,6) = -static_cast<FP>(3137.8285714285714285714285714285714207);
    rslt(4,7) = -static_cast<FP>(9.6055755976313388171166899886423250012e-33);
    rslt(4,8) = static_cast<FP>(5229.7142857142857142857142857142856939);
    rslt(5,0) = static_cast<FP>(1.1594304093243018862690819905881245733e-37);
    rslt(5,1) = static_cast<FP>(5.3186204351478359858567106563152719984);
    rslt(5,2) = static_cast<FP>(29.294214489743314228044869660011370143);
    rslt(5,3) = -static_cast<FP>(93.945361116427901157982282933233354653);
    rslt(5,4) = -static_cast<FP>(517.43785675590035330836437690462155272);
    rslt(5,5) = static_cast<FP>(519.90285388744727000173496873165017369);
    rslt(5,6) = static_cast<FP>(2863.5519118756634793887082038073239697);
    rslt(5,7) = -static_cast<FP>(916.87734553640416457405282999904442818);
    rslt(5,8) = -static_cast<FP>(5050.0316667518203752158744429960787247);
    rslt(6,0) = -static_cast<FP>(1.0321425199521923886031956022713147130e-37);
    rslt(6,1) = -static_cast<FP>(2.5388261727162990648431481864550176419);
    rslt(6,2) = -static_cast<FP>(7.4981618781484551860909359318346546404);
    rslt(6,3) = static_cast<FP>(99.718606678432675483142687592697592673);
    rslt(6,4) = static_cast<FP>(294.50864465381270287876653748721280156);
    rslt(6,5) = -static_cast<FP>(738.79928340719556092349753109520557377);
    rslt(6,6) = -static_cast<FP>(2181.9676675699122622370491319632943510);
    rslt(6,7) = static_cast<FP>(1522.1843018277025761136686068307819414);
    rslt(6,8) = static_cast<FP>(4495.6147160201469347977518276951904764);
    rslt(7,0) = static_cast<FP>(8.0136576713409163237392405573761714867e-38);
    rslt(7,1) = static_cast<FP>(1.4835647958325084811527985406883634082);
    rslt(7,2) = static_cast<FP>(3.2976973884051409580460662718232844999);
    rslt(7,3) = -static_cast<FP>(63.880922737948244780684791876642398448);
    rslt(7,4) = -static_cast<FP>(141.99578789791234957040216058259124824);
    rslt(7,5) = static_cast<FP>(624.35558801477337109521249213837650747);
    rslt(7,6) = static_cast<FP>(1387.8300414085344971340552138702560894);
    rslt(7,7) = -static_cast<FP>(1570.2757351852021106836724051312829128);
    rslt(7,8) = -static_cast<FP>(3490.4401921254694167247345275562545942);
    rslt(8,0) = -static_cast<FP>(3.2831189876481858132720571254449439725e-38);
    rslt(8,1) = -static_cast<FP>(0.54687500000000000000000000000000000030);
    rslt(8,2) = -static_cast<FP>(1.0937499999999999999999999999999999984);
    rslt(8,3) = static_cast<FP>(24.062499999999999999999999999999999909);
    rslt(8,4) = static_cast<FP>(48.124999999999999999999999999999999766);
    rslt(8,5) = -static_cast<FP>(250.24999999999999999999999999999999921);
    rslt(8,6) = -static_cast<FP>(500.49999999999999999999999999999999792);
    rslt(8,7) = static_cast<FP>(714.99999999999999999999999999999999829);
    rslt(8,8) = static_cast<FP>(1429.9999999999999999999999999999999954);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(0,8) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(1,8) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(2,8) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(3,8) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(4,8) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(5,8) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(6,8) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
    rslt(7,8) = 0;
    rslt(8,0) = 0;
    rslt(8,1) = 0;
    rslt(8,2) = 0;
    rslt(8,3) = 0;
    rslt(8,4) = 0;
    rslt(8,5) = 0;
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(8.0000000000000000000000000000000000000);
    rslt(8,8) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,9> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.903707837301587301587301587301587)*(a(5)*a(5))+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6279761904761904761904761904761905)*a(4)*a(6)+static_cast<FP>(563252.53348214285714285714285714285714)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(32.643229166666666666666666666666666667)*a(3)*a(7)+static_cast<FP>(52976.979166666666666666666666666666667)*a(5)*a(7)+static_cast<FP>(2.7599374140625000000000000000000000000e7)*(a(7)*a(7))+static_cast<FP>(0.51388888888888888888888888888888888889)*a(2)*a(8)+static_cast<FP>(1044.5833333333333333333333333333333333)*a(4)*a(8)+static_cast<FP>(2.5428950000000000000000000000000000000e6)*a(6)*a(8)+static_cast<FP>(1.7663599450000000000000000000000000000e9)*(a(8)*a(8));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
    rslt(8,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = 0;
    rslt(8,2) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,2) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,3) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,2) = 0;
    rslt(8,3) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,4) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,2) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,3) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,4) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,5) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,2) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,3) = 0;
    rslt(8,4) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,5) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,6) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,2) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,3) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,4) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,5) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,6) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,7) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_coefs(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(0,1) = static_cast<FP>(0.0050052703373015873015873015873015873016);
    rslt(0,2) = -static_cast<FP>(0.0016684234457671957671957671957671957672);
    rslt(0,3) = -static_cast<FP>(0.0061197916666666666666666666666666666667);
    rslt(0,4) = static_cast<FP>(0.0016999421296296296296296296296296296296);
    rslt(0,5) = static_cast<FP>(0.0015625000000000000000000000000000000000);
    rslt(0,6) = -static_cast<FP>(0.00040509259259259259259259259259259259259);
    rslt(0,7) = -static_cast<FP>(0.000099206349206349206349206349206349206349);
    rslt(0,8) = static_cast<FP>(0.000024801587301587301587301587301587301587);
    rslt(1,0) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(1,1) = -static_cast<FP>(0.052514260912698412698412698412698412698);
    rslt(1,2) = static_cast<FP>(0.022982804232804232804232804232804232804);
    rslt(1,3) = static_cast<FP>(0.061024305555555555555555555555555555556);
    rslt(1,4) = -static_cast<FP>(0.022280092592592592592592592592592592593);
    rslt(1,5) = -static_cast<FP>(0.013541666666666666666666666666666666667);
    rslt(1,6) = static_cast<FP>(0.0046296296296296296296296296296296296296);
    rslt(1,7) = static_cast<FP>(0.00059523809523809523809523809523809523810);
    rslt(1,8) = -static_cast<FP>(0.00019841269841269841269841269841269841270);
    rslt(2,0) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(2,1) = static_cast<FP>(0.26417100694444444444444444444444444444);
    rslt(2,2) = -static_cast<FP>(0.16702835648148148148148148148148148148);
    rslt(2,3) = -static_cast<FP>(0.26623263888888888888888888888888888889);
    rslt(2,4) = static_cast<FP>(0.14134837962962962962962962962962962963);
    rslt(2,5) = static_cast<FP>(0.038541666666666666666666666666666666667);
    rslt(2,6) = -static_cast<FP>(0.019675925925925925925925925925925925926);
    rslt(2,7) = -static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(2,8) = static_cast<FP>(0.00069444444444444444444444444444444444444);
    rslt(3,0) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(3,1) = -static_cast<FP>(0.89082031250000000000000000000000000000);
    rslt(3,2) = static_cast<FP>(0.98796296296296296296296296296296296296);
    rslt(3,3) = static_cast<FP>(0.37387152777777777777777777777777777778);
    rslt(3,4) = -static_cast<FP>(0.39207175925925925925925925925925925926);
    rslt(3,5) = -static_cast<FP>(0.042708333333333333333333333333333333333);
    rslt(3,6) = static_cast<FP>(0.043518518518518518518518518518518518519);
    rslt(3,7) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(3,8) = -static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(4,0) = static_cast<FP>(1.1337167891245039682539682539682539683);
    rslt(4,1) = 0;
    rslt(4,2) = -static_cast<FP>(1.6844979745370370370370370370370370370);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.54260706018518518518518518518518518518);
    rslt(4,5) = 0;
    rslt(4,6) = -static_cast<FP>(0.056134259259259259259259259259259259259);
    rslt(4,7) = 0;
    rslt(4,8) = static_cast<FP>(0.0017361111111111111111111111111111111111);
    rslt(5,0) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(5,1) = static_cast<FP>(0.89082031250000000000000000000000000000);
    rslt(5,2) = static_cast<FP>(0.98796296296296296296296296296296296296);
    rslt(5,3) = -static_cast<FP>(0.37387152777777777777777777777777777778);
    rslt(5,4) = -static_cast<FP>(0.39207175925925925925925925925925925926);
    rslt(5,5) = static_cast<FP>(0.042708333333333333333333333333333333333);
    rslt(5,6) = static_cast<FP>(0.043518518518518518518518518518518518519);
    rslt(5,7) = -static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(5,8) = -static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(6,0) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(6,1) = -static_cast<FP>(0.26417100694444444444444444444444444444);
    rslt(6,2) = -static_cast<FP>(0.16702835648148148148148148148148148148);
    rslt(6,3) = static_cast<FP>(0.26623263888888888888888888888888888889);
    rslt(6,4) = static_cast<FP>(0.14134837962962962962962962962962962963);
    rslt(6,5) = -static_cast<FP>(0.038541666666666666666666666666666666667);
    rslt(6,6) = -static_cast<FP>(0.019675925925925925925925925925925925926);
    rslt(6,7) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(6,8) = static_cast<FP>(0.00069444444444444444444444444444444444444);
    rslt(7,0) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(7,1) = static_cast<FP>(0.052514260912698412698412698412698412698);
    rslt(7,2) = static_cast<FP>(0.022982804232804232804232804232804232804);
    rslt(7,3) = -static_cast<FP>(0.061024305555555555555555555555555555556);
    rslt(7,4) = -static_cast<FP>(0.022280092592592592592592592592592592593);
    rslt(7,5) = static_cast<FP>(0.013541666666666666666666666666666666667);
    rslt(7,6) = static_cast<FP>(0.0046296296296296296296296296296296296296);
    rslt(7,7) = -static_cast<FP>(0.00059523809523809523809523809523809523810);
    rslt(7,8) = -static_cast<FP>(0.00019841269841269841269841269841269841270);
    rslt(8,0) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(8,1) = -static_cast<FP>(0.0050052703373015873015873015873015873016);
    rslt(8,2) = -static_cast<FP>(0.0016684234457671957671957671957671957672);
    rslt(8,3) = static_cast<FP>(0.0061197916666666666666666666666666666667);
    rslt(8,4) = static_cast<FP>(0.0016999421296296296296296296296296296296);
    rslt(8,5) = -static_cast<FP>(0.0015625000000000000000000000000000000000);
    rslt(8,6) = -static_cast<FP>(0.00040509259259259259259259259259259259259);
    rslt(8,7) = static_cast<FP>(0.000099206349206349206349206349206349206349);
    rslt(8,8) = static_cast<FP>(0.000024801587301587301587301587301587301587);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_sten(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,2) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,3) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,6) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,7) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,8) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(16.083333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,4) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,5) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,6) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,7) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,8) = static_cast<FP>(16.083333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(65.000000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,2) = -static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,3) = -static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,6) = static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,7) = static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,8) = static_cast<FP>(65.000000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(264.01250000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,4) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(4,5) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,6) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,7) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,8) = static_cast<FP>(264.01250000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(1077.5833333333333333333333333333333333);
    rslt(5,1) = -static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,2) = -static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,3) = -static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,6) = static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,7) = static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,8) = static_cast<FP>(1077.5833333333333333333333333333333333);
    rslt(6,0) = static_cast<FP>(4419.0022321428571428571428571428571429);
    rslt(6,1) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,2) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,3) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,4) = static_cast<FP>(0.0022321428571428571428571428571428571429);
    rslt(6,5) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,6) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,7) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,8) = static_cast<FP>(4419.0022321428571428571428571428571429);
    rslt(7,0) = -static_cast<FP>(18204.062500000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(2624.1093750000000000000000000000000000);
    rslt(7,2) = -static_cast<FP>(187.53125000000000000000000000000000000);
    rslt(7,3) = -static_cast<FP>(3.2031250000000000000000000000000000000);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(3.2031250000000000000000000000000000000);
    rslt(7,6) = static_cast<FP>(187.53125000000000000000000000000000000);
    rslt(7,7) = static_cast<FP>(2624.1093750000000000000000000000000000);
    rslt(7,8) = static_cast<FP>(18204.062500000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(75318.333767361111111111111111111111111);
    rslt(8,1) = static_cast<FP>(8333.4379340277777777777777777777777778);
    rslt(8,2) = static_cast<FP>(419.58376736111111111111111111111111111);
    rslt(8,3) = static_cast<FP>(4.2712673611111111111111111111111111111);
    rslt(8,4) = static_cast<FP>(0.00043402777777777777777777777777777777778);
    rslt(8,5) = static_cast<FP>(4.2712673611111111111111111111111111111);
    rslt(8,6) = static_cast<FP>(419.58376736111111111111111111111111111);
    rslt(8,7) = static_cast<FP>(8333.4379340277777777777777777777777778);
    rslt(8,8) = static_cast<FP>(75318.333767361111111111111111111111111);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,1> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(1,0) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(2,0) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(3,0) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(4,0) = static_cast<FP>(1.1337167891245039682539682539682539683);
    rslt(5,0) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(6,0) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(7,0) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(8,0) = static_cast<FP>(0.00011867947048611111111111111111111111111);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,2> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,3> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(0,2) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(1,2) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(2,2) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(3,2) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(1.1337167891245039682539682539682539683);
    rslt(4,2) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(5,2) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(6,2) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(7,2) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(8,2) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,4> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = -static_cast<FP>(0.0010122041403172291328773092455741965321);
    rslt(0,2) = static_cast<FP>(0.0010911194842325730482212245894895404475);
    rslt(0,3) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = static_cast<FP>(0.010514863662810996101025491404028685743);
    rslt(1,2) = -static_cast<FP>(0.011620789588736922026951417329954611669);
    rslt(1,3) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = -static_cast<FP>(0.051920077150053717023547593974669666991);
    rslt(2,2) = static_cast<FP>(0.060310659160635727605558175985251677573);
    rslt(2,3) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = static_cast<FP>(0.16593481578496988413302367119315091169);
    rslt(3,2) = -static_cast<FP>(0.22413978932994342910656864473812445666);
    rslt(3,3) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(1.0508414021164021164021164021164021164);
    rslt(4,2) = static_cast<FP>(1.0508414021164021164021164021164021164);
    rslt(4,3) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.22413978932994342910656864473812445666);
    rslt(5,2) = static_cast<FP>(0.16593481578496988413302367119315091169);
    rslt(5,3) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.060310659160635727605558175985251677573);
    rslt(6,2) = -static_cast<FP>(0.051920077150053717023547593974669666991);
    rslt(6,3) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.011620789588736922026951417329954611669);
    rslt(7,2) = static_cast<FP>(0.010514863662810996101025491404028685743);
    rslt(7,3) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.0010911194842325730482212245894895404475);
    rslt(8,2) = -static_cast<FP>(0.0010122041403172291328773092455741965321);
    rslt(8,3) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,5> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = -static_cast<FP>(0.0014706255204890072278804035154270403243);
    rslt(0,2) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(0,3) = static_cast<FP>(0.0013885044796528476911794257482268657938);
    rslt(0,4) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = static_cast<FP>(0.015665168611360815806136373384363141225);
    rslt(1,2) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(1,3) = -static_cast<FP>(0.014534439351726933098534382150551832445);
    rslt(1,4) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = -static_cast<FP>(0.081379139860331718191525956656693335804);
    rslt(2,2) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(2,3) = static_cast<FP>(0.073175960629455694312586625822318769651);
    rslt(2,4) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = static_cast<FP>(0.30251717324728454156398150692462358988);
    rslt(3,2) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(3,3) = -static_cast<FP>(0.25475755919758302830561693660670050228);
    rslt(3,4) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(0.95939495696237678744967374704984034430);
    rslt(4,2) = static_cast<FP>(1.1337167891245039682539682539682539683);
    rslt(4,3) = static_cast<FP>(0.95939495696237678744967374704984034430);
    rslt(4,4) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.25475755919758302830561693660670050228);
    rslt(5,2) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(5,3) = static_cast<FP>(0.30251717324728454156398150692462358988);
    rslt(5,4) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.073175960629455694312586625822318769651);
    rslt(6,2) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(6,3) = -static_cast<FP>(0.081379139860331718191525956656693335804);
    rslt(6,4) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.014534439351726933098534382150551832445);
    rslt(7,2) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(7,3) = static_cast<FP>(0.015665168611360815806136373384363141225);
    rslt(7,4) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.0013885044796528476911794257482268657938);
    rslt(8,2) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(8,3) = -static_cast<FP>(0.0014706255204890072278804035154270403243);
    rslt(8,4) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,6> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = -static_cast<FP>(0.0016750980566781685147488298270986728696);
    rslt(0,2) = -static_cast<FP>(0.00061072600284503391378356375902828660999);
    rslt(0,3) = static_cast<FP>(0.00078161563926793429955867976894929007125);
    rslt(0,4) = static_cast<FP>(0.0014944665017359497608269254133975800651);
    rslt(0,5) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = static_cast<FP>(0.018035959472950360464421475582124486059);
    rslt(1,2) = static_cast<FP>(0.0061244409339909505315657685082662240485);
    rslt(1,3) = -static_cast<FP>(0.0085018515911622323637324128428910798006);
    rslt(1,4) = -static_cast<FP>(0.015529173138406424691195750354707475232);
    rslt(1,5) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = -static_cast<FP>(0.095744402380527100512018374911916886178);
    rslt(2,2) = -static_cast<FP>(0.028048091052051025420291087940770441027);
    rslt(2,3) = static_cast<FP>(0.045761829227109043593295553733272152943);
    rslt(2,4) = static_cast<FP>(0.077184698247069261505330641573713766127);
    rslt(2,5) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = static_cast<FP>(0.37896532342819691338093674803336319271);
    rslt(3,2) = static_cast<FP>(0.068369758994153431720525267035406953832);
    rslt(3,3) = -static_cast<FP>(0.18355632879748157863119794339155616525);
    rslt(3,4) = -static_cast<FP>(0.26140340019131427471471411506905631494);
    rslt(3,5) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(0.89867162611697348332116127956018032426);
    rslt(4,2) = static_cast<FP>(1.0996793526490185101840597388883513518);
    rslt(4,3) = static_cast<FP>(1.0996793526490185101840597388883513518);
    rslt(4,4) = static_cast<FP>(0.89867162611697348332116127956018032426);
    rslt(4,5) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.26140340019131427471471411506905631494);
    rslt(5,2) = -static_cast<FP>(0.18355632879748157863119794339155616525);
    rslt(5,3) = static_cast<FP>(0.068369758994153431720525267035406953832);
    rslt(5,4) = static_cast<FP>(0.37896532342819691338093674803336319271);
    rslt(5,5) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.077184698247069261505330641573713766127);
    rslt(6,2) = static_cast<FP>(0.045761829227109043593295553733272152943);
    rslt(6,3) = -static_cast<FP>(0.028048091052051025420291087940770441027);
    rslt(6,4) = -static_cast<FP>(0.095744402380527100512018374911916886178);
    rslt(6,5) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.015529173138406424691195750354707475232);
    rslt(7,2) = -static_cast<FP>(0.0085018515911622323637324128428910798006);
    rslt(7,3) = static_cast<FP>(0.0061244409339909505315657685082662240485);
    rslt(7,4) = static_cast<FP>(0.018035959472950360464421475582124486059);
    rslt(7,5) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.0014944665017359497608269254133975800651);
    rslt(8,2) = static_cast<FP>(0.00078161563926793429955867976894929007125);
    rslt(8,3) = -static_cast<FP>(0.00061072600284503391378356375902828660999);
    rslt(8,4) = -static_cast<FP>(0.0016750980566781685147488298270986728696);
    rslt(8,5) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,7> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = -static_cast<FP>(0.0017794336252631124758850627644794487846);
    rslt(0,2) = -static_cast<FP>(0.0010635616349088241108116002817167465317);
    rslt(0,3) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(0,4) = static_cast<FP>(0.0011276785714187893019397513672812118648);
    rslt(0,5) = static_cast<FP>(0.0015386466229802766032961976612262600277);
    rslt(0,6) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = static_cast<FP>(0.019275114423034853741782640699319993602);
    rslt(1,2) = static_cast<FP>(0.011083542221175462330272226000931267344);
    rslt(1,3) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(1,4) = -static_cast<FP>(0.011984512308660336840639821942467645483);
    rslt(1,5) = -static_cast<FP>(0.015924496099525584930036020113043969471);
    rslt(1,6) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = -static_cast<FP>(0.10357783945739470165427838622494385561);
    rslt(2,2) = -static_cast<FP>(0.055085153300642521738838563635160893435);
    rslt(2,3) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(2,4) = static_cast<FP>(0.061965954522223887888548807609471122199);
    rslt(2,5) = static_cast<FP>(0.078599584111249268541302581439367831859);
    rslt(2,6) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = static_cast<FP>(0.42486746468302258216483890521299707322);
    rslt(3,2) = static_cast<FP>(0.17963426449258735984916387184651079113);
    rslt(3,3) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(3,4) = -static_cast<FP>(0.22845314512430562244576607436293149995);
    rslt(3,5) = -static_cast<FP>(0.26227282001884106346360819636508981754);
    rslt(3,6) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(0.85927377936073748147258734045464593270);
    rslt(4,2) = static_cast<FP>(1.0427749325611118057661314033980823929);
    rslt(4,3) = static_cast<FP>(1.1337167891245039682539682539682539683);
    rslt(4,4) = static_cast<FP>(1.0427749325611118057661314033980823929);
    rslt(4,5) = static_cast<FP>(0.85927377936073748147258734045464593270);
    rslt(4,6) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.26227282001884106346360819636508981754);
    rslt(5,2) = -static_cast<FP>(0.22845314512430562244576607436293149995);
    rslt(5,3) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(5,4) = static_cast<FP>(0.17963426449258735984916387184651079113);
    rslt(5,5) = static_cast<FP>(0.42486746468302258216483890521299707322);
    rslt(5,6) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.078599584111249268541302581439367831859);
    rslt(6,2) = static_cast<FP>(0.061965954522223887888548807609471122199);
    rslt(6,3) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(6,4) = -static_cast<FP>(0.055085153300642521738838563635160893435);
    rslt(6,5) = -static_cast<FP>(0.10357783945739470165427838622494385561);
    rslt(6,6) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.015924496099525584930036020113043969471);
    rslt(7,2) = -static_cast<FP>(0.011984512308660336840639821942467645483);
    rslt(7,3) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(7,4) = static_cast<FP>(0.011083542221175462330272226000931267344);
    rslt(7,5) = static_cast<FP>(0.019275114423034853741782640699319993601);
    rslt(7,6) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.0015386466229802766032961976612262600277);
    rslt(8,2) = static_cast<FP>(0.0011276785714187893019397513672812118648);
    rslt(8,3) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(8,4) = -static_cast<FP>(0.0010635616349088241108116002817167465317);
    rslt(8,5) = -static_cast<FP>(0.0017794336252631124758850627644794487846);
    rslt(8,6) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,8> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = -static_cast<FP>(0.0018388468575092664613390146477983461264);
    rslt(0,2) = -static_cast<FP>(0.0013404596869395151556790436399737034961);
    rslt(0,3) = -static_cast<FP>(0.00041619442814757557634417163616459787592);
    rslt(0,4) = static_cast<FP>(0.00061741646062190561289283341336818801777);
    rslt(0,5) = static_cast<FP>(0.0013112597463952443534374539538298957171);
    rslt(0,6) = static_cast<FP>(0.0015594851198194017452915909525230128438);
    rslt(0,7) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = static_cast<FP>(0.019994044161029297470241101693109269180);
    rslt(1,2) = static_cast<FP>(0.014183747924333451278162689959159118480);
    rslt(1,3) = static_cast<FP>(0.0040278789507429794403193785163195409508);
    rslt(1,4) = -static_cast<FP>(0.0068237777594338139036232745895051037488);
    rslt(1,5) = -static_cast<FP>(0.013789655389639583851159635664666541093);
    rslt(1,6) = -static_cast<FP>(0.016100688727175147239147928696380592691);
    rslt(1,7) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = -static_cast<FP>(0.10826926596427481731407400782255535890);
    rslt(2,2) = -static_cast<FP>(0.072702038151064744891230726195085247940);
    rslt(2,3) = -static_cast<FP>(0.016957251551103873795532982491996651889);
    rslt(2,4) = static_cast<FP>(0.037724255858947070771348961277332996623);
    rslt(2,5) = static_cast<FP>(0.069993990904575319204760411237562455994);
    rslt(2,6) = static_cast<FP>(0.079131314120942856921120280648192093851);
    rslt(2,7) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = static_cast<FP>(0.45430557411958636782790766540788410061);
    rslt(3,2) = static_cast<FP>(0.25993765734268124345192871716585114130);
    rslt(3,3) = static_cast<FP>(0.026042912021729154670675846425019225848);
    rslt(3,4) = -static_cast<FP>(0.15954918517415971357253673216697290830);
    rslt(3,5) = -static_cast<FP>(0.24799115927658996846080793690215827967);
    rslt(3,6) = -static_cast<FP>(0.26167478955035362700955912337675837420);
    rslt(3,7) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(0.83289317357793493405955943584178419544);
    rslt(4,2) = static_cast<FP>(0.99039665658624855407058807008548116071);
    rslt(4,3) = static_cast<FP>(1.1153339456208038663528001412525993104);
    rslt(4,4) = static_cast<FP>(1.1153339456208038663528001412525993104);
    rslt(4,5) = static_cast<FP>(0.99039665658624855407058807008548116071);
    rslt(4,6) = static_cast<FP>(0.83289317357793493405955943584178419544);
    rslt(4,7) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.26167478955035362700955912337675837420);
    rslt(5,2) = -static_cast<FP>(0.24799115927658996846080793690215827967);
    rslt(5,3) = -static_cast<FP>(0.15954918517415971357253673216697290830);
    rslt(5,4) = static_cast<FP>(0.026042912021729154670675846425019225848);
    rslt(5,5) = static_cast<FP>(0.25993765734268124345192871716585114130);
    rslt(5,6) = static_cast<FP>(0.45430557411958636782790766540788410060);
    rslt(5,7) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.079131314120942856921120280648192093851);
    rslt(6,2) = static_cast<FP>(0.069993990904575319204760411237562455994);
    rslt(6,3) = static_cast<FP>(0.037724255858947070771348961277332996623);
    rslt(6,4) = -static_cast<FP>(0.016957251551103873795532982491996651889);
    rslt(6,5) = -static_cast<FP>(0.072702038151064744891230726195085247940);
    rslt(6,6) = -static_cast<FP>(0.10826926596427481731407400782255535890);
    rslt(6,7) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.016100688727175147239147928696380592691);
    rslt(7,2) = -static_cast<FP>(0.013789655389639583851159635664666541093);
    rslt(7,3) = -static_cast<FP>(0.0068237777594338139036232745895051037488);
    rslt(7,4) = static_cast<FP>(0.0040278789507429794403193785163195409508);
    rslt(7,5) = static_cast<FP>(0.014183747924333451278162689959159118480);
    rslt(7,6) = static_cast<FP>(0.019994044161029297470241101693109269180);
    rslt(7,7) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.0015594851198194017452915909525230128438);
    rslt(8,2) = static_cast<FP>(0.0013112597463952443534374539538298957171);
    rslt(8,3) = static_cast<FP>(0.00061741646062190561289283341336818801777);
    rslt(8,4) = -static_cast<FP>(0.00041619442814757557634417163616459787592);
    rslt(8,5) = -static_cast<FP>(0.0013404596869395151556790436399737034961);
    rslt(8,6) = -static_cast<FP>(0.0018388468575092664613390146477983461264);
    rslt(8,7) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,9,9> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
    rslt(0,1) = -static_cast<FP>(0.0018756515517187235930421352592919290194);
    rslt(0,2) = -static_cast<FP>(0.0015149547284211572743987999348898638976);
    rslt(0,3) = -static_cast<FP>(0.00080691731860155656429728897982770131655);
    rslt(0,4) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(0,5) = static_cast<FP>(0.00093794720683940667354276250659150864189);
    rslt(0,6) = static_cast<FP>(0.0014132340956560759763343941103454056898);
    rslt(0,7) = static_cast<FP>(0.0015702954371221725811557899287180284704);
    rslt(0,8) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(1,0) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(1,1) = static_cast<FP>(0.020445976463589778150888124999809154447);
    rslt(1,2) = static_cast<FP>(0.016174073649052107199605935352808405643);
    rslt(1,3) = static_cast<FP>(0.0082584415493626751276207973637738194615);
    rslt(1,4) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(1,5) = -static_cast<FP>(0.010085299456173812733472335913090849741);
    rslt(1,6) = -static_cast<FP>(0.014770088043393046266233934935100414408);
    rslt(1,7) = -static_cast<FP>(0.016186091260809415234737727812725675312);
    rslt(1,8) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(2,0) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(2,1) = -static_cast<FP>(0.11129045242272933415775332315506195159);
    rslt(2,2) = -static_cast<FP>(0.084407589707456683265699304442740508473);
    rslt(2,3) = -static_cast<FP>(0.039533965514762263640625411586893459628);
    rslt(2,4) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(2,5) = static_cast<FP>(0.053219618311948738679870462393896206844);
    rslt(2,6) = static_cast<FP>(0.074157720116672016949082193570666856994);
    rslt(2,7) = static_cast<FP>(0.079327887963392426346180140428736218299);
    rslt(2,8) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(3,0) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(3,1) = static_cast<FP>(0.47422901567469387071846803903264534049);
    rslt(3,2) = static_cast<FP>(0.31795357430755679688768451389644738190);
    rslt(3,3) = static_cast<FP>(0.11412350310648491374402186543684848658);
    rslt(3,4) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(3,5) = -static_cast<FP>(0.20489063154518055962042672299414328510);
    rslt(3,6) = -static_cast<FP>(0.25665045531504295287023436099325319258);
    rslt(3,7) = -static_cast<FP>(0.26077424758544573348548565265855531899);
    rslt(3,8) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(4,0) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(4,1) = static_cast<FP>(0.81455326728190495867432674449572613321);
    rslt(4,2) = static_cast<FP>(0.94764448562537684266385936337571592913);
    rslt(4,3) = static_cast<FP>(1.0787773036600824583337658717728452743);
    rslt(4,4) = static_cast<FP>(1.1337167891245039682539682539682539683);
    rslt(4,5) = static_cast<FP>(1.0787773036600824583337658717728452743);
    rslt(4,6) = static_cast<FP>(0.94764448562537684266385936337571592913);
    rslt(4,7) = static_cast<FP>(0.81455326728190495867432674449572613321);
    rslt(4,8) = static_cast<FP>(0.74563492063492063492063492063492063492);
    rslt(5,0) = -static_cast<FP>(0.25436507936507936507936507936507936508);
    rslt(5,1) = -static_cast<FP>(0.26077424758544573348548565265855531899);
    rslt(5,2) = -static_cast<FP>(0.25665045531504295287023436099325319258);
    rslt(5,3) = -static_cast<FP>(0.20489063154518055962042672299414328510);
    rslt(5,4) = -static_cast<FP>(0.077525886656746031746031746031746031746);
    rslt(5,5) = static_cast<FP>(0.11412350310648491374402186543684848658);
    rslt(5,6) = static_cast<FP>(0.31795357430755679688768451389644738190);
    rslt(5,7) = static_cast<FP>(0.47422901567469387071846803903264534049);
    rslt(5,8) = static_cast<FP>(0.54563492063492063492063492063492063492);
    rslt(6,0) = static_cast<FP>(0.078968253968253968253968253968253968254);
    rslt(6,1) = static_cast<FP>(0.079327887963392426346180140428736218299);
    rslt(6,2) = static_cast<FP>(0.074157720116672016949082193570666856994);
    rslt(6,3) = static_cast<FP>(0.053219618311948738679870462393896206844);
    rslt(6,4) = static_cast<FP>(0.012195793030753968253968253968253968254);
    rslt(6,5) = -static_cast<FP>(0.039533965514762263640625411586893459628);
    rslt(6,6) = -static_cast<FP>(0.084407589707456683265699304442740508473);
    rslt(6,7) = -static_cast<FP>(0.11129045242272933415775332315506195159);
    rslt(6,8) = -static_cast<FP>(0.12103174603174603174603174603174603175);
    rslt(7,0) = -static_cast<FP>(0.016269841269841269841269841269841269841);
    rslt(7,1) = -static_cast<FP>(0.016186091260809415234737727812725675312);
    rslt(7,2) = -static_cast<FP>(0.014770088043393046266233934935100414408);
    rslt(7,3) = -static_cast<FP>(0.010085299456173812733472335913090849741);
    rslt(7,4) = -static_cast<FP>(0.0016469804067460317460317460317460317460);
    rslt(7,5) = static_cast<FP>(0.0082584415493626751276207973637738194615);
    rslt(7,6) = static_cast<FP>(0.016174073649052107199605935352808405643);
    rslt(7,7) = static_cast<FP>(0.020445976463589778150888124999809154448);
    rslt(7,8) = static_cast<FP>(0.021825396825396825396825396825396825397);
    rslt(8,0) = static_cast<FP>(0.0015873015873015873015873015873015873016);
    rslt(8,1) = static_cast<FP>(0.0015702954371221725811557899287180284704);
    rslt(8,2) = static_cast<FP>(0.0014132340956560759763343941103454056898);
    rslt(8,3) = static_cast<FP>(0.00093794720683940667354276250659150864189);
    rslt(8,4) = static_cast<FP>(0.00011867947048611111111111111111111111111);
    rslt(8,5) = -static_cast<FP>(0.00080691731860155656429728897982770131655);
    rslt(8,6) = -static_cast<FP>(0.0015149547284211572743987999348898638976);
    rslt(8,7) = -static_cast<FP>(0.0018756515517187235930421352592919290194);
    rslt(8,8) = -static_cast<FP>(0.0019841269841269841269841269841269841270);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void weno_lower_sten_to_coefs(SArray<FP,3,5,5,5> &rslt) {
    rslt(0,0,0) = -static_cast<FP>(0.036979166666666666666666666666666666667);
    rslt(0,0,1) = static_cast<FP>(0.18750000000000000000000000000000000000);
    rslt(0,0,2) = static_cast<FP>(0.43750000000000000000000000000000000000);
    rslt(0,0,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(0,0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,1,0) = static_cast<FP>(0.18958333333333333333333333333333333333);
    rslt(0,1,1) = -static_cast<FP>(1.0416666666666666666666666666666666667);
    rslt(0,1,2) = -static_cast<FP>(2.2500000000000000000000000000000000000);
    rslt(0,1,3) = -static_cast<FP>(1.1666666666666666666666666666666666667);
    rslt(0,1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(0,2,0) = -static_cast<FP>(0.38854166666666666666666666666666666667);
    rslt(0,2,1) = static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(0,2,2) = static_cast<FP>(4.6250000000000000000000000000000000000);
    rslt(0,2,3) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(0,2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(0,3,0) = static_cast<FP>(0.35625000000000000000000000000000000000);
    rslt(0,3,1) = -static_cast<FP>(3.6250000000000000000000000000000000000);
    rslt(0,3,2) = -static_cast<FP>(4.2500000000000000000000000000000000000);
    rslt(0,3,3) = -static_cast<FP>(1.5000000000000000000000000000000000000);
    rslt(0,3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(0,4,0) = static_cast<FP>(0.87968750000000000000000000000000000000);
    rslt(0,4,1) = static_cast<FP>(1.9791666666666666666666666666666666667);
    rslt(0,4,2) = static_cast<FP>(1.4375000000000000000000000000000000000);
    rslt(0,4,3) = static_cast<FP>(0.41666666666666666666666666666666666667);
    rslt(0,4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,0,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(1,0,1) = -static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(1,0,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(1,0,3) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(1,0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,1,0) = -static_cast<FP>(0.018750000000000000000000000000000000000);
    rslt(1,1,1) = static_cast<FP>(0.62500000000000000000000000000000000000);
    rslt(1,1,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(1,1,3) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,2,0) = -static_cast<FP>(0.013541666666666666666666666666666666667);
    rslt(1,2,1) = -static_cast<FP>(1.7500000000000000000000000000000000000);
    rslt(1,2,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(1,2,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(1,3,0) = static_cast<FP>(1.0645833333333333333333333333333333333);
    rslt(1,3,1) = static_cast<FP>(1.0416666666666666666666666666666666667);
    rslt(1,3,2) = -static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(1,3,3) = -static_cast<FP>(0.83333333333333333333333333333333333333);
    rslt(1,3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(1,4,0) = -static_cast<FP>(0.036979166666666666666666666666666666667);
    rslt(1,4,1) = static_cast<FP>(0.18750000000000000000000000000000000000);
    rslt(1,4,2) = static_cast<FP>(0.43750000000000000000000000000000000000);
    rslt(1,4,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(1,4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,0,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(2,0,1) = static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(2,0,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(2,0,3) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,1,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(2,1,1) = -static_cast<FP>(0.70833333333333333333333333333333333333);
    rslt(2,1,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(2,1,3) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,2,0) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(2,2,1) = 0;
    rslt(2,2,2) = -static_cast<FP>(1.3750000000000000000000000000000000000);
    rslt(2,2,3) = 0;
    rslt(2,2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,3,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(2,3,1) = static_cast<FP>(0.70833333333333333333333333333333333333);
    rslt(2,3,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(2,3,3) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,4,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(2,4,1) = -static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(2,4,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(2,4,3) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,0,0) = -static_cast<FP>(0.036979166666666666666666666666666666667);
    rslt(3,0,1) = -static_cast<FP>(0.18750000000000000000000000000000000000);
    rslt(3,0,2) = static_cast<FP>(0.43750000000000000000000000000000000000);
    rslt(3,0,3) = -static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,1,0) = static_cast<FP>(1.0645833333333333333333333333333333333);
    rslt(3,1,1) = -static_cast<FP>(1.0416666666666666666666666666666666667);
    rslt(3,1,2) = -static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(3,1,3) = static_cast<FP>(0.83333333333333333333333333333333333333);
    rslt(3,1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,2,0) = -static_cast<FP>(0.013541666666666666666666666666666666667);
    rslt(3,2,1) = static_cast<FP>(1.7500000000000000000000000000000000000);
    rslt(3,2,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,2,3) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(3,2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,3,0) = -static_cast<FP>(0.018750000000000000000000000000000000000);
    rslt(3,3,1) = -static_cast<FP>(0.62500000000000000000000000000000000000);
    rslt(3,3,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,3,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(3,3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,4,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(3,4,1) = static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(3,4,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(3,4,3) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(3,4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(4,0,0) = static_cast<FP>(0.87968750000000000000000000000000000000);
    rslt(4,0,1) = -static_cast<FP>(1.9791666666666666666666666666666666667);
    rslt(4,0,2) = static_cast<FP>(1.4375000000000000000000000000000000000);
    rslt(4,0,3) = -static_cast<FP>(0.41666666666666666666666666666666666667);
    rslt(4,0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(4,1,0) = static_cast<FP>(0.35625000000000000000000000000000000000);
    rslt(4,1,1) = static_cast<FP>(3.6250000000000000000000000000000000000);
    rslt(4,1,2) = -static_cast<FP>(4.2500000000000000000000000000000000000);
    rslt(4,1,3) = static_cast<FP>(1.5000000000000000000000000000000000000);
    rslt(4,1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(4,2,0) = -static_cast<FP>(0.38854166666666666666666666666666666667);
    rslt(4,2,1) = -static_cast<FP>(2.5000000000000000000000000000000000000);
    rslt(4,2,2) = static_cast<FP>(4.6250000000000000000000000000000000000);
    rslt(4,2,3) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(4,2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(4,3,0) = static_cast<FP>(0.18958333333333333333333333333333333333);
    rslt(4,3,1) = static_cast<FP>(1.0416666666666666666666666666666666667);
    rslt(4,3,2) = -static_cast<FP>(2.2500000000000000000000000000000000000);
    rslt(4,3,3) = static_cast<FP>(1.1666666666666666666666666666666666667);
    rslt(4,3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(4,4,0) = -static_cast<FP>(0.036979166666666666666666666666666666667);
    rslt(4,4,1) = -static_cast<FP>(0.18750000000000000000000000000000000000);
    rslt(4,4,2) = static_cast<FP>(0.43750000000000000000000000000000000000);
    rslt(4,4,3) = -static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(4,4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,10> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(9) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,10> &rslt) {
    rslt(0) = static_cast<FP>(0.011111111111111111111111111111111111111);
    rslt(1) = static_cast<FP>(0.066652995425535055563113585377696449054);
    rslt(2) = static_cast<FP>(0.11244467103156322605972891086552392138);
    rslt(3) = static_cast<FP>(0.14602134183984187893779112868722194610);
    rslt(4) = static_cast<FP>(0.16376988059194872832825526395844657235);
    rslt(5) = static_cast<FP>(0.16376988059194872832825526395844657235);
    rslt(6) = static_cast<FP>(0.14602134183984187893779112868722194610);
    rslt(7) = static_cast<FP>(0.11244467103156322605972891086552392138);
    rslt(8) = static_cast<FP>(0.066652995425535055563113585377696449054);
    rslt(9) = static_cast<FP>(0.011111111111111111111111111111111111111);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,10,10> &rslt) {
    rslt(0,0) = static_cast<FP>(0.027343749999999999999999999999999999827);
    rslt(0,1) = -static_cast<FP>(0.054687499999999999999999999999999994559);
    rslt(0,2) = -static_cast<FP>(4.8125000000000000000000000000000000319);
    rslt(0,3) = static_cast<FP>(9.6249999999999999999999999999999997798);
    rslt(0,4) = static_cast<FP>(125.12500000000000000000000000000000043);
    rslt(0,5) = -static_cast<FP>(250.24999999999999999999999999999999718);
    rslt(0,6) = -static_cast<FP>(1001.0000000000000000000000000000000025);
    rslt(0,7) = static_cast<FP>(2001.9999999999999999999999999999999861);
    rslt(0,8) = static_cast<FP>(2431.0000000000000000000000000000000044);
    rslt(0,9) = -static_cast<FP>(4861.9999999999999999999999999999999773);
    rslt(1,0) = -static_cast<FP>(0.072831862577668069819304728461183716713);
    rslt(1,1) = static_cast<FP>(0.15841039015710482532296063841041239739);
    rslt(1,2) = static_cast<FP>(12.765190296687043077608420633898340709);
    rslt(1,3) = -static_cast<FP>(27.764479772454942233317400834256169909);
    rslt(1,4) = -static_cast<FP>(324.16407574431937782110192305187875908);
    rslt(1,5) = static_cast<FP>(705.06171195078433083152784730503434241);
    rslt(1,6) = static_cast<FP>(2465.8234716244880600356294887083052074);
    rslt(1,7) = -static_cast<FP>(5363.2029221006428871511722731789769606);
    rslt(1,8) = -static_cast<FP>(5474.9958967569299260980840960865914571);
    rslt(1,9) = static_cast<FP>(11908.197942746919722949879265794687665);
    rslt(2,0) = static_cast<FP>(0.11774358235405709459636274716639340273);
    rslt(2,1) = -static_cast<FP>(0.31875405429303325285741509437756993060);
    rslt(2,2) = -static_cast<FP>(20.330917561820405188247678179222290904);
    rslt(2,3) = static_cast<FP>(55.039623143455204399525444183694236119);
    rslt(2,4) = static_cast<FP>(472.68348833397839785617402913398743450);
    rslt(2,5) = -static_cast<FP>(1279.6432322804867231102958547025166860);
    rslt(2,6) = -static_cast<FP>(3001.3003451955115246856777288450434422);
    rslt(2,7) = static_cast<FP>(8125.0853257157185882246676438504377888);
    rslt(2,8) = static_cast<FP>(5713.3019343122590488751089894320047215);
    rslt(2,9) = -static_cast<FP>(15466.984429657203351972067063757257389);
    rslt(3,0) = -static_cast<FP>(0.20740909365743629868574531312716115556);
    rslt(3,1) = static_cast<FP>(0.86795675237168215911639139029894073837);
    rslt(3,2) = static_cast<FP>(33.701448362149193490486215089122131610);
    rslt(3,3) = -static_cast<FP>(141.03238751404766025357397038796097587);
    rslt(3,4) = -static_cast<FP>(504.93367847677039804998575707675543885);
    rslt(3,5) = static_cast<FP>(2113.0249788258100181667283803922453342);
    rslt(3,6) = static_cast<FP>(2546.7511033623658624088269058352944139);
    rslt(3,7) = -static_cast<FP>(10657.535683677795596037037759216813951);
    rslt(3,8) = -static_cast<FP>(4211.8615250223817717631024756563537989);
    rslt(3,9) = static_cast<FP>(17625.618945790121716975434859504304085);
    rslt(4,0) = static_cast<FP>(0.63515362388104727390868729442195146978);
    rslt(4,1) = -static_cast<FP>(7.6858377236755675761994025029869635517);
    rslt(4,2) = -static_cast<FP>(21.323221097015831379846957543798181445);
    rslt(4,3) = static_cast<FP>(258.02705193792929940683336026874940726);
    rslt(4,4) = static_cast<FP>(231.28926588711137801491365099464676419);
    rslt(4,5) = -static_cast<FP>(2798.7744980091793881646313493804966408);
    rslt(4,6) = -static_cast<FP>(1010.2742297913423977587786656985561861);
    rslt(4,7) = static_cast<FP>(12225.079877749048174151405371754239265);
    rslt(4,8) = static_cast<FP>(1542.5554874670526489860775823109405518);
    rslt(4,9) = -static_cast<FP>(18666.084409615852348501807913364310203);
    rslt(5,0) = static_cast<FP>(0.63515362388104727390868729442195146911);
    rslt(5,1) = static_cast<FP>(7.6858377236755675761994025029869635591);
    rslt(5,2) = -static_cast<FP>(21.323221097015831379846957543798181149);
    rslt(5,3) = -static_cast<FP>(258.02705193792929940683336026874940752);
    rslt(5,4) = static_cast<FP>(231.28926588711137801491365099464676000);
    rslt(5,5) = static_cast<FP>(2798.7744980091793881646313493804966449);
    rslt(5,6) = -static_cast<FP>(1010.2742297913423977587786656985561611);
    rslt(5,7) = -static_cast<FP>(12225.079877749048174151405371754239286);
    rslt(5,8) = static_cast<FP>(1542.5554874670526489860775823109405033);
    rslt(5,9) = static_cast<FP>(18666.084409615852348501807913364310237);
    rslt(6,0) = -static_cast<FP>(0.20740909365743629868574531312716115496);
    rslt(6,1) = -static_cast<FP>(0.86795675237168215911639139029894075737);
    rslt(6,2) = static_cast<FP>(33.701448362149193490486215089122131332);
    rslt(6,3) = static_cast<FP>(141.03238751404766025357397038796097656);
    rslt(6,4) = -static_cast<FP>(504.93367847677039804998575707675543484);
    rslt(6,5) = -static_cast<FP>(2113.0249788258100181667283803922453443);
    rslt(6,6) = static_cast<FP>(2546.7511033623658624088269058352943896);
    rslt(6,7) = static_cast<FP>(10657.535683677795596037037759216814000);
    rslt(6,8) = -static_cast<FP>(4211.8615250223817717631024756563537512);
    rslt(6,9) = -static_cast<FP>(17625.618945790121716975434859504304158);
    rslt(7,0) = static_cast<FP>(0.11774358235405709459636274716639340206);
    rslt(7,1) = static_cast<FP>(0.31875405429303325285741509437756995335);
    rslt(7,2) = -static_cast<FP>(20.330917561820405188247678179222290646);
    rslt(7,3) = -static_cast<FP>(55.039623143455204399525444183694237006);
    rslt(7,4) = static_cast<FP>(472.68348833397839785617402913398743032);
    rslt(7,5) = static_cast<FP>(1279.6432322804867231102958547025166991);
    rslt(7,6) = -static_cast<FP>(3001.3003451955115246856777288450434149);
    rslt(7,7) = -static_cast<FP>(8125.0853257157185882246676438504378554);
    rslt(7,8) = static_cast<FP>(5713.3019343122590488751089894320046647);
    rslt(7,9) = static_cast<FP>(15466.984429657203351972067063757257495);
    rslt(8,0) = -static_cast<FP>(0.072831862577668069819304728461183716261);
    rslt(8,1) = -static_cast<FP>(0.15841039015710482532296063841041241950);
    rslt(8,2) = static_cast<FP>(12.765190296687043077608420633898340524);
    rslt(8,3) = static_cast<FP>(27.764479772454942233317400834256170770);
    rslt(8,4) = -static_cast<FP>(324.16407574431937782110192305187875624);
    rslt(8,5) = -static_cast<FP>(705.06171195078433083152784730503435393);
    rslt(8,6) = static_cast<FP>(2465.8234716244880600356294887083051898);
    rslt(8,7) = static_cast<FP>(5363.2029221006428871511722731789770130);
    rslt(8,8) = -static_cast<FP>(5474.9958967569299260980840960865914211);
    rslt(8,9) = -static_cast<FP>(11908.197942746919722949879265794687739);
    rslt(9,0) = static_cast<FP>(0.027343749999999999999999999999999999890);
    rslt(9,1) = static_cast<FP>(0.054687500000000000000000000000000001076);
    rslt(9,2) = -static_cast<FP>(4.8124999999999999999999999999999999878);
    rslt(9,3) = -static_cast<FP>(9.6249999999999999999999999999999999854);
    rslt(9,4) = static_cast<FP>(125.12499999999999999999999999999999974);
    rslt(9,5) = static_cast<FP>(250.24999999999999999999999999999999979);
    rslt(9,6) = -static_cast<FP>(1000.9999999999999999999999999999999975);
    rslt(9,7) = -static_cast<FP>(2001.9999999999999999999999999999999970);
    rslt(9,8) = static_cast<FP>(2430.9999999999999999999999999999999930);
    rslt(9,9) = static_cast<FP>(4861.9999999999999999999999999999999901);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,10,10> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,9) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,2) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,3) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,4) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,5) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,6) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,7) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,8) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,9) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,2) = -static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,3) = -static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,4) = -static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,5) = static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,6) = static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,7) = static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,8) = static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,9) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,2) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,3) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,4) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,5) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,6) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,7) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,8) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,9) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,2) = -static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,3) = -static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,4) = -static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,5) = static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,6) = static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,7) = static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,8) = static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,9) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,2) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,3) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,4) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,5) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,6) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,7) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,8) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,9) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,2) = -static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,3) = -static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,4) = -static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,5) = static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,6) = static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,7) = static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,8) = static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,9) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,2) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,3) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,4) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,5) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,6) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,7) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,8) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,9) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,2) = -static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,3) = -static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,4) = -static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,5) = static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,6) = static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,7) = static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,8) = static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,9) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,10,10> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(0,8) = 0;
    rslt(0,9) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(1,8) = 0;
    rslt(1,9) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(2,8) = 0;
    rslt(2,9) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(3,8) = 0;
    rslt(3,9) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(4,8) = 0;
    rslt(4,9) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(5,8) = 0;
    rslt(5,9) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(6,8) = 0;
    rslt(6,9) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
    rslt(7,8) = 0;
    rslt(7,9) = 0;
    rslt(8,0) = 0;
    rslt(8,1) = 0;
    rslt(8,2) = 0;
    rslt(8,3) = 0;
    rslt(8,4) = 0;
    rslt(8,5) = 0;
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(8.0000000000000000000000000000000000000);
    rslt(8,8) = 0;
    rslt(8,9) = 0;
    rslt(9,0) = 0;
    rslt(9,1) = 0;
    rslt(9,2) = 0;
    rslt(9,3) = 0;
    rslt(9,4) = 0;
    rslt(9,5) = 0;
    rslt(9,6) = 0;
    rslt(9,7) = 0;
    rslt(9,8) = static_cast<FP>(9.0000000000000000000000000000000000000);
    rslt(9,9) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,10> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.903707837301587301587301587301587)*(a(5)*a(5))+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6279761904761904761904761904761905)*a(4)*a(6)+static_cast<FP>(563252.53348214285714285714285714285714)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(32.643229166666666666666666666666666667)*a(3)*a(7)+static_cast<FP>(52976.979166666666666666666666666666667)*a(5)*a(7)+static_cast<FP>(2.7599374140625000000000000000000000000e7)*(a(7)*a(7))+static_cast<FP>(0.51388888888888888888888888888888888889)*a(2)*a(8)+static_cast<FP>(1044.5833333333333333333333333333333333)*a(4)*a(8)+static_cast<FP>(2.5428950000000000000000000000000000000e6)*a(6)*a(8)+static_cast<FP>(1.7663599450000000000000000000000000000e9)*(a(8)*a(8))+static_cast<FP>(0.0078125000000000000000000000000000000000)*a(1)*a(9)+static_cast<FP>(13.875000000000000000000000000000000000)*a(3)*a(9)+static_cast<FP>(47006.250000000000000000000000000000000)*a(5)*a(9)+static_cast<FP>(1.6020238500000000000000000000000000000e8)*a(7)*a(9)+static_cast<FP>(1.4307515554500000000000000000000000000e11)*(a(9)*a(9));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
    rslt(8,0) = 0;
    rslt(9,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = 0;
    rslt(8,2) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = 0;
    rslt(9,2) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,2) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,3) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,2) = static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,3) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,2) = 0;
    rslt(8,3) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,4) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,2) = 0;
    rslt(9,3) = static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,4) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,2) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,3) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,4) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,5) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,2) = -static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,3) = static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,4) = static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,5) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,2) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,3) = 0;
    rslt(8,4) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,5) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,6) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,2) = -static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,3) = 0;
    rslt(9,4) = static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,5) = static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,6) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,2) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,3) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,4) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,5) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,6) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,7) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,2) = -static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,3) = -static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,4) = static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,5) = static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,6) = static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,7) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,9> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,2) = -static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,3) = -static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,4) = 0;
    rslt(9,5) = static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,6) = static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,7) = static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,8) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,10,10> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,9) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,2) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,3) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,4) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,5) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,6) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,7) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,8) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,9) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,2) = -static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,3) = -static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,4) = -static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,5) = static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,6) = static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,7) = static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,8) = static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,9) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,2) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,3) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,4) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,5) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,6) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,7) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,8) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,9) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,2) = -static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,3) = -static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,4) = -static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,5) = static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,6) = static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,7) = static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,8) = static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,9) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,2) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,3) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,4) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,5) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,6) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,7) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,8) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,9) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,2) = -static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,3) = -static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,4) = -static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,5) = static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,6) = static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,7) = static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,8) = static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,9) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,2) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,3) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,4) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,5) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,6) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,7) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,8) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,9) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,2) = -static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,3) = -static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,4) = -static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,5) = static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,6) = static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,7) = static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,8) = static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,9) = static_cast<FP>(0.0019531250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,11> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(2) = -static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(3) = -static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(4) = -static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(5) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(6) = static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(7) = static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(8) = static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(9) = static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(10) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,11> &rslt) {
    rslt(0) = static_cast<FP>(0.0090909090909090909090909090909090909091);
    rslt(1) = static_cast<FP>(0.054806136633497432230701724790175355024);
    rslt(2) = static_cast<FP>(0.093584940890152602054070760949717459784);
    rslt(3) = static_cast<FP>(0.12402405213201415702004243321093637667);
    rslt(4) = static_cast<FP>(0.14343956238950404433961120166576761559);
    rslt(5) = static_cast<FP>(0.15010879772784534689296594058498820404);
    rslt(6) = static_cast<FP>(0.14343956238950404433961120166576761559);
    rslt(7) = static_cast<FP>(0.12402405213201415702004243321093637667);
    rslt(8) = static_cast<FP>(0.093584940890152602054070760949717459784);
    rslt(9) = static_cast<FP>(0.054806136633497432230701724790175355024);
    rslt(10) = static_cast<FP>(0.0090909090909090909090909090909090909091);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = static_cast<FP>(1.2424768658325223479003535068969703809e-37);
    rslt(0,1) = -static_cast<FP>(0.49218749999999999999999999999999995149);
    rslt(0,2) = static_cast<FP>(0.98437500000000000000000000000000016587);
    rslt(0,3) = static_cast<FP>(34.124999999999999999999999999999996992);
    rslt(0,4) = -static_cast<FP>(68.250000000000000000000000000000009675);
    rslt(0,5) = -static_cast<FP>(614.24999999999999999999999999999995744);
    rslt(0,6) = static_cast<FP>(1228.5000000000000000000000000000001307);
    rslt(0,7) = static_cast<FP>(3977.9999999999999999999999999999997846);
    rslt(0,8) = -static_cast<FP>(7956.0000000000000000000000000000006465);
    rslt(0,9) = -static_cast<FP>(8397.9999999999999999999999999999996355);
    rslt(0,10) = static_cast<FP>(16796.000000000000000000000000000001072);
    rslt(1,0) = -static_cast<FP>(2.9490551131841750842414284898881435437e-37);
    rslt(1,1) = static_cast<FP>(1.2938799276642020194101121458483151771);
    rslt(1,2) = -static_cast<FP>(2.7706165869551491294618962287824450318);
    rslt(1,3) = -static_cast<FP>(88.951739283952832651679170955528816957);
    rslt(1,4) = static_cast<FP>(190.47452474476489358657432702432861890);
    rslt(1,5) = static_cast<FP>(1565.7304463030907659905236057561259113);
    rslt(1,6) = -static_cast<FP>(3352.7367203689042405676876632276844303);
    rslt(1,7) = -static_cast<FP>(9737.2590968586818055166785618235378259);
    rslt(1,8) = static_cast<FP>(20850.629945190847946898954098543067081);
    rslt(1,9) = static_cast<FP>(19259.027299276220538956814787012812312);
    rslt(1,10) = -static_cast<FP>(41239.823992265358950911325277518043131);
    rslt(2,0) = static_cast<FP>(3.8227910673444363396618603076297895594e-37);
    rslt(2,1) = -static_cast<FP>(2.0130108171535586683789468467928361887);
    rslt(2,2) = static_cast<FP>(5.1320668560519385794249246878585759896);
    rslt(2,3) = static_cast<FP>(134.53685451773274032009331377183146381);
    rslt(2,4) = -static_cast<FP>(342.99474503780964911614386507622788946);
    rslt(2,5) = -static_cast<FP>(2196.0651556132170435089036886467426197);
    rslt(2,6) = static_cast<FP>(5598.7544144395905531646169022527756277);
    rslt(2,7) = static_cast<FP>(12044.944061543600508103920015449627569);
    rslt(2,8) = -static_cast<FP>(30707.961266028338490398958529534454968);
    rslt(2,9) = -static_cast<FP>(21137.761676306513697654182732068875969);
    rslt(2,10) = static_cast<FP>(53889.629000350426378062390326880199310);
    rslt(3,0) = -static_cast<FP>(3.5869282701824333396531917448504830963e-37);
    rslt(3,1) = static_cast<FP>(3.2162558074510303837812464775720236908);
    rslt(3,2) = -static_cast<FP>(11.380236350558550086646943183927206866);
    rslt(3,3) = -static_cast<FP>(195.59150836364322560756337791694186155);
    rslt(3,4) = static_cast<FP>(692.07106853374869904733570084679582521);
    rslt(3,5) = static_cast<FP>(2457.0730396460935259270111710581035983);
    rslt(3,6) = -static_cast<FP>(8693.9825672381950384326267498510671231);
    rslt(3,7) = -static_cast<FP>(11287.900589030775151894669040070467876);
    rslt(3,8) = static_cast<FP>(39940.534676122825519062900667067183186);
    rslt(3,9) = static_cast<FP>(17532.928770351306853382554511778054996);
    rslt(3,10) = -static_cast<FP>(62037.625509097109378177442069761226634);
    rslt(4,0) = static_cast<FP>(4.1429826177583717844577633398991445889e-37);
    rslt(4,1) = -static_cast<FP>(6.6103537067566433847795539760273824528);
    rslt(4,2) = static_cast<FP>(44.701077748128427303350581391517742877);
    rslt(4,3) = static_cast<FP>(182.47796579192638583422008327078034509);
    rslt(4,4) = -static_cast<FP>(1233.9675149073706101844328294615632359);
    rslt(4,5) = -static_cast<FP>(1738.5561915717964835121610008363091950);
    rslt(4,6) = static_cast<FP>(11756.607730310365868692840367968833255);
    rslt(4,7) = static_cast<FP>(6924.1528849893347934544612423926886064);
    rslt(4,8) = -static_cast<FP>(46823.076371158350848578769251948812066);
    rslt(4,9) = -static_cast<FP>(9866.0517365621834245097884676567394740);
    rslt(4,10) = static_cast<FP>(66717.026850218391157375583369605421111);
    rslt(5,0) = static_cast<FP>(0.99999999999999999999999999999999999958);
    rslt(5,1) = -static_cast<FP>(1.8166677444783042291902838814501195828e-34);
    rslt(5,2) = -static_cast<FP>(73.333333333333333333333333333333334219);
    rslt(5,3) = static_cast<FP>(1.1377656841382953681129719693235604805e-32);
    rslt(5,4) = static_cast<FP>(1525.3333333333333333333333333333333778);
    rslt(5,5) = -static_cast<FP>(1.5598226990213747376141181355616737911e-31);
    rslt(5,6) = -static_cast<FP>(13074.285714285714285714285714285714848);
    rslt(5,7) = static_cast<FP>(7.5802195198651119131466971847714508099e-31);
    rslt(5,8) = static_cast<FP>(49391.746031746031746031746031746034386);
    rslt(5,9) = -static_cast<FP>(1.2267210780774498766040051505294694555e-30);
    rslt(5,10) = -static_cast<FP>(68250.412698412698412698412698412702598);
    rslt(6,0) = static_cast<FP>(4.0254331826761430336608896861769199473e-37);
    rslt(6,1) = static_cast<FP>(6.6103537067566433847795539760273828054);
    rslt(6,2) = static_cast<FP>(44.701077748128427303350581391517742696);
    rslt(6,3) = -static_cast<FP>(182.47796579192638583422008327078036703);
    rslt(6,4) = -static_cast<FP>(1233.9675149073706101844328294615632276);
    rslt(6,5) = static_cast<FP>(1738.5561915717964835121610008363094959);
    rslt(6,6) = static_cast<FP>(11756.607730310365868692840367968833119);
    rslt(6,7) = -static_cast<FP>(6924.1528849893347934544612423926900706);
    rslt(6,8) = -static_cast<FP>(46823.076371158350848578769251948811287);
    rslt(6,9) = static_cast<FP>(9866.0517365621834245097884676567418485);
    rslt(6,10) = static_cast<FP>(66717.026850218391157375583369605419672);
    rslt(7,0) = -static_cast<FP>(3.5869282701824333396531917448504829720e-37);
    rslt(7,1) = -static_cast<FP>(3.2162558074510303837812464775720240092);
    rslt(7,2) = -static_cast<FP>(11.380236350558550086646943183927206529);
    rslt(7,3) = static_cast<FP>(195.59150836364322560756337791694188088);
    rslt(7,4) = static_cast<FP>(692.07106853374869904733570084679581032);
    rslt(7,5) = -static_cast<FP>(2457.0730396460935259270111710581038618);
    rslt(7,6) = -static_cast<FP>(8693.9825672381950384326267498510668891);
    rslt(7,7) = static_cast<FP>(11287.900589030775151894669040070469153);
    rslt(7,8) = static_cast<FP>(39940.534676122825519062900667067181869);
    rslt(7,9) = -static_cast<FP>(17532.928770351306853382554511778057059);
    rslt(7,10) = -static_cast<FP>(62037.625509097109378177442069761224225);
    rslt(8,0) = static_cast<FP>(2.8823955866866063332868710778519928592e-37);
    rslt(8,1) = static_cast<FP>(2.0130108171535586683789468467928364561);
    rslt(8,2) = static_cast<FP>(5.1320668560519385794249246878585755557);
    rslt(8,3) = -static_cast<FP>(134.53685451773274032009331377183147978);
    rslt(8,4) = -static_cast<FP>(342.99474503780964911614386507622787021);
    rslt(8,5) = static_cast<FP>(2196.0651556132170435089036886467428373);
    rslt(8,6) = static_cast<FP>(5598.7544144395905531646169022527753304);
    rslt(8,7) = -static_cast<FP>(12044.944061543600508103920015449628631);
    rslt(8,8) = -static_cast<FP>(30707.961266028338490398958529534453295);
    rslt(8,9) = static_cast<FP>(21137.761676306513697654182732068877708);
    rslt(8,10) = static_cast<FP>(53889.629000350426378062390326880196229);
    rslt(9,0) = -static_cast<FP>(2.0086596325263450778664392601103468782e-37);
    rslt(9,1) = -static_cast<FP>(1.2938799276642020194101121458483153563);
    rslt(9,2) = -static_cast<FP>(2.7706165869551491294618962287824446718);
    rslt(9,3) = static_cast<FP>(88.951739283952832651679170955528827403);
    rslt(9,4) = static_cast<FP>(190.47452474476489358657432702432860349);
    rslt(9,5) = -static_cast<FP>(1565.7304463030907659905236057561260503);
    rslt(9,6) = -static_cast<FP>(3352.7367203689042405676876632276841956);
    rslt(9,7) = static_cast<FP>(9737.2590968586818055166785618235384885);
    rslt(9,8) = static_cast<FP>(20850.629945190847946898954098543065773);
    rslt(9,9) = -static_cast<FP>(19259.027299276220538956814787012813375);
    rslt(9,10) = -static_cast<FP>(41239.823992265358950911325277518040734);
    rslt(10,0) = static_cast<FP>(7.7227912550360734471285889200807206251e-38);
    rslt(10,1) = static_cast<FP>(0.49218750000000000000000000000000001557);
    rslt(10,2) = static_cast<FP>(0.98437500000000000000000000000000003433);
    rslt(10,3) = -static_cast<FP>(34.125000000000000000000000000000000742);
    rslt(10,4) = -static_cast<FP>(68.250000000000000000000000000000003769);
    rslt(10,5) = static_cast<FP>(614.25000000000000000000000000000000634);
    rslt(10,6) = static_cast<FP>(1228.5000000000000000000000000000000404);
    rslt(10,7) = -static_cast<FP>(3978.0000000000000000000000000000000109);
    rslt(10,8) = -static_cast<FP>(7956.0000000000000000000000000000001447);
    rslt(10,9) = static_cast<FP>(8397.9999999999999999999999999999999873);
    rslt(10,10) = static_cast<FP>(16796.000000000000000000000000000000159);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,2) = -static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,3) = -static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,4) = -static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,5) = 0;
    rslt(1,6) = static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,7) = static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,8) = static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,9) = static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,10) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,2) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,3) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,4) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,5) = 0;
    rslt(2,6) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,7) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,8) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,9) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,10) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,2) = -static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,3) = -static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,4) = -static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,5) = 0;
    rslt(3,6) = static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,7) = static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,8) = static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,9) = static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,10) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,2) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,3) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,4) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,5) = 0;
    rslt(4,6) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,7) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,8) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,9) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,10) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,2) = -static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,3) = -static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,4) = -static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,5) = 0;
    rslt(5,6) = static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,7) = static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,8) = static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,9) = static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,10) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,2) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,3) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,4) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,5) = 0;
    rslt(6,6) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,7) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,8) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,9) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,10) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,2) = -static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,3) = -static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,4) = -static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,7) = static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,8) = static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,9) = static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,10) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,2) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,3) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,4) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,5) = 0;
    rslt(8,6) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,7) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,8) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,9) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,10) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,2) = -static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,3) = -static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,4) = -static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,5) = 0;
    rslt(9,6) = static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,7) = static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,8) = static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,9) = static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,10) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,2) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,3) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,4) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,5) = 0;
    rslt(10,6) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,7) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,8) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,9) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,10) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(0,8) = 0;
    rslt(0,9) = 0;
    rslt(0,10) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(1,8) = 0;
    rslt(1,9) = 0;
    rslt(1,10) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(2,8) = 0;
    rslt(2,9) = 0;
    rslt(2,10) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(3,8) = 0;
    rslt(3,9) = 0;
    rslt(3,10) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(4,8) = 0;
    rslt(4,9) = 0;
    rslt(4,10) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(5,8) = 0;
    rslt(5,9) = 0;
    rslt(5,10) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(6,8) = 0;
    rslt(6,9) = 0;
    rslt(6,10) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
    rslt(7,8) = 0;
    rslt(7,9) = 0;
    rslt(7,10) = 0;
    rslt(8,0) = 0;
    rslt(8,1) = 0;
    rslt(8,2) = 0;
    rslt(8,3) = 0;
    rslt(8,4) = 0;
    rslt(8,5) = 0;
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(8.0000000000000000000000000000000000000);
    rslt(8,8) = 0;
    rslt(8,9) = 0;
    rslt(8,10) = 0;
    rslt(9,0) = 0;
    rslt(9,1) = 0;
    rslt(9,2) = 0;
    rslt(9,3) = 0;
    rslt(9,4) = 0;
    rslt(9,5) = 0;
    rslt(9,6) = 0;
    rslt(9,7) = 0;
    rslt(9,8) = static_cast<FP>(9.0000000000000000000000000000000000000);
    rslt(9,9) = 0;
    rslt(9,10) = 0;
    rslt(10,0) = 0;
    rslt(10,1) = 0;
    rslt(10,2) = 0;
    rslt(10,3) = 0;
    rslt(10,4) = 0;
    rslt(10,5) = 0;
    rslt(10,6) = 0;
    rslt(10,7) = 0;
    rslt(10,8) = 0;
    rslt(10,9) = static_cast<FP>(10.000000000000000000000000000000000000);
    rslt(10,10) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,11> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(1.4307515635684090909090909090909090909e13)*(a(10)*a(10))+static_cast<FP>(0.15980113636363636363636363636363636364)*a(10)*a(2)+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(555.19176136363636363636363636363636364)*a(10)*a(4)+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.903707837301587301587301587301587)*(a(5)*a(5))+static_cast<FP>(2.8203903409090909090909090909090909091e6)*a(10)*a(6)+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6279761904761904761904761904761905)*a(4)*a(6)+static_cast<FP>(563252.53667816558441558441558441558442)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(32.643229166666666666666666666666666667)*a(3)*a(7)+static_cast<FP>(52976.985381155303030303030303030303030)*a(5)*a(7)+static_cast<FP>(2.7599374297230113636363636363636363636e7)*(a(7)*a(7))+static_cast<FP>(1.2816192303409090909090909090909090909e10)*a(10)*a(8)+static_cast<FP>(0.51388888888888888888888888888888888889)*a(2)*a(8)+static_cast<FP>(1044.5890151515151515151515151515151515)*a(4)*a(8)+static_cast<FP>(2.5428952982954545454545454545454545455e6)*a(6)*a(8)+static_cast<FP>(1.7663599550227272727272727272727272727e9)*(a(8)*a(8))+static_cast<FP>(0.0078125000000000000000000000000000000000)*a(1)*a(9)+static_cast<FP>(13.879794034090909090909090909090909091)*a(3)*a(9)+static_cast<FP>(47006.505681818181818181818181818181818)*a(5)*a(9)+static_cast<FP>(1.6020240379261363636363636363636363636e8)*a(7)*a(9)+static_cast<FP>(1.4307515635684090909090909090909090909e11)*(a(9)*a(9));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
    rslt(8,0) = 0;
    rslt(9,0) = 0;
    rslt(10,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = 0;
    rslt(8,2) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = 0;
    rslt(9,2) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = 0;
    rslt(10,2) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,2) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,3) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,2) = static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,3) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,2) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,3) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,2) = 0;
    rslt(8,3) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,4) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,2) = 0;
    rslt(9,3) = static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,4) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,2) = 0;
    rslt(10,3) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,4) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,2) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,3) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,4) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,5) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,2) = -static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,3) = static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,4) = static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,5) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,2) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,3) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,4) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,5) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,2) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,3) = 0;
    rslt(8,4) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,5) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,6) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,2) = -static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,3) = 0;
    rslt(9,4) = static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,5) = static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,6) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,2) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,3) = 0;
    rslt(10,4) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,5) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,6) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,2) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,3) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,4) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,5) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,6) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,7) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,2) = -static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,3) = -static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,4) = static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,5) = static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,6) = static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,7) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,2) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,3) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,4) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,5) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,6) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,7) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,9> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,2) = -static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,3) = -static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,4) = 0;
    rslt(9,5) = static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,6) = static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,7) = static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,8) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,2) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,3) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,4) = 0;
    rslt(10,5) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,6) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,7) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,8) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,10> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,9) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,2) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,3) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,4) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,5) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,6) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,7) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,8) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,9) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,2) = -static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,3) = -static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,4) = -static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,5) = static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,6) = static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,7) = static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,8) = static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,9) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,2) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,3) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,4) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,5) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,6) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,7) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,8) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,9) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,2) = -static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,3) = -static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,4) = -static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,5) = static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,6) = static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,7) = static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,8) = static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,9) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,2) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,3) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,4) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,5) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,6) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,7) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,8) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,9) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,2) = -static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,3) = -static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,4) = -static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,5) = static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,6) = static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,7) = static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,8) = static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,9) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,2) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,3) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,4) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,5) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,6) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,7) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,8) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,9) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,2) = -static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,3) = -static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,4) = -static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,5) = static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,6) = static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,7) = static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,8) = static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,9) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,2) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,3) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,4) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,5) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,6) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,7) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,8) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,9) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,2) = -static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,3) = -static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,4) = -static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,5) = 0;
    rslt(1,6) = static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,7) = static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,8) = static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,9) = static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,10) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,2) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,3) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,4) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,5) = 0;
    rslt(2,6) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,7) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,8) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,9) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,10) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,2) = -static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,3) = -static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,4) = -static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,5) = 0;
    rslt(3,6) = static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,7) = static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,8) = static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,9) = static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,10) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,2) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,3) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,4) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,5) = 0;
    rslt(4,6) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,7) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,8) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,9) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,10) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,2) = -static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,3) = -static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,4) = -static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,5) = 0;
    rslt(5,6) = static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,7) = static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,8) = static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,9) = static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,10) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,2) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,3) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,4) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,5) = 0;
    rslt(6,6) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,7) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,8) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,9) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,10) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,2) = -static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,3) = -static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,4) = -static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,7) = static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,8) = static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,9) = static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,10) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,2) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,3) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,4) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,5) = 0;
    rslt(8,6) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,7) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,8) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,9) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,10) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,2) = -static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,3) = -static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,4) = -static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,5) = 0;
    rslt(9,6) = static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,7) = static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,8) = static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,9) = static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,10) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,2) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,3) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,4) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,5) = 0;
    rslt(10,6) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,7) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,8) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,9) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,10) = static_cast<FP>(0.00097656250000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_coefs(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(0,1) = -static_cast<FP>(0.0011380537729414682539682539682539682540);
    rslt(0,2) = static_cast<FP>(0.00031037830171130952380952380952380952381);
    rslt(0,3) = static_cast<FP>(0.0014881813547178130511463844797178130511);
    rslt(0,4) = -static_cast<FP>(0.00033822303516313932980599647266313932981);
    rslt(0,5) = -static_cast<FP>(0.00045355902777777777777777777777777777778);
    rslt(0,6) = static_cast<FP>(0.000096209490740740740740740740740740740741);
    rslt(0,7) = static_cast<FP>(0.000045469576719576719576719576719576719577);
    rslt(0,8) = -static_cast<FP>(9.3005952380952380952380952380952380952e-6);
    rslt(0,9) = -static_cast<FP>(1.3778659611992945326278659611992945326e-6);
    rslt(0,10) = static_cast<FP>(2.7557319223985890652557319223985890653e-7);
    rslt(1,0) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(1,1) = static_cast<FP>(0.014109700520833333333333333333333333333);
    rslt(1,2) = -static_cast<FP>(0.0047722064628802910052910052910052910053);
    rslt(1,3) = -static_cast<FP>(0.018025242504409171075837742504409171076);
    rslt(1,4) = static_cast<FP>(0.0050821724812610229276895943562610229277);
    rslt(1,5) = static_cast<FP>(0.0051909722222222222222222222222222222222);
    rslt(1,6) = -static_cast<FP>(0.0013671875000000000000000000000000000000);
    rslt(1,7) = -static_cast<FP>(0.00046296296296296296296296296296296296296);
    rslt(1,8) = static_cast<FP>(0.00011780753968253968253968253968253968254);
    rslt(1,9) = static_cast<FP>(0.000011022927689594356261022927689594356261);
    rslt(1,10) = -static_cast<FP>(2.7557319223985890652557319223985890653e-6);
    rslt(2,0) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(2,1) = -static_cast<FP>(0.083241712782118055555555555555555555555);
    rslt(2,2) = static_cast<FP>(0.036949827809813161375661375661375661376);
    rslt(2,3) = static_cast<FP>(0.10120520213293650793650793650793650794);
    rslt(2,4) = -static_cast<FP>(0.037500129174933862433862433862433862434);
    rslt(2,5) = -static_cast<FP>(0.025787760416666666666666666666666666667);
    rslt(2,6) = static_cast<FP>(0.0089590567129629629629629629629629629630);
    rslt(2,7) = static_cast<FP>(0.0018229166666666666666666666666666666667);
    rslt(2,8) = -static_cast<FP>(0.00061693948412698412698412698412698412698);
    rslt(2,9) = -static_cast<FP>(0.000037202380952380952380952380952380952381);
    rslt(2,10) = static_cast<FP>(0.000012400793650793650793650793650793650794);
    rslt(3,0) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(3,1) = static_cast<FP>(0.31879758804563492063492063492063492063);
    rslt(3,2) = -static_cast<FP>(0.20427375268683862433862433862433862434);
    rslt(3,3) = -static_cast<FP>(0.33766534391534391534391534391534391534);
    rslt(3,4) = static_cast<FP>(0.18193514384920634920634920634920634921);
    rslt(3,5) = static_cast<FP>(0.060312500000000000000000000000000000000);
    rslt(3,6) = -static_cast<FP>(0.031221064814814814814814814814814814815);
    rslt(3,7) = -static_cast<FP>(0.0035714285714285714285714285714285714286);
    rslt(3,8) = static_cast<FP>(0.0018105158730158730158730158730158730159);
    rslt(3,9) = static_cast<FP>(0.000066137566137566137566137566137566137566);
    rslt(3,10) = -static_cast<FP>(0.000033068783068783068783068783068783068783);
    rslt(4,0) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(4,1) = -static_cast<FP>(0.93861857096354166666666666666666666667);
    rslt(4,2) = static_cast<FP>(1.0531424063223379629629629629629629630);
    rslt(4,3) = static_cast<FP>(0.43637514467592592592592592592592592593);
    rslt(4,4) = -static_cast<FP>(0.46309859664351851851851851851851851852);
    rslt(4,5) = -static_cast<FP>(0.061757812500000000000000000000000000000);
    rslt(4,6) = static_cast<FP>(0.063722511574074074074074074074074074074);
    rslt(4,7) = static_cast<FP>(0.0032986111111111111111111111111111111111);
    rslt(4,8) = -static_cast<FP>(0.0033420138888888888888888888888888888889);
    rslt(4,9) = -static_cast<FP>(0.000057870370370370370370370370370370370370);
    rslt(4,10) = static_cast<FP>(0.000057870370370370370370370370370370370370);
    rslt(5,0) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(5,1) = 0;
    rslt(5,2) = -static_cast<FP>(1.7627133065682870370370370370370370370);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.62783926504629629629629629629629629630);
    rslt(5,5) = 0;
    rslt(5,6) = -static_cast<FP>(0.080379050925925925925925925925925925926);
    rslt(5,7) = 0;
    rslt(5,8) = static_cast<FP>(0.0040798611111111111111111111111111111111);
    rslt(5,9) = 0;
    rslt(5,10) = -static_cast<FP>(0.000069444444444444444444444444444444444444);
    rslt(6,0) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(6,1) = static_cast<FP>(0.93861857096354166666666666666666666667);
    rslt(6,2) = static_cast<FP>(1.0531424063223379629629629629629629630);
    rslt(6,3) = -static_cast<FP>(0.43637514467592592592592592592592592593);
    rslt(6,4) = -static_cast<FP>(0.46309859664351851851851851851851851852);
    rslt(6,5) = static_cast<FP>(0.061757812500000000000000000000000000000);
    rslt(6,6) = static_cast<FP>(0.063722511574074074074074074074074074074);
    rslt(6,7) = -static_cast<FP>(0.0032986111111111111111111111111111111111);
    rslt(6,8) = -static_cast<FP>(0.0033420138888888888888888888888888888889);
    rslt(6,9) = static_cast<FP>(0.000057870370370370370370370370370370370370);
    rslt(6,10) = static_cast<FP>(0.000057870370370370370370370370370370370370);
    rslt(7,0) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(7,1) = -static_cast<FP>(0.31879758804563492063492063492063492063);
    rslt(7,2) = -static_cast<FP>(0.20427375268683862433862433862433862434);
    rslt(7,3) = static_cast<FP>(0.33766534391534391534391534391534391534);
    rslt(7,4) = static_cast<FP>(0.18193514384920634920634920634920634921);
    rslt(7,5) = -static_cast<FP>(0.060312500000000000000000000000000000000);
    rslt(7,6) = -static_cast<FP>(0.031221064814814814814814814814814814815);
    rslt(7,7) = static_cast<FP>(0.0035714285714285714285714285714285714286);
    rslt(7,8) = static_cast<FP>(0.0018105158730158730158730158730158730159);
    rslt(7,9) = -static_cast<FP>(0.000066137566137566137566137566137566137566);
    rslt(7,10) = -static_cast<FP>(0.000033068783068783068783068783068783068783);
    rslt(8,0) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(8,1) = static_cast<FP>(0.083241712782118055555555555555555555555);
    rslt(8,2) = static_cast<FP>(0.036949827809813161375661375661375661376);
    rslt(8,3) = -static_cast<FP>(0.10120520213293650793650793650793650794);
    rslt(8,4) = -static_cast<FP>(0.037500129174933862433862433862433862434);
    rslt(8,5) = static_cast<FP>(0.025787760416666666666666666666666666667);
    rslt(8,6) = static_cast<FP>(0.0089590567129629629629629629629629629630);
    rslt(8,7) = -static_cast<FP>(0.0018229166666666666666666666666666666667);
    rslt(8,8) = -static_cast<FP>(0.00061693948412698412698412698412698412698);
    rslt(8,9) = static_cast<FP>(0.000037202380952380952380952380952380952381);
    rslt(8,10) = static_cast<FP>(0.000012400793650793650793650793650793650794);
    rslt(9,0) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(9,1) = -static_cast<FP>(0.014109700520833333333333333333333333333);
    rslt(9,2) = -static_cast<FP>(0.0047722064628802910052910052910052910053);
    rslt(9,3) = static_cast<FP>(0.018025242504409171075837742504409171076);
    rslt(9,4) = static_cast<FP>(0.0050821724812610229276895943562610229277);
    rslt(9,5) = -static_cast<FP>(0.0051909722222222222222222222222222222222);
    rslt(9,6) = -static_cast<FP>(0.0013671875000000000000000000000000000000);
    rslt(9,7) = static_cast<FP>(0.00046296296296296296296296296296296296296);
    rslt(9,8) = static_cast<FP>(0.00011780753968253968253968253968253968254);
    rslt(9,9) = -static_cast<FP>(0.000011022927689594356261022927689594356261);
    rslt(9,10) = -static_cast<FP>(2.7557319223985890652557319223985890653e-6);
    rslt(10,0) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(10,1) = static_cast<FP>(0.0011380537729414682539682539682539682540);
    rslt(10,2) = static_cast<FP>(0.00031037830171130952380952380952380952381);
    rslt(10,3) = -static_cast<FP>(0.0014881813547178130511463844797178130511);
    rslt(10,4) = -static_cast<FP>(0.00033822303516313932980599647266313932981);
    rslt(10,5) = static_cast<FP>(0.00045355902777777777777777777777777777778);
    rslt(10,6) = static_cast<FP>(0.000096209490740740740740740740740740740741);
    rslt(10,7) = -static_cast<FP>(0.000045469576719576719576719576719576719577);
    rslt(10,8) = -static_cast<FP>(9.3005952380952380952380952380952380952e-6);
    rslt(10,9) = static_cast<FP>(1.3778659611992945326278659611992945326e-6);
    rslt(10,10) = static_cast<FP>(2.7557319223985890652557319223985890653e-7);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_sten(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(1,2) = -static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,3) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,4) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,5) = 0;
    rslt(1,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,7) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,8) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,9) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(1,10) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(25.083333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(16.083333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,4) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,6) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,7) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,8) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,9) = static_cast<FP>(16.083333333333333333333333333333333333);
    rslt(2,10) = static_cast<FP>(25.083333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(126.25000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(65.000000000000000000000000000000000000);
    rslt(3,2) = -static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,3) = -static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,4) = -static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,5) = 0;
    rslt(3,6) = static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,7) = static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,8) = static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,9) = static_cast<FP>(65.000000000000000000000000000000000000);
    rslt(3,10) = static_cast<FP>(126.25000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(637.51250000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(264.01250000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,4) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,5) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(4,6) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,7) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,8) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,9) = static_cast<FP>(264.01250000000000000000000000000000000);
    rslt(4,10) = static_cast<FP>(637.51250000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(3229.4791666666666666666666666666666667);
    rslt(5,1) = -static_cast<FP>(1077.5833333333333333333333333333333333);
    rslt(5,2) = -static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,3) = -static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,4) = -static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,5) = 0;
    rslt(5,6) = static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,7) = static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,8) = static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,9) = static_cast<FP>(1077.5833333333333333333333333333333333);
    rslt(5,10) = static_cast<FP>(3229.4791666666666666666666666666666667);
    rslt(6,0) = static_cast<FP>(16410.939732142857142857142857142857143);
    rslt(6,1) = static_cast<FP>(4419.0022321428571428571428571428571429);
    rslt(6,2) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,3) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,4) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,5) = static_cast<FP>(0.0022321428571428571428571428571428571429);
    rslt(6,6) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,7) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,8) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,9) = static_cast<FP>(4419.0022321428571428571428571428571429);
    rslt(6,10) = static_cast<FP>(16410.939732142857142857142857142857143);
    rslt(7,0) = -static_cast<FP>(83648.515625000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(18204.062500000000000000000000000000000);
    rslt(7,2) = -static_cast<FP>(2624.1093750000000000000000000000000000);
    rslt(7,3) = -static_cast<FP>(187.53125000000000000000000000000000000);
    rslt(7,4) = -static_cast<FP>(3.2031250000000000000000000000000000000);
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(3.2031250000000000000000000000000000000);
    rslt(7,7) = static_cast<FP>(187.53125000000000000000000000000000000);
    rslt(7,8) = static_cast<FP>(2624.1093750000000000000000000000000000);
    rslt(7,9) = static_cast<FP>(18204.062500000000000000000000000000000);
    rslt(7,10) = static_cast<FP>(83648.515625000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(427631.77126736111111111111111111111111);
    rslt(8,1) = static_cast<FP>(75318.333767361111111111111111111111111);
    rslt(8,2) = static_cast<FP>(8333.4379340277777777777777777777777778);
    rslt(8,3) = static_cast<FP>(419.58376736111111111111111111111111111);
    rslt(8,4) = static_cast<FP>(4.2712673611111111111111111111111111111);
    rslt(8,5) = static_cast<FP>(0.00043402777777777777777777777777777777778);
    rslt(8,6) = static_cast<FP>(4.2712673611111111111111111111111111111);
    rslt(8,7) = static_cast<FP>(419.58376736111111111111111111111111111);
    rslt(8,8) = static_cast<FP>(8333.4379340277777777777777777777777778);
    rslt(8,9) = static_cast<FP>(75318.333767361111111111111111111111111);
    rslt(8,10) = static_cast<FP>(427631.77126736111111111111111111111111);
    rslt(9,0) = -static_cast<FP>(2.1924453320312500000000000000000000000e6);
    rslt(9,1) = -static_cast<FP>(312920.81562500000000000000000000000000);
    rslt(9,2) = -static_cast<FP>(26631.799218750000000000000000000000000);
    rslt(9,3) = -static_cast<FP>(947.90781250000000000000000000000000000);
    rslt(9,4) = -static_cast<FP>(5.7664062500000000000000000000000000000);
    rslt(9,5) = 0;
    rslt(9,6) = static_cast<FP>(5.7664062500000000000000000000000000000);
    rslt(9,7) = static_cast<FP>(947.90781250000000000000000000000000000);
    rslt(9,8) = static_cast<FP>(26631.799218750000000000000000000000000);
    rslt(9,9) = static_cast<FP>(312920.81562500000000000000000000000000);
    rslt(9,10) = static_cast<FP>(2.1924453320312500000000000000000000000e6);
    rslt(10,0) = static_cast<FP>(1.1271777832120028409090909090909090909e7);
    rslt(10,1) = static_cast<FP>(1.3052083125887784090909090909090909091e6);
    rslt(10,2) = static_cast<FP>(85604.519620028409090909090909090909091);
    rslt(10,3) = static_cast<FP>(2159.5782137784090909090909090909090909);
    rslt(10,4) = static_cast<FP>(7.8633700284090909090909090909090909091);
    rslt(10,5) = static_cast<FP>(0.000088778409090909090909090909090909090909);
    rslt(10,6) = static_cast<FP>(7.8633700284090909090909090909090909091);
    rslt(10,7) = static_cast<FP>(2159.5782137784090909090909090909090909);
    rslt(10,8) = static_cast<FP>(85604.519620028409090909090909090909091);
    rslt(10,9) = static_cast<FP>(1.3052083125887784090909090909090909091e6);
    rslt(10,10) = static_cast<FP>(1.1271777832120028409090909090909090909e7);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,1> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(1,0) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(2,0) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(3,0) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(4,0) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(5,0) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(6,0) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(7,0) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(8,0) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(9,0) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(10,0) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,2> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,3> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(0,2) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(1,2) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(2,2) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(3,2) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(4,2) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(5,2) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(6,2) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(7,2) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(8,2) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(9,2) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(10,2) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,4> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00023092797872072080329035173530288010667);
    rslt(0,2) = -static_cast<FP>(0.00024525295066235941159562670724451871497);
    rslt(0,3) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0028453029981413569508948481560555987771);
    rslt(1,2) = static_cast<FP>(0.0030674680614730869492915132193873287755);
    rslt(1,3) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.016620994340795710315117513509731701149);
    rslt(2,2) = -static_cast<FP>(0.018371544004095373614780813173031364448);
    rslt(2,3) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.062488921138749325682494578279308922212);
    rslt(3,2) = static_cast<FP>(0.072598499782327969261138156922887565790);
    rslt(3,3) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.17443049324814251477357534643277423307);
    rslt(4,2) = -static_cast<FP>(0.23564371090086016749122806408549188579);
    rslt(4,3) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(1.0526463485810485810485810485810485810);
    rslt(5,2) = static_cast<FP>(1.0526463485810485810485810485810485810);
    rslt(5,3) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.23564371090086016749122806408549188579);
    rslt(6,2) = static_cast<FP>(0.17443049324814251477357534643277423307);
    rslt(6,3) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.072598499782327969261138156922887565791);
    rslt(7,2) = -static_cast<FP>(0.062488921138749325682494578279308922212);
    rslt(7,3) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.018371544004095373614780813173031364448);
    rslt(8,2) = static_cast<FP>(0.016620994340795710315117513509731701149);
    rslt(8,3) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0030674680614730869492915132193873287755);
    rslt(9,2) = -static_cast<FP>(0.0028453029981413569508948481560555987771);
    rslt(9,3) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00024525295066235941159562670724451871497);
    rslt(10,2) = static_cast<FP>(0.00023092797872072080329035173530288010667);
    rslt(10,3) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,5> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00032965142284058219522645657057883083579);
    rslt(0,2) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(0,3) = -static_cast<FP>(0.00031436851134069265047465204606055609439);
    rslt(0,4) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0041231198147135543344438606045759617520);
    rslt(1,2) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(1,3) = static_cast<FP>(0.0038881696588784993502248375921930398076);
    rslt(1,4) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.024703303231555540980016941510656046464);
    rslt(2,2) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(2,3) = -static_cast<FP>(0.022884842954426628758583746673522374321);
    rslt(2,4) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.097752592970675687173460834927135106612);
    rslt(3,2) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(3,3) = static_cast<FP>(0.087715464359812917924304961150567571491);
    rslt(3,4) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.31764629757257971552264426294846956326);
    rslt(4,2) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(4,3) = -static_cast<FP>(0.26667727210790139786640074248170877997);
    rslt(4,4) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.95746931011339070481094637696053772688);
    rslt(5,2) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(5,3) = static_cast<FP>(0.95746931011339070481094637696053772688);
    rslt(5,4) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.26667727210790139786640074248170877997);
    rslt(6,2) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(6,3) = static_cast<FP>(0.31764629757257971552264426294846956326);
    rslt(6,4) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.087715464359812917924304961150567571492);
    rslt(7,2) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(7,3) = -static_cast<FP>(0.097752592970675687173460834927135106612);
    rslt(7,4) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.022884842954426628758583746673522374321);
    rslt(8,2) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(8,3) = static_cast<FP>(0.024703303231555540980016941510656046463);
    rslt(8,4) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0038881696588784993502248375921930398076);
    rslt(9,2) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(9,3) = -static_cast<FP>(0.0041231198147135543344438606045759617520);
    rslt(9,4) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00031436851134069265047465204606055609440);
    rslt(10,2) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(10,3) = static_cast<FP>(0.00032965142284058219522645657057883083579);
    rslt(10,4) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,6> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00037232211726973511240241265507504400071);
    rslt(0,2) = static_cast<FP>(0.00014234028301937007355718490005222549158);
    rslt(0,3) = -static_cast<FP>(0.00017368839964129807617501574903089495208);
    rslt(0,4) = -static_cast<FP>(0.00033907352039600690613532577868743987784);
    rslt(0,5) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0046869235917097776202352179440866289981);
    rslt(1,2) = -static_cast<FP>(0.0017181001503780664996232121104674210821);
    rslt(1,3) = static_cast<FP>(0.0022024709530202469115766366101751191484);
    rslt(1,4) = static_cast<FP>(0.0041738060680302768036424447665094949649);
    rslt(1,5) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.028387894011096762355690399156639111184);
    rslt(2,2) = static_cast<FP>(0.0096854955259165904940492831688682871765);
    rslt(2,3) = -static_cast<FP>(0.013473571431074632444018315707533268651);
    rslt(2,4) = -static_cast<FP>(0.024384920817235057300445764491779914828);
    rslt(2,5) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.11481281349692860133294930990547274664);
    rslt(3,2) = -static_cast<FP>(0.033751892438591380856794052580045164045);
    rslt(3,3) = static_cast<FP>(0.055227404608280759343938220249987211222);
    rslt(3,4) = static_cast<FP>(0.092263277738623377574211151400757131839);
    rslt(3,5) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.39739573449091895742827337716307378707);
    rslt(4,2) = static_cast<FP>(0.071714809084725022590029241523392189797);
    rslt(4,3) = -static_cast<FP>(0.19348448337865805005044639616506198792);
    rslt(4,4) = -static_cast<FP>(0.27285160591055339544596250015737004349);
    rslt(4,5) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.89448230291088372933150833313534220478);
    rslt(5,2) = static_cast<FP>(1.1036292153433814385139064258596637038);
    rslt(5,3) = static_cast<FP>(1.1036292153433814385139064258596637038);
    rslt(5,4) = static_cast<FP>(0.89448230291088372933150833313534220478);
    rslt(5,5) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.27285160591055339544596250015737004349);
    rslt(6,2) = -static_cast<FP>(0.19348448337865805005044639616506198791);
    rslt(6,3) = static_cast<FP>(0.071714809084725022590029241523392189797);
    rslt(6,4) = static_cast<FP>(0.39739573449091895742827337716307378706);
    rslt(6,5) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.092263277738623377574211151400757131839);
    rslt(7,2) = static_cast<FP>(0.055227404608280759343938220249987211222);
    rslt(7,3) = -static_cast<FP>(0.033751892438591380856794052580045164045);
    rslt(7,4) = -static_cast<FP>(0.11481281349692860133294930990547274664);
    rslt(7,5) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.024384920817235057300445764491779914828);
    rslt(8,2) = -static_cast<FP>(0.013473571431074632444018315707533268651);
    rslt(8,3) = static_cast<FP>(0.0096854955259165904940492831688682871766);
    rslt(8,4) = static_cast<FP>(0.028387894011096762355690399156639111184);
    rslt(8,5) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0041738060680302768036424447665094949649);
    rslt(9,2) = static_cast<FP>(0.0022024709530202469115766366101751191484);
    rslt(9,3) = -static_cast<FP>(0.0017181001503780664996232121104674210821);
    rslt(9,4) = -static_cast<FP>(0.0046869235917097776202352179440866289981);
    rslt(9,5) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00033907352039600690613532577868743987784);
    rslt(10,2) = -static_cast<FP>(0.00017368839964129807617501574903089495208);
    rslt(10,3) = static_cast<FP>(0.00014234028301937007355718490005222549158);
    rslt(10,4) = static_cast<FP>(0.00037232211726973511240241265507504400071);
    rslt(10,5) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,7> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00039353985830864334487981464367436945678);
    rslt(0,2) = static_cast<FP>(0.00024213845154847099765226027827795462063);
    rslt(0,3) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(0,4) = -static_cast<FP>(0.00025373164298516788096102615358968948992);
    rslt(0,5) = -static_cast<FP>(0.00034938578269960903897496644705409669286);
    rslt(0,6) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0049719065673412935408284281104946772027);
    rslt(1,2) = -static_cast<FP>(0.0029890760558598952087209166326286486274);
    rslt(1,3) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(1,4) = static_cast<FP>(0.0031691249067368292329367264713104626534);
    rslt(1,5) = static_cast<FP>(0.0042895788089681146091910810410387608066);
    rslt(1,6) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.030298077277849532806681269848110423810);
    rslt(2,2) = static_cast<FP>(0.017516941690053907317104360636630428277);
    rslt(2,3) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(2,4) = -static_cast<FP>(0.018939605392190141576366420967194875534);
    rslt(2,5) = -static_cast<FP>(0.024960525551933720229216480413922125302);
    rslt(2,6) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.12405729937813481722108402419964340904);
    rslt(3,2) = -static_cast<FP>(0.066290444083248041827031485481280259930);
    rslt(3,3) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(3,4) = static_cast<FP>(0.074562428277233033973793634492998673010);
    rslt(3,5) = static_cast<FP>(0.093780554958905267399526435819634653615);
    rslt(3,6) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.44510508108314448434579836876342350258);
    rslt(4,2) = static_cast<FP>(0.18883025137694060355262247000799915618);
    rslt(4,3) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(4,4) = -static_cast<FP>(0.24008370221036521164406550633988418754);
    rslt(4,5) = -static_cast<FP>(0.27323808054106576140454953862525896647);
    rslt(4,6) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.85371036583399915892857646768049156444);
    rslt(5,2) = static_cast<FP>(1.0442356746821356130630359036873609864);
    rslt(5,3) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(5,4) = static_cast<FP>(1.0442356746821356130630359036873609864);
    rslt(5,5) = static_cast<FP>(0.85371036583399915892857646768049156444);
    rslt(5,6) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.27323808054106576140454953862525896647);
    rslt(6,2) = -static_cast<FP>(0.24008370221036521164406550633988418754);
    rslt(6,3) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(6,4) = static_cast<FP>(0.18883025137694060355262247000799915618);
    rslt(6,5) = static_cast<FP>(0.44510508108314448434579836876342350258);
    rslt(6,6) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.093780554958905267399526435819634653615);
    rslt(7,2) = static_cast<FP>(0.074562428277233033973793634492998673010);
    rslt(7,3) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(7,4) = -static_cast<FP>(0.066290444083248041827031485481280259930);
    rslt(7,5) = -static_cast<FP>(0.12405729937813481722108402419964340904);
    rslt(7,6) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.024960525551933720229216480413922125303);
    rslt(8,2) = -static_cast<FP>(0.018939605392190141576366420967194875534);
    rslt(8,3) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(8,4) = static_cast<FP>(0.017516941690053907317104360636630428277);
    rslt(8,5) = static_cast<FP>(0.030298077277849532806681269848110423810);
    rslt(8,6) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0042895788089681146091910810410387608066);
    rslt(9,2) = static_cast<FP>(0.0031691249067368292329367264713104626534);
    rslt(9,3) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(9,4) = -static_cast<FP>(0.0029890760558598952087209166326286486274);
    rslt(9,5) = -static_cast<FP>(0.0049719065673412935408284281104946772027);
    rslt(9,6) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00034938578269960903897496644705409669286);
    rslt(10,2) = -static_cast<FP>(0.00025373164298516788096102615358968948992);
    rslt(10,3) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(10,4) = static_cast<FP>(0.00024213845154847099765226027827795462063);
    rslt(10,5) = static_cast<FP>(0.00039353985830864334487981464367436945678);
    rslt(10,6) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,8> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00040536962314583751263426616976446567937);
    rslt(0,2) = static_cast<FP>(0.00030196751769787573632424257508118098188);
    rslt(0,3) = static_cast<FP>(0.000098907872192804504162470701291281195495);
    rslt(0,4) = -static_cast<FP>(0.00013588613216661455998545972355448964831);
    rslt(0,5) = -static_cast<FP>(0.00029638433850972236866974851671628623033);
    rslt(0,6) = -static_cast<FP>(0.00035425213359645379775457345405675873777);
    rslt(0,7) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0051329213322253502772928367216217785030);
    rslt(1,2) = -static_cast<FP>(0.0037617830077106744139274782989880461027);
    rslt(1,3) = -static_cast<FP>(0.0011704791457162015538209482242316389871);
    rslt(1,4) = static_cast<FP>(0.0017414837779286321485995002240673136571);
    rslt(1,5) = static_cast<FP>(0.0036767512752848699351409480291952908082);
    rslt(1,6) = static_cast<FP>(0.0043423846990416484124484858692693758044);
    rslt(1,7) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.031399081391911363745283522718119204998);
    rslt(2,2) = static_cast<FP>(0.022387119514869476467807686011635057754);
    rslt(2,3) = static_cast<FP>(0.0063655871601844105502991862508152571538);
    rslt(2,4) = -static_cast<FP>(0.010825507667696697525637588325845200329);
    rslt(2,5) = -static_cast<FP>(0.021741783916708707496352399090722216548);
    rslt(2,6) = -static_cast<FP>(0.025205438928334946344604177514543716137);
    rslt(2,7) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.12956723749905283165618772173672716140);
    rslt(3,2) = -static_cast<FP>(0.087397473451336301470356155900118146126);
    rslt(3,3) = -static_cast<FP>(0.020373612057301327985703971352502644971);
    rslt(3,4) = static_cast<FP>(0.045578007562001731660278632809424004044);
    rslt(3,5) = static_cast<FP>(0.084019444702268471665346553938807983995);
    rslt(3,6) = static_cast<FP>(0.094295186909794825477670868677439063366);
    rslt(3,7) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.47562496741385977540844103265743904223);
    rslt(4,2) = static_cast<FP>(0.27308928013779690726052440622191190167);
    rslt(4,3) = static_cast<FP>(0.027090868816026899156368538009143526023);
    rslt(4,4) = -static_cast<FP>(0.16836257656295756978105711842637098357);
    rslt(4,5) = -static_cast<FP>(0.25997031444219342506195987370159114222);
    rslt(4,6) = -static_cast<FP>(0.27225951003925645446535702032769485810);
    rslt(4,7) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.82645236989471258598471815366261312079);
    rslt(5,2) = static_cast<FP>(0.98969317600854122974612181873150442201);
    rslt(5,3) = static_cast<FP>(1.1199932063775039333864967580577635754);
    rslt(5,4) = static_cast<FP>(1.1199932063775039333864967580577635754);
    rslt(5,5) = static_cast<FP>(0.98969317600854122974612181873150442201);
    rslt(5,6) = static_cast<FP>(0.82645236989471258598471815366261312079);
    rslt(5,7) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.27225951003925645446535702032769485810);
    rslt(6,2) = -static_cast<FP>(0.25997031444219342506195987370159114222);
    rslt(6,3) = -static_cast<FP>(0.16836257656295756978105711842637098357);
    rslt(6,4) = static_cast<FP>(0.027090868816026899156368538009143526023);
    rslt(6,5) = static_cast<FP>(0.27308928013779690726052440622191190167);
    rslt(6,6) = static_cast<FP>(0.47562496741385977540844103265743904223);
    rslt(6,7) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.094295186909794825477670868677439063367);
    rslt(7,2) = static_cast<FP>(0.084019444702268471665346553938807983994);
    rslt(7,3) = static_cast<FP>(0.045578007562001731660278632809424004044);
    rslt(7,4) = -static_cast<FP>(0.020373612057301327985703971352502644971);
    rslt(7,5) = -static_cast<FP>(0.087397473451336301470356155900118146126);
    rslt(7,6) = -static_cast<FP>(0.12956723749905283165618772173672716140);
    rslt(7,7) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.025205438928334946344604177514543716137);
    rslt(8,2) = -static_cast<FP>(0.021741783916708707496352399090722216548);
    rslt(8,3) = -static_cast<FP>(0.010825507667696697525637588325845200329);
    rslt(8,4) = static_cast<FP>(0.0063655871601844105502991862508152571538);
    rslt(8,5) = static_cast<FP>(0.022387119514869476467807686011635057754);
    rslt(8,6) = static_cast<FP>(0.031399081391911363745283522718119204997);
    rslt(8,7) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0043423846990416484124484858692693758044);
    rslt(9,2) = static_cast<FP>(0.0036767512752848699351409480291952908082);
    rslt(9,3) = static_cast<FP>(0.0017414837779286321485995002240673136571);
    rslt(9,4) = -static_cast<FP>(0.0011704791457162015538209482242316389871);
    rslt(9,5) = -static_cast<FP>(0.0037617830077106744139274782989880461027);
    rslt(9,6) = -static_cast<FP>(0.0051329213322253502772928367216217785030);
    rslt(9,7) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00035425213359645379775457345405675873777);
    rslt(10,2) = -static_cast<FP>(0.00029638433850972236866974851671628623033);
    rslt(10,3) = -static_cast<FP>(0.00013588613216661455998545972355448964831);
    rslt(10,4) = static_cast<FP>(0.000098907872192804504162470701291281195495);
    rslt(10,5) = static_cast<FP>(0.00030196751769787573632424257508118098188);
    rslt(10,6) = static_cast<FP>(0.00040536962314583751263426616976446567937);
    rslt(10,7) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,9> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00041257272932634884885117924377175026369);
    rslt(0,2) = static_cast<FP>(0.00033899769193323400291893478865323353924);
    rslt(0,3) = static_cast<FP>(0.00018582556796970794700927243711356706261);
    rslt(0,4) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(0,5) = -static_cast<FP>(0.00020978698972732769592549894341846848937);
    rslt(0,6) = -static_cast<FP>(0.00032013063739750518785675077926375697975);
    rslt(0,7) = -static_cast<FP>(0.00035677722449562799847491253232441855682);
    rslt(0,8) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0052320288911602352342278359209132628358);
    rslt(1,2) = -static_cast<FP>(0.0042458033184227581128124622535052087710);
    rslt(1,3) = -static_cast<FP>(0.0022695604406016003914552419704313363907);
    rslt(1,4) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(1,5) = static_cast<FP>(0.0026402045464156479898629805602441579836);
    rslt(1,6) = static_cast<FP>(0.0039554121403003886641262163350659849684);
    rslt(1,7) = static_cast<FP>(0.0043687177282564757185788234758660452180);
    rslt(1,8) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.032087599698877684723256364984672396929);
    rslt(2,2) = static_cast<FP>(0.025496814822070984613976830730951000237);
    rslt(2,3) = static_cast<FP>(0.013060079088726211956625114609096017311);
    rslt(2,4) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(2,5) = -static_cast<FP>(0.015965200974630238263706845942133611795);
    rslt(2,6) = -static_cast<FP>(0.023243811762304127002806549890716563826);
    rslt(2,7) = -static_cast<FP>(0.025316916778714883540173965782458990984);
    rslt(2,8) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.13310258160430002951615552846820990569);
    rslt(3,2) = -static_cast<FP>(0.10135869288353815274804679863611687450);
    rslt(3,3) = -static_cast<FP>(0.047590981594033934136086334341368227270);
    rslt(3,4) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(3,5) = static_cast<FP>(0.064152005002134779045278565904959145698);
    rslt(3,6) = static_cast<FP>(0.088844776748466028623967606637306035880);
    rslt(3,7) = static_cast<FP>(0.094444556565276619659430340368204367579);
    rslt(3,8) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.49624389271218107380182397103263471494);
    rslt(4,2) = static_cast<FP>(0.33377630994975384547550323180859922155);
    rslt(4,3) = static_cast<FP>(0.11991541753357258860944828126600658336);
    rslt(4,4) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(4,5) = -static_cast<FP>(0.21571444454136838175826070514733068150);
    rslt(4,6) = -static_cast<FP>(0.26851110950473695029499443693361495474);
    rslt(4,7) = -static_cast<FP>(0.27107206860848155798982557525460503500);
    rslt(4,8) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.80752303367323413152691713885336233814);
    rslt(5,2) = static_cast<FP>(0.94526723675387501196602417819264188264);
    rslt(5,3) = static_cast<FP>(1.0817964428015425466972104115672628540);
    rslt(5,4) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(5,5) = static_cast<FP>(1.0817964428015425466972104115672628540);
    rslt(5,6) = static_cast<FP>(0.94526723675387501196602417819264188264);
    rslt(5,7) = static_cast<FP>(0.80752303367323413152691713885336233814);
    rslt(5,8) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.27107206860848155798982557525460503500);
    rslt(6,2) = -static_cast<FP>(0.26851110950473695029499443693361495474);
    rslt(6,3) = -static_cast<FP>(0.21571444454136838175826070514733068150);
    rslt(6,4) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(6,5) = static_cast<FP>(0.11991541753357258860944828126600658336);
    rslt(6,6) = static_cast<FP>(0.33377630994975384547550323180859922155);
    rslt(6,7) = static_cast<FP>(0.49624389271218107380182397103263471494);
    rslt(6,8) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.094444556565276619659430340368204367579);
    rslt(7,2) = static_cast<FP>(0.088844776748466028623967606637306035880);
    rslt(7,3) = static_cast<FP>(0.064152005002134779045278565904959145698);
    rslt(7,4) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(7,5) = -static_cast<FP>(0.047590981594033934136086334341368227270);
    rslt(7,6) = -static_cast<FP>(0.10135869288353815274804679863611687450);
    rslt(7,7) = -static_cast<FP>(0.13310258160430002951615552846820990569);
    rslt(7,8) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.025316916778714883540173965782458990984);
    rslt(8,2) = -static_cast<FP>(0.023243811762304127002806549890716563826);
    rslt(8,3) = -static_cast<FP>(0.015965200974630238263706845942133611795);
    rslt(8,4) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(8,5) = static_cast<FP>(0.013060079088726211956625114609096017311);
    rslt(8,6) = static_cast<FP>(0.025496814822070984613976830730951000237);
    rslt(8,7) = static_cast<FP>(0.032087599698877684723256364984672396929);
    rslt(8,8) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0043687177282564757185788234758660452180);
    rslt(9,2) = static_cast<FP>(0.0039554121403003886641262163350659849683);
    rslt(9,3) = static_cast<FP>(0.0026402045464156479898629805602441579836);
    rslt(9,4) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(9,5) = -static_cast<FP>(0.0022695604406016003914552419704313363907);
    rslt(9,6) = -static_cast<FP>(0.0042458033184227581128124622535052087710);
    rslt(9,7) = -static_cast<FP>(0.0052320288911602352342278359209132628358);
    rslt(9,8) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00035677722449562799847491253232441855682);
    rslt(10,2) = -static_cast<FP>(0.00032013063739750518785675077926375697975);
    rslt(10,3) = -static_cast<FP>(0.00020978698972732769592549894341846848937);
    rslt(10,4) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(10,5) = static_cast<FP>(0.00018582556796970794700927243711356706261);
    rslt(10,6) = static_cast<FP>(0.00033899769193323400291893478865323353924);
    rslt(10,7) = static_cast<FP>(0.00041257272932634884885117924377175026369);
    rslt(10,8) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,10> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00041726662439488890527601903102209940696);
    rslt(0,2) = static_cast<FP>(0.00036289866440535657107004580251914778040);
    rslt(0,3) = static_cast<FP>(0.00024678726801130715449792418123561174708);
    rslt(0,4) = static_cast<FP>(0.000073466141028220714311291113945234606017);
    rslt(0,5) = -static_cast<FP>(0.00011295392904427723791498078603183045717);
    rslt(0,6) = -static_cast<FP>(0.00025720588433792739423262548508385312536);
    rslt(0,7) = -static_cast<FP>(0.00033400558115342184404165169941607370777);
    rslt(0,8) = -static_cast<FP>(0.00035818886007938937781879364069612768048);
    rslt(0,9) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0052971850230625459294465016862875643677);
    rslt(1,2) = -static_cast<FP>(0.0045615116768619550253731640867040903944);
    rslt(1,3) = -static_cast<FP>(0.0030487815283750419797086264291561513803);
    rslt(1,4) = -static_cast<FP>(0.00085106198607857859589702637543609752405);
    rslt(1,5) = static_cast<FP>(0.0014606688435595997040958372210208376455);
    rslt(1,6) = static_cast<FP>(0.0032107183275340077406576906518246792945);
    rslt(1,7) = static_cast<FP>(0.0041158951162855267694502564443189052244);
    rslt(1,8) = static_cast<FP>(0.0043827712408219468758057445430216913664);
    rslt(1,9) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.032546025894023620488704299193223246279);
    rslt(2,2) = static_cast<FP>(0.027559063654135986018331948435525880516);
    rslt(2,3) = static_cast<FP>(0.017889863124513736092085492277189589661);
    rslt(2,4) = static_cast<FP>(0.0044424968830502683610020176659543307726);
    rslt(2,5) = -static_cast<FP>(0.0092015712867331129111414001366089565890);
    rslt(2,6) = -static_cast<FP>(0.019171464790493072159958445019396889849);
    rslt(2,7) = -static_cast<FP>(0.024087204203711909352739472534721235208);
    rslt(2,8) = -static_cast<FP>(0.025369473455105906038302796072864965747);
    rslt(2,9) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.13550388976886794085612834247039364448);
    rslt(3,2) = -static_cast<FP>(0.11089863513244222207429267957149692873);
    rslt(3,3) = -static_cast<FP>(0.067879562522923503379251721548652388232);
    rslt(3,4) = -static_cast<FP>(0.012723968818416798935462764291199123496);
    rslt(3,5) = static_cast<FP>(0.039585893651685366539381091958071763848);
    rslt(3,6) = static_cast<FP>(0.075360214297458902874013771987351920547);
    rslt(3,7) = static_cast<FP>(0.091405792533077831951987909854918139539);
    rslt(3,8) = static_cast<FP>(0.094454413881008883124362799105070316734);
    rslt(3,9) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.51079726885576849855970381080702686179);
    rslt(4,2) = static_cast<FP>(0.37826381804700438395030398911444020366);
    rslt(4,3) = static_cast<FP>(0.19491354702982339068888038501957524567);
    rslt(4,4) = static_cast<FP>(0.0023776138207514170008309394982399536602);
    rslt(4,5) = -static_cast<FP>(0.15226420841148650588437649745764114092);
    rslt(4,6) = -static_cast<FP>(0.24186253143303327102991885652062893064);
    rslt(4,7) = -static_cast<FP>(0.27201827220804061059433120887197982325);
    rslt(4,8) = -static_cast<FP>(0.26998234211299255654025843851545137914);
    rslt(4,9) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.79391333272409050078810219970632946584);
    rslt(5,2) = static_cast<FP>(0.91019216078730103362963402711259587457);
    rslt(5,3) = static_cast<FP>(1.0405984161118214713929350108857411663);
    rslt(5,4) = static_cast<FP>(1.1272136250916844012451714915896850285);
    rslt(5,5) = static_cast<FP>(1.1272136250916844012451714915896850285);
    rslt(5,6) = static_cast<FP>(1.0405984161118214713929350108857411663);
    rslt(5,7) = static_cast<FP>(0.91019216078730103362963402711259587457);
    rslt(5,8) = static_cast<FP>(0.79391333272409050078810219970632946584);
    rslt(5,9) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.26998234211299255654025843851545137914);
    rslt(6,2) = -static_cast<FP>(0.27201827220804061059433120887197982325);
    rslt(6,3) = -static_cast<FP>(0.24186253143303327102991885652062893064);
    rslt(6,4) = -static_cast<FP>(0.15226420841148650588437649745764114092);
    rslt(6,5) = static_cast<FP>(0.0023776138207514170008309394982399536602);
    rslt(6,6) = static_cast<FP>(0.19491354702982339068888038501957524567);
    rslt(6,7) = static_cast<FP>(0.37826381804700438395030398911444020366);
    rslt(6,8) = static_cast<FP>(0.51079726885576849855970381080702686179);
    rslt(6,9) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.094454413881008883124362799105070316734);
    rslt(7,2) = static_cast<FP>(0.091405792533077831951987909854918139539);
    rslt(7,3) = static_cast<FP>(0.075360214297458902874013771987351920547);
    rslt(7,4) = static_cast<FP>(0.039585893651685366539381091958071763848);
    rslt(7,5) = -static_cast<FP>(0.012723968818416798935462764291199123496);
    rslt(7,6) = -static_cast<FP>(0.067879562522923503379251721548652388232);
    rslt(7,7) = -static_cast<FP>(0.11089863513244222207429267957149692873);
    rslt(7,8) = -static_cast<FP>(0.13550388976886794085612834247039364448);
    rslt(7,9) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.025369473455105906038302796072864965747);
    rslt(8,2) = -static_cast<FP>(0.024087204203711909352739472534721235208);
    rslt(8,3) = -static_cast<FP>(0.019171464790493072159958445019396889849);
    rslt(8,4) = -static_cast<FP>(0.0092015712867331129111414001366089565890);
    rslt(8,5) = static_cast<FP>(0.0044424968830502683610020176659543307726);
    rslt(8,6) = static_cast<FP>(0.017889863124513736092085492277189589661);
    rslt(8,7) = static_cast<FP>(0.027559063654135986018331948435525880516);
    rslt(8,8) = static_cast<FP>(0.032546025894023620488704299193223246279);
    rslt(8,9) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0043827712408219468758057445430216913664);
    rslt(9,2) = static_cast<FP>(0.0041158951162855267694502564443189052244);
    rslt(9,3) = static_cast<FP>(0.0032107183275340077406576906518246792945);
    rslt(9,4) = static_cast<FP>(0.0014606688435595997040958372210208376455);
    rslt(9,5) = -static_cast<FP>(0.00085106198607857859589702637543609752405);
    rslt(9,6) = -static_cast<FP>(0.0030487815283750419797086264291561513803);
    rslt(9,7) = -static_cast<FP>(0.0045615116768619550253731640867040903944);
    rslt(9,8) = -static_cast<FP>(0.0052971850230625459294465016862875643677);
    rslt(9,9) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00035818886007938937781879364069612768048);
    rslt(10,2) = -static_cast<FP>(0.00033400558115342184404165169941607370777);
    rslt(10,3) = -static_cast<FP>(0.00025720588433792739423262548508385312536);
    rslt(10,4) = -static_cast<FP>(0.00011295392904427723791498078603183045717);
    rslt(10,5) = static_cast<FP>(0.000073466141028220714311291113945234606017);
    rslt(10,6) = static_cast<FP>(0.00024678726801130715449792418123561174708);
    rslt(10,7) = static_cast<FP>(0.00036289866440535657107004580251914778040);
    rslt(10,8) = static_cast<FP>(0.00041726662439488890527601903102209940696);
    rslt(10,9) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,11,11> &rslt) {
    rslt(0,0) = static_cast<FP>(0.00043290043290043290043290043290043290043);
    rslt(0,1) = static_cast<FP>(0.00042049186223633778635037177022870826925);
    rslt(0,2) = static_cast<FP>(0.00037897438827787537242220970037031101033);
    rslt(0,3) = static_cast<FP>(0.00028968580516540368662501222266959226582);
    rslt(0,4) = static_cast<FP>(0.00014829264617767143726724250249287151280);
    rslt(0,5) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(0,6) = -static_cast<FP>(0.00017873490957245661162113001890041327068);
    rslt(0,7) = -static_cast<FP>(0.00028801809412652086582586869614552338431);
    rslt(0,8) = -static_cast<FP>(0.00034248610195190976723274355677557592828);
    rslt(0,9) = -static_cast<FP>(0.00035902660060933172215291065348461869982);
    rslt(0,10) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(1,0) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(1,1) = -static_cast<FP>(0.0053422797832584467863870221731579658394);
    rslt(1,2) = -static_cast<FP>(0.0047758446948996865794221725756591135045);
    rslt(1,3) = -static_cast<FP>(0.0036023325187904589913590660842712416631);
    rslt(1,4) = -static_cast<FP>(0.0017933907270494882544543833965199661225);
    rslt(1,5) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(1,6) = static_cast<FP>(0.0022638188322092121154977144693470241593);
    rslt(1,7) = static_cast<FP>(0.0035777705024574388190049150537592553441);
    rslt(1,8) = static_cast<FP>(0.0042124905495259962764292863239705335857);
    rslt(1,9) = static_cast<FP>(0.0043906714698623485241560988291413622072);
    rslt(1,10) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(2,0) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(2,1) = static_cast<FP>(0.032866559547526502438500947465014373547);
    rslt(2,2) = static_cast<FP>(0.028979551208162579659944838672383930440);
    rslt(2,3) = static_cast<FP>(0.021373715724316233106346406207092726231);
    rslt(2,4) = static_cast<FP>(0.010144300382103373226412314673916441058);
    rslt(2,5) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(2,6) = -static_cast<FP>(0.013824189856139469458747708076012955266);
    rslt(2,7) = -static_cast<FP>(0.021200806890186506379892953444163590342);
    rslt(2,8) = -static_cast<FP>(0.024580847928013674939477536090655960296);
    rslt(2,9) = -static_cast<FP>(0.025394231211884718998267750698868346795);
    rslt(2,10) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(3,0) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(3,1) = -static_cast<FP>(0.13720942349750820344528242024154445056);
    rslt(3,2) = -static_cast<FP>(0.11764009404622017644856156041015503747);
    rslt(3,3) = -static_cast<FP>(0.082937315010804217458788440688435169648);
    rslt(3,4) = -static_cast<FP>(0.035618684071618599390126976548493931387);
    rslt(3,5) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(3,6) = static_cast<FP>(0.056492896228341571312686378385142945297);
    rslt(3,7) = static_cast<FP>(0.082230261748063014058666593134933232904);
    rslt(3,8) = static_cast<FP>(0.092806422451877822098661197136989791714);
    rslt(3,9) = static_cast<FP>(0.094411740110829704487838275682904076696);
    rslt(3,10) = static_cast<FP>(0.093686868686868686868686868686868686868);
    rslt(4,0) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(4,1) = static_cast<FP>(0.52144004875403435854195614515078471693);
    rslt(4,2) = static_cast<FP>(0.41158383687448372265170526156977421089);
    rslt(4,3) = static_cast<FP>(0.25461194258890380415173306093487559697);
    rslt(4,4) = static_cast<FP>(0.078090853518412484585581722952205768591);
    rslt(4,5) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(4,6) = -static_cast<FP>(0.19669960461853318571588720530131008749);
    rslt(4,7) = -static_cast<FP>(0.25644919917195691213914243245501450033);
    rslt(4,8) = -static_cast<FP>(0.27321577407130952568081310660241398069);
    rslt(4,9) = -static_cast<FP>(0.26905483408669219387977229214678667117);
    rslt(4,10) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(5,0) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(5,1) = static_cast<FP>(0.78383028343546364305306055701576881541);
    rslt(5,2) = static_cast<FP>(0.88259377137006697735634432583217089024);
    rslt(5,3) = static_cast<FP>(1.0023942953169587220126327738146996217);
    rslt(5,4) = static_cast<FP>(1.1009744425756688867533920303581323029);
    rslt(5,5) = static_cast<FP>(1.1392224376507823773448773448773448773);
    rslt(5,6) = static_cast<FP>(1.1009744425756688867533920303581323029);
    rslt(5,7) = static_cast<FP>(1.0023942953169587220126327738146996217);
    rslt(5,8) = static_cast<FP>(0.88259377137006697735634432583217089024);
    rslt(5,9) = static_cast<FP>(0.78383028343546364305306055701576881541);
    rslt(5,10) = static_cast<FP>(0.73654401154401154401154401154401154401);
    rslt(6,0) = -static_cast<FP>(0.26345598845598845598845598845598845599);
    rslt(6,1) = -static_cast<FP>(0.26905483408669219387977229214678667117);
    rslt(6,2) = -static_cast<FP>(0.27321577407130952568081310660241398069);
    rslt(6,3) = -static_cast<FP>(0.25644919917195691213914243245501450033);
    rslt(6,4) = -static_cast<FP>(0.19669960461853318571588720530131008749);
    rslt(6,5) = -static_cast<FP>(0.082113927095311372655122655122655122655);
    rslt(6,6) = static_cast<FP>(0.078090853518412484585581722952205768591);
    rslt(6,7) = static_cast<FP>(0.25461194258890380415173306093487559697);
    rslt(6,8) = static_cast<FP>(0.41158383687448372265170526156977421089);
    rslt(6,9) = static_cast<FP>(0.52144004875403435854195614515078471693);
    rslt(6,10) = static_cast<FP>(0.56987734487734487734487734487734487735);
    rslt(7,0) = static_cast<FP>(0.093686868686868686868686868686868686869);
    rslt(7,1) = static_cast<FP>(0.094411740110829704487838275682904076696);
    rslt(7,2) = static_cast<FP>(0.092806422451877822098661197136989791714);
    rslt(7,3) = static_cast<FP>(0.082230261748063014058666593134933232904);
    rslt(7,4) = static_cast<FP>(0.056492896228341571312686378385142945297);
    rslt(7,5) = static_cast<FP>(0.014817530424219877344877344877344877345);
    rslt(7,6) = -static_cast<FP>(0.035618684071618599390126976548493931387);
    rslt(7,7) = -static_cast<FP>(0.082937315010804217458788440688435169648);
    rslt(7,8) = -static_cast<FP>(0.11764009404622017644856156041015503747);
    rslt(7,9) = -static_cast<FP>(0.13720942349750820344528242024154445056);
    rslt(7,10) = -static_cast<FP>(0.14440836940836940836940836940836940837);
    rslt(8,0) = -static_cast<FP>(0.025360750360750360750360750360750360750);
    rslt(8,1) = -static_cast<FP>(0.025394231211884718998267750698868346795);
    rslt(8,2) = -static_cast<FP>(0.024580847928013674939477536090655960296);
    rslt(8,3) = -static_cast<FP>(0.021200806890186506379892953444163590342);
    rslt(8,4) = -static_cast<FP>(0.013824189856139469458747708076012955266);
    rslt(8,5) = -static_cast<FP>(0.0026301319292957476551226551226551226551);
    rslt(8,6) = static_cast<FP>(0.010144300382103373226412314673916441058);
    rslt(8,7) = static_cast<FP>(0.021373715724316233106346406207092726231);
    rslt(8,8) = static_cast<FP>(0.028979551208162579659944838672383930440);
    rslt(8,9) = static_cast<FP>(0.032866559547526502438500947465014373547);
    rslt(8,10) = static_cast<FP>(0.034163059163059163059163059163059163059);
    rslt(9,0) = static_cast<FP>(0.0044011544011544011544011544011544011544);
    rslt(9,1) = static_cast<FP>(0.0043906714698623485241560988291413622072);
    rslt(9,2) = static_cast<FP>(0.0042124905495259962764292863239705335857);
    rslt(9,3) = static_cast<FP>(0.0035777705024574388190049150537592553441);
    rslt(9,4) = static_cast<FP>(0.0022638188322092121154977144693470241593);
    rslt(9,5) = static_cast<FP>(0.00033715758660827020202020202020202020202);
    rslt(9,6) = -static_cast<FP>(0.0017933907270494882544543833965199661225);
    rslt(9,7) = -static_cast<FP>(0.0036023325187904589913590660842712416631);
    rslt(9,8) = -static_cast<FP>(0.0047758446948996865794221725756591135045);
    rslt(9,9) = -static_cast<FP>(0.0053422797832584467863870221731579658394);
    rslt(9,10) = -static_cast<FP>(0.0055194805194805194805194805194805194805);
    rslt(10,0) = -static_cast<FP>(0.00036075036075036075036075036075036075036);
    rslt(10,1) = -static_cast<FP>(0.00035902660060933172215291065348461869983);
    rslt(10,2) = -static_cast<FP>(0.00034248610195190976723274355677557592828);
    rslt(10,3) = -static_cast<FP>(0.00028801809412652086582586869614552338431);
    rslt(10,4) = -static_cast<FP>(0.00017873490957245661162113001890041327068);
    rslt(10,5) = -static_cast<FP>(0.000021847811612215909090909090909090909091);
    rslt(10,6) = static_cast<FP>(0.00014829264617767143726724250249287151280);
    rslt(10,7) = static_cast<FP>(0.00028968580516540368662501222266959226582);
    rslt(10,8) = static_cast<FP>(0.00037897438827787537242220970037031101033);
    rslt(10,9) = static_cast<FP>(0.00042049186223633778635037177022870826925);
    rslt(10,10) = static_cast<FP>(0.00043290043290043290043290043290043290043);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void weno_lower_sten_to_coefs(SArray<FP,3,6,6,6> &rslt) {
    rslt(0,0,0) = static_cast<FP>(0.032291666666666666666666666666666666667);
    rslt(0,0,1) = -static_cast<FP>(0.12829861111111111111111111111111111111);
    rslt(0,0,2) = -static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(0,0,3) = -static_cast<FP>(0.28472222222222222222222222222222222222);
    rslt(0,0,4) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(0,0,5) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(0,1,0) = -static_cast<FP>(0.19843750000000000000000000000000000000);
    rslt(0,1,1) = static_cast<FP>(0.82899305555555555555555555555555555555);
    rslt(0,1,2) = static_cast<FP>(2.3125000000000000000000000000000000000);
    rslt(0,1,3) = static_cast<FP>(1.6736111111111111111111111111111111111);
    rslt(0,1,4) = static_cast<FP>(0.45833333333333333333333333333333333333);
    rslt(0,1,5) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,2,0) = static_cast<FP>(0.51250000000000000000000000000000000000);
    rslt(0,2,1) = -static_cast<FP>(2.3246527777777777777777777777777777778);
    rslt(0,2,2) = -static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(0,2,3) = -static_cast<FP>(4.0138888888888888888888888888888888889);
    rslt(0,2,4) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(0,3,0) = -static_cast<FP>(0.71145833333333333333333333333333333333);
    rslt(0,3,1) = static_cast<FP>(3.7829861111111111111111111111111111111);
    rslt(0,3,2) = static_cast<FP>(8.3750000000000000000000000000000000000);
    rslt(0,3,3) = static_cast<FP>(4.8472222222222222222222222222222222222);
    rslt(0,3,4) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(0,3,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(0,4,0) = static_cast<FP>(0.51770833333333333333333333333333333333);
    rslt(0,4,1) = -static_cast<FP>(4.2664930555555555555555555555555555556);
    rslt(0,4,2) = -static_cast<FP>(6.1250000000000000000000000000000000000);
    rslt(0,4,3) = -static_cast<FP>(2.9236111111111111111111111111111111111);
    rslt(0,4,4) = -static_cast<FP>(0.58333333333333333333333333333333333333);
    rslt(0,4,5) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(0,5,0) = static_cast<FP>(0.84739583333333333333333333333333333333);
    rslt(0,5,1) = static_cast<FP>(2.1074652777777777777777777777777777778);
    rslt(0,5,2) = static_cast<FP>(1.8125000000000000000000000000000000000);
    rslt(0,5,3) = static_cast<FP>(0.70138888888888888888888888888888888889);
    rslt(0,5,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(0,5,5) = static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(1,0,0) = -static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(1,0,1) = static_cast<FP>(0.059201388888888888888888888888888888889);
    rslt(1,0,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(1,0,3) = -static_cast<FP>(0.034722222222222222222222222222222222222);
    rslt(1,0,4) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,0,5) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(1,1,0) = static_cast<FP>(0.028125000000000000000000000000000000000);
    rslt(1,1,1) = -static_cast<FP>(0.40017361111111111111111111111111111111);
    rslt(1,1,2) = -static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(1,1,3) = static_cast<FP>(0.25694444444444444444444444444444444444);
    rslt(1,1,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(1,1,5) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,2,0) = -static_cast<FP>(0.065625000000000000000000000000000000000);
    rslt(1,2,1) = static_cast<FP>(1.2170138888888888888888888888888888889);
    rslt(1,2,2) = static_cast<FP>(0.87500000000000000000000000000000000000);
    rslt(1,2,3) = -static_cast<FP>(0.84722222222222222222222222222222222222);
    rslt(1,2,4) = -static_cast<FP>(0.58333333333333333333333333333333333333);
    rslt(1,2,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(1,3,0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(1,3,1) = -static_cast<FP>(2.3420138888888888888888888888888888889);
    rslt(1,3,2) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,3,3) = static_cast<FP>(1.3472222222222222222222222222222222222);
    rslt(1,3,4) = static_cast<FP>(0.66666666666666666666666666666666666667);
    rslt(1,3,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(1,4,0) = static_cast<FP>(1.0411458333333333333333333333333333333);
    rslt(1,4,1) = static_cast<FP>(1.3376736111111111111111111111111111111);
    rslt(1,4,2) = -static_cast<FP>(0.43750000000000000000000000000000000000);
    rslt(1,4,3) = -static_cast<FP>(1.0069444444444444444444444444444444444);
    rslt(1,4,4) = -static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(1,4,5) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(1,5,0) = -static_cast<FP>(0.032291666666666666666666666666666666667);
    rslt(1,5,1) = static_cast<FP>(0.12829861111111111111111111111111111111);
    rslt(1,5,2) = static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(1,5,3) = static_cast<FP>(0.28472222222222222222222222222222222222);
    rslt(1,5,4) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(1,5,5) = static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(2,0,0) = 0;
    rslt(2,0,1) = -static_cast<FP>(0.044965277777777777777777777777777777778);
    rslt(2,0,2) = 0;
    rslt(2,0,3) = static_cast<FP>(0.048611111111111111111111111111111111111);
    rslt(2,0,4) = 0;
    rslt(2,0,5) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(2,1,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(2,1,1) = static_cast<FP>(0.32899305555555555555555555555555555556);
    rslt(2,1,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(2,1,3) = -static_cast<FP>(0.32638888888888888888888888888888888889);
    rslt(2,1,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,1,5) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,2,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(2,2,1) = -static_cast<FP>(1.1579861111111111111111111111111111111);
    rslt(2,2,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(2,2,3) = static_cast<FP>(0.65277777777777777777777777777777777778);
    rslt(2,2,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,2,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,3,0) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(2,3,1) = static_cast<FP>(0.44965277777777777777777777777777777778);
    rslt(2,3,2) = -static_cast<FP>(1.3750000000000000000000000000000000000);
    rslt(2,3,3) = -static_cast<FP>(0.48611111111111111111111111111111111111);
    rslt(2,3,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,3,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,4,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(2,4,1) = static_cast<FP>(0.48350694444444444444444444444444444444);
    rslt(2,4,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(2,4,3) = static_cast<FP>(0.076388888888888888888888888888888888889);
    rslt(2,4,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,4,5) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,5,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(2,5,1) = -static_cast<FP>(0.059201388888888888888888888888888888889);
    rslt(2,5,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(2,5,3) = static_cast<FP>(0.034722222222222222222222222222222222222);
    rslt(2,5,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(2,5,5) = static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(3,0,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(3,0,1) = static_cast<FP>(0.059201388888888888888888888888888888889);
    rslt(3,0,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(3,0,3) = -static_cast<FP>(0.034722222222222222222222222222222222222);
    rslt(3,0,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,0,5) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(3,1,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(3,1,1) = -static_cast<FP>(0.48350694444444444444444444444444444444);
    rslt(3,1,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(3,1,3) = -static_cast<FP>(0.076388888888888888888888888888888888889);
    rslt(3,1,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,1,5) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,2,0) = static_cast<FP>(1.1114583333333333333333333333333333333);
    rslt(3,2,1) = -static_cast<FP>(0.44965277777777777777777777777777777778);
    rslt(3,2,2) = -static_cast<FP>(1.3750000000000000000000000000000000000);
    rslt(3,2,3) = static_cast<FP>(0.48611111111111111111111111111111111111);
    rslt(3,2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,2,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(3,3,0) = -static_cast<FP>(0.060416666666666666666666666666666666667);
    rslt(3,3,1) = static_cast<FP>(1.1579861111111111111111111111111111111);
    rslt(3,3,2) = static_cast<FP>(0.75000000000000000000000000000000000000);
    rslt(3,3,3) = -static_cast<FP>(0.65277777777777777777777777777777777778);
    rslt(3,3,4) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(3,3,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(3,4,0) = static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(3,4,1) = -static_cast<FP>(0.32899305555555555555555555555555555556);
    rslt(3,4,2) = -static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(3,4,3) = static_cast<FP>(0.32638888888888888888888888888888888889);
    rslt(3,4,4) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,4,5) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(3,5,0) = 0;
    rslt(3,5,1) = static_cast<FP>(0.044965277777777777777777777777777777778);
    rslt(3,5,2) = 0;
    rslt(3,5,3) = -static_cast<FP>(0.048611111111111111111111111111111111111);
    rslt(3,5,4) = 0;
    rslt(3,5,5) = static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(4,0,0) = -static_cast<FP>(0.032291666666666666666666666666666666667);
    rslt(4,0,1) = -static_cast<FP>(0.12829861111111111111111111111111111111);
    rslt(4,0,2) = static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(4,0,3) = -static_cast<FP>(0.28472222222222222222222222222222222222);
    rslt(4,0,4) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(4,0,5) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(4,1,0) = static_cast<FP>(1.0411458333333333333333333333333333333);
    rslt(4,1,1) = -static_cast<FP>(1.3376736111111111111111111111111111111);
    rslt(4,1,2) = -static_cast<FP>(0.43750000000000000000000000000000000000);
    rslt(4,1,3) = static_cast<FP>(1.0069444444444444444444444444444444444);
    rslt(4,1,4) = -static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(4,1,5) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(4,2,0) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(4,2,1) = static_cast<FP>(2.3420138888888888888888888888888888889);
    rslt(4,2,2) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(4,2,3) = -static_cast<FP>(1.3472222222222222222222222222222222222);
    rslt(4,2,4) = static_cast<FP>(0.66666666666666666666666666666666666667);
    rslt(4,2,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(4,3,0) = -static_cast<FP>(0.065625000000000000000000000000000000000);
    rslt(4,3,1) = -static_cast<FP>(1.2170138888888888888888888888888888889);
    rslt(4,3,2) = static_cast<FP>(0.87500000000000000000000000000000000000);
    rslt(4,3,3) = static_cast<FP>(0.84722222222222222222222222222222222222);
    rslt(4,3,4) = -static_cast<FP>(0.58333333333333333333333333333333333333);
    rslt(4,3,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(4,4,0) = static_cast<FP>(0.028125000000000000000000000000000000000);
    rslt(4,4,1) = static_cast<FP>(0.40017361111111111111111111111111111111);
    rslt(4,4,2) = -static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(4,4,3) = -static_cast<FP>(0.25694444444444444444444444444444444444);
    rslt(4,4,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(4,4,5) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(4,5,0) = -static_cast<FP>(0.0046875000000000000000000000000000000000);
    rslt(4,5,1) = -static_cast<FP>(0.059201388888888888888888888888888888889);
    rslt(4,5,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,5,3) = static_cast<FP>(0.034722222222222222222222222222222222222);
    rslt(4,5,4) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(4,5,5) = static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(5,0,0) = static_cast<FP>(0.84739583333333333333333333333333333333);
    rslt(5,0,1) = -static_cast<FP>(2.1074652777777777777777777777777777778);
    rslt(5,0,2) = static_cast<FP>(1.8125000000000000000000000000000000000);
    rslt(5,0,3) = -static_cast<FP>(0.70138888888888888888888888888888888889);
    rslt(5,0,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(5,0,5) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(5,1,0) = static_cast<FP>(0.51770833333333333333333333333333333333);
    rslt(5,1,1) = static_cast<FP>(4.2664930555555555555555555555555555556);
    rslt(5,1,2) = -static_cast<FP>(6.1250000000000000000000000000000000000);
    rslt(5,1,3) = static_cast<FP>(2.9236111111111111111111111111111111111);
    rslt(5,1,4) = -static_cast<FP>(0.58333333333333333333333333333333333333);
    rslt(5,1,5) = static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(5,2,0) = -static_cast<FP>(0.71145833333333333333333333333333333333);
    rslt(5,2,1) = -static_cast<FP>(3.7829861111111111111111111111111111111);
    rslt(5,2,2) = static_cast<FP>(8.3750000000000000000000000000000000000);
    rslt(5,2,3) = -static_cast<FP>(4.8472222222222222222222222222222222222);
    rslt(5,2,4) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(5,2,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(5,3,0) = static_cast<FP>(0.51250000000000000000000000000000000000);
    rslt(5,3,1) = static_cast<FP>(2.3246527777777777777777777777777777778);
    rslt(5,3,2) = -static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(5,3,3) = static_cast<FP>(4.0138888888888888888888888888888888889);
    rslt(5,3,4) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(5,3,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(5,4,0) = -static_cast<FP>(0.19843750000000000000000000000000000000);
    rslt(5,4,1) = -static_cast<FP>(0.82899305555555555555555555555555555555);
    rslt(5,4,2) = static_cast<FP>(2.3125000000000000000000000000000000000);
    rslt(5,4,3) = -static_cast<FP>(1.6736111111111111111111111111111111111);
    rslt(5,4,4) = static_cast<FP>(0.45833333333333333333333333333333333333);
    rslt(5,4,5) = -static_cast<FP>(0.041666666666666666666666666666666666667);
    rslt(5,5,0) = static_cast<FP>(0.032291666666666666666666666666666666667);
    rslt(5,5,1) = static_cast<FP>(0.12829861111111111111111111111111111111);
    rslt(5,5,2) = -static_cast<FP>(0.37500000000000000000000000000000000000);
    rslt(5,5,3) = static_cast<FP>(0.28472222222222222222222222222222222222);
    rslt(5,5,4) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(5,5,5) = static_cast<FP>(0.0083333333333333333333333333333333333333);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,12> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(2) = -static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(3) = -static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(4) = -static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(5) = -static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(6) = static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(7) = static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(8) = static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(9) = static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(10) = static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(11) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,12> &rslt) {
    rslt(0) = static_cast<FP>(0.0075757575757575757575757575757575757576);
    rslt(1) = static_cast<FP>(0.045842258706598065334171297067039643155);
    rslt(2) = static_cast<FP>(0.078987352782185057582335531350170134125);
    rslt(3) = static_cast<FP>(0.10625420888051057267915103868343313510);
    rslt(4) = static_cast<FP>(0.12563780159960064014662220607379809167);
    rslt(5) = static_cast<FP>(0.13570262045534808850014416924980142020);
    rslt(6) = static_cast<FP>(0.13570262045534808850014416924980142020);
    rslt(7) = static_cast<FP>(0.12563780159960064014662220607379809167);
    rslt(8) = static_cast<FP>(0.10625420888051057267915103868343313510);
    rslt(9) = static_cast<FP>(0.078987352782185057582335531350170134125);
    rslt(10) = static_cast<FP>(0.045842258706598065334171297067039643155);
    rslt(11) = static_cast<FP>(0.0075757575757575757575757575757575757576);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,12,12> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.020507812500000000000000000000000007028);
    rslt(0,1) = static_cast<FP>(0.041015624999999999999999999999999994668);
    rslt(0,2) = static_cast<FP>(5.3320312500000000000000000000000003611);
    rslt(0,3) = -static_cast<FP>(10.664062499999999999999999999999999394);
    rslt(0,4) = -static_cast<FP>(213.28125000000000000000000000000001647);
    rslt(0,5) = static_cast<FP>(426.56249999999999999999999999999995985);
    rslt(0,6) = static_cast<FP>(2900.6250000000000000000000000000001875);
    rslt(0,7) = -static_cast<FP>(5801.2499999999999999999999999999995108);
    rslt(0,8) = -static_cast<FP>(15746.250000000000000000000000000000804);
    rslt(0,9) = static_cast<FP>(31492.499999999999999999999999999997830);
    rslt(0,10) = static_cast<FP>(29393.000000000000000000000000000001221);
    rslt(0,11) = -static_cast<FP>(58785.999999999999999999999999999996688);
    rslt(1,0) = static_cast<FP>(0.053389246685995019630884970228941875926);
    rslt(1,1) = -static_cast<FP>(0.11300515992651034443893628012554279776);
    rslt(1,2) = -static_cast<FP>(13.855571270165735329349608698274722600);
    rslt(1,3) = static_cast<FP>(29.327086341320606339592571929558294595);
    rslt(1,4) = static_cast<FP>(548.69845794865774358960688735703050904);
    rslt(1,5) = -static_cast<FP>(1161.3903705478378431297577510905956409);
    rslt(1,6) = -static_cast<FP>(7314.1366517683843010524303267398341894);
    rslt(1,7) = static_cast<FP>(15481.304445418454133447931393914086159);
    rslt(1,8) = static_cast<FP>(38430.520795991127983961714449919104566);
    rslt(1,9) = -static_cast<FP>(81343.105928281764682902281093817587362);
    rslt(1,10) = -static_cast<FP>(68320.242407828489364531339745445131349);
    rslt(1,11) = static_cast<FP>(144608.51948188008592651649047932472428);
    rslt(2,0) = -static_cast<FP>(0.080826372795637979492624884750144796305);
    rslt(2,1) = static_cast<FP>(0.19731090645238733850440764139004593377);
    rslt(2,2) = static_cast<FP>(20.856492977017122513594636090380723511);
    rslt(2,3) = -static_cast<FP>(50.914242373810790856509032488548730389);
    rslt(2,4) = -static_cast<FP>(800.36339004147074170331695016339994136);
    rslt(2,5) = static_cast<FP>(1953.8229975960377311215251762320831189);
    rslt(2,6) = static_cast<FP>(10024.845431810650214141947890789072419);
    rslt(2,7) = -static_cast<FP>(24472.350679361212823636444376696072386);
    rslt(2,8) = -static_cast<FP>(48047.038027756881636438594088676933431);
    rslt(2,9) = static_cast<FP>(117290.98186279937565171988155873488687);
    rslt(2,10) = static_cast<FP>(77757.386168337600516015715955386854366);
    rslt(2,11) = -static_cast<FP>(189818.98874807619439583622859437064093);
    rslt(3,0) = static_cast<FP>(0.12135582949558433713500709347517677446);
    rslt(3,1) = -static_cast<FP>(0.38350577412094388144701629881693201922);
    rslt(3,2) = -static_cast<FP>(30.825993261643898491602647785062653442);
    rslt(3,3) = static_cast<FP>(97.415562630915042777603123865324070492);
    rslt(3,4) = static_cast<FP>(1080.4603709612176678958658726266473707);
    rslt(3,5) = -static_cast<FP>(3414.4448824154839153767959512363944775);
    rslt(3,6) = -static_cast<FP>(11422.724420825789257835310259609680635);
    rslt(3,7) = static_cast<FP>(36097.819031745817003764311113337682838);
    rslt(3,8) = static_cast<FP>(47761.900710103266886277562162476357321);
    rslt(3,9) = -static_cast<FP>(150936.01009074141905202189769907613395);
    rslt(3,10) = -static_cast<FP>(69666.289943141010512456669774998512637);
    rslt(3,11) = static_cast<FP>(220157.73420880917031550889884249643330);
    rslt(4,0) = -static_cast<FP>(0.20903357581805155845340598909404551075);
    rslt(4,1) = static_cast<FP>(1.0463949315814361885911644300818768119);
    rslt(4,2) = static_cast<FP>(49.946746892655307591102706731890794922);
    rslt(4,3) = -static_cast<FP>(250.02692793691368999099357153301986279);
    rslt(4,4) = -static_cast<FP>(1139.7417792244373864120425161560778891);
    rslt(4,5) = static_cast<FP>(5705.3993188642001848887618316807222051);
    rslt(4,6) = static_cast<FP>(9701.0177361105945638003110115682336871);
    rslt(4,7) = -static_cast<FP>(48562.034833502207995443616779188656429);
    rslt(4,8) = -static_cast<FP>(35667.159587554194006305513617749688375);
    rslt(4,9) = static_cast<FP>(178545.16849871501877030615555155773372);
    rslt(4,10) = static_cast<FP>(47823.511619929181787321794129364258542);
    rslt(4,11) = -static_cast<FP>(239398.28792422304500643050903072941018);
    rslt(5,0) = static_cast<FP>(0.63562268493211018118013881014007168028);
    rslt(5,1) = -static_cast<FP>(9.3095427779261137968499947729472511862);
    rslt(5,2) = -static_cast<FP>(31.453706587862796283745086338934142771);
    rslt(5,3) = static_cast<FP>(460.68152371767648258542481218420198280);
    rslt(5,4) = static_cast<FP>(524.22759035603271662988670633579995885);
    rslt(5,5) = -static_cast<FP>(7678.0129052660739203017408479176360117);
    rslt(5,6) = -static_cast<FP>(3889.6270953270712190545183160077912456);
    rslt(5,7) = static_cast<FP>(56968.781468199902100350467111768825515);
    rslt(5,8) = static_cast<FP>(13268.026109216680772504831094031159111);
    rslt(5,9) = -static_cast<FP>(194327.95520126245229989937190044915132);
    rslt(5,10) = -static_cast<FP>(16987.365437297282426349500564307466746);
    rslt(5,11) = static_cast<FP>(248802.64498375126747940707080856637952);
    rslt(6,0) = static_cast<FP>(0.63562268493211018118013881014007161356);
    rslt(6,1) = static_cast<FP>(9.3095427779261137968499947729472511641);
    rslt(6,2) = -static_cast<FP>(31.453706587862796283745086338934142440);
    rslt(6,3) = -static_cast<FP>(460.68152371767648258542481218420198117);
    rslt(6,4) = static_cast<FP>(524.22759035603271662988670633579997432);
    rslt(6,5) = static_cast<FP>(7678.0129052660739203017408479176359833);
    rslt(6,6) = -static_cast<FP>(3889.6270953270712190545183160077918924);
    rslt(6,7) = -static_cast<FP>(56968.781468199902100350467111768825315);
    rslt(6,8) = static_cast<FP>(13268.026109216680772504831094031164161);
    rslt(6,9) = static_cast<FP>(194327.95520126245229989937190044915058);
    rslt(6,10) = -static_cast<FP>(16987.365437297282426349500564307477591);
    rslt(6,11) = -static_cast<FP>(248802.64498375126747940707080856637843);
    rslt(7,0) = -static_cast<FP>(0.20903357581805155845340598909404544689);
    rslt(7,1) = -static_cast<FP>(1.0463949315814361885911644300818767529);
    rslt(7,2) = static_cast<FP>(49.946746892655307591102706731890793887);
    rslt(7,3) = static_cast<FP>(250.02692793691368999099357153301985820);
    rslt(7,4) = -static_cast<FP>(1139.7417792244373864120425161560778777);
    rslt(7,5) = -static_cast<FP>(5705.3993188642001848887618316807221218);
    rslt(7,6) = static_cast<FP>(9701.0177361105945638003110115682339738);
    rslt(7,7) = static_cast<FP>(48562.034833502207995443616779188655821);
    rslt(7,8) = -static_cast<FP>(35667.159587554194006305513617749691488);
    rslt(7,9) = -static_cast<FP>(178545.16849871501877030615555155773150);
    rslt(7,10) = static_cast<FP>(47823.511619929181787321794129364265859);
    rslt(7,11) = static_cast<FP>(239398.28792422304500643050903072940698);
    rslt(8,0) = static_cast<FP>(0.12135582949558433713500709347517671583);
    rslt(8,1) = static_cast<FP>(0.38350577412094388144701629881693194458);
    rslt(8,2) = -static_cast<FP>(30.825993261643898491602647785062651220);
    rslt(8,3) = -static_cast<FP>(97.415562630915042777603123865324064048);
    rslt(8,4) = static_cast<FP>(1080.4603709612176678958658726266473121);
    rslt(8,5) = static_cast<FP>(3414.4448824154839153767959512363943555);
    rslt(8,6) = -static_cast<FP>(11422.724420825789257835310259609680273);
    rslt(8,7) = -static_cast<FP>(36097.819031745817003764311113337681949);
    rslt(8,8) = static_cast<FP>(47761.900710103266886277562162476356950);
    rslt(8,9) = static_cast<FP>(150936.01009074141905202189769907613083);
    rslt(8,10) = -static_cast<FP>(69666.289943141010512456669774998513669);
    rslt(8,11) = -static_cast<FP>(220157.73420880917031550889884249642904);
    rslt(9,0) = -static_cast<FP>(0.080826372795637979492624884750144747385);
    rslt(9,1) = -static_cast<FP>(0.19731090645238733850440764139004585460);
    rslt(9,2) = static_cast<FP>(20.856492977017122513594636090380720683);
    rslt(9,3) = static_cast<FP>(50.914242373810790856509032488548722472);
    rslt(9,4) = -static_cast<FP>(800.36339004147074170331695016339985452);
    rslt(9,5) = -static_cast<FP>(1953.8229975960377311215251762320829532);
    rslt(9,6) = static_cast<FP>(10024.845431810650214141947890789071636);
    rslt(9,7) = static_cast<FP>(24472.350679361212823636444376696071015);
    rslt(9,8) = -static_cast<FP>(48047.038027756881636438594088676930657);
    rslt(9,9) = -static_cast<FP>(117290.98186279937565171988155873488161);
    rslt(9,10) = static_cast<FP>(77757.386168337600516015715955386850885);
    rslt(9,11) = static_cast<FP>(189818.98874807619439583622859437063346);
    rslt(10,0) = static_cast<FP>(0.053389246685995019630884970228941840114);
    rslt(10,1) = static_cast<FP>(0.11300515992651034443893628012554273209);
    rslt(10,2) = -static_cast<FP>(13.855571270165735329349608698274719958);
    rslt(10,3) = -static_cast<FP>(29.327086341320606339592571929558287545);
    rslt(10,4) = static_cast<FP>(548.69845794865774358960688735703042438);
    rslt(10,5) = static_cast<FP>(1161.3903705478378431297577510905954805);
    rslt(10,6) = -static_cast<FP>(7314.1366517683843010524303267398333517);
    rslt(10,7) = -static_cast<FP>(15481.304445418454133447931393914084730);
    rslt(10,8) = static_cast<FP>(38430.520795991127983961714449919101235);
    rslt(10,9) = static_cast<FP>(81343.105928281764682902281093817581547);
    rslt(10,10) = -static_cast<FP>(68320.242407828489364531339745445126616);
    rslt(10,11) = -static_cast<FP>(144608.51948188008592651649047932471559);
    rslt(11,0) = -static_cast<FP>(0.020507812499999999999999999999999992117);
    rslt(11,1) = -static_cast<FP>(0.041015624999999999999999999999999964708);
    rslt(11,2) = static_cast<FP>(5.3320312499999999999999999999999990888);
    rslt(11,3) = static_cast<FP>(10.664062499999999999999999999999996287);
    rslt(11,4) = -static_cast<FP>(213.28124999999999999999999999999997317);
    rslt(11,5) = -static_cast<FP>(426.56249999999999999999999999999989536);
    rslt(11,6) = static_cast<FP>(2900.6249999999999999999999999999997253);
    rslt(11,7) = static_cast<FP>(5801.2499999999999999999999999999989892);
    rslt(11,8) = -static_cast<FP>(15746.249999999999999999999999999998827);
    rslt(11,9) = -static_cast<FP>(31492.499999999999999999999999999995871);
    rslt(11,10) = static_cast<FP>(29392.999999999999999999999999999998217);
    rslt(11,11) = static_cast<FP>(58785.999999999999999999999999999993951);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,12,12> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,11) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,2) = -static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,3) = -static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,4) = -static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,5) = -static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,6) = static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,7) = static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,8) = static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,9) = static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,10) = static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,11) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,2) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,3) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,4) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,5) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,6) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,7) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,8) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,9) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,10) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,11) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,2) = -static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,3) = -static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,4) = -static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,5) = -static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,6) = static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,7) = static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,8) = static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,9) = static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,10) = static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,11) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,2) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,3) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,4) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,5) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,6) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,7) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,8) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,9) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,10) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,11) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,2) = -static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,3) = -static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,4) = -static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,5) = -static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,6) = static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,7) = static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,8) = static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,9) = static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,10) = static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,11) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,2) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,3) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,4) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,5) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,6) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,7) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,8) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,9) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,10) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,11) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,2) = -static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,3) = -static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,4) = -static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,5) = -static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,6) = static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,7) = static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,8) = static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,9) = static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,10) = static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,11) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,2) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,3) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,4) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,5) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,6) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,7) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,8) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,9) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,10) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,11) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,2) = -static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,3) = -static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,4) = -static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,5) = -static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,6) = static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,7) = static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,8) = static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,9) = static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,10) = static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,11) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,2) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,3) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,4) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,5) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,6) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,7) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,8) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,9) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,10) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,11) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,2) = -static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,3) = -static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,4) = -static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,5) = -static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,6) = static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,7) = static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,8) = static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,9) = static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,10) = static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,11) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,12,12> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(0,8) = 0;
    rslt(0,9) = 0;
    rslt(0,10) = 0;
    rslt(0,11) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(1,8) = 0;
    rslt(1,9) = 0;
    rslt(1,10) = 0;
    rslt(1,11) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(2,8) = 0;
    rslt(2,9) = 0;
    rslt(2,10) = 0;
    rslt(2,11) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(3,8) = 0;
    rslt(3,9) = 0;
    rslt(3,10) = 0;
    rslt(3,11) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(4,8) = 0;
    rslt(4,9) = 0;
    rslt(4,10) = 0;
    rslt(4,11) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(5,8) = 0;
    rslt(5,9) = 0;
    rslt(5,10) = 0;
    rslt(5,11) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(6,8) = 0;
    rslt(6,9) = 0;
    rslt(6,10) = 0;
    rslt(6,11) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
    rslt(7,8) = 0;
    rslt(7,9) = 0;
    rslt(7,10) = 0;
    rslt(7,11) = 0;
    rslt(8,0) = 0;
    rslt(8,1) = 0;
    rslt(8,2) = 0;
    rslt(8,3) = 0;
    rslt(8,4) = 0;
    rslt(8,5) = 0;
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(8.0000000000000000000000000000000000000);
    rslt(8,8) = 0;
    rslt(8,9) = 0;
    rslt(8,10) = 0;
    rslt(8,11) = 0;
    rslt(9,0) = 0;
    rslt(9,1) = 0;
    rslt(9,2) = 0;
    rslt(9,3) = 0;
    rslt(9,4) = 0;
    rslt(9,5) = 0;
    rslt(9,6) = 0;
    rslt(9,7) = 0;
    rslt(9,8) = static_cast<FP>(9.0000000000000000000000000000000000000);
    rslt(9,9) = 0;
    rslt(9,10) = 0;
    rslt(9,11) = 0;
    rslt(10,0) = 0;
    rslt(10,1) = 0;
    rslt(10,2) = 0;
    rslt(10,3) = 0;
    rslt(10,4) = 0;
    rslt(10,5) = 0;
    rslt(10,6) = 0;
    rslt(10,7) = 0;
    rslt(10,8) = 0;
    rslt(10,9) = static_cast<FP>(10.000000000000000000000000000000000000);
    rslt(10,10) = 0;
    rslt(10,11) = 0;
    rslt(11,0) = 0;
    rslt(11,1) = 0;
    rslt(11,2) = 0;
    rslt(11,3) = 0;
    rslt(11,4) = 0;
    rslt(11,5) = 0;
    rslt(11,6) = 0;
    rslt(11,7) = 0;
    rslt(11,8) = 0;
    rslt(11,9) = 0;
    rslt(11,10) = static_cast<FP>(11.000000000000000000000000000000000000);
    rslt(11,11) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,12> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(1.4307515635684090909090909090909090909e13)*(a(10)*a(10))+static_cast<FP>(0.0019531250000000000000000000000000000000)*a(1)*a(11)+static_cast<FP>(1.7312093919177750000000000000000000000e15)*(a(11)*a(11))+static_cast<FP>(0.15980113636363636363636363636363636364)*a(10)*a(2)+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(5.2734375000000000000000000000000000000)*a(11)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(555.19176136363636363636363636363636364)*a(10)*a(4)+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(30535.546875000000000000000000000000000)*a(11)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.903707837301587301587301587301587)*(a(5)*a(5))+static_cast<FP>(2.8203903409090909090909090909090909091e6)*a(10)*a(6)+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6279761904761904761904761904761905)*a(4)*a(6)+static_cast<FP>(563252.53667816558441558441558441558442)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(2.1717005625000000000000000000000000000e8)*a(11)*a(7)+static_cast<FP>(32.643229166666666666666666666666666667)*a(3)*a(7)+static_cast<FP>(52976.985381155303030303030303030303030)*a(5)*a(7)+static_cast<FP>(2.7599374297230113636363636363636363636e7)*(a(7)*a(7))+static_cast<FP>(1.2816192303409090909090909090909090909e10)*a(10)*a(8)+static_cast<FP>(0.51388888888888888888888888888888888889)*a(2)*a(8)+static_cast<FP>(1044.5890151515151515151515151515151515)*a(4)*a(8)+static_cast<FP>(2.5428952982954545454545454545454545455e6)*a(6)*a(8)+static_cast<FP>(1.7663599550227272727272727272727272727e9)*(a(8)*a(8))+static_cast<FP>(0.0078125000000000000000000000000000000000)*a(1)*a(9)+static_cast<FP>(1.2688030380375000000000000000000000000e12)*a(11)*a(9)+static_cast<FP>(13.879794034090909090909090909090909091)*a(3)*a(9)+static_cast<FP>(47006.505681818181818181818181818181818)*a(5)*a(9)+static_cast<FP>(1.6020240379261363636363636363636363636e8)*a(7)*a(9)+static_cast<FP>(1.4307515635684090909090909090909090909e11)*(a(9)*a(9));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
    rslt(8,0) = 0;
    rslt(9,0) = 0;
    rslt(10,0) = 0;
    rslt(11,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = 0;
    rslt(8,2) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = 0;
    rslt(9,2) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = 0;
    rslt(10,2) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = 0;
    rslt(11,2) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,2) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,3) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,2) = static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,3) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,2) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,3) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(6.9877124296868428012786677147852382358e-8);
    rslt(11,2) = static_cast<FP>(6.9877124296868428012786677147852382358e-8);
    rslt(11,3) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,2) = 0;
    rslt(8,3) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,4) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,2) = 0;
    rslt(9,3) = static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,4) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,2) = 0;
    rslt(10,3) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,4) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(4.6216571889118944447610029857579623051e-6);
    rslt(11,2) = 0;
    rslt(11,3) = static_cast<FP>(4.6216571889118944447610029857579623051e-6);
    rslt(11,4) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,2) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,3) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,4) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,5) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,2) = -static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,3) = static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,4) = static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,5) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,2) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,3) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,4) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,5) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.000025662047611759319872168488557990018377);
    rslt(11,2) = -static_cast<FP>(4.9641245331952598910822957947075443294e-10);
    rslt(11,3) = static_cast<FP>(4.9641245331952598910822957947075443294e-10);
    rslt(11,4) = static_cast<FP>(0.000025662047611759319872168488557990018377);
    rslt(11,5) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,2) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,3) = 0;
    rslt(8,4) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,5) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,6) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,2) = -static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,3) = 0;
    rslt(9,4) = static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,5) = static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,6) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,2) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,3) = 0;
    rslt(10,4) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,5) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,6) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.000063069236286896470595441580170224364906);
    rslt(11,2) = -static_cast<FP>(1.1749810917033255258466387744112512666e-7);
    rslt(11,3) = 0;
    rslt(11,4) = static_cast<FP>(1.1749810917033255258466387744112512666e-7);
    rslt(11,5) = static_cast<FP>(0.000063069236286896470595441580170224364906);
    rslt(11,6) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,2) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,3) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,4) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,5) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,6) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,7) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,2) = -static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,3) = -static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,4) = static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,5) = static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,6) = static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,7) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,2) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,3) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,4) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,5) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,6) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,7) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00010787668124300126397927360604952024349);
    rslt(11,2) = -static_cast<FP>(1.5198081692351406103597017693483156022e-6);
    rslt(11,3) = -static_cast<FP>(1.6485939742838283094248615477799067381e-11);
    rslt(11,4) = static_cast<FP>(1.6485939742838283094248615477799067381e-11);
    rslt(11,5) = static_cast<FP>(1.5198081692351406103597017693483156022e-6);
    rslt(11,6) = static_cast<FP>(0.00010787668124300126397927360604952024349);
    rslt(11,7) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,9> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,2) = -static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,3) = -static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,4) = 0;
    rslt(9,5) = static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,6) = static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,7) = static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,8) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,2) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,3) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,4) = 0;
    rslt(10,5) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,6) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,7) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,8) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00015277521651054650078862987348271507340);
    rslt(11,2) = -static_cast<FP>(6.7059405768591642644510312885922379995e-6);
    rslt(11,3) = -static_cast<FP>(7.0662426792541675057534239160018861021e-9);
    rslt(11,4) = 0;
    rslt(11,5) = static_cast<FP>(7.0662426792541675057534239160018861021e-9);
    rslt(11,6) = static_cast<FP>(6.7059405768591642644510312885922379995e-6);
    rslt(11,7) = static_cast<FP>(0.00015277521651054650078862987348271507340);
    rslt(11,8) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,10> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,9) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,2) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,3) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,4) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,5) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,6) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,7) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,8) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,9) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,2) = -static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,3) = -static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,4) = -static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,5) = static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,6) = static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,7) = static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,8) = static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,9) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,2) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,3) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,4) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,5) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,6) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,7) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,8) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,9) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,2) = -static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,3) = -static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,4) = -static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,5) = static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,6) = static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,7) = static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,8) = static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,9) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,2) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,3) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,4) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,5) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,6) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,7) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,8) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,9) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,2) = -static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,3) = -static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,4) = -static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,5) = static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,6) = static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,7) = static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,8) = static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,9) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,2) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,3) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,4) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,5) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,6) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,7) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,8) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,9) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,2) = -static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,3) = -static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,4) = -static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,5) = static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,6) = static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,7) = static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,8) = static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,9) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,2) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,3) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,4) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,5) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,6) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,7) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,8) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,9) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00019405073086810396184968532568139273581);
    rslt(11,2) = -static_cast<FP>(0.000017470156896397291370538034589054196169);
    rslt(11,3) = -static_cast<FP>(1.4508642616547837790136366505971039866e-7);
    rslt(11,4) = -static_cast<FP>(1.2276180518450530653058495612202153539e-12);
    rslt(11,5) = static_cast<FP>(1.2276180518450530653058495612202153539e-12);
    rslt(11,6) = static_cast<FP>(1.4508642616547837790136366505971039866e-7);
    rslt(11,7) = static_cast<FP>(0.000017470156896397291370538034589054196169);
    rslt(11,8) = static_cast<FP>(0.00019405073086810396184968532568139273581);
    rslt(11,9) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,11> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,2) = -static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,3) = -static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,4) = -static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,5) = 0;
    rslt(1,6) = static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,7) = static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,8) = static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,9) = static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,10) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,2) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,3) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,4) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,5) = 0;
    rslt(2,6) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,7) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,8) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,9) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,10) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,2) = -static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,3) = -static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,4) = -static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,5) = 0;
    rslt(3,6) = static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,7) = static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,8) = static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,9) = static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,10) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,2) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,3) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,4) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,5) = 0;
    rslt(4,6) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,7) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,8) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,9) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,10) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,2) = -static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,3) = -static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,4) = -static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,5) = 0;
    rslt(5,6) = static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,7) = static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,8) = static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,9) = static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,10) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,2) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,3) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,4) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,5) = 0;
    rslt(6,6) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,7) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,8) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,9) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,10) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,2) = -static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,3) = -static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,4) = -static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,7) = static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,8) = static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,9) = static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,10) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,2) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,3) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,4) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,5) = 0;
    rslt(8,6) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,7) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,8) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,9) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,10) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,2) = -static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,3) = -static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,4) = -static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,5) = 0;
    rslt(9,6) = static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,7) = static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,8) = static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,9) = static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,10) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,2) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,3) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,4) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,5) = 0;
    rslt(10,6) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,7) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,8) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,9) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,10) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00023040558520137412340666889867251922255);
    rslt(11,2) = -static_cast<FP>(0.000033813633110299807995230095325375638610);
    rslt(11,3) = -static_cast<FP>(9.1873934966831984945070471729444686924e-7);
    rslt(11,4) = -static_cast<FP>(7.3956056580315310032155370144097310613e-10);
    rslt(11,5) = 0;
    rslt(11,6) = static_cast<FP>(7.3956056580315310032155370144097310613e-10);
    rslt(11,7) = static_cast<FP>(9.1873934966831984945070471729444686924e-7);
    rslt(11,8) = static_cast<FP>(0.000033813633110299807995230095325375638610);
    rslt(11,9) = static_cast<FP>(0.00023040558520137412340666889867251922255);
    rslt(11,10) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,12,12> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(0,11) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,2) = -static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,3) = -static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,4) = -static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,5) = -static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,6) = static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,7) = static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,8) = static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,9) = static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,10) = static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,11) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,2) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,3) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,4) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,5) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,6) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,7) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,8) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,9) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,10) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,11) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,2) = -static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,3) = -static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,4) = -static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,5) = -static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,6) = static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,7) = static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,8) = static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,9) = static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,10) = static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,11) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,2) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,3) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,4) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,5) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,6) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,7) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,8) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,9) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,10) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,11) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,2) = -static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,3) = -static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,4) = -static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,5) = -static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,6) = static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,7) = static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,8) = static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,9) = static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,10) = static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,11) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,2) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,3) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,4) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,5) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,6) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,7) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,8) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,9) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,10) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,11) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,2) = -static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,3) = -static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,4) = -static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,5) = -static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,6) = static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,7) = static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,8) = static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,9) = static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,10) = static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,11) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,2) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,3) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,4) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,5) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,6) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,7) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,8) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,9) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,10) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,11) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,2) = -static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,3) = -static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,4) = -static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,5) = -static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,6) = static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,7) = static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,8) = static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,9) = static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,10) = static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,11) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,2) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,3) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,4) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,5) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,6) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,7) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,8) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,9) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,10) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,11) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,2) = -static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,3) = -static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,4) = -static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,5) = -static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,6) = static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,7) = static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,8) = static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,9) = static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,10) = static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,11) = static_cast<FP>(0.00048828125000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,13> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(2) = -static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(3) = -static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(4) = -static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(5) = -static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(6) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(7) = static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(8) = static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(9) = static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(10) = static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(11) = static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(12) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,13> &rslt) {
    rslt(0) = static_cast<FP>(0.0064102564102564102564102564102564102564);
    rslt(1) = static_cast<FP>(0.038900843373409463896794494166566792532);
    rslt(2) = static_cast<FP>(0.067490963344804174559957381294685444628);
    rslt(3) = static_cast<FP>(0.091823432601775046003747129373405361623);
    rslt(4) = static_cast<FP>(0.11038389678305504304276700418969814873);
    rslt(5) = static_cast<FP>(0.12200789515333817822928907418007810626);
    rslt(6) = static_cast<FP>(0.12596542466672336802206932077061947192);
    rslt(7) = static_cast<FP>(0.12200789515333817822928907418007810626);
    rslt(8) = static_cast<FP>(0.11038389678305504304276700418969814873);
    rslt(9) = static_cast<FP>(0.091823432601775046003747129373405361623);
    rslt(10) = static_cast<FP>(0.067490963344804174559957381294685444628);
    rslt(11) = static_cast<FP>(0.038900843373409463896794494166566792532);
    rslt(12) = static_cast<FP>(0.0064102564102564102564102564102564102564);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = static_cast<FP>(7.7216146127415491847304756828242185528e-37);
    rslt(0,1) = static_cast<FP>(0.45117187500000000000000000000000027833);
    rslt(0,2) = -static_cast<FP>(0.90234374999999999999999999999999775678);
    rslt(0,3) = -static_cast<FP>(45.117187500000000000000000000000033641);
    rslt(0,4) = static_cast<FP>(90.234374999999999999999999999999875417);
    rslt(0,5) = static_cast<FP>(1227.1875000000000000000000000000008709);
    rslt(0,6) = -static_cast<FP>(2454.3749999999999999999999999999972748);
    rslt(0,7) = -static_cast<FP>(13323.750000000000000000000000000008473);
    rslt(0,8) = static_cast<FP>(26647.499999999999999999999999999975265);
    rslt(0,9) = static_cast<FP>(62177.500000000000000000000000000034799);
    rslt(0,10) = -static_cast<FP>(124354.99999999999999999999999999990232);
    rslt(0,11) = -static_cast<FP>(104006.00000000000000000000000000005111);
    rslt(0,12) = static_cast<FP>(208011.99999999999999999999999999986027);
    rslt(1,0) = -static_cast<FP>(1.9944787472442148325829496496660992930e-36);
    rslt(1,1) = -static_cast<FP>(1.1658689812443045795720307586851807146);
    rslt(1,2) = static_cast<FP>(2.4459392407428415965888298828808480752);
    rslt(1,3) = static_cast<FP>(116.11890656408135776495235492493036880);
    rslt(1,4) = -static_cast<FP>(243.61209940941260013770853373930261570);
    rslt(1,5) = -static_cast<FP>(3126.4242957204002560289868958771220298);
    rslt(1,6) = static_cast<FP>(6559.0936813095574124280615428584500751);
    rslt(1,7) = static_cast<FP>(33353.755651485790628717195220286898086);
    rslt(1,8) = -static_cast<FP>(69974.637876588546285752847573247681141);
    rslt(1,9) = -static_cast<FP>(151587.84039745233544318079335474616666);
    rslt(1,10) = static_cast<FP>(318024.28335632752187902230162793819641);
    rslt(1,11) = static_cast<FP>(244249.83584853164840075716786664155780);
    rslt(1,12) = -static_cast<FP>(512424.86733741606549909316124553921124);
    rslt(2,0) = static_cast<FP>(3.2435700458302440231304451235260434615e-36);
    rslt(2,1) = static_cast<FP>(1.7297302590181839104226768862848389411);
    rslt(2,2) = -static_cast<FP>(4.0875175430549573718912516244649798654);
    rslt(2,3) = -static_cast<FP>(170.23275321235291062446360591172613740);
    rslt(2,4) = static_cast<FP>(402.27622863752117335437793325479871085);
    rslt(2,5) = static_cast<FP>(4446.1413202196929201884870804186210870);
    rslt(2,6) = -static_cast<FP>(10506.655908080793756574552654868951795);
    rslt(2,7) = -static_cast<FP>(45072.641021595807959779028603466395367);
    rslt(2,8) = static_cast<FP>(106510.94870258299345352346068101063447);
    rslt(2,9) = static_cast<FP>(191009.98683723115256490234522319127585);
    rslt(2,10) = -static_cast<FP>(451374.81293704480969665734068568310700);
    rslt(2,11) = -static_cast<FP>(285622.39446032430499961823440224831116);
    rslt(2,12) = static_cast<FP>(674952.95405690499992112125250839886109);
    rslt(3,0) = -static_cast<FP>(3.6559497241581678264179104945342340700e-36);
    rslt(3,1) = -static_cast<FP>(2.4885001097304116062870469738868301443);
    rslt(3,2) = static_cast<FP>(7.2531096684281758676127848624894834473);
    rslt(3,3) = static_cast<FP>(237.66372708706259293734980873905250932);
    rslt(3,4) = -static_cast<FP>(692.70685182191724741264279056989689958);
    rslt(3,5) = -static_cast<FP>(5745.1215307091268783415379186547145225);
    rslt(3,6) = static_cast<FP>(16745.024988243023964485031298096058995);
    rslt(3,7) = static_cast<FP>(51757.938352464070741577939930827240365);
    rslt(3,8) = -static_cast<FP>(150856.33374669039495219698189875665575);
    rslt(3,9) = -static_cast<FP>(197210.76375880384484027289543237392714);
    rslt(3,10) = static_cast<FP>(574800.57635683393282505400586905388871);
    rslt(3,11) = static_cast<FP>(270110.12933925028540257935469422426420);
    rslt(3,12) = -static_cast<FP>(787276.79496190258254290525348755246324);
    rslt(4,0) = static_cast<FP>(4.2580049909101497529516222070274293798e-36);
    rslt(4,1) = static_cast<FP>(3.8769583995066544318678764518318929527);
    rslt(4,2) = -static_cast<FP>(16.056655839987058176962520350220399909);
    rslt(4,3) = -static_cast<FP>(336.70406994278342245050669283802650624);
    rslt(4,4) = static_cast<FP>(1394.4801088611538682001251741030921387);
    rslt(4,5) = static_cast<FP>(6320.7871628757533010892007873463510266);
    rslt(4,6) = -static_cast<FP>(26177.919300093329192553396664964200707);
    rslt(4,7) = -static_cast<FP>(48256.003905792478244792726246118068261);
    rslt(4,8) = static_cast<FP>(199855.13567207188254239207691504842137);
    rslt(4,9) = static_cast<FP>(164553.00417113042524805339864666476546);
    rslt(4,10) = -static_cast<FP>(681506.14041874014436961349781589866899);
    rslt(4,11) = -static_cast<FP>(208420.09611163251833614181715907750867);
    rslt(4,12) = static_cast<FP>(863184.33383947488243757572344876288092);
    rslt(5,0) = -static_cast<FP>(4.5509441321145539586461201128763350717e-36);
    rslt(5,1) = -static_cast<FP>(7.8958479417656941909535823016630988207);
    rslt(5,2) = static_cast<FP>(63.347468223870998084652157229315044169);
    rslt(5,3) = static_cast<FP>(312.93882793538157096148553471372658230);
    rslt(5,4) = -static_cast<FP>(2510.6717612673451940041517830486910571);
    rslt(5,5) = -static_cast<FP>(4492.2185139509724969051699914081426501);
    rslt(5,6) = static_cast<FP>(36040.545824335827286500570764592922136);
    rslt(5,7) = static_cast<FP>(29933.394440860608246684951507460619745);
    rslt(5,8) = -static_cast<FP>(240152.13656089974428177523193357845902);
    rslt(5,9) = -static_cast<FP>(94143.186832890315604240210453686078604);
    rslt(5,10) = static_cast<FP>(755299.82091535077208946725827731666822);
    rslt(5,11) = static_cast<FP>(113113.42951156415895732866853568453701);
    rslt(5,12) = -static_cast<FP>(907495.86802130365855912280364831203910);
    rslt(6,0) = static_cast<FP>(1.0000000000000000000000000000000000045);
    rslt(6,1) = static_cast<FP>(7.2390174733101226031361709987623250016e-34);
    rslt(6,2) = -static_cast<FP>(103.99999999999999999999999999999999673);
    rslt(6,3) = -static_cast<FP>(1.3726350978054723591851637793959438338e-31);
    rslt(6,4) = static_cast<FP>(3119.9999999999999999999999999999996927);
    rslt(6,5) = static_cast<FP>(3.8486941414283851871784951214267306628e-30);
    rslt(6,6) = -static_cast<FP>(40411.428571428571428571428571428562722);
    rslt(6,7) = -static_cast<FP>(3.9505349094751517350432789150581933882e-29);
    rslt(6,8) = static_cast<FP>(255939.04761904761904761904761904752951);
    rslt(6,9) = static_cast<FP>(1.7281831614173320246076023513520773212e-28);
    rslt(6,10) = -static_cast<FP>(781777.45454545454545454545454545415637);
    rslt(6,11) = -static_cast<FP>(2.7209307142709541663672489655486742965e-28);
    rslt(6,12) = static_cast<FP>(922096.48484848484848484848484848424169);
    rslt(7,0) = -static_cast<FP>(4.1194725931108392871451224076809795818e-36);
    rslt(7,1) = static_cast<FP>(7.8958479417656941909535823016630975284);
    rslt(7,2) = static_cast<FP>(63.347468223870998084652157229315048188);
    rslt(7,3) = -static_cast<FP>(312.93882793538157096148553471372632789);
    rslt(7,4) = -static_cast<FP>(2510.6717612673451940041517830486912641);
    rslt(7,5) = static_cast<FP>(4492.2185139509724969051699914081354680);
    rslt(7,6) = static_cast<FP>(36040.545824335827286500570764592926521);
    rslt(7,7) = -static_cast<FP>(29933.394440860608246684951507460545794);
    rslt(7,8) = -static_cast<FP>(240152.13656089974428177523193357849920);
    rslt(7,9) = static_cast<FP>(94143.186832890315604240210453685754313);
    rslt(7,10) = static_cast<FP>(755299.82091535077208946725827731682668);
    rslt(7,11) = -static_cast<FP>(113113.42951156415895732866853568402531);
    rslt(7,12) = -static_cast<FP>(907495.86802130365855912280364831226112);
    rslt(8,0) = static_cast<FP>(3.5653018265989289550071926984978035015e-36);
    rslt(8,1) = -static_cast<FP>(3.8769583995066544318678764518318920532);
    rslt(8,2) = -static_cast<FP>(16.056655839987058176962520350220407297);
    rslt(8,3) = static_cast<FP>(336.70406994278342245050669283802630351);
    rslt(8,4) = static_cast<FP>(1394.4801088611538682001251741030925236);
    rslt(8,5) = -static_cast<FP>(6320.7871628757533010892007873463451677);
    rslt(8,6) = -static_cast<FP>(26177.919300093329192553396664964208756);
    rslt(8,7) = static_cast<FP>(48256.003905792478244792726246118007269);
    rslt(8,8) = static_cast<FP>(199855.13567207188254239207691504849432);
    rslt(8,9) = -static_cast<FP>(164553.00417113042524805339864666449566);
    rslt(8,10) = -static_cast<FP>(681506.14041874014436961349781589895454);
    rslt(8,11) = static_cast<FP>(208420.09611163251833614181715907707968);
    rslt(8,12) = static_cast<FP>(863184.33383947488243757572344876327898);
    rslt(9,0) = -static_cast<FP>(2.9424372910454767579139738737560917168e-36);
    rslt(9,1) = static_cast<FP>(2.4885001097304116062870469738868297059);
    rslt(9,2) = static_cast<FP>(7.2531096684281758676127848624894929706);
    rslt(9,3) = -static_cast<FP>(237.66372708706259293734980873905237063);
    rslt(9,4) = -static_cast<FP>(692.70685182191724741264279056989739841);
    rslt(9,5) = static_cast<FP>(5745.1215307091268783415379186547103537);
    rslt(9,6) = static_cast<FP>(16745.024988243023964485031298096069138);
    rslt(9,7) = -static_cast<FP>(51757.938352464070741577939930827196223);
    rslt(9,8) = -static_cast<FP>(150856.33374669039495219698189875674536);
    rslt(9,9) = static_cast<FP>(197210.76375880384484027289543237372918);
    rslt(9,10) = static_cast<FP>(574800.57635683393282505400586905423268);
    rslt(9,11) = -static_cast<FP>(270110.12933925028540257935469422394546);
    rslt(9,12) = -static_cast<FP>(787276.79496190258254290525348755293507);
    rslt(10,0) = static_cast<FP>(2.3141168838446355339615731821426076260e-36);
    rslt(10,1) = -static_cast<FP>(1.7297302590181839104226768862848387470);
    rslt(10,2) = -static_cast<FP>(4.0875175430549573718912516244649899779);
    rslt(10,3) = static_cast<FP>(170.23275321235291062446360591172604313);
    rslt(10,4) = static_cast<FP>(402.27622863752117335437793325479925679);
    rslt(10,5) = -static_cast<FP>(4446.1413202196929201884870804186181651);
    rslt(10,6) = -static_cast<FP>(10506.655908080793756574552654868962792);
    rslt(10,7) = static_cast<FP>(45072.641021595807959779028603466364173);
    rslt(10,8) = static_cast<FP>(106510.94870258299345352346068101072976);
    rslt(10,9) = -static_cast<FP>(191009.98683723115256490234522319113536);
    rslt(10,10) = -static_cast<FP>(451374.81293704480969665734068568346573);
    rslt(10,11) = static_cast<FP>(285622.39446032430499961823440224808417);
    rslt(10,12) = static_cast<FP>(674952.95405690499992112125250839934405);
    rslt(11,0) = -static_cast<FP>(1.6562609842955257353165619981876264734e-36);
    rslt(11,1) = static_cast<FP>(1.1658689812443045795720307586851806894);
    rslt(11,2) = static_cast<FP>(2.4459392407428415965888298828808564259);
    rslt(11,3) = -static_cast<FP>(116.11890656408135776495235492493031390);
    rslt(11,4) = -static_cast<FP>(243.61209940941260013770853373930306958);
    rslt(11,5) = static_cast<FP>(3126.4242957204002560289868958771202253);
    rslt(11,6) = static_cast<FP>(6559.0936813095574124280615428584590893);
    rslt(11,7) = -static_cast<FP>(33353.755651485790628717195220286878298);
    rslt(11,8) = -static_cast<FP>(69974.637876588546285752847573247758422);
    rslt(11,9) = static_cast<FP>(151587.84039745233544318079335474607544);
    rslt(11,10) = static_cast<FP>(318024.28335632752187902230162793848569);
    rslt(11,11) = -static_cast<FP>(244249.83584853164840075716786664140739);
    rslt(11,12) = -static_cast<FP>(512424.86733741606549909316124553959994);
    rslt(12,0) = static_cast<FP>(6.5536392931671972072082188568508129893e-37);
    rslt(12,1) = -static_cast<FP>(0.45117187500000000000000000000000026629);
    rslt(12,2) = -static_cast<FP>(0.90234375000000000000000000000000142665);
    rslt(12,3) = static_cast<FP>(45.117187500000000000000000000000011202);
    rslt(12,4) = static_cast<FP>(90.234375000000000000000000000000079245);
    rslt(12,5) = -static_cast<FP>(1227.1875000000000000000000000000001660);
    rslt(12,6) = -static_cast<FP>(2454.3750000000000000000000000000012820);
    rslt(12,7) = static_cast<FP>(13323.750000000000000000000000000000934);
    rslt(12,8) = static_cast<FP>(26647.500000000000000000000000000009009);
    rslt(12,9) = -static_cast<FP>(62177.500000000000000000000000000000677);
    rslt(12,10) = -static_cast<FP>(124355.00000000000000000000000000002623);
    rslt(12,11) = static_cast<FP>(104005.99999999999999999999999999999552);
    rslt(12,12) = static_cast<FP>(208012.00000000000000000000000000002362);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,11) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,12) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(1,2) = -static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(1,3) = -static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(1,4) = -static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(1,5) = -static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(1,6) = 0;
    rslt(1,7) = static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(1,8) = static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(1,9) = static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(1,10) = static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(1,11) = static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(1,12) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22719991592622651908169188067697197017);
    rslt(2,2) = static_cast<FP>(0.17907605004803879781549050546066293634);
    rslt(2,3) = static_cast<FP>(0.11771365377519149176479467316248463529);
    rslt(2,4) = static_cast<FP>(0.058300473826616584670302248834312701940);
    rslt(2,5) = static_cast<FP>(0.015535993380448345798155474474263408439);
    rslt(2,6) = 0;
    rslt(2,7) = static_cast<FP>(0.015535993380448345798155474474263408439);
    rslt(2,8) = static_cast<FP>(0.058300473826616584670302248834312701940);
    rslt(2,9) = static_cast<FP>(0.11771365377519149176479467316248463529);
    rslt(2,10) = static_cast<FP>(0.17907605004803879781549050546066293634);
    rslt(2,11) = static_cast<FP>(0.22719991592622651908169188067697197017);
    rslt(2,12) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10829595850437176853035870166962054041);
    rslt(3,2) = -static_cast<FP>(0.075780289422817219574321205253147523592);
    rslt(3,3) = -static_cast<FP>(0.040386875937009342631095068146519983236);
    rslt(3,4) = -static_cast<FP>(0.014076935692575771889068444583815547937);
    rslt(3,5) = -static_cast<FP>(0.0019364600479814169844431869765204083476);
    rslt(3,6) = 0;
    rslt(3,7) = static_cast<FP>(0.0019364600479814169844431869765204083476);
    rslt(3,8) = static_cast<FP>(0.014076935692575771889068444583815547937);
    rslt(3,9) = static_cast<FP>(0.040386875937009342631095068146519983236);
    rslt(3,10) = static_cast<FP>(0.075780289422817219574321205253147523592);
    rslt(3,11) = static_cast<FP>(0.10829595850437176853035870166962054041);
    rslt(3,12) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.051619801796884398670108111342184081708);
    rslt(4,2) = static_cast<FP>(0.032068231700807696321401063156355473401);
    rslt(4,3) = static_cast<FP>(0.013856504285105654141228644450321985532);
    rslt(4,4) = static_cast<FP>(0.0033989452484080054351413183720032251132);
    rslt(4,5) = static_cast<FP>(0.00024136709031733481910438954924055425724);
    rslt(4,6) = 0;
    rslt(4,7) = static_cast<FP>(0.00024136709031733481910438954924055425724);
    rslt(4,8) = static_cast<FP>(0.0033989452484080054351413183720032251132);
    rslt(4,9) = static_cast<FP>(0.013856504285105654141228644450321985532);
    rslt(4,10) = static_cast<FP>(0.032068231700807696321401063156355473401);
    rslt(4,11) = static_cast<FP>(0.051619801796884398670108111342184081708);
    rslt(4,12) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.024604832667343381614616781906533477314);
    rslt(5,2) = -static_cast<FP>(0.013570434901335281555334192972576694939);
    rslt(5,3) = -static_cast<FP>(0.0047540867311107302215647938392381309058);
    rslt(5,4) = -static_cast<FP>(0.00082069202090397859429325422014526225387);
    rslt(5,5) = -static_cast<FP>(0.000030084830486941980359137332648276219260);
    rslt(5,6) = 0;
    rslt(5,7) = static_cast<FP>(0.000030084830486941980359137332648276219260);
    rslt(5,8) = static_cast<FP>(0.00082069202090397859429325422014526225387);
    rslt(5,9) = static_cast<FP>(0.0047540867311107302215647938392381309058);
    rslt(5,10) = static_cast<FP>(0.013570434901335281555334192972576694939);
    rslt(5,11) = static_cast<FP>(0.024604832667343381614616781906533477314);
    rslt(5,12) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011728014628380611976689776252337248193);
    rslt(6,2) = static_cast<FP>(0.0057426522650059433658114369943834259605);
    rslt(6,3) = static_cast<FP>(0.0016310997479513842673349234386568819810);
    rslt(6,4) = static_cast<FP>(0.00019816011849291372657568721765391578987);
    rslt(6,5) = static_cast<FP>(3.7498775174281917696060835401185543983e-6);
    rslt(6,6) = 0;
    rslt(6,7) = static_cast<FP>(3.7498775174281917696060835401185543983e-6);
    rslt(6,8) = static_cast<FP>(0.00019816011849291372657568721765391578987);
    rslt(6,9) = static_cast<FP>(0.0016310997479513842673349234386568819810);
    rslt(6,10) = static_cast<FP>(0.0057426522650059433658114369943834259605);
    rslt(6,11) = static_cast<FP>(0.011728014628380611976689776252337248193);
    rslt(6,12) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0055902159133992880927144559916705229108);
    rslt(7,2) = -static_cast<FP>(0.0024301398795651693250606251440522667341);
    rslt(7,3) = -static_cast<FP>(0.00055962091948320038694683451326812391038);
    rslt(7,4) = -static_cast<FP>(0.000047846733684425475014986906579840237129);
    rslt(7,5) = -static_cast<FP>(4.6739772729704119064068777650155603134e-7);
    rslt(7,6) = 0;
    rslt(7,7) = static_cast<FP>(4.6739772729704119064068777650155603134e-7);
    rslt(7,8) = static_cast<FP>(0.000047846733684425475014986906579840237129);
    rslt(7,9) = static_cast<FP>(0.00055962091948320038694683451326812391038);
    rslt(7,10) = static_cast<FP>(0.0024301398795651693250606251440522667341);
    rslt(7,11) = static_cast<FP>(0.0055902159133992880927144559916705229108);
    rslt(7,12) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0026646039375496297937360355557585726590);
    rslt(8,2) = static_cast<FP>(0.0010283714844166876755565062971962861067);
    rslt(8,3) = static_cast<FP>(0.00019200271100315135534633657677881488665);
    rslt(8,4) = static_cast<FP>(0.000011552828801675357774029981013055773031);
    rslt(8,5) = static_cast<FP>(5.8258072288256463786507210869224220550e-8);
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(5.8258072288256463786507210869224220550e-8);
    rslt(8,8) = static_cast<FP>(0.000011552828801675357774029981013055773031);
    rslt(8,9) = static_cast<FP>(0.00019200271100315135534633657677881488665);
    rslt(8,10) = static_cast<FP>(0.0010283714844166876755565062971962861067);
    rslt(8,11) = static_cast<FP>(0.0026646039375496297937360355557585726590);
    rslt(8,12) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0012700965855337718421081398391277678630);
    rslt(9,2) = -static_cast<FP>(0.00043517985069674723865081437753148979020);
    rslt(9,3) = -static_cast<FP>(0.000065875023161399765075493562963404787946);
    rslt(9,4) = -static_cast<FP>(2.7894872448579415124727120899241797611e-6);
    rslt(9,5) = -static_cast<FP>(7.2614879973234330384820899859551827818e-9);
    rslt(9,6) = 0;
    rslt(9,7) = static_cast<FP>(7.2614879973234330384820899859551827818e-9);
    rslt(9,8) = static_cast<FP>(2.7894872448579415124727120899241797611e-6);
    rslt(9,9) = static_cast<FP>(0.000065875023161399765075493562963404787946);
    rslt(9,10) = static_cast<FP>(0.00043517985069674723865081437753148979020);
    rslt(9,11) = static_cast<FP>(0.0012700965855337718421081398391277678630);
    rslt(9,12) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00060539779058796802722625831121383571480);
    rslt(10,2) = static_cast<FP>(0.00018415670341137871284144980378879474931);
    rslt(10,3) = static_cast<FP>(0.000022601340646923108515136014077712878912);
    rslt(10,4) = static_cast<FP>(6.7353539317545643799175985554948785642e-7);
    rslt(10,5) = static_cast<FP>(9.0509702542803363504846343483216753128e-10);
    rslt(10,6) = 0;
    rslt(10,7) = static_cast<FP>(9.0509702542803363504846343483216753128e-10);
    rslt(10,8) = static_cast<FP>(6.7353539317545643799175985554948785642e-7);
    rslt(10,9) = static_cast<FP>(0.000022601340646923108515136014077712878912);
    rslt(10,10) = static_cast<FP>(0.00018415670341137871284144980378879474931);
    rslt(10,11) = static_cast<FP>(0.00060539779058796802722625831121383571480);
    rslt(10,12) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00028856583745146033147285062122763693047);
    rslt(11,2) = -static_cast<FP>(0.000077930288723268760206991553580391203373);
    rslt(11,3) = -static_cast<FP>(7.7543896688537324149040524186233042073e-6);
    rslt(11,4) = -static_cast<FP>(1.6262842810852122730933726607029415195e-7);
    rslt(11,5) = -static_cast<FP>(1.1281442945862197103668740774885574140e-10);
    rslt(11,6) = 0;
    rslt(11,7) = static_cast<FP>(1.1281442945862197103668740774885574140e-10);
    rslt(11,8) = static_cast<FP>(1.6262842810852122730933726607029415195e-7);
    rslt(11,9) = static_cast<FP>(7.7543896688537324149040524186233042073e-6);
    rslt(11,10) = static_cast<FP>(0.000077930288723268760206991553580391203373);
    rslt(11,11) = static_cast<FP>(0.00028856583745146033147285062122763693047);
    rslt(11,12) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00013754632712350962404456424728771623077);
    rslt(12,2) = static_cast<FP>(0.000032978055036777891591277579760998715299);
    rslt(12,3) = static_cast<FP>(2.6604863877670692854046799942476295075e-6);
    rslt(12,4) = static_cast<FP>(3.9267432561125608687079771809514611424e-8);
    rslt(12,5) = static_cast<FP>(1.4061581395713418668803941418587058633e-11);
    rslt(12,6) = 0;
    rslt(12,7) = static_cast<FP>(1.4061581395713418668803941418587058633e-11);
    rslt(12,8) = static_cast<FP>(3.9267432561125608687079771809514611424e-8);
    rslt(12,9) = static_cast<FP>(2.6604863877670692854046799942476295075e-6);
    rslt(12,10) = static_cast<FP>(0.000032978055036777891591277579760998715299);
    rslt(12,11) = static_cast<FP>(0.00013754632712350962404456424728771623077);
    rslt(12,12) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(0,8) = 0;
    rslt(0,9) = 0;
    rslt(0,10) = 0;
    rslt(0,11) = 0;
    rslt(0,12) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(1,8) = 0;
    rslt(1,9) = 0;
    rslt(1,10) = 0;
    rslt(1,11) = 0;
    rslt(1,12) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(2,8) = 0;
    rslt(2,9) = 0;
    rslt(2,10) = 0;
    rslt(2,11) = 0;
    rslt(2,12) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(3,8) = 0;
    rslt(3,9) = 0;
    rslt(3,10) = 0;
    rslt(3,11) = 0;
    rslt(3,12) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(4,8) = 0;
    rslt(4,9) = 0;
    rslt(4,10) = 0;
    rslt(4,11) = 0;
    rslt(4,12) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(5,8) = 0;
    rslt(5,9) = 0;
    rslt(5,10) = 0;
    rslt(5,11) = 0;
    rslt(5,12) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(6,8) = 0;
    rslt(6,9) = 0;
    rslt(6,10) = 0;
    rslt(6,11) = 0;
    rslt(6,12) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
    rslt(7,8) = 0;
    rslt(7,9) = 0;
    rslt(7,10) = 0;
    rslt(7,11) = 0;
    rslt(7,12) = 0;
    rslt(8,0) = 0;
    rslt(8,1) = 0;
    rslt(8,2) = 0;
    rslt(8,3) = 0;
    rslt(8,4) = 0;
    rslt(8,5) = 0;
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(8.0000000000000000000000000000000000000);
    rslt(8,8) = 0;
    rslt(8,9) = 0;
    rslt(8,10) = 0;
    rslt(8,11) = 0;
    rslt(8,12) = 0;
    rslt(9,0) = 0;
    rslt(9,1) = 0;
    rslt(9,2) = 0;
    rslt(9,3) = 0;
    rslt(9,4) = 0;
    rslt(9,5) = 0;
    rslt(9,6) = 0;
    rslt(9,7) = 0;
    rslt(9,8) = static_cast<FP>(9.0000000000000000000000000000000000000);
    rslt(9,9) = 0;
    rslt(9,10) = 0;
    rslt(9,11) = 0;
    rslt(9,12) = 0;
    rslt(10,0) = 0;
    rslt(10,1) = 0;
    rslt(10,2) = 0;
    rslt(10,3) = 0;
    rslt(10,4) = 0;
    rslt(10,5) = 0;
    rslt(10,6) = 0;
    rslt(10,7) = 0;
    rslt(10,8) = 0;
    rslt(10,9) = static_cast<FP>(10.000000000000000000000000000000000000);
    rslt(10,10) = 0;
    rslt(10,11) = 0;
    rslt(10,12) = 0;
    rslt(11,0) = 0;
    rslt(11,1) = 0;
    rslt(11,2) = 0;
    rslt(11,3) = 0;
    rslt(11,4) = 0;
    rslt(11,5) = 0;
    rslt(11,6) = 0;
    rslt(11,7) = 0;
    rslt(11,8) = 0;
    rslt(11,9) = 0;
    rslt(11,10) = static_cast<FP>(11.000000000000000000000000000000000000);
    rslt(11,11) = 0;
    rslt(11,12) = 0;
    rslt(12,0) = 0;
    rslt(12,1) = 0;
    rslt(12,2) = 0;
    rslt(12,3) = 0;
    rslt(12,4) = 0;
    rslt(12,5) = 0;
    rslt(12,6) = 0;
    rslt(12,7) = 0;
    rslt(12,8) = 0;
    rslt(12,9) = 0;
    rslt(12,10) = 0;
    rslt(12,11) = static_cast<FP>(12.000000000000000000000000000000000000);
    rslt(12,12) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,13> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(1.4307515636161134178321678321678321678e13)*(a(10)*a(10))+static_cast<FP>(0.0019531250000000000000000000000000000000)*a(1)*a(11)+static_cast<FP>(1.7312093919754972355769230769230769231e15)*(a(11)*a(11))+static_cast<FP>(1.5225636467244807692307692307692307692e14)*a(10)*a(12)+static_cast<FP>(2.4929415244447160192307692307692307692e17)*(a(12)*a(12))+static_cast<FP>(0.15980113636363636363636363636363636364)*a(10)*a(2)+static_cast<FP>(0.047776442307692307692307692307692307692)*a(12)*a(2)+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(5.2746769831730769230769230769230769231)*a(11)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(555.19326376748251748251748251748251748)*a(10)*a(4)+static_cast<FP>(253.18449519230769230769230769230769231)*a(12)*a(4)+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(30535.629507211538461538461538461538462)*a(11)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.903707837301587301587301587301587)*(a(5)*a(5))+static_cast<FP>(2.8203904423213505244755244755244755245e6)*a(10)*a(6)+static_cast<FP>(2.1985653245192307692307692307692307692e6)*a(12)*a(6)+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6279761904761904761904761904761905)*a(4)*a(6)+static_cast<FP>(563252.53667816558441558441558441558442)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(2.1717006405874399038461538461538461538e8)*a(11)*a(7)+static_cast<FP>(32.643229166666666666666666666666666667)*a(3)*a(7)+static_cast<FP>(52976.985381155303030303030303030303030)*a(5)*a(7)+static_cast<FP>(2.7599374298150335992132867132867132867e7)*(a(7)*a(7))+static_cast<FP>(1.2816192312495629370629370629370629371e10)*a(10)*a(8)+static_cast<FP>(2.0848326149639423076923076923076923077e10)*a(12)*a(8)+static_cast<FP>(0.51388888888888888888888888888888888889)*a(2)*a(8)+static_cast<FP>(1044.5890151515151515151515151515151515)*a(4)*a(8)+static_cast<FP>(2.5428953000983391608391608391608391608e6)*a(6)*a(8)+static_cast<FP>(1.7663599550816215034965034965034965035e9)*(a(8)*a(8))+static_cast<FP>(0.0078125000000000000000000000000000000000)*a(1)*a(9)+static_cast<FP>(1.2688030389370673076923076923076923077e12)*a(11)*a(9)+static_cast<FP>(13.879794034090909090909090909090909091)*a(3)*a(9)+static_cast<FP>(47006.507372022508741258741258741258741)*a(5)*a(9)+static_cast<FP>(1.6020240390619536713286713286713286713e8)*a(7)*a(9)+static_cast<FP>(1.4307515636161134178321678321678321678e11)*(a(9)*a(9));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
    rslt(8,0) = 0;
    rslt(9,0) = 0;
    rslt(10,0) = 0;
    rslt(11,0) = 0;
    rslt(12,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = 0;
    rslt(8,2) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = 0;
    rslt(9,2) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = 0;
    rslt(10,2) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = 0;
    rslt(11,2) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = 0;
    rslt(12,2) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,2) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,3) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,2) = static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,3) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,2) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,3) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(6.9877124296868428012786677147852382358e-8);
    rslt(11,2) = static_cast<FP>(6.9877124296868428012786677147852382358e-8);
    rslt(11,3) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(1.5625000000000000000000000000000000000e-8);
    rslt(12,2) = static_cast<FP>(1.5625000000000000000000000000000000000e-8);
    rslt(12,3) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,2) = 0;
    rslt(8,3) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,4) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,2) = 0;
    rslt(9,3) = static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,4) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,2) = 0;
    rslt(10,3) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,4) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(4.6216571889118944447610029857579623051e-6);
    rslt(11,2) = 0;
    rslt(11,3) = static_cast<FP>(4.6216571889118944447610029857579623051e-6);
    rslt(11,4) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(1.5127924217375413305680456272471504220e-6);
    rslt(12,2) = 0;
    rslt(12,3) = static_cast<FP>(1.5127924217375413305680456272471504220e-6);
    rslt(12,4) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,2) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,3) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,4) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,5) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,2) = -static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,3) = static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,4) = static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,5) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,2) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,3) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,4) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,5) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.000025662047611759319872168488557990018377);
    rslt(11,2) = -static_cast<FP>(4.9641245331952598910822957947075443294e-10);
    rslt(11,3) = static_cast<FP>(4.9641245331952598910822957947075443294e-10);
    rslt(11,4) = static_cast<FP>(0.000025662047611759319872168488557990018377);
    rslt(11,5) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(9.8164430741539361322269361913813667960e-6);
    rslt(12,2) = static_cast<FP>(7.0796238430102920856023682201253147326e-11);
    rslt(12,3) = static_cast<FP>(7.0796238430102920856023682201253147326e-11);
    rslt(12,4) = static_cast<FP>(9.8164430741539361322269361913813667960e-6);
    rslt(12,5) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,2) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,3) = 0;
    rslt(8,4) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,5) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,6) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,2) = -static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,3) = 0;
    rslt(9,4) = static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,5) = static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,6) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,2) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,3) = 0;
    rslt(10,4) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,5) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,6) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.000063069236286896470595441580170224364906);
    rslt(11,2) = -static_cast<FP>(1.1749810917033255258466387744112512666e-7);
    rslt(11,3) = 0;
    rslt(11,4) = static_cast<FP>(1.1749810917033255258466387744112512666e-7);
    rslt(11,5) = static_cast<FP>(0.000063069236286896470595441580170224364906);
    rslt(11,6) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000026180793542710382544105733518265248728);
    rslt(12,2) = static_cast<FP>(2.7544423359800339384735768007851243853e-8);
    rslt(12,3) = 0;
    rslt(12,4) = static_cast<FP>(2.7544423359800339384735768007851243853e-8);
    rslt(12,5) = static_cast<FP>(0.000026180793542710382544105733518265248728);
    rslt(12,6) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,2) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,3) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,4) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,5) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,6) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,7) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,2) = -static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,3) = -static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,4) = static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,5) = static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,6) = static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,7) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,2) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,3) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,4) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,5) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,6) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,7) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00010787668124300126397927360604952024349);
    rslt(11,2) = -static_cast<FP>(1.5198081692351406103597017693483156022e-6);
    rslt(11,3) = -static_cast<FP>(1.6485939742838283094248615477799067381e-11);
    rslt(11,4) = static_cast<FP>(1.6485939742838283094248615477799067381e-11);
    rslt(11,5) = static_cast<FP>(1.5198081692351406103597017693483156022e-6);
    rslt(11,6) = static_cast<FP>(0.00010787668124300126397927360604952024349);
    rslt(11,7) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000047020217063748708113780718833652475873);
    rslt(12,2) = static_cast<FP>(4.4963538474000226997541449270752962791e-7);
    rslt(12,3) = static_cast<FP>(1.7252471472817231294777572668735363922e-12);
    rslt(12,4) = static_cast<FP>(1.7252471472817231294777572668735363922e-12);
    rslt(12,5) = static_cast<FP>(4.4963538474000226997541449270752962791e-7);
    rslt(12,6) = static_cast<FP>(0.000047020217063748708113780718833652475873);
    rslt(12,7) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,9> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,2) = -static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,3) = -static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,4) = 0;
    rslt(9,5) = static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,6) = static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,7) = static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,8) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,2) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,3) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,4) = 0;
    rslt(10,5) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,6) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,7) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,8) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00015277521651054650078862987348271507340);
    rslt(11,2) = -static_cast<FP>(6.7059405768591642644510312885922379995e-6);
    rslt(11,3) = -static_cast<FP>(7.0662426792541675057534239160018861021e-9);
    rslt(11,4) = 0;
    rslt(11,5) = static_cast<FP>(7.0662426792541675057534239160018861021e-9);
    rslt(11,6) = static_cast<FP>(6.7059405768591642644510312885922379995e-6);
    rslt(11,7) = static_cast<FP>(0.00015277521651054650078862987348271507340);
    rslt(11,8) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000068730361278040565261350300737126400318);
    rslt(12,2) = static_cast<FP>(2.2705854749316739901300101940399910608e-6);
    rslt(12,3) = static_cast<FP>(1.2829380602355357013078803609731331931e-9);
    rslt(12,4) = 0;
    rslt(12,5) = static_cast<FP>(1.2829380602355357013078803609731331931e-9);
    rslt(12,6) = static_cast<FP>(2.2705854749316739901300101940399910608e-6);
    rslt(12,7) = static_cast<FP>(0.000068730361278040565261350300737126400318);
    rslt(12,8) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,10> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,9) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,2) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,3) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,4) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,5) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,6) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,7) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,8) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,9) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,2) = -static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,3) = -static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,4) = -static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,5) = static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,6) = static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,7) = static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,8) = static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,9) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,2) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,3) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,4) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,5) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,6) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,7) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,8) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,9) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,2) = -static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,3) = -static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,4) = -static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,5) = static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,6) = static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,7) = static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,8) = static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,9) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,2) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,3) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,4) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,5) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,6) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,7) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,8) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,9) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,2) = -static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,3) = -static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,4) = -static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,5) = static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,6) = static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,7) = static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,8) = static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,9) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,2) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,3) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,4) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,5) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,6) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,7) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,8) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,9) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,2) = -static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,3) = -static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,4) = -static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,5) = static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,6) = static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,7) = static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,8) = static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,9) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,2) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,3) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,4) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,5) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,6) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,7) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,8) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,9) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00019405073086810396184968532568139273581);
    rslt(11,2) = -static_cast<FP>(0.000017470156896397291370538034589054196169);
    rslt(11,3) = -static_cast<FP>(1.4508642616547837790136366505971039866e-7);
    rslt(11,4) = -static_cast<FP>(1.2276180518450530653058495612202153539e-12);
    rslt(11,5) = static_cast<FP>(1.2276180518450530653058495612202153539e-12);
    rslt(11,6) = static_cast<FP>(1.4508642616547837790136366505971039866e-7);
    rslt(11,7) = static_cast<FP>(0.000017470156896397291370538034589054196169);
    rslt(11,8) = static_cast<FP>(0.00019405073086810396184968532568139273581);
    rslt(11,9) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000089218113468852661536433044908588285593);
    rslt(12,2) = static_cast<FP>(6.4532476671755108675069798804268054793e-6);
    rslt(12,3) = static_cast<FP>(3.4670211471656507400037699169905996412e-8);
    rslt(12,4) = static_cast<FP>(1.0144971601069551859493250595053282653e-13);
    rslt(12,5) = static_cast<FP>(1.0144971601069551859493250595053282653e-13);
    rslt(12,6) = static_cast<FP>(3.4670211471656507400037699169905996412e-8);
    rslt(12,7) = static_cast<FP>(6.4532476671755108675069798804268054793e-6);
    rslt(12,8) = static_cast<FP>(0.000089218113468852661536433044908588285593);
    rslt(12,9) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,11> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,2) = -static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,3) = -static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,4) = -static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,5) = 0;
    rslt(1,6) = static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,7) = static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,8) = static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,9) = static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,10) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,2) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,3) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,4) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,5) = 0;
    rslt(2,6) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,7) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,8) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,9) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,10) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,2) = -static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,3) = -static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,4) = -static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,5) = 0;
    rslt(3,6) = static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,7) = static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,8) = static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,9) = static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,10) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,2) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,3) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,4) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,5) = 0;
    rslt(4,6) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,7) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,8) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,9) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,10) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,2) = -static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,3) = -static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,4) = -static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,5) = 0;
    rslt(5,6) = static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,7) = static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,8) = static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,9) = static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,10) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,2) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,3) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,4) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,5) = 0;
    rslt(6,6) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,7) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,8) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,9) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,10) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,2) = -static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,3) = -static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,4) = -static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,7) = static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,8) = static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,9) = static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,10) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,2) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,3) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,4) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,5) = 0;
    rslt(8,6) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,7) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,8) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,9) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,10) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,2) = -static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,3) = -static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,4) = -static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,5) = 0;
    rslt(9,6) = static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,7) = static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,8) = static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,9) = static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,10) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,2) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,3) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,4) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,5) = 0;
    rslt(10,6) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,7) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,8) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,9) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,10) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00023040558520137412340666889867251922255);
    rslt(11,2) = -static_cast<FP>(0.000033813633110299807995230095325375638610);
    rslt(11,3) = -static_cast<FP>(9.1873934966831984945070471729444686924e-7);
    rslt(11,4) = -static_cast<FP>(7.3956056580315310032155370144097310613e-10);
    rslt(11,5) = 0;
    rslt(11,6) = static_cast<FP>(7.3956056580315310032155370144097310613e-10);
    rslt(11,7) = static_cast<FP>(9.1873934966831984945070471729444686924e-7);
    rslt(11,8) = static_cast<FP>(0.000033813633110299807995230095325375638610);
    rslt(11,9) = static_cast<FP>(0.00023040558520137412340666889867251922255);
    rslt(11,10) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00010759957307604468643470949003962600676);
    rslt(12,2) = static_cast<FP>(0.000013263118179769553758886388134342905232);
    rslt(12,3) = static_cast<FP>(2.5965196836702675087899890323841145346e-7);
    rslt(12,4) = static_cast<FP>(1.0936552704778128324505672722338879356e-10);
    rslt(12,5) = 0;
    rslt(12,6) = static_cast<FP>(1.0936552704778128324505672722338879356e-10);
    rslt(12,7) = static_cast<FP>(2.5965196836702675087899890323841145346e-7);
    rslt(12,8) = static_cast<FP>(0.000013263118179769553758886388134342905232);
    rslt(12,9) = static_cast<FP>(0.00010759957307604468643470949003962600676);
    rslt(12,10) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,12> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(0,11) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,2) = -static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,3) = -static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,4) = -static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,5) = -static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,6) = static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,7) = static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,8) = static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,9) = static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,10) = static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,11) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,2) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,3) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,4) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,5) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,6) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,7) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,8) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,9) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,10) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,11) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,2) = -static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,3) = -static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,4) = -static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,5) = -static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,6) = static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,7) = static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,8) = static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,9) = static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,10) = static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,11) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,2) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,3) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,4) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,5) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,6) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,7) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,8) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,9) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,10) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,11) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,2) = -static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,3) = -static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,4) = -static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,5) = -static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,6) = static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,7) = static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,8) = static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,9) = static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,10) = static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,11) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,2) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,3) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,4) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,5) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,6) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,7) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,8) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,9) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,10) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,11) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,2) = -static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,3) = -static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,4) = -static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,5) = -static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,6) = static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,7) = static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,8) = static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,9) = static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,10) = static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,11) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,2) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,3) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,4) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,5) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,6) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,7) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,8) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,9) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,10) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,11) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,2) = -static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,3) = -static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,4) = -static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,5) = -static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,6) = static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,7) = static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,8) = static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,9) = static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,10) = static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,11) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,2) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,3) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,4) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,5) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,6) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,7) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,8) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,9) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,10) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,11) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,2) = -static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,3) = -static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,4) = -static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,5) = -static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,6) = static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,7) = static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,8) = static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,9) = static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,10) = static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,11) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00012367053111091872272436271870282981359);
    rslt(12,2) = static_cast<FP>(0.000022326671089096174968034710487378120864);
    rslt(12,3) = static_cast<FP>(1.0080099792617534911506900107577773063e-6);
    rslt(12,4) = static_cast<FP>(4.0387323162555606337462283070340123000e-9);
    rslt(12,5) = static_cast<FP>(1.0262482727059215256710166442454665581e-14);
    rslt(12,6) = static_cast<FP>(1.0262482727059215256710166442454665581e-14);
    rslt(12,7) = static_cast<FP>(4.0387323162555606337462283070340123000e-9);
    rslt(12,8) = static_cast<FP>(1.0080099792617534911506900107577773063e-6);
    rslt(12,9) = static_cast<FP>(0.000022326671089096174968034710487378120864);
    rslt(12,10) = static_cast<FP>(0.00012367053111091872272436271870282981359);
    rslt(12,11) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(0,11) = 1;
    rslt(0,12) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(1,2) = -static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(1,3) = -static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(1,4) = -static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(1,5) = -static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(1,6) = 0;
    rslt(1,7) = static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(1,8) = static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(1,9) = static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(1,10) = static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(1,11) = static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(1,12) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22719991592622651908169188067697197017);
    rslt(2,2) = static_cast<FP>(0.17907605004803879781549050546066293634);
    rslt(2,3) = static_cast<FP>(0.11771365377519149176479467316248463529);
    rslt(2,4) = static_cast<FP>(0.058300473826616584670302248834312701940);
    rslt(2,5) = static_cast<FP>(0.015535993380448345798155474474263408439);
    rslt(2,6) = 0;
    rslt(2,7) = static_cast<FP>(0.015535993380448345798155474474263408439);
    rslt(2,8) = static_cast<FP>(0.058300473826616584670302248834312701940);
    rslt(2,9) = static_cast<FP>(0.11771365377519149176479467316248463529);
    rslt(2,10) = static_cast<FP>(0.17907605004803879781549050546066293634);
    rslt(2,11) = static_cast<FP>(0.22719991592622651908169188067697197017);
    rslt(2,12) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10829595850437176853035870166962054041);
    rslt(3,2) = -static_cast<FP>(0.075780289422817219574321205253147523592);
    rslt(3,3) = -static_cast<FP>(0.040386875937009342631095068146519983236);
    rslt(3,4) = -static_cast<FP>(0.014076935692575771889068444583815547937);
    rslt(3,5) = -static_cast<FP>(0.0019364600479814169844431869765204083476);
    rslt(3,6) = 0;
    rslt(3,7) = static_cast<FP>(0.0019364600479814169844431869765204083476);
    rslt(3,8) = static_cast<FP>(0.014076935692575771889068444583815547937);
    rslt(3,9) = static_cast<FP>(0.040386875937009342631095068146519983236);
    rslt(3,10) = static_cast<FP>(0.075780289422817219574321205253147523592);
    rslt(3,11) = static_cast<FP>(0.10829595850437176853035870166962054041);
    rslt(3,12) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.051619801796884398670108111342184081708);
    rslt(4,2) = static_cast<FP>(0.032068231700807696321401063156355473401);
    rslt(4,3) = static_cast<FP>(0.013856504285105654141228644450321985532);
    rslt(4,4) = static_cast<FP>(0.0033989452484080054351413183720032251132);
    rslt(4,5) = static_cast<FP>(0.00024136709031733481910438954924055425724);
    rslt(4,6) = 0;
    rslt(4,7) = static_cast<FP>(0.00024136709031733481910438954924055425724);
    rslt(4,8) = static_cast<FP>(0.0033989452484080054351413183720032251132);
    rslt(4,9) = static_cast<FP>(0.013856504285105654141228644450321985532);
    rslt(4,10) = static_cast<FP>(0.032068231700807696321401063156355473401);
    rslt(4,11) = static_cast<FP>(0.051619801796884398670108111342184081708);
    rslt(4,12) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.024604832667343381614616781906533477314);
    rslt(5,2) = -static_cast<FP>(0.013570434901335281555334192972576694939);
    rslt(5,3) = -static_cast<FP>(0.0047540867311107302215647938392381309058);
    rslt(5,4) = -static_cast<FP>(0.00082069202090397859429325422014526225387);
    rslt(5,5) = -static_cast<FP>(0.000030084830486941980359137332648276219260);
    rslt(5,6) = 0;
    rslt(5,7) = static_cast<FP>(0.000030084830486941980359137332648276219260);
    rslt(5,8) = static_cast<FP>(0.00082069202090397859429325422014526225387);
    rslt(5,9) = static_cast<FP>(0.0047540867311107302215647938392381309058);
    rslt(5,10) = static_cast<FP>(0.013570434901335281555334192972576694939);
    rslt(5,11) = static_cast<FP>(0.024604832667343381614616781906533477314);
    rslt(5,12) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011728014628380611976689776252337248193);
    rslt(6,2) = static_cast<FP>(0.0057426522650059433658114369943834259605);
    rslt(6,3) = static_cast<FP>(0.0016310997479513842673349234386568819810);
    rslt(6,4) = static_cast<FP>(0.00019816011849291372657568721765391578987);
    rslt(6,5) = static_cast<FP>(3.7498775174281917696060835401185543983e-6);
    rslt(6,6) = 0;
    rslt(6,7) = static_cast<FP>(3.7498775174281917696060835401185543983e-6);
    rslt(6,8) = static_cast<FP>(0.00019816011849291372657568721765391578987);
    rslt(6,9) = static_cast<FP>(0.0016310997479513842673349234386568819810);
    rslt(6,10) = static_cast<FP>(0.0057426522650059433658114369943834259605);
    rslt(6,11) = static_cast<FP>(0.011728014628380611976689776252337248193);
    rslt(6,12) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0055902159133992880927144559916705229108);
    rslt(7,2) = -static_cast<FP>(0.0024301398795651693250606251440522667341);
    rslt(7,3) = -static_cast<FP>(0.00055962091948320038694683451326812391038);
    rslt(7,4) = -static_cast<FP>(0.000047846733684425475014986906579840237129);
    rslt(7,5) = -static_cast<FP>(4.6739772729704119064068777650155603134e-7);
    rslt(7,6) = 0;
    rslt(7,7) = static_cast<FP>(4.6739772729704119064068777650155603134e-7);
    rslt(7,8) = static_cast<FP>(0.000047846733684425475014986906579840237129);
    rslt(7,9) = static_cast<FP>(0.00055962091948320038694683451326812391038);
    rslt(7,10) = static_cast<FP>(0.0024301398795651693250606251440522667341);
    rslt(7,11) = static_cast<FP>(0.0055902159133992880927144559916705229108);
    rslt(7,12) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0026646039375496297937360355557585726590);
    rslt(8,2) = static_cast<FP>(0.0010283714844166876755565062971962861067);
    rslt(8,3) = static_cast<FP>(0.00019200271100315135534633657677881488665);
    rslt(8,4) = static_cast<FP>(0.000011552828801675357774029981013055773031);
    rslt(8,5) = static_cast<FP>(5.8258072288256463786507210869224220550e-8);
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(5.8258072288256463786507210869224220550e-8);
    rslt(8,8) = static_cast<FP>(0.000011552828801675357774029981013055773031);
    rslt(8,9) = static_cast<FP>(0.00019200271100315135534633657677881488665);
    rslt(8,10) = static_cast<FP>(0.0010283714844166876755565062971962861067);
    rslt(8,11) = static_cast<FP>(0.0026646039375496297937360355557585726590);
    rslt(8,12) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0012700965855337718421081398391277678630);
    rslt(9,2) = -static_cast<FP>(0.00043517985069674723865081437753148979020);
    rslt(9,3) = -static_cast<FP>(0.000065875023161399765075493562963404787946);
    rslt(9,4) = -static_cast<FP>(2.7894872448579415124727120899241797611e-6);
    rslt(9,5) = -static_cast<FP>(7.2614879973234330384820899859551827818e-9);
    rslt(9,6) = 0;
    rslt(9,7) = static_cast<FP>(7.2614879973234330384820899859551827818e-9);
    rslt(9,8) = static_cast<FP>(2.7894872448579415124727120899241797611e-6);
    rslt(9,9) = static_cast<FP>(0.000065875023161399765075493562963404787946);
    rslt(9,10) = static_cast<FP>(0.00043517985069674723865081437753148979020);
    rslt(9,11) = static_cast<FP>(0.0012700965855337718421081398391277678630);
    rslt(9,12) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00060539779058796802722625831121383571480);
    rslt(10,2) = static_cast<FP>(0.00018415670341137871284144980378879474931);
    rslt(10,3) = static_cast<FP>(0.000022601340646923108515136014077712878912);
    rslt(10,4) = static_cast<FP>(6.7353539317545643799175985554948785642e-7);
    rslt(10,5) = static_cast<FP>(9.0509702542803363504846343483216753128e-10);
    rslt(10,6) = 0;
    rslt(10,7) = static_cast<FP>(9.0509702542803363504846343483216753128e-10);
    rslt(10,8) = static_cast<FP>(6.7353539317545643799175985554948785642e-7);
    rslt(10,9) = static_cast<FP>(0.000022601340646923108515136014077712878912);
    rslt(10,10) = static_cast<FP>(0.00018415670341137871284144980378879474931);
    rslt(10,11) = static_cast<FP>(0.00060539779058796802722625831121383571480);
    rslt(10,12) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00028856583745146033147285062122763693047);
    rslt(11,2) = -static_cast<FP>(0.000077930288723268760206991553580391203373);
    rslt(11,3) = -static_cast<FP>(7.7543896688537324149040524186233042073e-6);
    rslt(11,4) = -static_cast<FP>(1.6262842810852122730933726607029415195e-7);
    rslt(11,5) = -static_cast<FP>(1.1281442945862197103668740774885574140e-10);
    rslt(11,6) = 0;
    rslt(11,7) = static_cast<FP>(1.1281442945862197103668740774885574140e-10);
    rslt(11,8) = static_cast<FP>(1.6262842810852122730933726607029415195e-7);
    rslt(11,9) = static_cast<FP>(7.7543896688537324149040524186233042073e-6);
    rslt(11,10) = static_cast<FP>(0.000077930288723268760206991553580391203373);
    rslt(11,11) = static_cast<FP>(0.00028856583745146033147285062122763693047);
    rslt(11,12) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00013754632712350962404456424728771623077);
    rslt(12,2) = static_cast<FP>(0.000032978055036777891591277579760998715299);
    rslt(12,3) = static_cast<FP>(2.6604863877670692854046799942476295075e-6);
    rslt(12,4) = static_cast<FP>(3.9267432561125608687079771809514611424e-8);
    rslt(12,5) = static_cast<FP>(1.4061581395713418668803941418587058633e-11);
    rslt(12,6) = 0;
    rslt(12,7) = static_cast<FP>(1.4061581395713418668803941418587058633e-11);
    rslt(12,8) = static_cast<FP>(3.9267432561125608687079771809514611424e-8);
    rslt(12,9) = static_cast<FP>(2.6604863877670692854046799942476295075e-6);
    rslt(12,10) = static_cast<FP>(0.000032978055036777891591277579760998715299);
    rslt(12,11) = static_cast<FP>(0.00013754632712350962404456424728771623077);
    rslt(12,12) = static_cast<FP>(0.00024414062500000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_coefs(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,1) = static_cast<FP>(0.00026262464060010446729196729196729196729);
    rslt(0,2) = -static_cast<FP>(0.000060605686292331800144300144300144300144);
    rslt(0,3) = -static_cast<FP>(0.00035828479944012713109935332157554379777);
    rslt(0,4) = static_cast<FP>(0.000068900922969255217519106407995296884186);
    rslt(0,5) = static_cast<FP>(0.00012085176229056437389770723104056437390);
    rslt(0,6) = -static_cast<FP>(0.000021691341949588477366255144032921810700);
    rslt(0,7) = -static_cast<FP>(0.000015001515652557319223985890652557319224);
    rslt(0,8) = static_cast<FP>(2.5964161706349206349206349206349206349e-6);
    rslt(0,9) = static_cast<FP>(7.4634406231628453850676072898295120517e-7);
    rslt(0,10) = -static_cast<FP>(1.2630437977660199882422104644326866549e-7);
    rslt(0,11) = -static_cast<FP>(1.2526054192720859387526054192720859388e-8);
    rslt(0,12) = static_cast<FP>(2.0876756987868098979210090321201432313e-9);
    rslt(1,0) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,1) = -static_cast<FP>(0.0037643001789425129268879268879268879269);
    rslt(1,2) = static_cast<FP>(0.0010376465372192911255411255411255411255);
    rslt(1,3) = static_cast<FP>(0.0050710293491190843621399176954732510288);
    rslt(1,4) = -static_cast<FP>(0.0011650341107942019400352733686067019400);
    rslt(1,5) = -static_cast<FP>(0.0016620766506834215167548500881834215168);
    rslt(1,6) = static_cast<FP>(0.00035650559413580246913580246913580246914);
    rslt(1,7) = static_cast<FP>(0.00019548473324514991181657848324514991182);
    rslt(1,8) = -static_cast<FP>(0.000040457589285714285714285714285714285714);
    rslt(1,9) = -static_cast<FP>(8.8413065843621399176954732510288065844e-6);
    rslt(1,10) = static_cast<FP>(1.7912257495590828924162257495590828924e-6);
    rslt(1,11) = static_cast<FP>(1.2526054192720859387526054192720859388e-7);
    rslt(1,12) = -static_cast<FP>(2.5052108385441718775052108385441718775e-8);
    rslt(2,0) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,1) = static_cast<FP>(0.025665184707237929894179894179894179894);
    rslt(2,2) = -static_cast<FP>(0.0087721817581741898148148148148148148148);
    rslt(2,3) = -static_cast<FP>(0.033789773679774764844209288653733098178);
    rslt(2,4) = static_cast<FP>(0.0096296333972318672839506172839506172840);
    rslt(2,5) = static_cast<FP>(0.010508449763007054673721340388007054674);
    rslt(2,6) = -static_cast<FP>(0.0027988160686728395061728395061728395062);
    rslt(2,7) = -static_cast<FP>(0.0011230296516754850088183421516754850088);
    rslt(2,8) = static_cast<FP>(0.00028917100694444444444444444444444444444);
    rslt(2,9) = static_cast<FP>(0.000043862066431510875955320399764844209289);
    rslt(2,10) = -static_cast<FP>(0.000011091820987654320987654320987654320988);
    rslt(2,11) = -static_cast<FP>(5.5114638447971781305114638447971781305e-7);
    rslt(2,12) = static_cast<FP>(1.3778659611992945326278659611992945326e-7);
    rslt(3,0) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,1) = -static_cast<FP>(0.11213042324812954695767195767195767196);
    rslt(3,2) = static_cast<FP>(0.050283078794126157407407407407407407407);
    rslt(3,3) = static_cast<FP>(0.14061653007135049235743680188124632569);
    rslt(3,4) = -static_cast<FP>(0.052658332228170010288065843621399176955);
    rslt(3,5) = -static_cast<FP>(0.039081454268628747795414462081128747795);
    rslt(3,6) = static_cast<FP>(0.013731151941872427983539094650205761317);
    rslt(3,7) = static_cast<FP>(0.0034730833884479717813051146384479717813);
    rslt(3,8) = -static_cast<FP>(0.0011881510416666666666666666666666666667);
    rslt(3,9) = -static_cast<FP>(0.00011930022780717225161669606114050558495);
    rslt(3,10) = static_cast<FP>(0.000040187757201646090534979423868312757202);
    rslt(3,11) = static_cast<FP>(1.3778659611992945326278659611992945326e-6);
    rslt(3,12) = -static_cast<FP>(4.5928865373309817754262198706643151088e-7);
    rslt(4,0) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,1) = static_cast<FP>(0.36213065374465215773809523809523809524);
    rslt(4,2) = -static_cast<FP>(0.23427356740154286541005291005291005291);
    rslt(4,3) = -static_cast<FP>(0.39678233582296489197530864197530864198);
    rslt(4,4) = static_cast<FP>(0.21604110071898768187830687830687830688);
    rslt(4,5) = static_cast<FP>(0.080253040777943121693121693121693121693);
    rslt(4,6) = -static_cast<FP>(0.041958279079861111111111111111111111111);
    rslt(4,7) = -static_cast<FP>(0.0060466786541005291005291005291005291005);
    rslt(4,8) = static_cast<FP>(0.0030957418774801587301587301587301587302);
    rslt(4,9) = static_cast<FP>(0.00018928433641975308641975308641975308642);
    rslt(4,10) = -static_cast<FP>(0.000095589451058201058201058201058201058201);
    rslt(4,11) = -static_cast<FP>(2.0667989417989417989417989417989417989e-6);
    rslt(4,12) = static_cast<FP>(1.0333994708994708994708994708994708995e-6);
    rslt(5,0) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,1) = -static_cast<FP>(0.97328502352275545634920634920634920635);
    rslt(5,2) = static_cast<FP>(1.1011421098658647486772486772486772487);
    rslt(5,3) = static_cast<FP>(0.48366873820202270723104056437389770723);
    rslt(5,4) = -static_cast<FP>(0.51766812763516865079365079365079365079);
    rslt(5,5) = -static_cast<FP>(0.077710245122354497354497354497354497355);
    rslt(5,6) = static_cast<FP>(0.080902054398148148148148148148148148148);
    rslt(5,7) = static_cast<FP>(0.0052788111772486772486772486772486772487);
    rslt(5,8) = -static_cast<FP>(0.0053983754960317460317460317460317460317);
    rslt(5,9) = -static_cast<FP>(0.00015638778659611992945326278659611992945);
    rslt(5,10) = static_cast<FP>(0.00015790343915343915343915343915343915344);
    rslt(5,11) = static_cast<FP>(1.6534391534391534391534391534391534392e-6);
    rslt(5,12) = -static_cast<FP>(1.6534391534391534391534391534391534392e-6);
    rslt(6,0) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,1) = 0;
    rslt(6,2) = -static_cast<FP>(1.8187129607024016203703703703703703704);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.69150371786988811728395061728395061728);
    rslt(6,5) = 0;
    rslt(6,6) = -static_cast<FP>(0.10042185088734567901234567901234567901);
    rslt(6,7) = 0;
    rslt(6,8) = static_cast<FP>(0.0064789496527777777777777777777777777778);
    rslt(6,9) = 0;
    rslt(6,10) = -static_cast<FP>(0.00018614969135802469135802469135802469136);
    rslt(6,11) = 0;
    rslt(6,12) = static_cast<FP>(1.9290123456790123456790123456790123457e-6);
    rslt(7,0) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,1) = static_cast<FP>(0.97328502352275545634920634920634920635);
    rslt(7,2) = static_cast<FP>(1.1011421098658647486772486772486772487);
    rslt(7,3) = -static_cast<FP>(0.48366873820202270723104056437389770723);
    rslt(7,4) = -static_cast<FP>(0.51766812763516865079365079365079365079);
    rslt(7,5) = static_cast<FP>(0.077710245122354497354497354497354497355);
    rslt(7,6) = static_cast<FP>(0.080902054398148148148148148148148148148);
    rslt(7,7) = -static_cast<FP>(0.0052788111772486772486772486772486772487);
    rslt(7,8) = -static_cast<FP>(0.0053983754960317460317460317460317460317);
    rslt(7,9) = static_cast<FP>(0.00015638778659611992945326278659611992945);
    rslt(7,10) = static_cast<FP>(0.00015790343915343915343915343915343915344);
    rslt(7,11) = -static_cast<FP>(1.6534391534391534391534391534391534392e-6);
    rslt(7,12) = -static_cast<FP>(1.6534391534391534391534391534391534392e-6);
    rslt(8,0) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,1) = -static_cast<FP>(0.36213065374465215773809523809523809524);
    rslt(8,2) = -static_cast<FP>(0.23427356740154286541005291005291005291);
    rslt(8,3) = static_cast<FP>(0.39678233582296489197530864197530864198);
    rslt(8,4) = static_cast<FP>(0.21604110071898768187830687830687830688);
    rslt(8,5) = -static_cast<FP>(0.080253040777943121693121693121693121693);
    rslt(8,6) = -static_cast<FP>(0.041958279079861111111111111111111111111);
    rslt(8,7) = static_cast<FP>(0.0060466786541005291005291005291005291005);
    rslt(8,8) = static_cast<FP>(0.0030957418774801587301587301587301587302);
    rslt(8,9) = -static_cast<FP>(0.00018928433641975308641975308641975308642);
    rslt(8,10) = -static_cast<FP>(0.000095589451058201058201058201058201058201);
    rslt(8,11) = static_cast<FP>(2.0667989417989417989417989417989417989e-6);
    rslt(8,12) = static_cast<FP>(1.0333994708994708994708994708994708995e-6);
    rslt(9,0) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,1) = static_cast<FP>(0.11213042324812954695767195767195767196);
    rslt(9,2) = static_cast<FP>(0.050283078794126157407407407407407407407);
    rslt(9,3) = -static_cast<FP>(0.14061653007135049235743680188124632569);
    rslt(9,4) = -static_cast<FP>(0.052658332228170010288065843621399176955);
    rslt(9,5) = static_cast<FP>(0.039081454268628747795414462081128747795);
    rslt(9,6) = static_cast<FP>(0.013731151941872427983539094650205761317);
    rslt(9,7) = -static_cast<FP>(0.0034730833884479717813051146384479717813);
    rslt(9,8) = -static_cast<FP>(0.0011881510416666666666666666666666666667);
    rslt(9,9) = static_cast<FP>(0.00011930022780717225161669606114050558495);
    rslt(9,10) = static_cast<FP>(0.000040187757201646090534979423868312757202);
    rslt(9,11) = -static_cast<FP>(1.3778659611992945326278659611992945326e-6);
    rslt(9,12) = -static_cast<FP>(4.5928865373309817754262198706643151088e-7);
    rslt(10,0) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,1) = -static_cast<FP>(0.025665184707237929894179894179894179894);
    rslt(10,2) = -static_cast<FP>(0.0087721817581741898148148148148148148148);
    rslt(10,3) = static_cast<FP>(0.033789773679774764844209288653733098178);
    rslt(10,4) = static_cast<FP>(0.0096296333972318672839506172839506172840);
    rslt(10,5) = -static_cast<FP>(0.010508449763007054673721340388007054674);
    rslt(10,6) = -static_cast<FP>(0.0027988160686728395061728395061728395062);
    rslt(10,7) = static_cast<FP>(0.0011230296516754850088183421516754850088);
    rslt(10,8) = static_cast<FP>(0.00028917100694444444444444444444444444444);
    rslt(10,9) = -static_cast<FP>(0.000043862066431510875955320399764844209289);
    rslt(10,10) = -static_cast<FP>(0.000011091820987654320987654320987654320988);
    rslt(10,11) = static_cast<FP>(5.5114638447971781305114638447971781305e-7);
    rslt(10,12) = static_cast<FP>(1.3778659611992945326278659611992945326e-7);
    rslt(11,0) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,1) = static_cast<FP>(0.0037643001789425129268879268879268879269);
    rslt(11,2) = static_cast<FP>(0.0010376465372192911255411255411255411255);
    rslt(11,3) = -static_cast<FP>(0.0050710293491190843621399176954732510288);
    rslt(11,4) = -static_cast<FP>(0.0011650341107942019400352733686067019400);
    rslt(11,5) = static_cast<FP>(0.0016620766506834215167548500881834215168);
    rslt(11,6) = static_cast<FP>(0.00035650559413580246913580246913580246914);
    rslt(11,7) = -static_cast<FP>(0.00019548473324514991181657848324514991182);
    rslt(11,8) = -static_cast<FP>(0.000040457589285714285714285714285714285714);
    rslt(11,9) = static_cast<FP>(8.8413065843621399176954732510288065844e-6);
    rslt(11,10) = static_cast<FP>(1.7912257495590828924162257495590828924e-6);
    rslt(11,11) = -static_cast<FP>(1.2526054192720859387526054192720859388e-7);
    rslt(11,12) = -static_cast<FP>(2.5052108385441718775052108385441718775e-8);
    rslt(12,0) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,1) = -static_cast<FP>(0.00026262464060010446729196729196729196729);
    rslt(12,2) = -static_cast<FP>(0.000060605686292331800144300144300144300144);
    rslt(12,3) = static_cast<FP>(0.00035828479944012713109935332157554379777);
    rslt(12,4) = static_cast<FP>(0.000068900922969255217519106407995296884186);
    rslt(12,5) = -static_cast<FP>(0.00012085176229056437389770723104056437390);
    rslt(12,6) = -static_cast<FP>(0.000021691341949588477366255144032921810700);
    rslt(12,7) = static_cast<FP>(0.000015001515652557319223985890652557319224);
    rslt(12,8) = static_cast<FP>(2.5964161706349206349206349206349206349e-6);
    rslt(12,9) = -static_cast<FP>(7.4634406231628453850676072898295120517e-7);
    rslt(12,10) = -static_cast<FP>(1.2630437977660199882422104644326866549e-7);
    rslt(12,11) = static_cast<FP>(1.2526054192720859387526054192720859388e-8);
    rslt(12,12) = static_cast<FP>(2.0876756987868098979210090321201432313e-9);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_sten(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,11) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,12) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(1,2) = -static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(1,3) = -static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,4) = -static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,5) = -static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,6) = 0;
    rslt(1,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,8) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(1,9) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(1,10) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(1,11) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(1,12) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(36.083333333333333333333333333333333333);
    rslt(2,1) = static_cast<FP>(25.083333333333333333333333333333333333);
    rslt(2,2) = static_cast<FP>(16.083333333333333333333333333333333333);
    rslt(2,3) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,4) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,5) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,6) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(2,7) = static_cast<FP>(1.0833333333333333333333333333333333333);
    rslt(2,8) = static_cast<FP>(4.0833333333333333333333333333333333333);
    rslt(2,9) = static_cast<FP>(9.0833333333333333333333333333333333333);
    rslt(2,10) = static_cast<FP>(16.083333333333333333333333333333333333);
    rslt(2,11) = static_cast<FP>(25.083333333333333333333333333333333333);
    rslt(2,12) = static_cast<FP>(36.083333333333333333333333333333333333);
    rslt(3,0) = -static_cast<FP>(217.50000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(126.25000000000000000000000000000000000);
    rslt(3,2) = -static_cast<FP>(65.000000000000000000000000000000000000);
    rslt(3,3) = -static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,4) = -static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,5) = -static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,6) = 0;
    rslt(3,7) = static_cast<FP>(1.2500000000000000000000000000000000000);
    rslt(3,8) = static_cast<FP>(8.5000000000000000000000000000000000000);
    rslt(3,9) = static_cast<FP>(27.750000000000000000000000000000000000);
    rslt(3,10) = static_cast<FP>(65.000000000000000000000000000000000000);
    rslt(3,11) = static_cast<FP>(126.25000000000000000000000000000000000);
    rslt(3,12) = static_cast<FP>(217.50000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(1314.0125000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(637.51250000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(264.01250000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,4) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,5) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,6) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(4,7) = static_cast<FP>(1.5125000000000000000000000000000000000);
    rslt(4,8) = static_cast<FP>(18.012500000000000000000000000000000000);
    rslt(4,9) = static_cast<FP>(85.512500000000000000000000000000000000);
    rslt(4,10) = static_cast<FP>(264.01250000000000000000000000000000000);
    rslt(4,11) = static_cast<FP>(637.51250000000000000000000000000000000);
    rslt(4,12) = static_cast<FP>(1314.0125000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(7956.3750000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(3229.4791666666666666666666666666666667);
    rslt(5,2) = -static_cast<FP>(1077.5833333333333333333333333333333333);
    rslt(5,3) = -static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,4) = -static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,5) = -static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,6) = 0;
    rslt(5,7) = static_cast<FP>(1.8958333333333333333333333333333333333);
    rslt(5,8) = static_cast<FP>(38.791666666666666666666666666666666667);
    rslt(5,9) = static_cast<FP>(265.68750000000000000000000000000000000);
    rslt(5,10) = static_cast<FP>(1077.5833333333333333333333333333333333);
    rslt(5,11) = static_cast<FP>(3229.4791666666666666666666666666666667);
    rslt(5,12) = static_cast<FP>(7956.3750000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(48282.752232142857142857142857142857143);
    rslt(6,1) = static_cast<FP>(16410.939732142857142857142857142857143);
    rslt(6,2) = static_cast<FP>(4419.0022321428571428571428571428571429);
    rslt(6,3) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,4) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,5) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,6) = static_cast<FP>(0.0022321428571428571428571428571428571429);
    rslt(6,7) = static_cast<FP>(2.4397321428571428571428571428571428571);
    rslt(6,8) = static_cast<FP>(84.752232142857142857142857142857142857);
    rslt(6,9) = static_cast<FP>(831.93973214285714285714285714285714286);
    rslt(6,10) = static_cast<FP>(4419.0022321428571428571428571428571429);
    rslt(6,11) = static_cast<FP>(16410.939732142857142857142857142857143);
    rslt(6,12) = static_cast<FP>(48282.752232142857142857142857142857143);
    rslt(7,0) = -static_cast<FP>(293638.59375000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(83648.515625000000000000000000000000000);
    rslt(7,2) = -static_cast<FP>(18204.062500000000000000000000000000000);
    rslt(7,3) = -static_cast<FP>(2624.1093750000000000000000000000000000);
    rslt(7,4) = -static_cast<FP>(187.53125000000000000000000000000000000);
    rslt(7,5) = -static_cast<FP>(3.2031250000000000000000000000000000000);
    rslt(7,6) = 0;
    rslt(7,7) = static_cast<FP>(3.2031250000000000000000000000000000000);
    rslt(7,8) = static_cast<FP>(187.53125000000000000000000000000000000);
    rslt(7,9) = static_cast<FP>(2624.1093750000000000000000000000000000);
    rslt(7,10) = static_cast<FP>(18204.062500000000000000000000000000000);
    rslt(7,11) = static_cast<FP>(83648.515625000000000000000000000000000);
    rslt(7,12) = static_cast<FP>(293638.59375000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(1.7896162504340277777777777777777777778e6);
    rslt(8,1) = static_cast<FP>(427631.77126736111111111111111111111111);
    rslt(8,2) = static_cast<FP>(75318.333767361111111111111111111111111);
    rslt(8,3) = static_cast<FP>(8333.4379340277777777777777777777777778);
    rslt(8,4) = static_cast<FP>(419.58376736111111111111111111111111111);
    rslt(8,5) = static_cast<FP>(4.2712673611111111111111111111111111111);
    rslt(8,6) = static_cast<FP>(0.00043402777777777777777777777777777777778);
    rslt(8,7) = static_cast<FP>(4.2712673611111111111111111111111111111);
    rslt(8,8) = static_cast<FP>(419.58376736111111111111111111111111111);
    rslt(8,9) = static_cast<FP>(8333.4379340277777777777777777777777778);
    rslt(8,10) = static_cast<FP>(75318.333767361111111111111111111111111);
    rslt(8,11) = static_cast<FP>(427631.77126736111111111111111111111111);
    rslt(8,12) = static_cast<FP>(1.7896162504340277777777777777777777778e6);
    rslt(9,0) = -static_cast<FP>(1.0929791723437500000000000000000000000e7);
    rslt(9,1) = -static_cast<FP>(2.1924453320312500000000000000000000000e6);
    rslt(9,2) = -static_cast<FP>(312920.81562500000000000000000000000000);
    rslt(9,3) = -static_cast<FP>(26631.799218750000000000000000000000000);
    rslt(9,4) = -static_cast<FP>(947.90781250000000000000000000000000000);
    rslt(9,5) = -static_cast<FP>(5.7664062500000000000000000000000000000);
    rslt(9,6) = 0;
    rslt(9,7) = static_cast<FP>(5.7664062500000000000000000000000000000);
    rslt(9,8) = static_cast<FP>(947.90781250000000000000000000000000000);
    rslt(9,9) = static_cast<FP>(26631.799218750000000000000000000000000);
    rslt(9,10) = static_cast<FP>(312920.81562500000000000000000000000000);
    rslt(9,11) = static_cast<FP>(2.1924453320312500000000000000000000000e6);
    rslt(9,12) = static_cast<FP>(1.0929791723437500000000000000000000000e7);
    rslt(10,0) = static_cast<FP>(6.6887816203213778409090909090909090909e7);
    rslt(10,1) = static_cast<FP>(1.1271777832120028409090909090909090909e7);
    rslt(10,2) = static_cast<FP>(1.3052083125887784090909090909090909091e6);
    rslt(10,3) = static_cast<FP>(85604.519620028409090909090909090909091);
    rslt(10,4) = static_cast<FP>(2159.5782137784090909090909090909090909);
    rslt(10,5) = static_cast<FP>(7.8633700284090909090909090909090909091);
    rslt(10,6) = static_cast<FP>(0.000088778409090909090909090909090909090909);
    rslt(10,7) = static_cast<FP>(7.8633700284090909090909090909090909091);
    rslt(10,8) = static_cast<FP>(2159.5782137784090909090909090909090909);
    rslt(10,9) = static_cast<FP>(85604.519620028409090909090909090909091);
    rslt(10,10) = static_cast<FP>(1.3052083125887784090909090909090909091e6);
    rslt(10,11) = static_cast<FP>(1.1271777832120028409090909090909090909e7);
    rslt(10,12) = static_cast<FP>(6.6887816203213778409090909090909090909e7);
    rslt(11,0) = -static_cast<FP>(4.1014926647460937500000000000000000000e8);
    rslt(11,1) = -static_cast<FP>(5.8105445154622395833333333333333333333e7);
    rslt(11,2) = -static_cast<FP>(5.4644419205729166666666666666666666667e6);
    rslt(11,3) = -static_cast<FP>(276634.65527343750000000000000000000000);
    rslt(11,4) = -static_cast<FP>(4956.2415364583333333333333333333333333);
    rslt(11,5) = -static_cast<FP>(10.812174479166666666666666666666666667);
    rslt(11,6) = 0;
    rslt(11,7) = static_cast<FP>(10.812174479166666666666666666666666667);
    rslt(11,8) = static_cast<FP>(4956.2415364583333333333333333333333333);
    rslt(11,9) = static_cast<FP>(276634.65527343750000000000000000000000);
    rslt(11,10) = static_cast<FP>(5.4644419205729166666666666666666666667e6);
    rslt(11,11) = static_cast<FP>(5.8105445154622395833333333333333333333e7);
    rslt(11,12) = static_cast<FP>(4.1014926647460937500000000000000000000e8);
    rslt(12,0) = static_cast<FP>(2.5198354346484562800480769230769230769e9);
    rslt(12,1) = static_cast<FP>(3.0030091567384690504807692307692307692e8);
    rslt(12,2) = static_cast<FP>(2.2958391093768780048076923076923076923e7);
    rslt(12,3) = static_cast<FP>(898327.70509690504807692307692307692308);
    rslt(12,4) = static_cast<FP>(11447.460956280048076923076923076923077);
    rslt(12,5) = static_cast<FP>(14.970721905048076923076923076923076923);
    rslt(12,6) = static_cast<FP>(0.000018780048076923076923076923076923076923);
    rslt(12,7) = static_cast<FP>(14.970721905048076923076923076923076923);
    rslt(12,8) = static_cast<FP>(11447.460956280048076923076923076923077);
    rslt(12,9) = static_cast<FP>(898327.70509690504807692307692307692308);
    rslt(12,10) = static_cast<FP>(2.2958391093768780048076923076923076923e7);
    rslt(12,11) = static_cast<FP>(3.0030091567384690504807692307692307692e8);
    rslt(12,12) = static_cast<FP>(2.5198354346484562800480769230769230769e9);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,1> &rslt) {
    rslt(0,0) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(1,0) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(2,0) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(3,0) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(4,0) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(5,0) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(6,0) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(7,0) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(8,0) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(9,0) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(10,0) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(11,0) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(12,0) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,2> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,3> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,2) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,2) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,2) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,2) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,2) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,2) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,2) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,2) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,2) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,2) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,2) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,2) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,2) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,4> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000053410261471592559656397186783681921822);
    rslt(0,2) = static_cast<FP>(0.000056161836501500922898093761813590285063);
    rslt(0,3) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.00076227901840673803661262702810979096164);
    rslt(1,2) = -static_cast<FP>(0.00080962289070727700381826090041032992885);
    rslt(1,3) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0051650871775624375801176620492086113416);
    rslt(2,2) = static_cast<FP>(0.0055688561928681195524663010645142933140);
    rslt(2,3) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.022344786476025931899027892429291752571);
    rslt(3,2) = -static_cast<FP>(0.024700682645905435111864438599171255784);
    rslt(3,3) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.070847604401627218090920179218681559377);
    rslt(4,2) = static_cast<FP>(0.082319212685010501474203562502064842761);
    rslt(4,3) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.18057262800252297277845990532835048688);
    rslt(5,2) = -static_cast<FP>(0.24396509307892804918353631040475556329);
    rslt(5,3) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(1.0539175762448662448662448662448662449);
    rslt(6,2) = static_cast<FP>(1.0539175762448662448662448662448662449);
    rslt(6,3) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.24396509307892804918353631040475556329);
    rslt(7,2) = static_cast<FP>(0.18057262800252297277845990532835048688);
    rslt(7,3) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.082319212685010501474203562502064842761);
    rslt(8,2) = -static_cast<FP>(0.070847604401627218090920179218681559377);
    rslt(8,3) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.024700682645905435111864438599171255784);
    rslt(9,2) = static_cast<FP>(0.022344786476025931899027892429291752571);
    rslt(9,3) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0055688561928681195524663010645142933140);
    rslt(10,2) = -static_cast<FP>(0.0051650871775624375801176620492086113416);
    rslt(10,3) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.00080962289070727700381826090041032992885);
    rslt(11,2) = static_cast<FP>(0.00076227901840673803661262702810979096164);
    rslt(11,3) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000056161836501500922898093761813590285063);
    rslt(12,2) = -static_cast<FP>(0.000053410261471592559656397186783681921822);
    rslt(12,3) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,5> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000075339220911789808598969455814010819865);
    rslt(0,2) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,3) = static_cast<FP>(0.000072354548536467066507279051770760598577);
    rslt(0,4) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0010860283043338030233078415327621892557);
    rslt(1,2) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,3) = -static_cast<FP>(0.0010349293243300405734557521597249118589);
    rslt(1,4) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0074708769309608560758071111048681902602);
    rslt(2,2) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,3) = static_cast<FP>(0.0070389383983545001135365214256307537108);
    rslt(2,4) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.033154774512495170740946553872575998819);
    rslt(3,2) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,3) = -static_cast<FP>(0.030679686312795255259341470145927277993);
    rslt(3,4) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.11067603536304925803741971180358317840);
    rslt(4,2) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,3) = static_cast<FP>(0.099161493926401731452877088025606783744);
    rslt(4,4) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.32857601661679247514796606445019156451);
    rslt(5,2) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,3) = -static_cast<FP>(0.27524313063085854575510374398117660595);
    rslt(5,4) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.95609039147599159796458541029255612465);
    rslt(6,2) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,3) = static_cast<FP>(0.95609039147599159796458541029255612465);
    rslt(6,4) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27524313063085854575510374398117660595);
    rslt(7,2) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,3) = static_cast<FP>(0.32857601661679247514796606445019156451);
    rslt(7,4) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.099161493926401731452877088025606783744);
    rslt(8,2) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,3) = -static_cast<FP>(0.11067603536304925803741971180358317840);
    rslt(8,4) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.030679686312795255259341470145927277993);
    rslt(9,2) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,3) = static_cast<FP>(0.033154774512495170740946553872575998820);
    rslt(9,4) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0070389383983545001135365214256307537108);
    rslt(10,2) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,3) = -static_cast<FP>(0.0074708769309608560758071111048681902602);
    rslt(10,4) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0010349293243300405734557521597249118589);
    rslt(11,2) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,3) = static_cast<FP>(0.0010860283043338030233078415327621892557);
    rslt(11,4) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000072354548536467066507279051770760598577);
    rslt(12,2) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,3) = -static_cast<FP>(0.000075339220911789808598969455814010819865);
    rslt(12,4) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,6> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000084601702743022300778127273787401726588);
    rslt(0,2) = -static_cast<FP>(0.000033390086708639776571914104687016726876);
    rslt(0,3) = static_cast<FP>(0.000039454409715046027316118757781619033445);
    rslt(0,4) = static_cast<FP>(0.000078155199785714116087023349496718246436);
    rslt(0,5) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0012247856476572663048747893172397447467);
    rslt(1,2) = static_cast<FP>(0.00047017682709936158853212129382779045377);
    rslt(1,3) = -static_cast<FP>(0.00057429681979816460008040797994168759310);
    rslt(1,4) = -static_cast<FP>(0.0011141790152958398823144553493639388620);
    rslt(1,5) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0084803100449331488860749611579298232497);
    rslt(2,2) = -static_cast<FP>(0.0031205564124877479106011815326555316924);
    rslt(2,3) = static_cast<FP>(0.0040051725335527408716721131366069819922);
    rslt(2,4) = static_cast<FP>(0.0075417233260713078798693289771675795264);
    rslt(2,5) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.038048638975481165599295115109240892517);
    rslt(3,2) = static_cast<FP>(0.013024867298514622126028578764237000272);
    rslt(3,3) = -static_cast<FP>(0.018147094265082039239722634983714489192);
    rslt(3,4) = -static_cast<FP>(0.032627435131011659912007617100431330528);
    rslt(3,5) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.12983576743748313143537245758835680575);
    rslt(4,2) = -static_cast<FP>(0.038260643449459912618366112092793543395);
    rslt(4,3) = static_cast<FP>(0.062737995507320385223891583044563732324);
    rslt(4,4) = static_cast<FP>(0.10409521271531035625453785655975286828);
    rslt(4,5) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.41069050522890960207905047231893636342);
    rslt(5,2) = static_cast<FP>(0.074121073938151410351934367820859636576);
    rslt(5,3) = -static_cast<FP>(0.20069369205315818840176160771345446150);
    rslt(5,4) = -static_cast<FP>(0.28104074630635595782138528727501130357);
    rslt(5,5) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.89150401854460734800421832011304643695);
    rslt(6,2) = static_cast<FP>(1.1064309325723411263577289755893699694);
    rslt(6,3) = static_cast<FP>(1.1064309325723411263577289755893699694);
    rslt(6,4) = static_cast<FP>(0.89150401854460734800421832011304643695);
    rslt(6,5) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.28104074630635595782138528727501130357);
    rslt(7,2) = -static_cast<FP>(0.20069369205315818840176160771345446150);
    rslt(7,3) = static_cast<FP>(0.074121073938151410351934367820859636576);
    rslt(7,4) = static_cast<FP>(0.41069050522890960207905047231893636343);
    rslt(7,5) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10409521271531035625453785655975286828);
    rslt(8,2) = static_cast<FP>(0.062737995507320385223891583044563732324);
    rslt(8,3) = -static_cast<FP>(0.038260643449459912618366112092793543395);
    rslt(8,4) = -static_cast<FP>(0.12983576743748313143537245758835680575);
    rslt(8,5) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.032627435131011659912007617100431330528);
    rslt(9,2) = -static_cast<FP>(0.018147094265082039239722634983714489192);
    rslt(9,3) = static_cast<FP>(0.013024867298514622126028578764237000272);
    rslt(9,4) = static_cast<FP>(0.038048638975481165599295115109240892517);
    rslt(9,5) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0075417233260713078798693289771675795265);
    rslt(10,2) = static_cast<FP>(0.0040051725335527408716721131366069819923);
    rslt(10,3) = -static_cast<FP>(0.0031205564124877479106011815326555316924);
    rslt(10,4) = -static_cast<FP>(0.0084803100449331488860749611579298232497);
    rslt(10,5) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011141790152958398823144553493639388620);
    rslt(11,2) = -static_cast<FP>(0.00057429681979816460008040797994168759310);
    rslt(11,3) = static_cast<FP>(0.00047017682709936158853212129382779045377);
    rslt(11,4) = static_cast<FP>(0.0012247856476572663048747893172397447467);
    rslt(11,5) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000078155199785714116087023349496718246437);
    rslt(12,2) = static_cast<FP>(0.000039454409715046027316118757781619033445);
    rslt(12,3) = -static_cast<FP>(0.000033390086708639776571914104687016726876);
    rslt(12,4) = -static_cast<FP>(0.000084601702743022300778127273787401726588);
    rslt(12,5) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,7> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000089117857398469724349069843297470469677);
    rslt(0,2) = -static_cast<FP>(0.000055924460350977246155344645517068991069);
    rslt(0,3) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,4) = static_cast<FP>(0.000058145356288506140990637147206491109180);
    rslt(0,5) = static_cast<FP>(0.000080578372305574255468343286445017866190);
    rslt(0,6) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0012932579173862360572512396335015267570);
    rslt(1,2) = static_cast<FP>(0.00079916215912071456437041423175922241321);
    rslt(1,3) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,4) = -static_cast<FP>(0.00083740610180775818570269012734402269983);
    rslt(1,5) = -static_cast<FP>(0.0011466300206624561247776727546518227513);
    rslt(1,6) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0089870266288958115698754933409603565069);
    rslt(2,2) = -static_cast<FP>(0.0054253224559900761963678635167960409352);
    rslt(2,3) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,4) = static_cast<FP>(0.0057519504387439172797129784669797147566);
    rslt(2,5) = static_cast<FP>(0.0077410928543915316921101935192425682806);
    rslt(2,6) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.040570713271790453273518913237717068666);
    rslt(3,2) = static_cast<FP>(0.023546483052097315178251184050589800799);
    rslt(3,3) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,4) = -static_cast<FP>(0.025457743860489906301277594752827114040);
    rslt(3,5) = -static_cast<FP>(0.033354474825437637542294281295989197391);
    rslt(3,6) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.14017076088921007410400043022438071611);
    rslt(4,2) = -static_cast<FP>(0.075151532211467019794840089212841993969);
    rslt(4,3) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,4) = static_cast<FP>(0.084522859894528814885072026560824355513);
    rslt(4,5) = static_cast<FP>(0.10566697134899726718648319620240792196);
    rslt(4,6) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.45968666834039799269051535183999896373);
    rslt(5,2) = static_cast<FP>(0.19547938448388506474948143765874296402);
    rslt(5,3) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,4) = -static_cast<FP>(0.24849178489983255755047613532865031293);
    rslt(5,5) = -static_cast<FP>(0.28105639560474605839573108867469196566);
    rslt(5,6) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.84976512372108145230568079841465846163);
    rslt(6,2) = static_cast<FP>(1.0452617286052739624769410394678740050);
    rslt(6,3) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,4) = static_cast<FP>(1.0452617286052739624769410394678740050);
    rslt(6,5) = static_cast<FP>(0.84976512372108145230568079841465846163);
    rslt(6,6) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.28105639560474605839573108867469196566);
    rslt(7,2) = -static_cast<FP>(0.24849178489983255755047613532865031293);
    rslt(7,3) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,4) = static_cast<FP>(0.19547938448388506474948143765874296402);
    rslt(7,5) = static_cast<FP>(0.45968666834039799269051535183999896373);
    rslt(7,6) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10566697134899726718648319620240792196);
    rslt(8,2) = static_cast<FP>(0.084522859894528814885072026560824355513);
    rslt(8,3) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,4) = -static_cast<FP>(0.075151532211467019794840089212841993969);
    rslt(8,5) = -static_cast<FP>(0.14017076088921007410400043022438071611);
    rslt(8,6) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033354474825437637542294281295989197392);
    rslt(9,2) = -static_cast<FP>(0.025457743860489906301277594752827114040);
    rslt(9,3) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,4) = static_cast<FP>(0.023546483052097315178251184050589800799);
    rslt(9,5) = static_cast<FP>(0.040570713271790453273518913237717068666);
    rslt(9,6) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0077410928543915316921101935192425682806);
    rslt(10,2) = static_cast<FP>(0.0057519504387439172797129784669797147566);
    rslt(10,3) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,4) = -static_cast<FP>(0.0054253224559900761963678635167960409352);
    rslt(10,5) = -static_cast<FP>(0.0089870266288958115698754933409603565069);
    rslt(10,6) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011466300206624561247776727546518227513);
    rslt(11,2) = -static_cast<FP>(0.00083740610180775818570269012734402269983);
    rslt(11,3) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,4) = static_cast<FP>(0.00079916215912071456437041423175922241321);
    rslt(11,5) = static_cast<FP>(0.0012932579173862360572512396335015267570);
    rslt(11,6) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000080578372305574255468343286445017866190);
    rslt(12,2) = static_cast<FP>(0.000058145356288506140990637147206491109180);
    rslt(12,3) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,4) = -static_cast<FP>(0.000055924460350977246155344645517068991069);
    rslt(12,5) = -static_cast<FP>(0.000089117857398469724349069843297470469677);
    rslt(12,6) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,8> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000091594319625451691455521615601710082146);
    rslt(0,2) = -static_cast<FP>(0.000069245382671677077914853202924234171470);
    rslt(0,3) = -static_cast<FP>(0.000023493435291616752323983142687201237848);
    rslt(0,4) = static_cast<FP>(0.000030655484048246300147543847037663970338);
    rslt(0,5) = static_cast<FP>(0.000068136027432010991968635793274414647636);
    rslt(0,6) = static_cast<FP>(0.000081722246485067624210436251272348817718);
    rslt(0,7) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0013311848925407384944345676901109277653);
    rslt(1,2) = static_cast<FP>(0.00099553069965431260141899201397334222041);
    rslt(1,3) = static_cast<FP>(0.00032668017635234247957874142381283084148);
    rslt(1,4) = -static_cast<FP>(0.00044960302140570710928445889828159208419);
    rslt(1,5) = -static_cast<FP>(0.00097663525759016620240988903981061318287);
    rslt(1,6) = -static_cast<FP>(0.0011616025253067459726138506024508856505);
    rslt(1,7) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0092716642002894494410317268157199960261);
    rslt(2,2) = -static_cast<FP>(0.0068207827529007927875894107338023644095);
    rslt(2,3) = -static_cast<FP>(0.0021254077622244136300170387546134033950);
    rslt(2,4) = static_cast<FP>(0.0031691076123743943811505972415796184094);
    rslt(2,5) = static_cast<FP>(0.0066625335746570266363525314271215205420);
    rslt(2,6) = static_cast<FP>(0.0078295707398403991380117419176297498752);
    rslt(2,7) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.042017420573432173503870595472422183577);
    rslt(3,2) = static_cast<FP>(0.030065126146935589765483495864040890427);
    rslt(3,3) = static_cast<FP>(0.0085559523606476281756414932071319430301);
    rslt(3,4) = -static_cast<FP>(0.014591523594618415672163250239263687353);
    rslt(3,5) = -static_cast<FP>(0.029175732396048281885860378820167753977);
    rslt(3,6) = -static_cast<FP>(0.033651922018971261309272470116387216542);
    rslt(3,7) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.14630919230541573184178787342535393359);
    rslt(4,2) = -static_cast<FP>(0.099006005206707923507432806974837005851);
    rslt(4,3) = -static_cast<FP>(0.023068290835574216728273673678064498355);
    rslt(4,4) = static_cast<FP>(0.051817900474806246575510883788464910011);
    rslt(4,5) = static_cast<FP>(0.095078845614005381159045587236866179422);
    rslt(4,6) = static_cast<FP>(0.10615046551166761237695376502303200966);
    rslt(4,7) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.49097320174074614087144805614555399034);
    rslt(5,2) = static_cast<FP>(0.28259575787954808990753677419235125517);
    rslt(5,3) = static_cast<FP>(0.027828526184832559681359280408201387696);
    rslt(5,4) = -static_cast<FP>(0.17477257654701383218230793867099532937);
    rslt(5,5) = -static_cast<FP>(0.26859818283412906763956805322937343284);
    rslt(5,6) = -static_cast<FP>(0.27978906243895863867025643526695568477);
    rslt(5,7) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.82189147210385514691748871534244821663);
    rslt(6,2) = static_cast<FP>(0.98918065388781549803896937547328780200);
    rslt(6,3) = static_cast<FP>(1.1233020729030667844809818034676773578);
    rslt(6,4) = static_cast<FP>(1.1233020729030667844809818034676773578);
    rslt(6,5) = static_cast<FP>(0.98918065388781549803896937547328780200);
    rslt(6,6) = static_cast<FP>(0.82189147210385514691748871534244821663);
    rslt(6,7) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27978906243895863867025643526695568477);
    rslt(7,2) = -static_cast<FP>(0.26859818283412906763956805322937343284);
    rslt(7,3) = -static_cast<FP>(0.17477257654701383218230793867099532937);
    rslt(7,4) = static_cast<FP>(0.027828526184832559681359280408201387697);
    rslt(7,5) = static_cast<FP>(0.28259575787954808990753677419235125517);
    rslt(7,6) = static_cast<FP>(0.49097320174074614087144805614555399034);
    rslt(7,7) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10615046551166761237695376502303200966);
    rslt(8,2) = static_cast<FP>(0.095078845614005381159045587236866179422);
    rslt(8,3) = static_cast<FP>(0.051817900474806246575510883788464910011);
    rslt(8,4) = -static_cast<FP>(0.023068290835574216728273673678064498355);
    rslt(8,5) = -static_cast<FP>(0.099006005206707923507432806974837005851);
    rslt(8,6) = -static_cast<FP>(0.14630919230541573184178787342535393359);
    rslt(8,7) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033651922018971261309272470116387216542);
    rslt(9,2) = -static_cast<FP>(0.029175732396048281885860378820167753977);
    rslt(9,3) = -static_cast<FP>(0.014591523594618415672163250239263687353);
    rslt(9,4) = static_cast<FP>(0.0085559523606476281756414932071319430301);
    rslt(9,5) = static_cast<FP>(0.030065126146935589765483495864040890427);
    rslt(9,6) = static_cast<FP>(0.042017420573432173503870595472422183577);
    rslt(9,7) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0078295707398403991380117419176297498752);
    rslt(10,2) = static_cast<FP>(0.0066625335746570266363525314271215205420);
    rslt(10,3) = static_cast<FP>(0.0031691076123743943811505972415796184094);
    rslt(10,4) = -static_cast<FP>(0.0021254077622244136300170387546134033950);
    rslt(10,5) = -static_cast<FP>(0.0068207827529007927875894107338023644095);
    rslt(10,6) = -static_cast<FP>(0.0092716642002894494410317268157199960261);
    rslt(10,7) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011616025253067459726138506024508856505);
    rslt(11,2) = -static_cast<FP>(0.00097663525759016620240988903981061318286);
    rslt(11,3) = -static_cast<FP>(0.00044960302140570710928445889828159208419);
    rslt(11,4) = static_cast<FP>(0.00032668017635234247957874142381283084148);
    rslt(11,5) = static_cast<FP>(0.00099553069965431260141899201397334222042);
    rslt(11,6) = static_cast<FP>(0.0013311848925407384944345676901109277653);
    rslt(11,7) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000081722246485067624210436251272348817718);
    rslt(12,2) = static_cast<FP>(0.000068136027432010991968635793274414647637);
    rslt(12,3) = static_cast<FP>(0.000030655484048246300147543847037663970338);
    rslt(12,4) = -static_cast<FP>(0.000023493435291616752323983142687201237848);
    rslt(12,5) = -static_cast<FP>(0.000069245382671677077914853202924234171470);
    rslt(12,6) = -static_cast<FP>(0.000091594319625451691455521615601710082146);
    rslt(12,7) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,9> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000093081329232613340952400667126863757742);
    rslt(0,2) = -static_cast<FP>(0.000077383458600817192440300039545883871713);
    rslt(0,3) = -static_cast<FP>(0.000043248440998315522665175010224119111160);
    rslt(0,4) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,5) = static_cast<FP>(0.000047874097885429090034704858735318087922);
    rslt(0,6) = static_cast<FP>(0.000073706898438296135772159452667014630892);
    rslt(0,7) = static_cast<FP>(0.000082315884498770315580508797521471095767);
    rslt(0,8) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0013541514663863252837470777846457805031);
    rslt(1,2) = static_cast<FP>(0.0011165088381039269839900757709909414972);
    rslt(1,3) = static_cast<FP>(0.00061368432106574960629149269084355919745);
    rslt(1,4) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,5) = -static_cast<FP>(0.00069315362546873216364207737928284834535);
    rslt(1,6) = -static_cast<FP>(0.0010535230616179454889102047190550340479);
    rslt(1,7) = -static_cast<FP>(0.0011691706247494881289081086379337368525);
    rslt(1,8) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0094460272694674955152242758401545874582);
    rslt(2,2) = -static_cast<FP>(0.0076911176586464462035352104491916607754);
    rslt(2,3) = -static_cast<FP>(0.0041216096187692341476581140866693885373);
    rslt(2,4) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,5) = static_cast<FP>(0.0047975470791327771924548226782213425965);
    rslt(2,6) = static_cast<FP>(0.0071580735097976870147516857967470670786);
    rslt(2,7) = static_cast<FP>(0.0078721967541300963250304000011514541500);
    rslt(2,8) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.042918645374826518623474491196924006689);
    rslt(3,2) = static_cast<FP>(0.034211206077099533899157567359336034371);
    rslt(3,3) = static_cast<FP>(0.017562996469749673244470224065633175817);
    rslt(3,4) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,5) = -static_cast<FP>(0.021485762870818684372848522071134545189);
    rslt(3,6) = -static_cast<FP>(0.031149359781578043820996357405750364979);
    rslt(3,7) = -static_cast<FP>(0.033779564613218251858575880681524215110);
    rslt(3,8) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.15023729930876532995966379702903221494);
    rslt(4,2) = -static_cast<FP>(0.11473359597948896385093950199620113807);
    rslt(4,3) = -static_cast<FP>(0.053963740972382256759867786024000049446);
    rslt(4,4) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,5) = static_cast<FP>(0.072814464539604317516977292600634461370);
    rslt(4,6) = static_cast<FP>(0.10039978256396891667613071949235002524);
    rslt(4,7) = static_cast<FP>(0.10625037912648962254385213347435730915);
    rslt(4,8) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.51208322493305423318026517606316030941);
    rslt(5,2) = static_cast<FP>(0.34520419133869366357810923069868274209);
    rslt(5,3) = static_cast<FP>(0.12409774497260276036930653260689464370);
    rslt(5,4) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,5) = -static_cast<FP>(0.22356029223499249887478659650908833144);
    rslt(5,6) = -static_cast<FP>(0.27702715524496009151643309101563403654);
    rslt(5,7) = -static_cast<FP>(0.27838516860015104127372841955765964119);
    rslt(5,8) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.80254939820619865380510309509567092831);
    rslt(6,2) = static_cast<FP>(0.94356866595879028378534322705460429338);
    rslt(6,3) = static_cast<FP>(1.0839334962833890148219332015794367813);
    rslt(6,4) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,5) = static_cast<FP>(1.0839334962833890148219332015794367813);
    rslt(6,6) = static_cast<FP>(0.94356866595879028378534322705460429338);
    rslt(6,7) = static_cast<FP>(0.80254939820619865380510309509567092831);
    rslt(6,8) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27838516860015104127372841955765964119);
    rslt(7,2) = -static_cast<FP>(0.27702715524496009151643309101563403654);
    rslt(7,3) = -static_cast<FP>(0.22356029223499249887478659650908833144);
    rslt(7,4) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,5) = static_cast<FP>(0.12409774497260276036930653260689464370);
    rslt(7,6) = static_cast<FP>(0.34520419133869366357810923069868274209);
    rslt(7,7) = static_cast<FP>(0.51208322493305423318026517606316030941);
    rslt(7,8) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10625037912648962254385213347435730915);
    rslt(8,2) = static_cast<FP>(0.10039978256396891667613071949235002524);
    rslt(8,3) = static_cast<FP>(0.072814464539604317516977292600634461370);
    rslt(8,4) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,5) = -static_cast<FP>(0.053963740972382256759867786024000049445);
    rslt(8,6) = -static_cast<FP>(0.11473359597948896385093950199620113807);
    rslt(8,7) = -static_cast<FP>(0.15023729930876532995966379702903221494);
    rslt(8,8) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033779564613218251858575880681524215110);
    rslt(9,2) = -static_cast<FP>(0.031149359781578043820996357405750364979);
    rslt(9,3) = -static_cast<FP>(0.021485762870818684372848522071134545189);
    rslt(9,4) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,5) = static_cast<FP>(0.017562996469749673244470224065633175817);
    rslt(9,6) = static_cast<FP>(0.034211206077099533899157567359336034371);
    rslt(9,7) = static_cast<FP>(0.042918645374826518623474491196924006689);
    rslt(9,8) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0078721967541300963250304000011514541500);
    rslt(10,2) = static_cast<FP>(0.0071580735097976870147516857967470670785);
    rslt(10,3) = static_cast<FP>(0.0047975470791327771924548226782213425965);
    rslt(10,4) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,5) = -static_cast<FP>(0.0041216096187692341476581140866693885373);
    rslt(10,6) = -static_cast<FP>(0.0076911176586464462035352104491916607754);
    rslt(10,7) = -static_cast<FP>(0.0094460272694674955152242758401545874582);
    rslt(10,8) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011691706247494881289081086379337368525);
    rslt(11,2) = -static_cast<FP>(0.0010535230616179454889102047190550340478);
    rslt(11,3) = -static_cast<FP>(0.00069315362546873216364207737928284834535);
    rslt(11,4) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,5) = static_cast<FP>(0.00061368432106574960629149269084355919745);
    rslt(11,6) = static_cast<FP>(0.0011165088381039269839900757709909414972);
    rslt(11,7) = static_cast<FP>(0.0013541514663863252837470777846457805031);
    rslt(11,8) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000082315884498770315580508797521471095767);
    rslt(12,2) = static_cast<FP>(0.000073706898438296135772159452667014630892);
    rslt(12,3) = static_cast<FP>(0.000047874097885429090034704858735318087922);
    rslt(12,4) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,5) = -static_cast<FP>(0.000043248440998315522665175010224119111160);
    rslt(12,6) = -static_cast<FP>(0.000077383458600817192440300039545883871713);
    rslt(12,7) = -static_cast<FP>(0.000093081329232613340952400667126863757742);
    rslt(12,8) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,10> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000094039085343906598018836500249487429608);
    rslt(0,2) = -static_cast<FP>(0.000082573468564782118400264595306910140746);
    rslt(0,3) = -static_cast<FP>(0.000056965562267477212890070883990417038898);
    rslt(0,4) = -static_cast<FP>(0.000017675596280346661863458951785728341553);
    rslt(0,5) = static_cast<FP>(0.000025327252110832949682740567126265622801);
    rslt(0,6) = static_cast<FP>(0.000058958366927780639923068396580175169157);
    rslt(0,7) = static_cast<FP>(0.000076964741400952691911633379395345834827);
    rslt(0,8) = static_cast<FP>(0.000082647782287110041998904507684728696410);
    rslt(0,9) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0013690487808907514414843160260817324362);
    rslt(1,2) = static_cast<FP>(0.0011942420772170071815613229714998134938);
    rslt(1,3) = static_cast<FP>(0.00081445008602577585636563550855002400580);
    rslt(1,4) = static_cast<FP>(0.00024257044800120104512659901646198074030);
    rslt(1,5) = -static_cast<FP>(0.00037387810598309302256166807263502396643);
    rslt(1,6) = -static_cast<FP>(0.00084878235827603722049630696347536294719);
    rslt(1,7) = -static_cast<FP>(0.0010980442679991193366693542774579677501);
    rslt(1,8) = -static_cast<FP>(0.0011732753798936932417879067249786559114);
    rslt(1,9) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0095602091118191983584945596154773573356);
    rslt(2,2) = -static_cast<FP>(0.0082564402925144919263597496552353439523);
    rslt(2,3) = -static_cast<FP>(0.0055333454168807016495087726862471616589);
    rslt(2,4) = -static_cast<FP>(0.0015446200082784825518771224852622344587);
    rslt(2,5) = static_cast<FP>(0.0026592361505715986561485199433224351425);
    rslt(2,6) = static_cast<FP>(0.0058268073236196935946356727398397261702);
    rslt(2,7) = static_cast<FP>(0.0074406477391253215221871817626869145917);
    rslt(2,8) = static_cast<FP>(0.0078939693278300266075382909629374079432);
    rslt(2,9) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.043516846949977156851872573811728593862);
    rslt(3,2) = static_cast<FP>(0.036950625190272637499235770794422032823);
    rslt(3,3) = static_cast<FP>(0.024046470717619541023178426323698766775);
    rslt(3,4) = static_cast<FP>(0.0059659714032116553359220135186548978749);
    rslt(3,5) = -static_cast<FP>(0.012408410089601483206303351364227725566);
    rslt(3,6) = -static_cast<FP>(0.025766489408865631038310831835652855620);
    rslt(3,7) = -static_cast<FP>(0.032244845763806087006144427393073240214);
    rslt(3,8) = -static_cast<FP>(0.033834207838564200077086032327123392026);
    rslt(3,9) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.15289990385498396127252514378474426135);
    rslt(4,2) = -static_cast<FP>(0.12544869742766312698096048842254521243);
    rslt(4,3) = -static_cast<FP>(0.076950067528107178045668827829761108158);
    rslt(4,4) = -static_cast<FP>(0.014377918992643760652752024804655648446);
    rslt(4,5) = static_cast<FP>(0.045027413462003040727214752065094243016);
    rslt(4,6) = static_cast<FP>(0.085417157609492773921764647000390914951);
    rslt(4,7) = static_cast<FP>(0.10317953488220317074678326682974209181);
    rslt(4,8) = static_cast<FP>(0.10621173295401060831089326409986536066);
    rslt(4,9) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.52696955812990703298476778638632958445);
    rslt(5,2) = static_cast<FP>(0.39101439586161933432038721694576856319);
    rslt(5,3) = static_cast<FP>(0.20177537571123025186948056255169011182);
    rslt(5,4) = static_cast<FP>(0.0021857461056967013864445880715787919334);
    rslt(5,5) = -static_cast<FP>(0.15813245211417693022286118538068550594);
    rslt(5,6) = -static_cast<FP>(0.25030266140540044642065306402383223596);
    rslt(5,7) = -static_cast<FP>(0.28032673810890265518541851370134925249);
    rslt(5,8) = -static_cast<FP>(0.27713271936614821859753627598346518511);
    rslt(5,9) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.78865055071185049190689361914141093110);
    rslt(6,2) = static_cast<FP>(0.90760092883761183859188640536145316524);
    rslt(6,3) = static_cast<FP>(1.0415190918648816546821798617022094225);
    rslt(6,4) = static_cast<FP>(1.1307486900853690662176795978770132524);
    rslt(6,5) = static_cast<FP>(1.1307486900853690662176795978770132524);
    rslt(6,6) = static_cast<FP>(1.0415190918648816546821798617022094225);
    rslt(6,7) = static_cast<FP>(0.90760092883761183859188640536145316524);
    rslt(6,8) = static_cast<FP>(0.78865055071185049190689361914141093110);
    rslt(6,9) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27713271936614821859753627598346518511);
    rslt(7,2) = -static_cast<FP>(0.28032673810890265518541851370134925249);
    rslt(7,3) = -static_cast<FP>(0.25030266140540044642065306402383223596);
    rslt(7,4) = -static_cast<FP>(0.15813245211417693022286118538068550594);
    rslt(7,5) = static_cast<FP>(0.0021857461056967013864445880715787919334);
    rslt(7,6) = static_cast<FP>(0.20177537571123025186948056255169011182);
    rslt(7,7) = static_cast<FP>(0.39101439586161933432038721694576856319);
    rslt(7,8) = static_cast<FP>(0.52696955812990703298476778638632958445);
    rslt(7,9) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10621173295401060831089326409986536066);
    rslt(8,2) = static_cast<FP>(0.10317953488220317074678326682974209181);
    rslt(8,3) = static_cast<FP>(0.085417157609492773921764647000390914951);
    rslt(8,4) = static_cast<FP>(0.045027413462003040727214752065094243016);
    rslt(8,5) = -static_cast<FP>(0.014377918992643760652752024804655648446);
    rslt(8,6) = -static_cast<FP>(0.076950067528107178045668827829761108158);
    rslt(8,7) = -static_cast<FP>(0.12544869742766312698096048842254521243);
    rslt(8,8) = -static_cast<FP>(0.15289990385498396127252514378474426135);
    rslt(8,9) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033834207838564200077086032327123392027);
    rslt(9,2) = -static_cast<FP>(0.032244845763806087006144427393073240214);
    rslt(9,3) = -static_cast<FP>(0.025766489408865631038310831835652855620);
    rslt(9,4) = -static_cast<FP>(0.012408410089601483206303351364227725566);
    rslt(9,5) = static_cast<FP>(0.0059659714032116553359220135186548978748);
    rslt(9,6) = static_cast<FP>(0.024046470717619541023178426323698766775);
    rslt(9,7) = static_cast<FP>(0.036950625190272637499235770794422032824);
    rslt(9,8) = static_cast<FP>(0.043516846949977156851872573811728593862);
    rslt(9,9) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0078939693278300266075382909629374079432);
    rslt(10,2) = static_cast<FP>(0.0074406477391253215221871817626869145917);
    rslt(10,3) = static_cast<FP>(0.0058268073236196935946356727398397261703);
    rslt(10,4) = static_cast<FP>(0.0026592361505715986561485199433224351425);
    rslt(10,5) = -static_cast<FP>(0.0015446200082784825518771224852622344587);
    rslt(10,6) = -static_cast<FP>(0.0055333454168807016495087726862471616589);
    rslt(10,7) = -static_cast<FP>(0.0082564402925144919263597496552353439524);
    rslt(10,8) = -static_cast<FP>(0.0095602091118191983584945596154773573356);
    rslt(10,9) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011732753798936932417879067249786559114);
    rslt(11,2) = -static_cast<FP>(0.0010980442679991193366693542774579677501);
    rslt(11,3) = -static_cast<FP>(0.00084878235827603722049630696347536294719);
    rslt(11,4) = -static_cast<FP>(0.00037387810598309302256166807263502396643);
    rslt(11,5) = static_cast<FP>(0.00024257044800120104512659901646198074030);
    rslt(11,6) = static_cast<FP>(0.00081445008602577585636563550855002400580);
    rslt(11,7) = static_cast<FP>(0.0011942420772170071815613229714998134938);
    rslt(11,8) = static_cast<FP>(0.0013690487808907514414843160260817324362);
    rslt(11,9) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000082647782287110041998904507684728696410);
    rslt(12,2) = static_cast<FP>(0.000076964741400952691911633379395345834827);
    rslt(12,3) = static_cast<FP>(0.000058958366927780639923068396580175169157);
    rslt(12,4) = static_cast<FP>(0.000025327252110832949682740567126265622801);
    rslt(12,5) = -static_cast<FP>(0.000017675596280346661863458951785728341553);
    rslt(12,6) = -static_cast<FP>(0.000056965562267477212890070883990417038898);
    rslt(12,7) = -static_cast<FP>(0.000082573468564782118400264595306910140746);
    rslt(12,8) = -static_cast<FP>(0.000094039085343906598018836500249487429608);
    rslt(12,9) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,11> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000094690779168080470205122071213885805727);
    rslt(0,2) = -static_cast<FP>(0.000086025948136910594122962314983595674202);
    rslt(0,3) = -static_cast<FP>(0.000066525994607024944670374000757729401795);
    rslt(0,4) = -static_cast<FP>(0.000034742670551181933814069651916963823321);
    rslt(0,5) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,6) = static_cast<FP>(0.000040630470209457746599565697696428793714);
    rslt(0,7) = static_cast<FP>(0.000066174771896811173314639416766544432001);
    rslt(0,8) = static_cast<FP>(0.000078956965438507059378544702022186961288);
    rslt(0,9) = static_cast<FP>(0.000082844757887253334568123988677408272069);
    rslt(0,10) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0013792456751979696240385905649040438602);
    rslt(1,2) = static_cast<FP>(0.0012463028523453848483962504631676764653);
    rslt(1,3) = static_cast<FP>(0.00095529697394586690468448681423807125356);
    rslt(1,4) = static_cast<FP>(0.00048983155203121496262244297588304477562);
    rslt(1,5) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,6) = -static_cast<FP>(0.00059092741132530989040228304164416617822);
    rslt(1,7) = -static_cast<FP>(0.00094941459038441882761652827981978273453);
    rslt(1,8) = -static_cast<FP>(0.0011249867736385768262737729640360368282);
    rslt(1,9) = -static_cast<FP>(0.0011756281582010379321971524577222238869);
    rslt(1,10) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0096389803007430859674193722144701941616);
    rslt(2,2) = -static_cast<FP>(0.0086387452226061916030211081775128190114);
    rslt(2,3) = -static_cast<FP>(0.0065333397313119080417686025415143700098);
    rslt(2,4) = -static_cast<FP>(0.0032573024350604594016329915772922596743);
    rslt(2,5) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,6) = static_cast<FP>(0.0041163253176663869065190616715640057570);
    rslt(2,7) = static_cast<FP>(0.0064855970161047789599359689675841756844);
    rslt(2,8) = static_cast<FP>(0.0076088382191378680068966594703712640403);
    rslt(2,9) = static_cast<FP>(0.0079055345828123967531465754230460733080);
    rslt(2,10) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.043934076426460846621099269838048076527);
    rslt(3,2) = static_cast<FP>(0.038831199551634939424413662033456933812);
    rslt(3,3) = static_cast<FP>(0.028710892380150734444652948409958133767);
    rslt(3,4) = static_cast<FP>(0.013642165161528216242757693866911888252);
    rslt(3,5) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,6) = -static_cast<FP>(0.018617370560384991287902217340490695946);
    rslt(3,7) = -static_cast<FP>(0.028460714549773978019937887168968304524);
    rslt(3,8) = -static_cast<FP>(0.032877320077837257060174484600219046828);
    rslt(3,9) = -static_cast<FP>(0.033855623409037093340726494913876992372);
    rslt(3,10) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.15478799557157795840923224561035440156);
    rslt(4,2) = -static_cast<FP>(0.13300075763404700771167924852108076134);
    rslt(4,3) = -static_cast<FP>(0.093972055868148605603096357172006040960);
    rslt(4,4) = -static_cast<FP>(0.040379737768948109359841621561181242120);
    rslt(4,5) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,6) = static_cast<FP>(0.064168410756517608611221566058665416375);
    rslt(4,7) = static_cast<FP>(0.093091147363851585381885890542867544168);
    rslt(4,8) = static_cast<FP>(0.10466793960399490366329216683201820270);
    rslt(4,9) = static_cast<FP>(0.10612653165089002731147405019615764853);
    rslt(4,10) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.53784841862689393536924162578805522939);
    rslt(5,2) = static_cast<FP>(0.42527202631902908754159409942487371515);
    rslt(5,3) = static_cast<FP>(0.26350927737140164139561484175198691804);
    rslt(5,4) = static_cast<FP>(0.080733912143937481629825221898021553041);
    rslt(5,5) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,6) = -static_cast<FP>(0.20400580057341262648624357250446212849);
    rslt(5,7) = -static_cast<FP>(0.26506836556796544246928242275110732533);
    rslt(5,8) = -static_cast<FP>(0.28130532921871929105312319499207778432);
    rslt(5,9) = -static_cast<FP>(0.27608115510513667928255529141516697697);
    rslt(5,10) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.77835742160372150638876744288391619486);
    rslt(6,2) = static_cast<FP>(0.87932790136340454430442338864400006488);
    rslt(6,3) = static_cast<FP>(1.0022320304248399596462833960107721656);
    rslt(6,4) = static_cast<FP>(1.1036946060177923122602912035082451192);
    rslt(6,5) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,6) = static_cast<FP>(1.1036946060177923122602912035082451192);
    rslt(6,7) = static_cast<FP>(1.0022320304248399596462833960107721656);
    rslt(6,8) = static_cast<FP>(0.87932790136340454430442338864400006488);
    rslt(6,9) = static_cast<FP>(0.77835742160372150638876744288391619486);
    rslt(6,10) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27608115510513667928255529141516697697);
    rslt(7,2) = -static_cast<FP>(0.28130532921871929105312319499207778431);
    rslt(7,3) = -static_cast<FP>(0.26506836556796544246928242275110732533);
    rslt(7,4) = -static_cast<FP>(0.20400580057341262648624357250446212849);
    rslt(7,5) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,6) = static_cast<FP>(0.080733912143937481629825221898021553041);
    rslt(7,7) = static_cast<FP>(0.26350927737140164139561484175198691804);
    rslt(7,8) = static_cast<FP>(0.42527202631902908754159409942487371515);
    rslt(7,9) = static_cast<FP>(0.53784841862689393536924162578805522939);
    rslt(7,10) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10612653165089002731147405019615764853);
    rslt(8,2) = static_cast<FP>(0.10466793960399490366329216683201820270);
    rslt(8,3) = static_cast<FP>(0.093091147363851585381885890542867544168);
    rslt(8,4) = static_cast<FP>(0.064168410756517608611221566058665416375);
    rslt(8,5) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,6) = -static_cast<FP>(0.040379737768948109359841621561181242121);
    rslt(8,7) = -static_cast<FP>(0.093972055868148605603096357172006040960);
    rslt(8,8) = -static_cast<FP>(0.13300075763404700771167924852108076134);
    rslt(8,9) = -static_cast<FP>(0.15478799557157795840923224561035440156);
    rslt(8,10) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033855623409037093340726494913876992371);
    rslt(9,2) = -static_cast<FP>(0.032877320077837257060174484600219046827);
    rslt(9,3) = -static_cast<FP>(0.028460714549773978019937887168968304524);
    rslt(9,4) = -static_cast<FP>(0.018617370560384991287902217340490695946);
    rslt(9,5) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,6) = static_cast<FP>(0.013642165161528216242757693866911888252);
    rslt(9,7) = static_cast<FP>(0.028710892380150734444652948409958133768);
    rslt(9,8) = static_cast<FP>(0.038831199551634939424413662033456933812);
    rslt(9,9) = static_cast<FP>(0.043934076426460846621099269838048076528);
    rslt(9,10) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0079055345828123967531465754230460733080);
    rslt(10,2) = static_cast<FP>(0.0076088382191378680068966594703712640403);
    rslt(10,3) = static_cast<FP>(0.0064855970161047789599359689675841756844);
    rslt(10,4) = static_cast<FP>(0.0041163253176663869065190616715640057570);
    rslt(10,5) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,6) = -static_cast<FP>(0.0032573024350604594016329915772922596743);
    rslt(10,7) = -static_cast<FP>(0.0065333397313119080417686025415143700098);
    rslt(10,8) = -static_cast<FP>(0.0086387452226061916030211081775128190114);
    rslt(10,9) = -static_cast<FP>(0.0096389803007430859674193722144701941616);
    rslt(10,10) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011756281582010379321971524577222238869);
    rslt(11,2) = -static_cast<FP>(0.0011249867736385768262737729640360368282);
    rslt(11,3) = -static_cast<FP>(0.00094941459038441882761652827981978273453);
    rslt(11,4) = -static_cast<FP>(0.00059092741132530989040228304164416617822);
    rslt(11,5) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,6) = static_cast<FP>(0.00048983155203121496262244297588304477562);
    rslt(11,7) = static_cast<FP>(0.00095529697394586690468448681423807125357);
    rslt(11,8) = static_cast<FP>(0.0012463028523453848483962504631676764653);
    rslt(11,9) = static_cast<FP>(0.0013792456751979696240385905649040438602);
    rslt(11,10) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000082844757887253334568123988677408272069);
    rslt(12,2) = static_cast<FP>(0.000078956965438507059378544702022186961288);
    rslt(12,3) = static_cast<FP>(0.000066174771896811173314639416766544432001);
    rslt(12,4) = static_cast<FP>(0.000040630470209457746599565697696428793714);
    rslt(12,5) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,6) = -static_cast<FP>(0.000034742670551181933814069651916963823321);
    rslt(12,7) = -static_cast<FP>(0.000066525994607024944670374000757729401795);
    rslt(12,8) = -static_cast<FP>(0.000086025948136910594122962314983595674202);
    rslt(12,9) = -static_cast<FP>(0.000094690779168080470205122071213885805727);
    rslt(12,10) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,12> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000095154020352830276832535819383591335592);
    rslt(0,2) = -static_cast<FP>(0.000088412091128130739724930128883301471846);
    rslt(0,3) = -static_cast<FP>(0.000073293344748680473593169765978769002302);
    rslt(0,4) = -static_cast<FP>(0.000047719061507328140316245470377984464123);
    rslt(0,5) = -static_cast<FP>(0.000013861739999834897356074435703019423935);
    rslt(0,6) = static_cast<FP>(0.000021772711582915059697112183303228517821);
    rslt(0,7) = static_cast<FP>(0.000051571707204175924892110557751431591147);
    rslt(0,8) = static_cast<FP>(0.000070967760468809426080559304826845732735);
    rslt(0,9) = static_cast<FP>(0.000080224663999449079533193982098409904348);
    rslt(0,10) = static_cast<FP>(0.000082967503559890435631465909834557217576);
    rslt(0,11) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0013865299745636326936898739994201891146);
    rslt(1,2) = static_cast<FP>(0.0012825062488341597597362224821177860181);
    rslt(1,3) = static_cast<FP>(0.0010555885902294442102790379105053958605);
    rslt(1,4) = static_cast<FP>(0.00067896760093042455185020207741075343132);
    rslt(1,5) = static_cast<FP>(0.00018752745998741992039376068119321046779);
    rslt(1,6) = -static_cast<FP>(0.00032327565664649096973142921404889688582);
    rslt(1,7) = -static_cast<FP>(0.00074518797317521732297804968738859176425);
    rslt(1,8) = -static_cast<FP>(0.0010158100963627609245631263861057532374);
    rslt(1,9) = -static_cast<FP>(0.0011419400151547404694517646766120035194);
    rslt(1,10) = -static_cast<FP>(0.0011770371434717024419675907068628227956);
    rslt(1,11) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0096956190137986011125178597783826867450);
    rslt(2,2) = -static_cast<FP>(0.0089069279202754040806536674686599715570);
    rslt(2,3) = -static_cast<FP>(0.0072516138764524295035562435850040466320);
    rslt(2,4) = -static_cast<FP>(0.0045791172798026520507305154819192361259);
    rslt(2,5) = -static_cast<FP>(0.0011655055311600223567443761819843568629);
    rslt(2,6) = static_cast<FP>(0.0023176724761955047153592384844664498448);
    rslt(2,7) = static_cast<FP>(0.0051428390334481748447517319372062059604);
    rslt(2,8) = static_cast<FP>(0.0069159216935600599394759820650820942808);
    rslt(2,9) = static_cast<FP>(0.0077127535791793033639484599644010368258);
    rslt(2,10) = static_cast<FP>(0.0079118111036377882515822631584047148350);
    rslt(2,11) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.044236768677148119781160425554177224537);
    rslt(3,2) = static_cast<FP>(0.040168019181617217594863056216655095642);
    rslt(3,3) = static_cast<FP>(0.032108185409713978057097682177926105803);
    rslt(3,4) = static_cast<FP>(0.019652650590675444074322170861282459011);
    rslt(3,5) = static_cast<FP>(0.0042822665248871612817154380745955170674);
    rslt(3,6) = -static_cast<FP>(0.010940075923178174695447287140159087647);
    rslt(3,7) = -static_cast<FP>(0.022929741815412297882218560573771939214);
    rslt(3,8) = -static_cast<FP>(0.030191156178604556251686780319031298007);
    rslt(3,9) = -static_cast<FP>(0.033254540426492213484653342018714099749);
    rslt(3,10) = -static_cast<FP>(0.033861413231685706857331047010883242941);
    rslt(3,11) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.15617599336641138174107305787755453976);
    rslt(4,2) = -static_cast<FP>(0.13849257521898302718951823119519539587);
    rslt(4,3) = -static_cast<FP>(0.10669180469143466484752163147136868472);
    rslt(4,4) = -static_cast<FP>(0.061296533733959397514761439173720469803);
    rslt(4,5) = -static_cast<FP>(0.0087716431008075603927773463769631767769);
    rslt(4,6) = static_cast<FP>(0.040426019858254607320852421479403458410);
    rslt(4,7) = static_cast<FP>(0.077110565444404418619838330896602616885);
    rslt(4,8) = static_cast<FP>(0.097852654998189356694594697205556671610);
    rslt(4,9) = static_cast<FP>(0.10547250963809339218577322748684412872);
    rslt(4,10) = static_cast<FP>(0.10603072138125408616553564955238293394);
    rslt(4,11) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.54603483427655180570306707784724708555);
    rslt(5,2) = static_cast<FP>(0.45144405991255923416668092533218654843);
    rslt(5,3) = static_cast<FP>(0.31258553942553386295664524831835482448);
    rslt(5,4) = static_cast<FP>(0.14825157683163523968905147012997947105);
    rslt(5,5) = -static_cast<FP>(0.014048686467311240423972991405617804045);
    rslt(5,6) = -static_cast<FP>(0.14664595462445239893188290824756438644);
    rslt(5,7) = -static_cast<FP>(0.23294370678424775544173863851026849662);
    rslt(5,8) = -static_cast<FP>(0.27322214718308278752839690430857411245);
    rslt(5,9) = -static_cast<FP>(0.28122640700790845806769090678872159903);
    rslt(5,10) = -static_cast<FP>(0.27521429962676396795136316706009925432);
    rslt(5,11) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.77053588348576886735041850223169943270);
    rslt(6,2) = static_cast<FP>(0.85695072945565921788115775681248336566);
    rslt(6,3) = static_cast<FP>(0.96785696749299036824514464885381072629);
    rslt(6,4) = static_cast<FP>(1.0716538354398067706480374324372137801);
    rslt(6,5) = static_cast<FP>(1.1346737440126481143698944420990788638);
    rslt(6,6) = static_cast<FP>(1.1346737440126481143698944420990788638);
    rslt(6,7) = static_cast<FP>(1.0716538354398067706480374324372137801);
    rslt(6,8) = static_cast<FP>(0.96785696749299036824514464885381072629);
    rslt(6,9) = static_cast<FP>(0.85695072945565921788115775681248336566);
    rslt(6,10) = static_cast<FP>(0.77053588348576886735041850223169943270);
    rslt(6,11) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27521429962676396795136316706009925432);
    rslt(7,2) = -static_cast<FP>(0.28122640700790845806769090678872159903);
    rslt(7,3) = -static_cast<FP>(0.27322214718308278752839690430857411245);
    rslt(7,4) = -static_cast<FP>(0.23294370678424775544173863851026849662);
    rslt(7,5) = -static_cast<FP>(0.14664595462445239893188290824756438644);
    rslt(7,6) = -static_cast<FP>(0.014048686467311240423972991405617804045);
    rslt(7,7) = static_cast<FP>(0.14825157683163523968905147012997947104);
    rslt(7,8) = static_cast<FP>(0.31258553942553386295664524831835482448);
    rslt(7,9) = static_cast<FP>(0.45144405991255923416668092533218654843);
    rslt(7,10) = static_cast<FP>(0.54603483427655180570306707784724708556);
    rslt(7,11) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10603072138125408616553564955238293394);
    rslt(8,2) = static_cast<FP>(0.10547250963809339218577322748684412872);
    rslt(8,3) = static_cast<FP>(0.097852654998189356694594697205556671610);
    rslt(8,4) = static_cast<FP>(0.077110565444404418619838330896602616885);
    rslt(8,5) = static_cast<FP>(0.040426019858254607320852421479403458410);
    rslt(8,6) = -static_cast<FP>(0.0087716431008075603927773463769631767768);
    rslt(8,7) = -static_cast<FP>(0.061296533733959397514761439173720469803);
    rslt(8,8) = -static_cast<FP>(0.10669180469143466484752163147136868472);
    rslt(8,9) = -static_cast<FP>(0.13849257521898302718951823119519539587);
    rslt(8,10) = -static_cast<FP>(0.15617599336641138174107305787755453977);
    rslt(8,11) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033861413231685706857331047010883242941);
    rslt(9,2) = -static_cast<FP>(0.033254540426492213484653342018714099749);
    rslt(9,3) = -static_cast<FP>(0.030191156178604556251686780319031298007);
    rslt(9,4) = -static_cast<FP>(0.022929741815412297882218560573771939214);
    rslt(9,5) = -static_cast<FP>(0.010940075923178174695447287140159087647);
    rslt(9,6) = static_cast<FP>(0.0042822665248871612817154380745955170674);
    rslt(9,7) = static_cast<FP>(0.019652650590675444074322170861282459011);
    rslt(9,8) = static_cast<FP>(0.032108185409713978057097682177926105803);
    rslt(9,9) = static_cast<FP>(0.040168019181617217594863056216655095642);
    rslt(9,10) = static_cast<FP>(0.044236768677148119781160425554177224537);
    rslt(9,11) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0079118111036377882515822631584047148350);
    rslt(10,2) = static_cast<FP>(0.0077127535791793033639484599644010368258);
    rslt(10,3) = static_cast<FP>(0.0069159216935600599394759820650820942808);
    rslt(10,4) = static_cast<FP>(0.0051428390334481748447517319372062059604);
    rslt(10,5) = static_cast<FP>(0.0023176724761955047153592384844664498448);
    rslt(10,6) = -static_cast<FP>(0.0011655055311600223567443761819843568629);
    rslt(10,7) = -static_cast<FP>(0.0045791172798026520507305154819192361259);
    rslt(10,8) = -static_cast<FP>(0.0072516138764524295035562435850040466320);
    rslt(10,9) = -static_cast<FP>(0.0089069279202754040806536674686599715569);
    rslt(10,10) = -static_cast<FP>(0.0096956190137986011125178597783826867450);
    rslt(10,11) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011770371434717024419675907068628227956);
    rslt(11,2) = -static_cast<FP>(0.0011419400151547404694517646766120035194);
    rslt(11,3) = -static_cast<FP>(0.0010158100963627609245631263861057532374);
    rslt(11,4) = -static_cast<FP>(0.00074518797317521732297804968738859176425);
    rslt(11,5) = -static_cast<FP>(0.00032327565664649096973142921404889688582);
    rslt(11,6) = static_cast<FP>(0.00018752745998741992039376068119321046779);
    rslt(11,7) = static_cast<FP>(0.00067896760093042455185020207741075343132);
    rslt(11,8) = static_cast<FP>(0.0010555885902294442102790379105053958605);
    rslt(11,9) = static_cast<FP>(0.0012825062488341597597362224821177860181);
    rslt(11,10) = static_cast<FP>(0.0013865299745636326936898739994201891146);
    rslt(11,11) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000082967503559890435631465909834557217576);
    rslt(12,2) = static_cast<FP>(0.000080224663999449079533193982098409904348);
    rslt(12,3) = static_cast<FP>(0.000070967760468809426080559304826845732735);
    rslt(12,4) = static_cast<FP>(0.000051571707204175924892110557751431591147);
    rslt(12,5) = static_cast<FP>(0.000021772711582915059697112183303228517821);
    rslt(12,6) = -static_cast<FP>(0.000013861739999834897356074435703019423935);
    rslt(12,7) = -static_cast<FP>(0.000047719061507328140316245470377984464123);
    rslt(12,8) = -static_cast<FP>(0.000073293344748680473593169765978769002301);
    rslt(12,9) = -static_cast<FP>(0.000088412091128130739724930128883301471845);
    rslt(12,10) = -static_cast<FP>(0.000095154020352830276832535819383591335592);
    rslt(12,11) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void sten_to_gll_lower(SArray<FP,2,13,13> &rslt) {
    rslt(0,0) = -static_cast<FP>(0.000097125097125097125097125097125097125097);
    rslt(0,1) = -static_cast<FP>(0.000095495146369623504472823661615484300902);
    rslt(0,2) = -static_cast<FP>(0.000090117716048893095181807914434454331678);
    rslt(0,3) = -static_cast<FP>(0.000078178951118477368995327040267000889751);
    rslt(0,4) = -static_cast<FP>(0.000057533826864113452070825587843026538629);
    rslt(0,5) = -static_cast<FP>(0.000028732775374096622835661167479349713835);
    rslt(0,6) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(0,7) = static_cast<FP>(0.000035355764248581121771114106708764667612);
    rslt(0,8) = static_cast<FP>(0.000059400019946327129802476118100660075933);
    rslt(0,9) = static_cast<FP>(0.000074223428799554255010521402435334663242);
    rslt(0,10) = static_cast<FP>(0.000081059915364187115188548507696647721337);
    rslt(0,11) = static_cast<FP>(0.000083047157922766609177005163591128756950);
    rslt(0,12) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(1,0) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(1,1) = static_cast<FP>(0.0013919165061841718338162216029977376050);
    rslt(1,2) = static_cast<FP>(0.0013085300403859443569078453702944966319);
    rslt(1,3) = static_cast<FP>(0.0011283891410126269464484140015681935020);
    rslt(1,4) = static_cast<FP>(0.00082279852130562105352919646125848404977);
    rslt(1,5) = static_cast<FP>(0.00040258049876016726776691808853295209875);
    rslt(1,6) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(1,7) = -static_cast<FP>(0.00051627046935207898843261981206815236197);
    rslt(1,8) = -static_cast<FP>(0.00085495934531959878988847104455845567618);
    rslt(1,9) = -static_cast<FP>(0.0010606098508583029554874204217323622737);
    rslt(1,10) = -static_cast<FP>(0.0011529758762647947645283659871502406268);
    rslt(1,11) = -static_cast<FP>(0.0011779109705275653535844818359208513257);
    rslt(1,12) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(2,0) = -static_cast<FP>(0.0099456099456099456099456099456099456100);
    rslt(2,1) = -static_cast<FP>(0.0097377292961400231529860828634377645948);
    rslt(2,2) = -static_cast<FP>(0.0091012206915541340622968088355813803352);
    rslt(2,3) = -static_cast<FP>(0.0077771608263428605610754469325091642507);
    rslt(2,4) = -static_cast<FP>(0.0055923744728412708665541257430516610093);
    rslt(2,5) = -static_cast<FP>(0.0026510838260158101864674252026276247916);
    rslt(2,6) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(2,7) = static_cast<FP>(0.0036166774274321862936847318854337045701);
    rslt(2,8) = static_cast<FP>(0.0058674235197632372926459551513595106422);
    rslt(2,9) = static_cast<FP>(0.0072033311732027255663337414831244802661);
    rslt(2,10) = static_cast<FP>(0.0077790365422213032458042155123655021821);
    rslt(2,11) = static_cast<FP>(0.0079152245841672724293957023200435910338);
    rslt(2,12) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(3,0) = static_cast<FP>(0.045609945609945609945609945609945609946);
    rslt(3,1) = static_cast<FP>(0.044463475764107785500662097063857885869);
    rslt(3,2) = static_cast<FP>(0.041147967152519926500222802670618176809);
    rslt(3,3) = static_cast<FP>(0.034625449244055933327637201682555968899);
    rslt(3,4) = static_cast<FP>(0.024319986081854374045028298370080792190);
    rslt(3,5) = static_cast<FP>(0.010911574172574862669482661534241796880);
    rslt(3,6) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(3,7) = -static_cast<FP>(0.016498826498290248441902801553572772404);
    rslt(3,8) = -static_cast<FP>(0.025933812834640614979454551621500829420);
    rslt(3,9) = -static_cast<FP>(0.031326751235243778834651041395053364944);
    rslt(3,10) = -static_cast<FP>(0.033485348918504656653265550298518638125);
    rslt(3,11) = -static_cast<FP>(0.033859813978928737748932455119825927001);
    rslt(3,12) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(4,0) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(4,1) = -static_cast<FP>(0.15722671273473595502624852421342631665);
    rslt(4,2) = -static_cast<FP>(0.14259828437993533025745578721977809085);
    rslt(4,3) = -static_cast<FP>(0.11633516284382580914293059496025563327);
    rslt(4,4) = -static_cast<FP>(0.077935941067303624132922126123357194400);
    rslt(4,5) = -static_cast<FP>(0.031044357230229102978271859337477745588);
    rslt(4,6) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(4,7) = static_cast<FP>(0.057698198605605677123665024841500566308);
    rslt(4,8) = static_cast<FP>(0.085900697781688452576257476380378666042);
    rslt(4,9) = static_cast<FP>(0.10086143515805284420803904142901666765);
    rslt(4,10) = static_cast<FP>(0.10590246521406610075239618341553540472);
    rslt(4,11) = static_cast<FP>(0.10593825892616838465278309488305823002);
    rslt(4,12) = static_cast<FP>(0.10513375513375513375513375513375513376);
    rslt(5,0) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(5,1) = static_cast<FP>(0.55234721786099681895555522906264957995);
    rslt(5,2) = static_cast<FP>(0.47183525041209136414678951414037843495);
    rslt(5,3) = static_cast<FP>(0.35186917826528934398744714877696153266);
    rslt(5,4) = static_cast<FP>(0.20524370226089012914798401841569424020);
    rslt(5,5) = static_cast<FP>(0.051892792821431282717912944713018125923);
    rslt(5,6) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(5,7) = -static_cast<FP>(0.18886590330172976154339287506297676219);
    rslt(5,8) = -static_cast<FP>(0.25127509495143173498134704971972153390);
    rslt(5,9) = -static_cast<FP>(0.27765303815978342400799958675417865662);
    rslt(5,10) = -static_cast<FP>(0.28068064802910044173285735090956524727);
    rslt(5,11) = -static_cast<FP>(0.27450171151620908367659968144756480682);
    rslt(5,12) = -static_cast<FP>(0.26986624486624486624486624486624486625);
    rslt(6,0) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(6,1) = static_cast<FP>(0.76446023284336378848143469904559299746);
    rslt(6,2) = static_cast<FP>(0.83905428633475942444827656154813938852);
    rslt(6,3) = static_cast<FP>(0.93846889545675962458022334872833400461);
    rslt(6,4) = static_cast<FP>(1.0394357083129528159569897289431603477);
    rslt(6,5) = static_cast<FP>(1.1150479948109383415670198469667664966);
    rslt(6,6) = static_cast<FP>(1.1431369772813788316718004218004218004);
    rslt(6,7) = static_cast<FP>(1.1150479948109383415670198469667664966);
    rslt(6,8) = static_cast<FP>(1.0394357083129528159569897289431603477);
    rslt(6,9) = static_cast<FP>(0.93846889545675962458022334872833400461);
    rslt(6,10) = static_cast<FP>(0.83905428633475942444827656154813938852);
    rslt(6,11) = static_cast<FP>(0.76446023284336378848143469904559299746);
    rslt(6,12) = static_cast<FP>(0.73013375513375513375513375513375513375);
    rslt(7,0) = -static_cast<FP>(0.26986624486624486624486624486624486624);
    rslt(7,1) = -static_cast<FP>(0.27450171151620908367659968144756480682);
    rslt(7,2) = -static_cast<FP>(0.28068064802910044173285735090956524727);
    rslt(7,3) = -static_cast<FP>(0.27765303815978342400799958675417865662);
    rslt(7,4) = -static_cast<FP>(0.25127509495143173498134704971972153390);
    rslt(7,5) = -static_cast<FP>(0.18886590330172976154339287506297676219);
    rslt(7,6) = -static_cast<FP>(0.085469246778679762078199578199578199578);
    rslt(7,7) = static_cast<FP>(0.051892792821431282717912944713018125923);
    rslt(7,8) = static_cast<FP>(0.20524370226089012914798401841569424020);
    rslt(7,9) = static_cast<FP>(0.35186917826528934398744714877696153266);
    rslt(7,10) = static_cast<FP>(0.47183525041209136414678951414037843495);
    rslt(7,11) = static_cast<FP>(0.55234721786099681895555522906264957995);
    rslt(7,12) = static_cast<FP>(0.58727661227661227661227661227661227661);
    rslt(8,0) = static_cast<FP>(0.10513375513375513375513375513375513375);
    rslt(8,1) = static_cast<FP>(0.10593825892616838465278309488305823002);
    rslt(8,2) = static_cast<FP>(0.10590246521406610075239618341553540472);
    rslt(8,3) = static_cast<FP>(0.10086143515805284420803904142901666765);
    rslt(8,4) = static_cast<FP>(0.085900697781688452576257476380378666042);
    rslt(8,5) = static_cast<FP>(0.057698198605605677123665024841500566308);
    rslt(8,6) = static_cast<FP>(0.016914605226325120734300421800421800422);
    rslt(8,7) = -static_cast<FP>(0.031044357230229102978271859337477745588);
    rslt(8,8) = -static_cast<FP>(0.077935941067303624132922126123357194401);
    rslt(8,9) = -static_cast<FP>(0.11633516284382580914293059496025563327);
    rslt(8,10) = -static_cast<FP>(0.14259828437993533025745578721977809085);
    rslt(8,11) = -static_cast<FP>(0.15722671273473595502624852421342631665);
    rslt(8,12) = -static_cast<FP>(0.16272338772338772338772338772338772339);
    rslt(9,0) = -static_cast<FP>(0.033755133755133755133755133755133755134);
    rslt(9,1) = -static_cast<FP>(0.033859813978928737748932455119825927001);
    rslt(9,2) = -static_cast<FP>(0.033485348918504656653265550298518638125);
    rslt(9,3) = -static_cast<FP>(0.031326751235243778834651041395053364944);
    rslt(9,4) = -static_cast<FP>(0.025933812834640614979454551621500829420);
    rslt(9,5) = -static_cast<FP>(0.016498826498290248441902801553572772404);
    rslt(9,6) = -static_cast<FP>(0.0035621651746758558281995781995781995782);
    rslt(9,7) = static_cast<FP>(0.010911574172574862669482661534241796880);
    rslt(9,8) = static_cast<FP>(0.024319986081854374045028298370080792190);
    rslt(9,9) = static_cast<FP>(0.034625449244055933327637201682555968899);
    rslt(9,10) = static_cast<FP>(0.041147967152519926500222802670618176809);
    rslt(9,11) = static_cast<FP>(0.044463475764107785500662097063857885869);
    rslt(9,12) = static_cast<FP>(0.045609945609945609945609945609945609945);
    rslt(10,0) = static_cast<FP>(0.0079115329115329115329115329115329115329);
    rslt(10,1) = static_cast<FP>(0.0079152245841672724293957023200435910338);
    rslt(10,2) = static_cast<FP>(0.0077790365422213032458042155123655021821);
    rslt(10,3) = static_cast<FP>(0.0072033311732027255663337414831244802661);
    rslt(10,4) = static_cast<FP>(0.0058674235197632372926459551513595106422);
    rslt(10,5) = static_cast<FP>(0.0036166774274321862936847318854337045701);
    rslt(10,6) = static_cast<FP>(0.00061676756022230265394327894327894327894);
    rslt(10,7) = -static_cast<FP>(0.0026510838260158101864674252026276247916);
    rslt(10,8) = -static_cast<FP>(0.0055923744728412708665541257430516610093);
    rslt(10,9) = -static_cast<FP>(0.0077771608263428605610754469325091642508);
    rslt(10,10) = -static_cast<FP>(0.0091012206915541340622968088355813803352);
    rslt(10,11) = -static_cast<FP>(0.0097377292961400231529860828634377645947);
    rslt(10,12) = -static_cast<FP>(0.0099456099456099456099456099456099456099);
    rslt(11,0) = -static_cast<FP>(0.0011793761793761793761793761793761793762);
    rslt(11,1) = -static_cast<FP>(0.0011779109705275653535844818359208513257);
    rslt(11,2) = -static_cast<FP>(0.0011529758762647947645283659871502406268);
    rslt(11,3) = -static_cast<FP>(0.0010606098508583029554874204217323622737);
    rslt(11,4) = -static_cast<FP>(0.00085495934531959878988847104455845567618);
    rslt(11,5) = -static_cast<FP>(0.00051627046935207898843261981206815236197);
    rslt(11,6) = -static_cast<FP>(0.000072685988632949082167832167832167832168);
    rslt(11,7) = static_cast<FP>(0.00040258049876016726776691808853295209875);
    rslt(11,8) = static_cast<FP>(0.00082279852130562105352919646125848404977);
    rslt(11,9) = static_cast<FP>(0.0011283891410126269464484140015681935020);
    rslt(11,10) = static_cast<FP>(0.0013085300403859443569078453702944966319);
    rslt(11,11) = static_cast<FP>(0.0013919165061841718338162216029977376050);
    rslt(11,12) = static_cast<FP>(0.0014180264180264180264180264180264180264);
    rslt(12,0) = static_cast<FP>(0.000083250083250083250083250083250083250083);
    rslt(12,1) = static_cast<FP>(0.000083047157922766609177005163591128756950);
    rslt(12,2) = static_cast<FP>(0.000081059915364187115188548507696647721337);
    rslt(12,3) = static_cast<FP>(0.000074223428799554255010521402435334663242);
    rslt(12,4) = static_cast<FP>(0.000059400019946327129802476118100660075933);
    rslt(12,5) = static_cast<FP>(0.000035355764248581121771114106708764667612);
    rslt(12,6) = static_cast<FP>(4.2365147517277644230769230769230769231e-6);
    rslt(12,7) = -static_cast<FP>(0.000028732775374096622835661167479349713835);
    rslt(12,8) = -static_cast<FP>(0.000057533826864113452070825587843026538629);
    rslt(12,9) = -static_cast<FP>(0.000078178951118477368995327040267000889751);
    rslt(12,10) = -static_cast<FP>(0.000090117716048893095181807914434454331678);
    rslt(12,11) = -static_cast<FP>(0.000095495146369623504472823661615484300901);
    rslt(12,12) = -static_cast<FP>(0.000097125097125097125097125097125097125098);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void weno_lower_sten_to_coefs(SArray<FP,3,7,7,7> &rslt) {
    rslt(0,0,0) = -static_cast<FP>(0.028301711309523809523809523809523809524);
    rslt(0,0,1) = static_cast<FP>(0.091579861111111111111111111111111111111);
    rslt(0,0,2) = static_cast<FP>(0.32213541666666666666666666666666666667);
    rslt(0,0,3) = static_cast<FP>(0.29513888888888888888888888888888888889);
    rslt(0,0,4) = static_cast<FP>(0.11631944444444444444444444444444444444);
    rslt(0,0,5) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(0,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(0,1,0) = static_cast<FP>(0.20210193452380952380952380952380952381);
    rslt(0,1,1) = -static_cast<FP>(0.67777777777777777777777777777777777778);
    rslt(0,1,2) = -static_cast<FP>(2.3078125000000000000000000000000000000);
    rslt(0,1,3) = -static_cast<FP>(2.0555555555555555555555555555555555556);
    rslt(0,1,4) = -static_cast<FP>(0.78125000000000000000000000000000000000);
    rslt(0,1,5) = -static_cast<FP>(0.13333333333333333333333333333333333333);
    rslt(0,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(0,2,0) = -static_cast<FP>(0.62296316964285714285714285714285714286);
    rslt(0,2,1) = static_cast<FP>(2.2026909722222222222222222222222222222);
    rslt(0,2,2) = static_cast<FP>(7.1445312500000000000000000000000000000);
    rslt(0,2,3) = static_cast<FP>(6.1006944444444444444444444444444444444);
    rslt(0,2,4) = static_cast<FP>(2.2031250000000000000000000000000000000);
    rslt(0,2,5) = static_cast<FP>(0.35416666666666666666666666666666666667);
    rslt(0,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(0,3,0) = static_cast<FP>(1.0785342261904761904761904761904761905);
    rslt(0,3,1) = -static_cast<FP>(4.1562500000000000000000000000000000000);
    rslt(0,3,2) = -static_cast<FP>(12.442708333333333333333333333333333333);
    rslt(0,3,3) = -static_cast<FP>(9.9166666666666666666666666666666666667);
    rslt(0,3,4) = -static_cast<FP>(3.3263888888888888888888888888888888889);
    rslt(0,3,5) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(0,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(0,4,0) = -static_cast<FP>(1.1359840029761904761904761904761904762);
    rslt(0,4,1) = static_cast<FP>(5.1566840277777777777777777777777777778);
    rslt(0,4,2) = static_cast<FP>(13.207031250000000000000000000000000000);
    rslt(0,4,3) = static_cast<FP>(9.2743055555555555555555555555555555556);
    rslt(0,4,4) = static_cast<FP>(2.8281250000000000000000000000000000000);
    rslt(0,4,5) = static_cast<FP>(0.39583333333333333333333333333333333333);
    rslt(0,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(0,5,0) = static_cast<FP>(0.68751860119047619047619047619047619048);
    rslt(0,5,1) = -static_cast<FP>(4.8159722222222222222222222222222222222);
    rslt(0,5,2) = -static_cast<FP>(8.0578125000000000000000000000000000000);
    rslt(0,5,3) = -static_cast<FP>(4.6944444444444444444444444444444444444);
    rslt(0,5,4) = -static_cast<FP>(1.2812500000000000000000000000000000000);
    rslt(0,5,5) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(0,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(0,6,0) = static_cast<FP>(0.81909412202380952380952380952380952381);
    rslt(0,6,1) = static_cast<FP>(2.1990451388888888888888888888888888889);
    rslt(0,6,2) = static_cast<FP>(2.1346354166666666666666666666666666667);
    rslt(0,6,3) = static_cast<FP>(0.99652777777777777777777777777777777778);
    rslt(0,6,4) = static_cast<FP>(0.24131944444444444444444444444444444444);
    rslt(0,6,5) = static_cast<FP>(0.029166666666666666666666666666666666667);
    rslt(0,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(1,0,0) = static_cast<FP>(0.0039899553571428571428571428571428571429);
    rslt(1,0,1) = -static_cast<FP>(0.036718750000000000000000000000000000000);
    rslt(1,0,2) = -static_cast<FP>(0.052864583333333333333333333333333333333);
    rslt(1,0,3) = static_cast<FP>(0.010416666666666666666666666666666666667);
    rslt(1,0,4) = static_cast<FP>(0.032986111111111111111111111111111111111);
    rslt(1,0,5) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(1,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(1,1,0) = -static_cast<FP>(0.028627232142857142857142857142857142857);
    rslt(1,1,1) = static_cast<FP>(0.27951388888888888888888888888888888889);
    rslt(1,1,2) = static_cast<FP>(0.37968750000000000000000000000000000000);
    rslt(1,1,3) = -static_cast<FP>(0.097222222222222222222222222222222222222);
    rslt(1,1,4) = -static_cast<FP>(0.23958333333333333333333333333333333333);
    rslt(1,1,5) = -static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(1,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(1,2,0) = static_cast<FP>(0.087974330357142857142857142857142857143);
    rslt(1,2,1) = -static_cast<FP>(0.95095486111111111111111111111111111111);
    rslt(1,2,2) = -static_cast<FP>(1.1679687500000000000000000000000000000);
    rslt(1,2,3) = static_cast<FP>(0.41319444444444444444444444444444444444);
    rslt(1,2,4) = static_cast<FP>(0.74479166666666666666666666666666666667);
    rslt(1,2,5) = static_cast<FP>(0.22916666666666666666666666666666666667);
    rslt(1,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(1,3,0) = -static_cast<FP>(0.14542410714285714285714285714285714286);
    rslt(1,3,1) = static_cast<FP>(1.9513888888888888888888888888888888889);
    rslt(1,3,2) = static_cast<FP>(1.9322916666666666666666666666666666667);
    rslt(1,3,3) = -static_cast<FP>(1.0555555555555555555555555555555555556);
    rslt(1,3,4) = -static_cast<FP>(1.2430555555555555555555555555555555556);
    rslt(1,3,5) = -static_cast<FP>(0.33333333333333333333333333333333333333);
    rslt(1,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(1,4,0) = static_cast<FP>(0.093182663690476190476190476190476190476);
    rslt(1,4,1) = -static_cast<FP>(2.8927951388888888888888888888888888889);
    rslt(1,4,2) = -static_cast<FP>(1.2929687500000000000000000000000000000);
    rslt(1,4,3) = static_cast<FP>(1.5034722222222222222222222222222222222);
    rslt(1,4,4) = static_cast<FP>(1.1614583333333333333333333333333333333);
    rslt(1,4,5) = static_cast<FP>(0.27083333333333333333333333333333333333);
    rslt(1,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(1,5,0) = static_cast<FP>(1.0172061011904761904761904761904761905);
    rslt(1,5,1) = static_cast<FP>(1.5579861111111111111111111111111111111);
    rslt(1,5,2) = -static_cast<FP>(0.12031250000000000000000000000000000000);
    rslt(1,5,3) = -static_cast<FP>(1.0694444444444444444444444444444444444);
    rslt(1,5,4) = -static_cast<FP>(0.57291666666666666666666666666666666667);
    rslt(1,5,5) = -static_cast<FP>(0.11666666666666666666666666666666666667);
    rslt(1,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(1,6,0) = -static_cast<FP>(0.028301711309523809523809523809523809524);
    rslt(1,6,1) = static_cast<FP>(0.091579861111111111111111111111111111111);
    rslt(1,6,2) = static_cast<FP>(0.32213541666666666666666666666666666667);
    rslt(1,6,3) = static_cast<FP>(0.29513888888888888888888888888888888889);
    rslt(1,6,4) = static_cast<FP>(0.11631944444444444444444444444444444444);
    rslt(1,6,5) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(1,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(2,0,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(2,0,1) = static_cast<FP>(0.022482638888888888888888888888888888889);
    rslt(2,0,2) = static_cast<FP>(0.0096354166666666666666666666666666666667);
    rslt(2,0,3) = -static_cast<FP>(0.024305555555555555555555555555555555556);
    rslt(2,0,4) = -static_cast<FP>(0.0086805555555555555555555555555555555555);
    rslt(2,0,5) = static_cast<FP>(0.0041666666666666666666666666666666666667);
    rslt(2,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(2,1,0) = static_cast<FP>(0.0041852678571428571428571428571428571429);
    rslt(2,1,1) = -static_cast<FP>(0.17986111111111111111111111111111111111);
    rslt(2,1,2) = -static_cast<FP>(0.057812500000000000000000000000000000000);
    rslt(2,1,3) = static_cast<FP>(0.19444444444444444444444444444444444444);
    rslt(2,1,4) = static_cast<FP>(0.052083333333333333333333333333333333333);
    rslt(2,1,5) = -static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(2,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(2,2,0) = -static_cast<FP>(0.0057756696428571428571428571428571428571);
    rslt(2,2,1) = static_cast<FP>(0.66623263888888888888888888888888888889);
    rslt(2,2,2) = static_cast<FP>(0.082031250000000000000000000000000000000);
    rslt(2,2,3) = -static_cast<FP>(0.69097222222222222222222222222222222222);
    rslt(2,2,4) = -static_cast<FP>(0.088541666666666666666666666666666666667);
    rslt(2,2,5) = static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(2,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(2,3,0) = -static_cast<FP>(0.046465773809523809523809523809523809524);
    rslt(2,3,1) = -static_cast<FP>(1.6076388888888888888888888888888888889);
    rslt(2,3,2) = static_cast<FP>(0.55729166666666666666666666666666666667);
    rslt(2,3,3) = static_cast<FP>(1.1388888888888888888888888888888888889);
    rslt(2,3,4) = static_cast<FP>(0.0069444444444444444444444444444444444444);
    rslt(2,3,5) = -static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(2,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(2,4,0) = static_cast<FP>(1.1009951636904761904761904761904761905);
    rslt(2,4,1) = static_cast<FP>(0.78689236111111111111111111111111111111);
    rslt(2,4,2) = -static_cast<FP>(1.2304687500000000000000000000000000000);
    rslt(2,4,3) = -static_cast<FP>(0.85069444444444444444444444444444444445);
    rslt(2,4,4) = static_cast<FP>(0.11979166666666666666666666666666666667);
    rslt(2,4,5) = static_cast<FP>(0.14583333333333333333333333333333333333);
    rslt(2,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(2,5,0) = -static_cast<FP>(0.056231398809523809523809523809523809524);
    rslt(2,5,1) = static_cast<FP>(0.34861111111111111111111111111111111111);
    rslt(2,5,2) = static_cast<FP>(0.69218750000000000000000000000000000000);
    rslt(2,5,3) = static_cast<FP>(0.22222222222222222222222222222222222222);
    rslt(2,5,4) = -static_cast<FP>(0.11458333333333333333333333333333333333);
    rslt(2,5,5) = -static_cast<FP>(0.066666666666666666666666666666666666667);
    rslt(2,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(2,6,0) = static_cast<FP>(0.0039899553571428571428571428571428571429);
    rslt(2,6,1) = -static_cast<FP>(0.036718750000000000000000000000000000000);
    rslt(2,6,2) = -static_cast<FP>(0.052864583333333333333333333333333333333);
    rslt(2,6,3) = static_cast<FP>(0.010416666666666666666666666666666666667);
    rslt(2,6,4) = static_cast<FP>(0.032986111111111111111111111111111111111);
    rslt(2,6,5) = static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(2,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(3,0,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(3,0,1) = -static_cast<FP>(0.022482638888888888888888888888888888889);
    rslt(3,0,2) = static_cast<FP>(0.0096354166666666666666666666666666666667);
    rslt(3,0,3) = static_cast<FP>(0.024305555555555555555555555555555555556);
    rslt(3,0,4) = -static_cast<FP>(0.0086805555555555555555555555555555555555);
    rslt(3,0,5) = -static_cast<FP>(0.0041666666666666666666666666666666666667);
    rslt(3,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(3,1,0) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(3,1,1) = static_cast<FP>(0.19409722222222222222222222222222222222);
    rslt(3,1,2) = -static_cast<FP>(0.12031250000000000000000000000000000000);
    rslt(3,1,3) = -static_cast<FP>(0.18055555555555555555555555555555555556);
    rslt(3,1,4) = static_cast<FP>(0.093750000000000000000000000000000000000);
    rslt(3,1,5) = static_cast<FP>(0.016666666666666666666666666666666666667);
    rslt(3,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(3,2,0) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(3,2,1) = -static_cast<FP>(0.82074652777777777777777777777777777778);
    rslt(3,2,2) = static_cast<FP>(0.89453125000000000000000000000000000000);
    rslt(3,2,3) = static_cast<FP>(0.28819444444444444444444444444444444444);
    rslt(3,2,4) = -static_cast<FP>(0.29687500000000000000000000000000000000);
    rslt(3,2,5) = -static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(3,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(3,3,0) = static_cast<FP>(1.1254092261904761904761904761904761905);
    rslt(3,3,1) = 0;
    rslt(3,3,2) = -static_cast<FP>(1.5677083333333333333333333333333333333);
    rslt(3,3,3) = 0;
    rslt(3,3,4) = static_cast<FP>(0.42361111111111111111111111111111111111);
    rslt(3,3,5) = 0;
    rslt(3,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(3,4,0) = -static_cast<FP>(0.070879836309523809523809523809523809524);
    rslt(3,4,1) = static_cast<FP>(0.82074652777777777777777777777777777778);
    rslt(3,4,2) = static_cast<FP>(0.89453125000000000000000000000000000000);
    rslt(3,4,3) = -static_cast<FP>(0.28819444444444444444444444444444444444);
    rslt(3,4,4) = -static_cast<FP>(0.29687500000000000000000000000000000000);
    rslt(3,4,5) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(3,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(3,5,0) = static_cast<FP>(0.0088727678571428571428571428571428571429);
    rslt(3,5,1) = -static_cast<FP>(0.19409722222222222222222222222222222222);
    rslt(3,5,2) = -static_cast<FP>(0.12031250000000000000000000000000000000);
    rslt(3,5,3) = static_cast<FP>(0.18055555555555555555555555555555555556);
    rslt(3,5,4) = static_cast<FP>(0.093750000000000000000000000000000000000);
    rslt(3,5,5) = -static_cast<FP>(0.016666666666666666666666666666666666667);
    rslt(3,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(3,6,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(3,6,1) = static_cast<FP>(0.022482638888888888888888888888888888889);
    rslt(3,6,2) = static_cast<FP>(0.0096354166666666666666666666666666666667);
    rslt(3,6,3) = -static_cast<FP>(0.024305555555555555555555555555555555556);
    rslt(3,6,4) = -static_cast<FP>(0.0086805555555555555555555555555555555555);
    rslt(3,6,5) = static_cast<FP>(0.0041666666666666666666666666666666666667);
    rslt(3,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(4,0,0) = static_cast<FP>(0.0039899553571428571428571428571428571429);
    rslt(4,0,1) = static_cast<FP>(0.036718750000000000000000000000000000000);
    rslt(4,0,2) = -static_cast<FP>(0.052864583333333333333333333333333333333);
    rslt(4,0,3) = -static_cast<FP>(0.010416666666666666666666666666666666667);
    rslt(4,0,4) = static_cast<FP>(0.032986111111111111111111111111111111111);
    rslt(4,0,5) = -static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(4,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(4,1,0) = -static_cast<FP>(0.056231398809523809523809523809523809524);
    rslt(4,1,1) = -static_cast<FP>(0.34861111111111111111111111111111111111);
    rslt(4,1,2) = static_cast<FP>(0.69218750000000000000000000000000000000);
    rslt(4,1,3) = -static_cast<FP>(0.22222222222222222222222222222222222222);
    rslt(4,1,4) = -static_cast<FP>(0.11458333333333333333333333333333333333);
    rslt(4,1,5) = static_cast<FP>(0.066666666666666666666666666666666666667);
    rslt(4,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(4,2,0) = static_cast<FP>(1.1009951636904761904761904761904761905);
    rslt(4,2,1) = -static_cast<FP>(0.78689236111111111111111111111111111111);
    rslt(4,2,2) = -static_cast<FP>(1.2304687500000000000000000000000000000);
    rslt(4,2,3) = static_cast<FP>(0.85069444444444444444444444444444444445);
    rslt(4,2,4) = static_cast<FP>(0.11979166666666666666666666666666666667);
    rslt(4,2,5) = -static_cast<FP>(0.14583333333333333333333333333333333333);
    rslt(4,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(4,3,0) = -static_cast<FP>(0.046465773809523809523809523809523809524);
    rslt(4,3,1) = static_cast<FP>(1.6076388888888888888888888888888888889);
    rslt(4,3,2) = static_cast<FP>(0.55729166666666666666666666666666666667);
    rslt(4,3,3) = -static_cast<FP>(1.1388888888888888888888888888888888889);
    rslt(4,3,4) = static_cast<FP>(0.0069444444444444444444444444444444444444);
    rslt(4,3,5) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(4,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(4,4,0) = -static_cast<FP>(0.0057756696428571428571428571428571428571);
    rslt(4,4,1) = -static_cast<FP>(0.66623263888888888888888888888888888889);
    rslt(4,4,2) = static_cast<FP>(0.082031250000000000000000000000000000000);
    rslt(4,4,3) = static_cast<FP>(0.69097222222222222222222222222222222222);
    rslt(4,4,4) = -static_cast<FP>(0.088541666666666666666666666666666666667);
    rslt(4,4,5) = -static_cast<FP>(0.10416666666666666666666666666666666667);
    rslt(4,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(4,5,0) = static_cast<FP>(0.0041852678571428571428571428571428571429);
    rslt(4,5,1) = static_cast<FP>(0.17986111111111111111111111111111111111);
    rslt(4,5,2) = -static_cast<FP>(0.057812500000000000000000000000000000000);
    rslt(4,5,3) = -static_cast<FP>(0.19444444444444444444444444444444444444);
    rslt(4,5,4) = static_cast<FP>(0.052083333333333333333333333333333333333);
    rslt(4,5,5) = static_cast<FP>(0.033333333333333333333333333333333333333);
    rslt(4,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(4,6,0) = -static_cast<FP>(0.00069754464285714285714285714285714285714);
    rslt(4,6,1) = -static_cast<FP>(0.022482638888888888888888888888888888889);
    rslt(4,6,2) = static_cast<FP>(0.0096354166666666666666666666666666666667);
    rslt(4,6,3) = static_cast<FP>(0.024305555555555555555555555555555555556);
    rslt(4,6,4) = -static_cast<FP>(0.0086805555555555555555555555555555555555);
    rslt(4,6,5) = -static_cast<FP>(0.0041666666666666666666666666666666666667);
    rslt(4,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(5,0,0) = -static_cast<FP>(0.028301711309523809523809523809523809524);
    rslt(5,0,1) = -static_cast<FP>(0.091579861111111111111111111111111111111);
    rslt(5,0,2) = static_cast<FP>(0.32213541666666666666666666666666666667);
    rslt(5,0,3) = -static_cast<FP>(0.29513888888888888888888888888888888889);
    rslt(5,0,4) = static_cast<FP>(0.11631944444444444444444444444444444444);
    rslt(5,0,5) = -static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(5,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(5,1,0) = static_cast<FP>(1.0172061011904761904761904761904761905);
    rslt(5,1,1) = -static_cast<FP>(1.5579861111111111111111111111111111111);
    rslt(5,1,2) = -static_cast<FP>(0.12031250000000000000000000000000000000);
    rslt(5,1,3) = static_cast<FP>(1.0694444444444444444444444444444444444);
    rslt(5,1,4) = -static_cast<FP>(0.57291666666666666666666666666666666667);
    rslt(5,1,5) = static_cast<FP>(0.11666666666666666666666666666666666667);
    rslt(5,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(5,2,0) = static_cast<FP>(0.093182663690476190476190476190476190476);
    rslt(5,2,1) = static_cast<FP>(2.8927951388888888888888888888888888889);
    rslt(5,2,2) = -static_cast<FP>(1.2929687500000000000000000000000000000);
    rslt(5,2,3) = -static_cast<FP>(1.5034722222222222222222222222222222222);
    rslt(5,2,4) = static_cast<FP>(1.1614583333333333333333333333333333333);
    rslt(5,2,5) = -static_cast<FP>(0.27083333333333333333333333333333333333);
    rslt(5,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(5,3,0) = -static_cast<FP>(0.14542410714285714285714285714285714286);
    rslt(5,3,1) = -static_cast<FP>(1.9513888888888888888888888888888888889);
    rslt(5,3,2) = static_cast<FP>(1.9322916666666666666666666666666666667);
    rslt(5,3,3) = static_cast<FP>(1.0555555555555555555555555555555555556);
    rslt(5,3,4) = -static_cast<FP>(1.2430555555555555555555555555555555556);
    rslt(5,3,5) = static_cast<FP>(0.33333333333333333333333333333333333333);
    rslt(5,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(5,4,0) = static_cast<FP>(0.087974330357142857142857142857142857143);
    rslt(5,4,1) = static_cast<FP>(0.95095486111111111111111111111111111111);
    rslt(5,4,2) = -static_cast<FP>(1.1679687500000000000000000000000000000);
    rslt(5,4,3) = -static_cast<FP>(0.41319444444444444444444444444444444444);
    rslt(5,4,4) = static_cast<FP>(0.74479166666666666666666666666666666667);
    rslt(5,4,5) = -static_cast<FP>(0.22916666666666666666666666666666666667);
    rslt(5,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(5,5,0) = -static_cast<FP>(0.028627232142857142857142857142857142857);
    rslt(5,5,1) = -static_cast<FP>(0.27951388888888888888888888888888888889);
    rslt(5,5,2) = static_cast<FP>(0.37968750000000000000000000000000000000);
    rslt(5,5,3) = static_cast<FP>(0.097222222222222222222222222222222222222);
    rslt(5,5,4) = -static_cast<FP>(0.23958333333333333333333333333333333333);
    rslt(5,5,5) = static_cast<FP>(0.083333333333333333333333333333333333333);
    rslt(5,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(5,6,0) = static_cast<FP>(0.0039899553571428571428571428571428571429);
    rslt(5,6,1) = static_cast<FP>(0.036718750000000000000000000000000000000);
    rslt(5,6,2) = -static_cast<FP>(0.052864583333333333333333333333333333333);
    rslt(5,6,3) = -static_cast<FP>(0.010416666666666666666666666666666666667);
    rslt(5,6,4) = static_cast<FP>(0.032986111111111111111111111111111111111);
    rslt(5,6,5) = -static_cast<FP>(0.012500000000000000000000000000000000000);
    rslt(5,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(6,0,0) = static_cast<FP>(0.81909412202380952380952380952380952381);
    rslt(6,0,1) = -static_cast<FP>(2.1990451388888888888888888888888888889);
    rslt(6,0,2) = static_cast<FP>(2.1346354166666666666666666666666666667);
    rslt(6,0,3) = -static_cast<FP>(0.99652777777777777777777777777777777778);
    rslt(6,0,4) = static_cast<FP>(0.24131944444444444444444444444444444444);
    rslt(6,0,5) = -static_cast<FP>(0.029166666666666666666666666666666666667);
    rslt(6,0,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
    rslt(6,1,0) = static_cast<FP>(0.68751860119047619047619047619047619048);
    rslt(6,1,1) = static_cast<FP>(4.8159722222222222222222222222222222222);
    rslt(6,1,2) = -static_cast<FP>(8.0578125000000000000000000000000000000);
    rslt(6,1,3) = static_cast<FP>(4.6944444444444444444444444444444444444);
    rslt(6,1,4) = -static_cast<FP>(1.2812500000000000000000000000000000000);
    rslt(6,1,5) = static_cast<FP>(0.16666666666666666666666666666666666667);
    rslt(6,1,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(6,2,0) = -static_cast<FP>(1.1359840029761904761904761904761904762);
    rslt(6,2,1) = -static_cast<FP>(5.1566840277777777777777777777777777778);
    rslt(6,2,2) = static_cast<FP>(13.207031250000000000000000000000000000);
    rslt(6,2,3) = -static_cast<FP>(9.2743055555555555555555555555555555556);
    rslt(6,2,4) = static_cast<FP>(2.8281250000000000000000000000000000000);
    rslt(6,2,5) = -static_cast<FP>(0.39583333333333333333333333333333333333);
    rslt(6,2,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(6,3,0) = static_cast<FP>(1.0785342261904761904761904761904761905);
    rslt(6,3,1) = static_cast<FP>(4.1562500000000000000000000000000000000);
    rslt(6,3,2) = -static_cast<FP>(12.442708333333333333333333333333333333);
    rslt(6,3,3) = static_cast<FP>(9.9166666666666666666666666666666666667);
    rslt(6,3,4) = -static_cast<FP>(3.3263888888888888888888888888888888889);
    rslt(6,3,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(6,3,6) = -static_cast<FP>(0.027777777777777777777777777777777777778);
    rslt(6,4,0) = -static_cast<FP>(0.62296316964285714285714285714285714286);
    rslt(6,4,1) = -static_cast<FP>(2.2026909722222222222222222222222222222);
    rslt(6,4,2) = static_cast<FP>(7.1445312500000000000000000000000000000);
    rslt(6,4,3) = -static_cast<FP>(6.1006944444444444444444444444444444444);
    rslt(6,4,4) = static_cast<FP>(2.2031250000000000000000000000000000000);
    rslt(6,4,5) = -static_cast<FP>(0.35416666666666666666666666666666666667);
    rslt(6,4,6) = static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(6,5,0) = static_cast<FP>(0.20210193452380952380952380952380952381);
    rslt(6,5,1) = static_cast<FP>(0.67777777777777777777777777777777777778);
    rslt(6,5,2) = -static_cast<FP>(2.3078125000000000000000000000000000000);
    rslt(6,5,3) = static_cast<FP>(2.0555555555555555555555555555555555556);
    rslt(6,5,4) = -static_cast<FP>(0.78125000000000000000000000000000000000);
    rslt(6,5,5) = static_cast<FP>(0.13333333333333333333333333333333333333);
    rslt(6,5,6) = -static_cast<FP>(0.0083333333333333333333333333333333333333);
    rslt(6,6,0) = -static_cast<FP>(0.028301711309523809523809523809523809524);
    rslt(6,6,1) = -static_cast<FP>(0.091579861111111111111111111111111111111);
    rslt(6,6,2) = static_cast<FP>(0.32213541666666666666666666666666666667);
    rslt(6,6,3) = -static_cast<FP>(0.29513888888888888888888888888888888889);
    rslt(6,6,4) = static_cast<FP>(0.11631944444444444444444444444444444444);
    rslt(6,6,5) = -static_cast<FP>(0.020833333333333333333333333333333333333);
    rslt(6,6,6) = static_cast<FP>(0.0013888888888888888888888888888888888889);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,14> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.47996752263363045067755008100771219453);
    rslt(2) = -static_cast<FP>(0.43390052691517362550011010145413210663);
    rslt(3) = -static_cast<FP>(0.36443429954566307029233620026044079783);
    rslt(4) = -static_cast<FP>(0.27531970146432352765831135292954031723);
    rslt(5) = -static_cast<FP>(0.17136200667135642252195170182083732242);
    rslt(6) = -static_cast<FP>(0.058165934441851933829388354868080083971);
    rslt(7) = static_cast<FP>(0.058165934441851933829388354868080083971);
    rslt(8) = static_cast<FP>(0.17136200667135642252195170182083732242);
    rslt(9) = static_cast<FP>(0.27531970146432352765831135292954031723);
    rslt(10) = static_cast<FP>(0.36443429954566307029233620026044079783);
    rslt(11) = static_cast<FP>(0.43390052691517362550011010145413210663);
    rslt(12) = static_cast<FP>(0.47996752263363045067755008100771219453);
    rslt(13) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,14> &rslt) {
    rslt(0) = static_cast<FP>(0.0054945054945054945054945054945054945055);
    rslt(1) = static_cast<FP>(0.033418642248840642317035330373026412529);
    rslt(2) = static_cast<FP>(0.058293327949355825770498335327325115002);
    rslt(3) = static_cast<FP>(0.080010925881476071206410498993797320253);
    rslt(4) = static_cast<FP>(0.097413074686708059320165889187942256075);
    rslt(5) = static_cast<FP>(0.10956312650488537743558126197708380648);
    rslt(6) = static_cast<FP>(0.11580639723422852944481417864631959516);
    rslt(7) = static_cast<FP>(0.11580639723422852944481417864631959516);
    rslt(8) = static_cast<FP>(0.10956312650488537743558126197708380648);
    rslt(9) = static_cast<FP>(0.097413074686708059320165889187942256075);
    rslt(10) = static_cast<FP>(0.080010925881476071206410498993797320253);
    rslt(11) = static_cast<FP>(0.058293327949355825770498335327325115002);
    rslt(12) = static_cast<FP>(0.033418642248840642317035330373026412529);
    rslt(13) = static_cast<FP>(0.0054945054945054945054945054945054945055);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,14,14> &rslt) {
    rslt(0,0) = static_cast<FP>(0.016113281249999999999999999999999991180);
    rslt(0,1) = -static_cast<FP>(0.032226562500000000000000000000000227729);
    rslt(0,2) = -static_cast<FP>(5.8007812500000000000000000000000002730);
    rslt(0,3) = static_cast<FP>(11.601562500000000000000000000000052151);
    rslt(0,4) = static_cast<FP>(328.71093750000000000000000000000023698);
    rslt(0,5) = -static_cast<FP>(657.42187500000000000000000000000122232);
    rslt(0,6) = -static_cast<FP>(6661.8750000000000000000000000000072453);
    rslt(0,7) = static_cast<FP>(13323.750000000000000000000000000005467);
    rslt(0,8) = static_cast<FP>(59956.875000000000000000000000000073663);
    rslt(0,9) = -static_cast<FP>(119913.74999999999999999999999999996395);
    rslt(0,10) = -static_cast<FP>(245157.00000000000000000000000000030427);
    rslt(0,11) = static_cast<FP>(490313.99999999999999999999999999968855);
    rslt(0,12) = static_cast<FP>(371450.00000000000000000000000000044473);
    rslt(0,13) = -static_cast<FP>(742899.99999999999999999999999999941762);
    rslt(1,0) = -static_cast<FP>(0.041397320811719744518309718447160621728);
    rslt(1,1) = static_cast<FP>(0.086250254151715201073761779722092128791);
    rslt(1,2) = static_cast<FP>(14.888924587256477924940526570804104513);
    rslt(1,3) = -static_cast<FP>(31.020691786726400641307769721469398707);
    rslt(1,4) = -static_cast<FP>(839.48667230846220043829825945806993577);
    rslt(1,5) = static_cast<FP>(1749.0489100223151168211356419087498156);
    rslt(1,6) = static_cast<FP>(16849.231234752318584149455606293688763);
    rslt(1,7) = -static_cast<FP>(35104.940314083917186229877171234204089);
    rslt(1,8) = -static_cast<FP>(149358.76703714613639305371492546935935);
    rslt(1,9) = static_cast<FP>(311185.15314869523100624194539945214599);
    rslt(1,10) = static_cast<FP>(597648.17516696275073645686751113413265);
    rslt(1,11) = -static_cast<FP>(1.2451846155915021716458168874843945286e6);
    rslt(1,12) = -static_cast<FP>(879371.33433800071605192093822030079895);
    rslt(1,13) = static_cast<FP>(1.8321475784711454292889988661217358551e6);
    rslt(2,0) = static_cast<FP>(0.060479603217050382082112793909556556400);
    rslt(2,1) = -static_cast<FP>(0.13938587179654193008878253998767467988);
    rslt(2,2) = -static_cast<FP>(21.693336339545826264451730107105825512);
    rslt(2,3) = static_cast<FP>(49.996105083750715513239783463098426878);
    rslt(2,4) = static_cast<FP>(1205.6497258481867861638130117889746514);
    rslt(2,5) = -static_cast<FP>(2778.6316242106984878502972116547493608);
    rslt(2,6) = -static_cast<FP>(23535.977996832012475307706342336400840);
    rslt(2,7) = static_cast<FP>(54242.796532563861688742078223697125740);
    rslt(2,8) = static_cast<FP>(200048.87800893263192704560933125774502);
    rslt(2,9) = -static_cast<FP>(461047.78768346977423106319902617637501);
    rslt(2,10) = -static_cast<FP>(757775.59263856827698579827653623940841);
    rslt(2,11) = static_cast<FP>(1.7464269933618019024932486762350449975e6);
    rslt(2,12) = static_cast<FP>(1.0499428363483818660020106693622086871e6);
    rslt(2,13) = -static_cast<FP>(2.4197777398727216544057143256367814659e6);
    rslt(3,0) = -static_cast<FP>(0.084361654614432150155075435401385814074);
    rslt(3,1) = static_cast<FP>(0.23148659365928250547964174541783687144);
    rslt(3,2) = static_cast<FP>(30.072447969052256766074633812766119197);
    rslt(3,3) = -static_cast<FP>(82.518160355771408967927766662306597210);
    rslt(3,4) = -static_cast<FP>(1616.0304523243429230418210050859780365);
    rslt(3,5) = static_cast<FP>(4434.3533370460283333216625920669919827);
    rslt(3,6) = static_cast<FP>(29594.621853767516576653279640338980429);
    rslt(3,7) = -static_cast<FP>(81207.015614783961668252788002156800866);
    rslt(3,8) = -static_cast<FP>(230589.94123640234567879754729268044099);
    rslt(3,9) = static_cast<FP>(632733.91534187844035848291374161376220);
    rslt(3,10) = static_cast<FP>(802945.06109769899388601540312526329790);
    rslt(3,11) = -static_cast<FP>(2.2032642429615524811134609680569542198e6);
    rslt(3,12) = -static_cast<FP>(1.0331418288374565141318298115387189468e6);
    rslt(3,13) = static_cast<FP>(2.8349192985552266737966634814038524772e6);
    rslt(4,0) = static_cast<FP>(0.12321427376695660720256340924596475165);
    rslt(4,1) = -static_cast<FP>(0.44753162636609555125732386014516758543);
    rslt(4,2) = -static_cast<FP>(43.224497642908210205544366424619471597);
    rslt(4,3) = static_cast<FP>(156.99747389312539350042641233340273334);
    rslt(4,4) = static_cast<FP>(2120.7627634448540890608375255564388411);
    rslt(4,5) = -static_cast<FP>(7702.9095708200407492986021421618002068);
    rslt(4,6) = -static_cast<FP>(33017.939736954717134339111246556259782);
    rslt(4,7) = static_cast<FP>(119925.81555676736477975796517071419263);
    rslt(4,8) = static_cast<FP>(226654.73931574855966962142073039245215);
    rslt(4,9) = -static_cast<FP>(823241.99143852017363782616077272043254);
    rslt(4,10) = -static_cast<FP>(718425.37800648226675178631952734981546);
    rslt(4,11) = static_cast<FP>(2.6094223340554408180647395016863254072e6);
    rslt(4,12) = static_cast<FP>(861215.75861815991507870699115481118953);
    rslt(4,13) = -static_cast<FP>(3.1280571424335862837042937046123119654e6);
    rslt(5,0) = -static_cast<FP>(0.20994587939045577986217091674033414411);
    rslt(5,1) = static_cast<FP>(1.2251600192398350678060440579976611916);
    rslt(5,2) = static_cast<FP>(69.270757191631546424955323553997812289);
    rslt(5,3) = -static_cast<FP>(404.23637968059767408047207354486695023);
    rslt(5,4) = -static_cast<FP>(2226.2564861625009007593096945263202728);
    rslt(5,5) = static_cast<FP>(12991.540712009093808674224202094156312);
    rslt(5,6) = static_cast<FP>(28118.182716901987058807924628952475104);
    rslt(5,7) = -static_cast<FP>(164086.44636630536083935114700863247873);
    rslt(5,8) = -static_cast<FP>(170857.57123843491018475179757412795427);
    rslt(5,9) = static_cast<FP>(997056.31695893399017684650322595657644);
    rslt(5,10) = static_cast<FP>(500620.66515369098905866470322722102849);
    rslt(5,11) = -static_cast<FP>(2.9214215850879794498646876045775095827e6);
    rslt(5,12) = -static_cast<FP>(568476.87126617973111279274542138262515);
    rslt(5,13) = static_cast<FP>(3.3174032115323146891477482263594930583e6);
    rslt(6,0) = static_cast<FP>(0.63589769658260068525087986743335924756);
    rslt(6,1) = -static_cast<FP>(10.932476245495600820830928527114612312);
    rslt(6,2) = -static_cast<FP>(43.513514515486244645974387405842721042);
    rslt(6,3) = static_cast<FP>(748.09276139088579479604515134688522724);
    rslt(6,4) = static_cast<FP>(1026.6501840022651490147784217249540970);
    rslt(6,5) = -static_cast<FP>(17650.368619601563376292999298547518424);
    rslt(6,6) = -static_cast<FP>(11346.243071635092609963842286692475332);
    rslt(6,7) = static_cast<FP>(195066.80637921926922694887897247087136);
    rslt(6,8) = static_cast<FP>(64145.787187302200659936029730627504290);
    rslt(6,9) = -static_cast<FP>(1.1028067854979323438269408782464883491e6);
    rslt(6,10) = -static_cast<FP>(179855.93077330218994355237780002907323);
    rslt(6,11) = static_cast<FP>(3.0921179638763109688260756235378873973e6);
    rslt(6,12) = static_cast<FP>(198381.43947509518021582583466338231428);
    rslt(6,13) = -static_cast<FP>(3.4106120941530764531759956277498560679e6);
    rslt(7,0) = static_cast<FP>(0.63589769658260068525087986743335939017);
    rslt(7,1) = static_cast<FP>(10.932476245495600820830928527114611784);
    rslt(7,2) = -static_cast<FP>(43.513514515486244645974387405842792136);
    rslt(7,3) = -static_cast<FP>(748.09276139088579479604515134688513968);
    rslt(7,4) = static_cast<FP>(1026.6501840022651490147784217249559139);
    rslt(7,5) = static_cast<FP>(17650.368619601563376292999298547515991);
    rslt(7,6) = -static_cast<FP>(11346.243071635092609963842286692483044);
    rslt(7,7) = -static_cast<FP>(195066.80637921926922694887897247084413);
    rslt(7,8) = static_cast<FP>(64145.787187302200659936029730627453069);
    rslt(7,9) = static_cast<FP>(1.1028067854979323438269408782464882091e6);
    rslt(7,10) = -static_cast<FP>(179855.93077330218994355237780002863000);
    rslt(7,11) = -static_cast<FP>(3.0921179638763109688260756235378870604e6);
    rslt(7,12) = static_cast<FP>(198381.43947509518021582583466338144139);
    rslt(7,13) = static_cast<FP>(3.4106120941530764531759956277498557549e6);
    rslt(8,0) = -static_cast<FP>(0.20994587939045577986217091674033427024);
    rslt(8,1) = -static_cast<FP>(1.2251600192398350678060440579976597856);
    rslt(8,2) = static_cast<FP>(69.270757191631546424955323553997872306);
    rslt(8,3) = static_cast<FP>(404.23637968059767408047207354486671618);
    rslt(8,4) = -static_cast<FP>(2226.2564861625009007593096945263216766);
    rslt(8,5) = -static_cast<FP>(12991.540712009093808674224202094149926);
    rslt(8,6) = static_cast<FP>(28118.182716901987058807924628952477534);
    rslt(8,7) = static_cast<FP>(164086.44636630536083935114700863240920);
    rslt(8,8) = -static_cast<FP>(170857.57123843491018475179757412787117);
    rslt(8,9) = -static_cast<FP>(997056.31695893399017684650322595623375);
    rslt(8,10) = static_cast<FP>(500620.66515369098905866470322722049341);
    rslt(8,11) = static_cast<FP>(2.9214215850879794498646876045775088070e6);
    rslt(8,12) = -static_cast<FP>(568476.87126617973111279274542138165213);
    rslt(8,13) = -static_cast<FP>(3.3174032115323146891477482263594923962e6);
    rslt(9,0) = static_cast<FP>(0.12321427376695660720256340924596484522);
    rslt(9,1) = static_cast<FP>(0.44753162636609555125732386014516573609);
    rslt(9,2) = -static_cast<FP>(43.224497642908210205544366424619513059);
    rslt(9,3) = -static_cast<FP>(156.99747389312539350042641233340242213);
    rslt(9,4) = static_cast<FP>(2120.7627634448540890608375255564395503);
    rslt(9,5) = static_cast<FP>(7702.9095708200407492986021421617920562);
    rslt(9,6) = -static_cast<FP>(33017.939736954717134339111246556253232);
    rslt(9,7) = -static_cast<FP>(119925.81555676736477975796517071410947);
    rslt(9,8) = static_cast<FP>(226654.73931574855966962142073039231338);
    rslt(9,9) = static_cast<FP>(823241.99143852017363782616077272006707);
    rslt(9,10) = -static_cast<FP>(718425.37800648226675178631952734911314);
    rslt(9,11) = -static_cast<FP>(2.6094223340554408180647395016863247396e6);
    rslt(9,12) = static_cast<FP>(861215.75861815991507870699115481002366);
    rslt(9,13) = static_cast<FP>(3.1280571424335862837042937046123116061e6);
    rslt(10,0) = -static_cast<FP>(0.084361654614432150155075435401385869766);
    rslt(10,1) = -static_cast<FP>(0.23148659365928250547964174541783503378);
    rslt(10,2) = static_cast<FP>(30.072447969052256766074633812766141616);
    rslt(10,3) = static_cast<FP>(82.518160355771408967927766662306282326);
    rslt(10,4) = -static_cast<FP>(1616.0304523243429230418210050859780644);
    rslt(10,5) = -static_cast<FP>(4434.3533370460283333216625920669842310);
    rslt(10,6) = static_cast<FP>(29594.621853767516576653279640338965690);
    rslt(10,7) = static_cast<FP>(81207.015614783961668252788002156730106);
    rslt(10,8) = -static_cast<FP>(230589.94123640234567879754729268025621);
    rslt(10,9) = -static_cast<FP>(632733.91534187844035848291374161351912);
    rslt(10,10) = static_cast<FP>(802945.06109769899388601540312526247420);
    rslt(10,11) = static_cast<FP>(2.2032642429615524811134609680569540406e6);
    rslt(10,12) = -static_cast<FP>(1.0331418288374565141318298115387176649e6);
    rslt(10,13) = -static_cast<FP>(2.8349192985552266737966634814038528020e6);
    rslt(11,0) = static_cast<FP>(0.060479603217050382082112793909556581153);
    rslt(11,1) = static_cast<FP>(0.13938587179654193008878253998767309000);
    rslt(11,2) = -static_cast<FP>(21.693336339545826264451730107105834043);
    rslt(11,3) = -static_cast<FP>(49.996105083750715513239783463098152003);
    rslt(11,4) = static_cast<FP>(1205.6497258481867861638130117889742228);
    rslt(11,5) = static_cast<FP>(2778.6316242106984878502972116547430879);
    rslt(11,6) = -static_cast<FP>(23535.977996832012475307706342336381469);
    rslt(11,7) = -static_cast<FP>(54242.796532563861688742078223697077465);
    rslt(11,8) = static_cast<FP>(200048.87800893263192704560933125753960);
    rslt(11,9) = static_cast<FP>(461047.78768346977423106319902617629206);
    rslt(11,10) = -static_cast<FP>(757775.59263856827698579827653623854796);
    rslt(11,11) = -static_cast<FP>(1.7464269933618019024932486762350453524e6);
    rslt(11,12) = static_cast<FP>(1.0499428363483818660020106693622073982e6);
    rslt(11,13) = static_cast<FP>(2.4197777398727216544057143256367824646e6);
    rslt(12,0) = -static_cast<FP>(0.041397320811719744518309718447160633213);
    rslt(12,1) = -static_cast<FP>(0.086250254151715201073761779722090978918);
    rslt(12,2) = static_cast<FP>(14.888924587256477924940526570804107292);
    rslt(12,3) = static_cast<FP>(31.020691786726400641307769721469191889);
    rslt(12,4) = -static_cast<FP>(839.48667230846220043829825945806948956);
    rslt(12,5) = -static_cast<FP>(1749.0489100223151168211356419087452034);
    rslt(12,6) = static_cast<FP>(16849.231234752318584149455606293672531);
    rslt(12,7) = static_cast<FP>(35104.940314083917186229877171234171643);
    rslt(12,8) = -static_cast<FP>(149358.76703714613639305371492546919294);
    rslt(12,9) = -static_cast<FP>(311185.15314869523100624194539945212742);
    rslt(12,10) = static_cast<FP>(597648.17516696275073645686751113344239);
    rslt(12,11) = static_cast<FP>(1.2451846155915021716458168874843949899e6);
    rslt(12,12) = -static_cast<FP>(879371.33433800071605192093822029976880);
    rslt(12,13) = -static_cast<FP>(1.8321475784711454292889988661217369039e6);
    rslt(13,0) = static_cast<FP>(0.016113281249999999999999999999999993297);
    rslt(13,1) = static_cast<FP>(0.032226562499999999999999999999999806224);
    rslt(13,2) = -static_cast<FP>(5.8007812500000000000000000000000004997);
    rslt(13,3) = -static_cast<FP>(11.601562499999999999999999999999971977);
    rslt(13,4) = static_cast<FP>(328.71093750000000000000000000000002556);
    rslt(13,5) = static_cast<FP>(657.42187499999999999999999999999948028);
    rslt(13,6) = -static_cast<FP>(6661.8750000000000000000000000000002891);
    rslt(13,7) = -static_cast<FP>(13323.749999999999999999999999999994251);
    rslt(13,8) = static_cast<FP>(59956.875000000000000000000000000003556);
    rslt(13,9) = static_cast<FP>(119913.74999999999999999999999999997146);
    rslt(13,10) = -static_cast<FP>(245157.00000000000000000000000000001397);
    rslt(13,11) = -static_cast<FP>(490313.99999999999999999999999999993269);
    rslt(13,12) = static_cast<FP>(371450.00000000000000000000000000001061);
    rslt(13,13) = static_cast<FP>(742899.99999999999999999999999999992545);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,14,14> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,11) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,12) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,13) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47996752263363045067755008100771219453);
    rslt(1,2) = -static_cast<FP>(0.43390052691517362550011010145413210663);
    rslt(1,3) = -static_cast<FP>(0.36443429954566307029233620026044079783);
    rslt(1,4) = -static_cast<FP>(0.27531970146432352765831135292954031723);
    rslt(1,5) = -static_cast<FP>(0.17136200667135642252195170182083732242);
    rslt(1,6) = -static_cast<FP>(0.058165934441851933829388354868080083971);
    rslt(1,7) = static_cast<FP>(0.058165934441851933829388354868080083971);
    rslt(1,8) = static_cast<FP>(0.17136200667135642252195170182083732242);
    rslt(1,9) = static_cast<FP>(0.27531970146432352765831135292954031723);
    rslt(1,10) = static_cast<FP>(0.36443429954566307029233620026044079783);
    rslt(1,11) = static_cast<FP>(0.43390052691517362550011010145413210663);
    rslt(1,12) = static_cast<FP>(0.47996752263363045067755008100771219453);
    rslt(1,13) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.23036882278306455895238141485017699571);
    rslt(2,2) = static_cast<FP>(0.18826966725726531180919233696873834602);
    rslt(2,3) = static_cast<FP>(0.13281235868533807832209872270933375627);
    rslt(2,4) = static_cast<FP>(0.075800938014404230819899362043991656361);
    rslt(2,5) = static_cast<FP>(0.029364937330434003059409891379738410593);
    rslt(2,6) = static_cast<FP>(0.0033832759294938170370182720480208350421);
    rslt(2,7) = static_cast<FP>(0.0033832759294938170370182720480208350421);
    rslt(2,8) = static_cast<FP>(0.029364937330434003059409891379738410593);
    rslt(2,9) = static_cast<FP>(0.075800938014404230819899362043991656361);
    rslt(2,10) = static_cast<FP>(0.13281235868533807832209872270933375627);
    rslt(2,11) = static_cast<FP>(0.18826966725726531180919233696873834602);
    rslt(2,12) = static_cast<FP>(0.23036882278306455895238141485017699571);
    rslt(2,13) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.11056955316321334092848728709085910488);
    rslt(3,2) = -static_cast<FP>(0.081690307825071830071093432033845321918);
    rslt(3,3) = -static_cast<FP>(0.048401378908498543564329744310206752291);
    rslt(3,4) = -static_cast<FP>(0.020869491624841465461126844523650977879);
    rslt(3,5) = -static_cast<FP>(0.0050320345867217948886120991776588233989);
    rslt(3,6) = -static_cast<FP>(0.00019679140591363302730854479532173220090);
    rslt(3,7) = static_cast<FP>(0.00019679140591363302730854479532173220090);
    rslt(3,8) = static_cast<FP>(0.0050320345867217948886120991776588233989);
    rslt(3,9) = static_cast<FP>(0.020869491624841465461126844523650977879);
    rslt(3,10) = static_cast<FP>(0.048401378908498543564329744310206752291);
    rslt(3,11) = static_cast<FP>(0.081690307825071830071093432033845321918);
    rslt(3,12) = static_cast<FP>(0.11056955316321334092848728709085910488);
    rslt(3,13) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.053069794510455004604809424754744790228);
    rslt(4,2) = static_cast<FP>(0.035445467609161398236121058300393273744);
    rslt(4,3) = static_cast<FP>(0.017639122619562896887981511341856652759);
    rslt(4,4) = static_cast<FP>(0.0057457822038635524148412432825852682804);
    rslt(4,5) = static_cast<FP>(0.00086229954442031647418138781295182846342);
    rslt(4,6) = static_cast<FP>(0.000011446556015092251630591898772534352043);
    rslt(4,7) = static_cast<FP>(0.000011446556015092251630591898772534352043);
    rslt(4,8) = static_cast<FP>(0.00086229954442031647418138781295182846342);
    rslt(4,9) = static_cast<FP>(0.0057457822038635524148412432825852682804);
    rslt(4,10) = static_cast<FP>(0.017639122619562896887981511341856652759);
    rslt(4,11) = static_cast<FP>(0.035445467609161398236121058300393273744);
    rslt(4,12) = static_cast<FP>(0.053069794510455004604809424754744790228);
    rslt(4,13) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.025471777797858929465693546723899210976);
    rslt(5,2) = -static_cast<FP>(0.015379807072369850212971355832143682621);
    rslt(5,3) = -static_cast<FP>(0.0064283012964604658196345100673505262939);
    rslt(5,4) = -static_cast<FP>(0.0015819270410467361577061904033019788223);
    rslt(5,5) = -static_cast<FP>(0.00014776538028366187545490227039496689978);
    rslt(5,6) = -static_cast<FP>(6.6579962675884182321132958350003558527e-7);
    rslt(5,7) = static_cast<FP>(6.6579962675884182321132958350003558527e-7);
    rslt(5,8) = static_cast<FP>(0.00014776538028366187545490227039496689978);
    rslt(5,9) = static_cast<FP>(0.0015819270410467361577061904033019788223);
    rslt(5,10) = static_cast<FP>(0.0064283012964604658196345100673505262939);
    rslt(5,11) = static_cast<FP>(0.015379807072369850212971355832143682621);
    rslt(5,12) = static_cast<FP>(0.025471777797858929465693546723899210976);
    rslt(5,13) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.012225626086712661326837483256676546634);
    rslt(6,2) = static_cast<FP>(0.0066733063925549918718624333539201936194);
    rslt(6,3) = static_cast<FP>(0.0023426934802440476643827862005116828248);
    rslt(6,4) = static_cast<FP>(0.00043553568067932807016245202289803811858);
    rslt(6,5) = static_cast<FP>(0.000025321372081964385083509189061309268362);
    rslt(6,6) = static_cast<FP>(3.8726857441464280031629106142578373424e-8);
    rslt(6,7) = static_cast<FP>(3.8726857441464280031629106142578373424e-8);
    rslt(6,8) = static_cast<FP>(0.000025321372081964385083509189061309268362);
    rslt(6,9) = static_cast<FP>(0.00043553568067932807016245202289803811858);
    rslt(6,10) = static_cast<FP>(0.0023426934802440476643827862005116828248);
    rslt(6,11) = static_cast<FP>(0.0066733063925549918718624333539201936194);
    rslt(6,12) = static_cast<FP>(0.012225626086712661326837483256676546634);
    rslt(6,13) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0058679034654845621502063754980673267486);
    rslt(7,2) = -static_cast<FP>(0.0028955511599960074624744472921389801306);
    rslt(7,3) = -static_cast<FP>(0.00085375785752293117667573346481324227077);
    rslt(7,4) = -static_cast<FP>(0.00011991155358169354483212276109616290964);
    rslt(7,5) = -static_cast<FP>(4.3391211316374792227614457086940630607e-6);
    rslt(7,6) = -static_cast<FP>(2.2525838510791570273232875653835541715e-9);
    rslt(7,7) = static_cast<FP>(2.2525838510791570273232875653835541715e-9);
    rslt(7,8) = static_cast<FP>(4.3391211316374792227614457086940630607e-6);
    rslt(7,9) = static_cast<FP>(0.00011991155358169354483212276109616290964);
    rslt(7,10) = static_cast<FP>(0.00085375785752293117667573346481324227077);
    rslt(7,11) = static_cast<FP>(0.0028955511599960074624744472921389801306);
    rslt(7,12) = static_cast<FP>(0.0058679034654845621502063754980673267486);
    rslt(7,13) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0028164030893819201418568868880816241106);
    rslt(8,2) = static_cast<FP>(0.0012563811740321098487821834609694037418);
    rslt(8,3) = static_cast<FP>(0.00031113864678797543361923562483439672039);
    rslt(8,4) = static_cast<FP>(0.000033014013134235101402850700220121611363);
    rslt(8,5) = static_cast<FP>(7.4356050430748534422126290725931120391e-7);
    rslt(8,6) = static_cast<FP>(1.3102364460664460713909902417339527250e-10);
    rslt(8,7) = static_cast<FP>(1.3102364460664460713909902417339527250e-10);
    rslt(8,8) = static_cast<FP>(7.4356050430748534422126290725931120391e-7);
    rslt(8,9) = static_cast<FP>(0.000033014013134235101402850700220121611363);
    rslt(8,10) = static_cast<FP>(0.00031113864678797543361923562483439672039);
    rslt(8,11) = static_cast<FP>(0.0012563811740321098487821834609694037418);
    rslt(8,12) = static_cast<FP>(0.0028164030893819201418568868880816241106);
    rslt(8,13) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0013517820135483434809036489010167624131);
    rslt(9,2) = -static_cast<FP>(0.00054514445341883691832542061626157748986);
    rslt(9,3) = -static_cast<FP>(0.00011338959480376129807317657180177582335);
    rslt(9,4) = -static_cast<FP>(9.0894082402568640225834017148507245368e-6);
    rslt(9,5) = -static_cast<FP>(1.2741802009969644950184773878522498768e-7);
    rslt(9,6) = -static_cast<FP>(7.6211127225225969271291920170955822759e-12);
    rslt(9,7) = static_cast<FP>(7.6211127225225969271291920170955822759e-12);
    rslt(9,8) = static_cast<FP>(1.2741802009969644950184773878522498768e-7);
    rslt(9,9) = static_cast<FP>(9.0894082402568640225834017148507245368e-6);
    rslt(9,10) = static_cast<FP>(0.00011338959480376129807317657180177582335);
    rslt(9,11) = static_cast<FP>(0.00054514445341883691832542061626157748986);
    rslt(9,12) = static_cast<FP>(0.0013517820135483434809036489010167624131);
    rslt(9,13) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00064881146418349909419662167312303262445);
    rslt(10,2) = static_cast<FP>(0.00023653846558331766302621191830129866704);
    rslt(10,3) = static_cast<FP>(0.000041323057558075305666452475395600552080);
    rslt(10,4) = static_cast<FP>(2.5024931631948820643379105325933298761e-6);
    rslt(10,5) = static_cast<FP>(2.1834607610375209716676673282142555197e-8);
    rslt(10,6) = static_cast<FP>(4.4328914299221308075036362396881370915e-13);
    rslt(10,7) = static_cast<FP>(4.4328914299221308075036362396881370915e-13);
    rslt(10,8) = static_cast<FP>(2.1834607610375209716676673282142555197e-8);
    rslt(10,9) = static_cast<FP>(2.5024931631948820643379105325933298761e-6);
    rslt(10,10) = static_cast<FP>(0.000041323057558075305666452475395600552080);
    rslt(10,11) = static_cast<FP>(0.00023653846558331766302621191830129866704);
    rslt(10,12) = static_cast<FP>(0.00064881146418349909419662167312303262445);
    rslt(10,13) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00031140843112045251398614875896701591946);
    rslt(11,2) = -static_cast<FP>(0.00010263416485230819593028194435730708145);
    rslt(11,3) = -static_cast<FP>(0.000015059539536262292270770635898426512866);
    rslt(11,4) = -static_cast<FP>(6.8898567060732558815923017922051361442e-7);
    rslt(11,5) = -static_cast<FP>(3.7416221749955664021924878607477841489e-9);
    rslt(11,6) = -static_cast<FP>(2.5784327230069793645543927742396812301e-14);
    rslt(11,7) = static_cast<FP>(2.5784327230069793645543927742396812301e-14);
    rslt(11,8) = static_cast<FP>(3.7416221749955664021924878607477841489e-9);
    rslt(11,9) = static_cast<FP>(6.8898567060732558815923017922051361442e-7);
    rslt(11,10) = static_cast<FP>(0.000015059539536262292270770635898426512866);
    rslt(11,11) = static_cast<FP>(0.00010263416485230819593028194435730708145);
    rslt(11,12) = static_cast<FP>(0.00031140843112045251398614875896701591946);
    rslt(11,13) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00014946593321210914121224330053759580652);
    rslt(12,2) = static_cast<FP>(0.000044533018208915319276323258868612620319);
    rslt(12,3) = static_cast<FP>(5.4882127423779681443771221748360770871e-6);
    rslt(12,4) = static_cast<FP>(1.8969132914480562642406913143118654368e-7);
    rslt(12,5) = static_cast<FP>(6.4117188411328537761973490539726923598e-10);
    rslt(12,6) = static_cast<FP>(1.4997694872914972816764222850875496993e-15);
    rslt(12,7) = static_cast<FP>(1.4997694872914972816764222850875496993e-15);
    rslt(12,8) = static_cast<FP>(6.4117188411328537761973490539726923598e-10);
    rslt(12,9) = static_cast<FP>(1.8969132914480562642406913143118654368e-7);
    rslt(12,10) = static_cast<FP>(5.4882127423779681443771221748360770871e-6);
    rslt(12,11) = static_cast<FP>(0.000044533018208915319276323258868612620319);
    rslt(12,12) = static_cast<FP>(0.00014946593321210914121224330053759580652);
    rslt(12,13) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000071738793681939691523317808771316244284);
    rslt(13,2) = -static_cast<FP>(0.000019322900065971378652170053683789667135);
    rslt(13,3) = -static_cast<FP>(2.0000929665260974291638917687744735932e-6);
    rslt(13,4) = -static_cast<FP>(5.2225760110518617884902410187951892057e-8);
    rslt(13,5) = -static_cast<FP>(1.0987250068290697589933994843340237799e-10);
    rslt(13,6) = -static_cast<FP>(8.7235493675687117905228544109543138332e-17);
    rslt(13,7) = static_cast<FP>(8.7235493675687117905228544109543138332e-17);
    rslt(13,8) = static_cast<FP>(1.0987250068290697589933994843340237799e-10);
    rslt(13,9) = static_cast<FP>(5.2225760110518617884902410187951892057e-8);
    rslt(13,10) = static_cast<FP>(2.0000929665260974291638917687744735932e-6);
    rslt(13,11) = static_cast<FP>(0.000019322900065971378652170053683789667135);
    rslt(13,12) = static_cast<FP>(0.000071738793681939691523317808771316244284);
    rslt(13,13) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_deriv(SArray<FP,2,14,14> &rslt) {
    rslt(0,0) = 0;
    rslt(0,1) = 0;
    rslt(0,2) = 0;
    rslt(0,3) = 0;
    rslt(0,4) = 0;
    rslt(0,5) = 0;
    rslt(0,6) = 0;
    rslt(0,7) = 0;
    rslt(0,8) = 0;
    rslt(0,9) = 0;
    rslt(0,10) = 0;
    rslt(0,11) = 0;
    rslt(0,12) = 0;
    rslt(0,13) = 0;
    rslt(1,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = 0;
    rslt(1,3) = 0;
    rslt(1,4) = 0;
    rslt(1,5) = 0;
    rslt(1,6) = 0;
    rslt(1,7) = 0;
    rslt(1,8) = 0;
    rslt(1,9) = 0;
    rslt(1,10) = 0;
    rslt(1,11) = 0;
    rslt(1,12) = 0;
    rslt(1,13) = 0;
    rslt(2,0) = 0;
    rslt(2,1) = static_cast<FP>(2.0000000000000000000000000000000000000);
    rslt(2,2) = 0;
    rslt(2,3) = 0;
    rslt(2,4) = 0;
    rslt(2,5) = 0;
    rslt(2,6) = 0;
    rslt(2,7) = 0;
    rslt(2,8) = 0;
    rslt(2,9) = 0;
    rslt(2,10) = 0;
    rslt(2,11) = 0;
    rslt(2,12) = 0;
    rslt(2,13) = 0;
    rslt(3,0) = 0;
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(3.0000000000000000000000000000000000000);
    rslt(3,3) = 0;
    rslt(3,4) = 0;
    rslt(3,5) = 0;
    rslt(3,6) = 0;
    rslt(3,7) = 0;
    rslt(3,8) = 0;
    rslt(3,9) = 0;
    rslt(3,10) = 0;
    rslt(3,11) = 0;
    rslt(3,12) = 0;
    rslt(3,13) = 0;
    rslt(4,0) = 0;
    rslt(4,1) = 0;
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(4.0000000000000000000000000000000000000);
    rslt(4,4) = 0;
    rslt(4,5) = 0;
    rslt(4,6) = 0;
    rslt(4,7) = 0;
    rslt(4,8) = 0;
    rslt(4,9) = 0;
    rslt(4,10) = 0;
    rslt(4,11) = 0;
    rslt(4,12) = 0;
    rslt(4,13) = 0;
    rslt(5,0) = 0;
    rslt(5,1) = 0;
    rslt(5,2) = 0;
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(5.0000000000000000000000000000000000000);
    rslt(5,5) = 0;
    rslt(5,6) = 0;
    rslt(5,7) = 0;
    rslt(5,8) = 0;
    rslt(5,9) = 0;
    rslt(5,10) = 0;
    rslt(5,11) = 0;
    rslt(5,12) = 0;
    rslt(5,13) = 0;
    rslt(6,0) = 0;
    rslt(6,1) = 0;
    rslt(6,2) = 0;
    rslt(6,3) = 0;
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(6.0000000000000000000000000000000000000);
    rslt(6,6) = 0;
    rslt(6,7) = 0;
    rslt(6,8) = 0;
    rslt(6,9) = 0;
    rslt(6,10) = 0;
    rslt(6,11) = 0;
    rslt(6,12) = 0;
    rslt(6,13) = 0;
    rslt(7,0) = 0;
    rslt(7,1) = 0;
    rslt(7,2) = 0;
    rslt(7,3) = 0;
    rslt(7,4) = 0;
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(7.0000000000000000000000000000000000000);
    rslt(7,7) = 0;
    rslt(7,8) = 0;
    rslt(7,9) = 0;
    rslt(7,10) = 0;
    rslt(7,11) = 0;
    rslt(7,12) = 0;
    rslt(7,13) = 0;
    rslt(8,0) = 0;
    rslt(8,1) = 0;
    rslt(8,2) = 0;
    rslt(8,3) = 0;
    rslt(8,4) = 0;
    rslt(8,5) = 0;
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(8.0000000000000000000000000000000000000);
    rslt(8,8) = 0;
    rslt(8,9) = 0;
    rslt(8,10) = 0;
    rslt(8,11) = 0;
    rslt(8,12) = 0;
    rslt(8,13) = 0;
    rslt(9,0) = 0;
    rslt(9,1) = 0;
    rslt(9,2) = 0;
    rslt(9,3) = 0;
    rslt(9,4) = 0;
    rslt(9,5) = 0;
    rslt(9,6) = 0;
    rslt(9,7) = 0;
    rslt(9,8) = static_cast<FP>(9.0000000000000000000000000000000000000);
    rslt(9,9) = 0;
    rslt(9,10) = 0;
    rslt(9,11) = 0;
    rslt(9,12) = 0;
    rslt(9,13) = 0;
    rslt(10,0) = 0;
    rslt(10,1) = 0;
    rslt(10,2) = 0;
    rslt(10,3) = 0;
    rslt(10,4) = 0;
    rslt(10,5) = 0;
    rslt(10,6) = 0;
    rslt(10,7) = 0;
    rslt(10,8) = 0;
    rslt(10,9) = static_cast<FP>(10.000000000000000000000000000000000000);
    rslt(10,10) = 0;
    rslt(10,11) = 0;
    rslt(10,12) = 0;
    rslt(10,13) = 0;
    rslt(11,0) = 0;
    rslt(11,1) = 0;
    rslt(11,2) = 0;
    rslt(11,3) = 0;
    rslt(11,4) = 0;
    rslt(11,5) = 0;
    rslt(11,6) = 0;
    rslt(11,7) = 0;
    rslt(11,8) = 0;
    rslt(11,9) = 0;
    rslt(11,10) = static_cast<FP>(11.000000000000000000000000000000000000);
    rslt(11,11) = 0;
    rslt(11,12) = 0;
    rslt(11,13) = 0;
    rslt(12,0) = 0;
    rslt(12,1) = 0;
    rslt(12,2) = 0;
    rslt(12,3) = 0;
    rslt(12,4) = 0;
    rslt(12,5) = 0;
    rslt(12,6) = 0;
    rslt(12,7) = 0;
    rslt(12,8) = 0;
    rslt(12,9) = 0;
    rslt(12,10) = 0;
    rslt(12,11) = static_cast<FP>(12.000000000000000000000000000000000000);
    rslt(12,12) = 0;
    rslt(12,13) = 0;
    rslt(13,0) = 0;
    rslt(13,1) = 0;
    rslt(13,2) = 0;
    rslt(13,3) = 0;
    rslt(13,4) = 0;
    rslt(13,5) = 0;
    rslt(13,6) = 0;
    rslt(13,7) = 0;
    rslt(13,8) = 0;
    rslt(13,9) = 0;
    rslt(13,10) = 0;
    rslt(13,11) = 0;
    rslt(13,12) = static_cast<FP>(13.000000000000000000000000000000000000);
    rslt(13,13) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION float coefs_to_tv(SArray<FP,1,14> &a) {
    FP rslt;
    rslt = static_cast<FP>(1.0000000000000000000000000000000000000)*(a(1)*a(1))+static_cast<FP>(1.4307515636161134178321678321678321678e13)*(a(10)*a(10))+static_cast<FP>(0.0019531250000000000000000000000000000000)*a(1)*a(11)+static_cast<FP>(1.7312093919754972355769230769230769231e15)*(a(11)*a(11))+static_cast<FP>(1.5225636467244807692307692307692307692e14)*a(10)*a(12)+static_cast<FP>(2.4929415244447160192307692307692307692e17)*(a(12)*a(12))+static_cast<FP>(0.00048828125000000000000000000000000000000)*a(1)*a(13)+static_cast<FP>(2.1772660148160075000000000000000000000e16)*a(11)*a(13)+static_cast<FP>(4.2130711763115700725000000000000000000e19)*(a(13)*a(13))+static_cast<FP>(0.15980113636363636363636363636363636364)*a(10)*a(2)+static_cast<FP>(0.047776442307692307692307692307692307692)*a(12)*a(2)+static_cast<FP>(4.3333333333333333333333333333333333333)*(a(2)*a(2))+static_cast<FP>(0.50000000000000000000000000000000000000)*a(1)*a(3)+static_cast<FP>(5.2746769831730769230769230769230769231)*a(11)*a(3)+static_cast<FP>(1.8632812500000000000000000000000000000)*a(13)*a(3)+static_cast<FP>(39.112500000000000000000000000000000000)*(a(3)*a(3))+static_cast<FP>(555.19326376748251748251748251748251748)*a(10)*a(4)+static_cast<FP>(253.18449519230769230769230769230769231)*a(12)*a(4)+static_cast<FP>(4.2000000000000000000000000000000000000)*a(2)*a(4)+static_cast<FP>(625.83571428571428571428571428571428571)*(a(4)*a(4))+static_cast<FP>(0.12500000000000000000000000000000000000)*a(1)*a(5)+static_cast<FP>(30535.629507211538461538461538461538462)*a(11)*a(5)+static_cast<FP>(16456.992187500000000000000000000000000)*a(13)*a(5)+static_cast<FP>(63.066964285714285714285714285714285714)*a(3)*a(5)+static_cast<FP>(15645.903707837301587301587301587301587)*(a(5)*a(5))+static_cast<FP>(2.8203904423213505244755244755244755245e6)*a(10)*a(6)+static_cast<FP>(2.1985653245192307692307692307692307692e6)*a(12)*a(6)+static_cast<FP>(1.5535714285714285714285714285714285714)*a(2)*a(6)+static_cast<FP>(1513.6279761904761904761904761904761905)*a(4)*a(6)+static_cast<FP>(563252.53667816558441558441558441558442)*(a(6)*a(6))+static_cast<FP>(0.031250000000000000000000000000000000000)*a(1)*a(7)+static_cast<FP>(2.1717006405874399038461538461538461538e8)*a(11)*a(7)+static_cast<FP>(2.0006944453125000000000000000000000000e8)*a(13)*a(7)+static_cast<FP>(32.643229166666666666666666666666666667)*a(3)*a(7)+static_cast<FP>(52976.985381155303030303030303030303030)*a(5)*a(7)+static_cast<FP>(2.7599374298150335992132867132867132867e7)*(a(7)*a(7))+static_cast<FP>(1.2816192312495629370629370629370629371e10)*a(10)*a(8)+static_cast<FP>(2.0848326149639423076923076923076923077e10)*a(12)*a(8)+static_cast<FP>(0.51388888888888888888888888888888888889)*a(2)*a(8)+static_cast<FP>(1044.5890151515151515151515151515151515)*a(4)*a(8)+static_cast<FP>(2.5428953000983391608391608391608391608e6)*a(6)*a(8)+static_cast<FP>(1.7663599550816215034965034965034965035e9)*(a(8)*a(8))+static_cast<FP>(0.0078125000000000000000000000000000000000)*a(1)*a(9)+static_cast<FP>(1.2688030389370673076923076923076923077e12)*a(11)*a(9)+static_cast<FP>(2.4392541595078125000000000000000000000e12)*a(13)*a(9)+static_cast<FP>(13.879794034090909090909090909090909091)*a(3)*a(9)+static_cast<FP>(47006.507372022508741258741258741258741)*a(5)*a(9)+static_cast<FP>(1.6020240390619536713286713286713286713e8)*a(7)*a(9)+static_cast<FP>(1.4307515636161134178321678321678321678e11)*(a(9)*a(9));
    return rslt;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,1> &rslt) {
    rslt(0,0) = 1;
    rslt(1,0) = 0;
    rslt(2,0) = 0;
    rslt(3,0) = 0;
    rslt(4,0) = 0;
    rslt(5,0) = 0;
    rslt(6,0) = 0;
    rslt(7,0) = 0;
    rslt(8,0) = 0;
    rslt(9,0) = 0;
    rslt(10,0) = 0;
    rslt(11,0) = 0;
    rslt(12,0) = 0;
    rslt(13,0) = 0;
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,2> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,3> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = 0;
    rslt(1,2) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = 0;
    rslt(2,2) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = 0;
    rslt(3,2) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = 0;
    rslt(4,2) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = 0;
    rslt(5,2) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = 0;
    rslt(6,2) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = 0;
    rslt(7,2) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = 0;
    rslt(8,2) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = 0;
    rslt(9,2) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = 0;
    rslt(10,2) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = 0;
    rslt(11,2) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = 0;
    rslt(12,2) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = 0;
    rslt(13,2) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,4> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,2) = static_cast<FP>(0.22360679774997896964091736687312762354);
    rslt(1,3) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,2) = static_cast<FP>(0.050000000000000000000000000000000000000);
    rslt(2,3) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,2) = static_cast<FP>(0.011180339887498948482045868343656381177);
    rslt(3,3) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,2) = static_cast<FP>(0.0025000000000000000000000000000000000000);
    rslt(4,3) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,2) = static_cast<FP>(0.00055901699437494742410229341718281905886);
    rslt(5,3) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,2) = static_cast<FP>(0.00012500000000000000000000000000000000000);
    rslt(6,3) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,2) = static_cast<FP>(0.000027950849718747371205114670859140952943);
    rslt(7,3) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,2) = static_cast<FP>(6.2500000000000000000000000000000000000e-6);
    rslt(8,3) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,2) = static_cast<FP>(1.3975424859373685602557335429570476472e-6);
    rslt(9,3) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,2) = static_cast<FP>(3.1250000000000000000000000000000000000e-7);
    rslt(10,3) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(6.9877124296868428012786677147852382358e-8);
    rslt(11,2) = static_cast<FP>(6.9877124296868428012786677147852382358e-8);
    rslt(11,3) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(1.5625000000000000000000000000000000000e-8);
    rslt(12,2) = static_cast<FP>(1.5625000000000000000000000000000000000e-8);
    rslt(12,3) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(3.4938562148434214006393338573926191179e-9);
    rslt(13,2) = static_cast<FP>(3.4938562148434214006393338573926191179e-9);
    rslt(13,3) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,5> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,2) = 0;
    rslt(1,3) = static_cast<FP>(0.32732683535398857189914622812342917778);
    rslt(1,4) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,2) = 0;
    rslt(2,3) = static_cast<FP>(0.10714285714285714285714285714285714286);
    rslt(2,4) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,2) = 0;
    rslt(3,3) = static_cast<FP>(0.035070732359355918417765667298938840477);
    rslt(3,4) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,2) = 0;
    rslt(4,3) = static_cast<FP>(0.011479591836734693877551020408163265306);
    rslt(4,4) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,2) = 0;
    rslt(5,3) = static_cast<FP>(0.0037575784670738484019034643534577329082);
    rslt(5,4) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,2) = 0;
    rslt(6,3) = static_cast<FP>(0.0012299562682215743440233236151603498542);
    rslt(6,4) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,2) = 0;
    rslt(7,3) = static_cast<FP>(0.00040259769290076947163251403787047138302);
    rslt(7,4) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,2) = 0;
    rslt(8,3) = static_cast<FP>(0.00013178102873802582257392753019575177010);
    rslt(8,4) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,2) = 0;
    rslt(9,3) = static_cast<FP>(0.000043135467096511014817769361200407648181);
    rslt(9,4) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,2) = 0;
    rslt(10,3) = static_cast<FP>(0.000014119395936217052418635092520973403939);
    rslt(10,4) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(4.6216571889118944447610029857579623051e-6);
    rslt(11,2) = 0;
    rslt(11,3) = static_cast<FP>(4.6216571889118944447610029857579623051e-6);
    rslt(11,4) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(1.5127924217375413305680456272471504220e-6);
    rslt(12,2) = 0;
    rslt(12,3) = static_cast<FP>(1.5127924217375413305680456272471504220e-6);
    rslt(12,4) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(4.9517755595484583336725031990263881840e-7);
    rslt(13,2) = 0;
    rslt(13,3) = static_cast<FP>(4.9517755595484583336725031990263881840e-7);
    rslt(13,4) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,6> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,2) = -static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,3) = static_cast<FP>(0.14261575824032254815707549702043953596);
    rslt(1,4) = static_cast<FP>(0.38252766196473234642550148697966907518);
    rslt(1,5) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,2) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,3) = static_cast<FP>(0.020339254498462128797580577294303323197);
    rslt(2,4) = static_cast<FP>(0.14632741216820453786908608937236334347);
    rslt(2,5) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,2) = -static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,3) = static_cast<FP>(0.0029006982023410678014462619804145476307);
    rslt(3,4) = static_cast<FP>(0.055974282858053008128050867864994325063);
    rslt(3,5) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,2) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,3) = static_cast<FP>(0.00041368527355321194245390573952674434242);
    rslt(4,4) = static_cast<FP>(0.021411711551843613454371491085870081054);
    rslt(4,5) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,2) = -static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,3) = static_cast<FP>(0.000058998038960646573583080874651116462373);
    rslt(5,4) = static_cast<FP>(0.0081905719585899884188849616472024200249);
    rslt(5,5) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,2) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,3) = static_cast<FP>(8.4140500610647023209468574976022618397e-6);
    rslt(6,4) = static_cast<FP>(0.0031331203414733268320705875340367892725);
    rslt(6,5) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,2) = -static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,3) = static_cast<FP>(1.1999761293307747595424613096665900662e-6);
    rslt(7,4) = static_cast<FP>(0.0011985051988779355456235326916022059415);
    rslt(7,5) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,2) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,3) = static_cast<FP>(1.7113550555479579618785202481839976369e-7);
    rslt(8,4) = static_cast<FP>(0.00045846139157935324149280181791723249467);
    rslt(8,5) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,2) = -static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,3) = static_cast<FP>(2.4406619886538133783621900863727920637e-8);
    rslt(9,4) = static_cast<FP>(0.00017537416422194762540485972941226521636);
    rslt(9,5) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,2) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,3) = static_cast<FP>(3.4807686012019710284906425363932289499e-9);
    rslt(10,4) = static_cast<FP>(0.000067085469008840638962875935325381638181);
    rslt(10,5) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.000025662047611759319872168488557990018377);
    rslt(11,2) = -static_cast<FP>(4.9641245331952598910822957947075443294e-10);
    rslt(11,3) = static_cast<FP>(4.9641245331952598910822957947075443294e-10);
    rslt(11,4) = static_cast<FP>(0.000025662047611759319872168488557990018377);
    rslt(11,5) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(9.8164430741539361322269361913813667960e-6);
    rslt(12,2) = static_cast<FP>(7.0796238430102920856023682201253147326e-11);
    rslt(12,3) = static_cast<FP>(7.0796238430102920856023682201253147326e-11);
    rslt(12,4) = static_cast<FP>(9.8164430741539361322269361913813667960e-6);
    rslt(12,5) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(3.7550610179659949030850465173665946808e-6);
    rslt(13,2) = -static_cast<FP>(1.0096659224271790495354034484030736927e-11);
    rslt(13,3) = static_cast<FP>(1.0096659224271790495354034484030736927e-11);
    rslt(13,4) = static_cast<FP>(3.7550610179659949030850465173665946808e-6);
    rslt(13,5) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,7> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,2) = -static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,3) = 0;
    rslt(1,4) = static_cast<FP>(0.23442439673535710690188594095438316470);
    rslt(1,5) = static_cast<FP>(0.41511194813928346493601610698373256979);
    rslt(1,6) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,2) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,3) = 0;
    rslt(2,4) = static_cast<FP>(0.054954797784736107800314160609357581654);
    rslt(2,5) = static_cast<FP>(0.17231792948799116492695856666336969107);
    rslt(2,6) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,2) = -static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,3) = 0;
    rslt(3,4) = static_cast<FP>(0.012882745318400301199841250426883266125);
    rslt(3,5) = static_cast<FP>(0.071531231409087693369306561698188172409);
    rslt(3,6) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,2) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,3) = 0;
    rslt(4,4) = static_cast<FP>(0.0030200297995612366212835213506115715880);
    rslt(4,5) = static_cast<FP>(0.029693468823028295059157249999250687365);
    rslt(4,6) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,2) = -static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,3) = 0;
    rslt(5,4) = static_cast<FP>(0.00070796866388494433612030368646605324136);
    rslt(5,5) = static_cast<FP>(0.012326113690140352044766490281939238334);
    rslt(5,6) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,2) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,3) = 0;
    rslt(6,4) = static_cast<FP>(0.00016596512693876487794024954361098614071);
    rslt(6,5) = static_cast<FP>(0.0051167170669004537546668128155174886903);
    rslt(6,6) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,2) = -static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,3) = 0;
    rslt(7,4) = static_cast<FP>(0.000038906274761726921089451117881647837766);
    rslt(7,5) = static_cast<FP>(0.0021240103897185677623587992904200146553);
    rslt(7,6) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,2) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,3) = 0;
    rslt(8,4) = static_cast<FP>(9.1205799902378830424476107580690889109e-6);
    rslt(8,5) = static_cast<FP>(0.00088170209074415336224286228762470682956);
    rslt(8,6) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,2) = -static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,3) = 0;
    rslt(9,4) = static_cast<FP>(2.1380864620880849434329843058096104642e-6);
    rslt(9,5) = static_cast<FP>(0.00036600507256728479405155958984982114956);
    rslt(9,6) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,2) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,3) = 0;
    rslt(10,4) = static_cast<FP>(5.0121962904303328672815449415409084424e-7);
    rslt(10,5) = static_cast<FP>(0.00015193307870226540662085115613139654564);
    rslt(10,6) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.000063069236286896470595441580170224364906);
    rslt(11,2) = -static_cast<FP>(1.1749810917033255258466387744112512666e-7);
    rslt(11,3) = 0;
    rslt(11,4) = static_cast<FP>(1.1749810917033255258466387744112512666e-7);
    rslt(11,5) = static_cast<FP>(0.000063069236286896470595441580170224364906);
    rslt(11,6) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000026180793542710382544105733518265248728);
    rslt(12,2) = static_cast<FP>(2.7544423359800339384735768007851243853e-8);
    rslt(12,3) = 0;
    rslt(12,4) = static_cast<FP>(2.7544423359800339384735768007851243853e-8);
    rslt(12,5) = static_cast<FP>(0.000026180793542710382544105733518265248728);
    rslt(12,6) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000010867960211346879737112105437836776593);
    rslt(13,2) = -static_cast<FP>(6.4570848295444727140051965225131872694e-9);
    rslt(13,3) = 0;
    rslt(13,4) = static_cast<FP>(6.4570848295444727140051965225131872694e-9);
    rslt(13,5) = static_cast<FP>(0.000010867960211346879737112105437836776593);
    rslt(13,6) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,8> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,2) = -static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,3) = -static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,4) = static_cast<FP>(0.10464960895123943438432863017267562765);
    rslt(1,5) = static_cast<FP>(0.29585009071657115107225536569897659497);
    rslt(1,6) = static_cast<FP>(0.43587007425480330766872288061033171905);
    rslt(1,7) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,2) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,3) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,4) = static_cast<FP>(0.010951540653647332749779886509312406908);
    rslt(2,5) = static_cast<FP>(0.087527276177003379585734907439067299196);
    rslt(2,6) = static_cast<FP>(0.18998272163088774920294674451315875543);
    rslt(2,7) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,2) = -static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,3) = -static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,4) = static_cast<FP>(0.0011460744468177944795224966676909626551);
    rslt(3,5) = static_cast<FP>(0.025894952597140826821118341871434397055);
    rslt(3,6) = static_cast<FP>(0.082807782984384669802238263266905079039);
    rslt(3,7) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,2) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,3) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,4) = static_cast<FP>(0.00011993624268849024825988444750585976381);
    rslt(4,5) = static_cast<FP>(0.0076610240749654233471969661972791503317);
    rslt(4,6) = static_cast<FP>(0.036093434518279383876302159575763671992);
    rslt(4,7) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,2) = -static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,3) = -static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,4) = static_cast<FP>(0.000012551280896431454249400623486561808602);
    rslt(5,5) = static_cast<FP>(0.0022665146675603560839465574864604876207);
    rslt(5,6) = static_cast<FP>(0.015732047983593315903220273604436359675);
    rslt(5,7) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,2) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,3) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,4) = static_cast<FP>(1.3134866376487136267899952366590034698e-6);
    rslt(6,5) = static_cast<FP>(0.00067054857000817045212351115476961425775);
    rslt(6,6) = static_cast<FP>(0.0068571289227889472512646365749906233333);
    rslt(6,7) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,2) = -static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,3) = -static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,4) = static_cast<FP>(1.3745586299261620901616726121167790757e-7);
    rslt(7,5) = static_cast<FP>(0.00019838185526678428965669097868179525498);
    rslt(7,6) = static_cast<FP>(0.0029888172927507778554283041661589045943);
    rslt(7,7) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,2) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,3) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,4) = static_cast<FP>(1.4384702310232430533893981925155505597e-8);
    rslt(8,5) = static_cast<FP>(0.000058691289877199820485887279153552601918);
    rslt(8,6) = static_cast<FP>(0.0013027360153253217396134720726099631302);
    rslt(8,7) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,2) = -static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,3) = -static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,4) = static_cast<FP>(1.5053534716458143336316784858655906909e-9);
    rslt(9,5) = static_cast<FP>(0.000017363823434442140983954079903421004137);
    rslt(9,6) = static_cast<FP>(0.00056782364373425456644319684462111799087);
    rslt(9,7) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,2) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,3) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,4) = static_cast<FP>(1.5753465214112516977218628280407013748e-10);
    rslt(10,5) = static_cast<FP>(5.1370887382662314553291105152586195973e-6);
    rslt(10,6) = static_cast<FP>(0.00024749733375808251680642868088777643323);
    rslt(10,7) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00010787668124300126397927360604952024349);
    rslt(11,2) = -static_cast<FP>(1.5198081692351406103597017693483156022e-6);
    rslt(11,3) = -static_cast<FP>(1.6485939742838283094248615477799067381e-11);
    rslt(11,4) = static_cast<FP>(1.6485939742838283094248615477799067381e-11);
    rslt(11,5) = static_cast<FP>(1.5198081692351406103597017693483156022e-6);
    rslt(11,6) = static_cast<FP>(0.00010787668124300126397927360604952024349);
    rslt(11,7) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000047020217063748708113780718833652475873);
    rslt(12,2) = static_cast<FP>(4.4963538474000226997541449270752962791e-7);
    rslt(12,3) = static_cast<FP>(1.7252471472817231294777572668735363922e-12);
    rslt(12,4) = static_cast<FP>(1.7252471472817231294777572668735363922e-12);
    rslt(12,5) = static_cast<FP>(4.4963538474000226997541449270752962791e-7);
    rslt(12,6) = static_cast<FP>(0.000047020217063748708113780718833652475873);
    rslt(12,7) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000020494705503053118958102497983959467378);
    rslt(13,2) = -static_cast<FP>(1.3302466936471004337839050694931139316e-7);
    rslt(13,3) = -static_cast<FP>(1.8054643930727371161782336375069851554e-13);
    rslt(13,4) = static_cast<FP>(1.8054643930727371161782336375069851554e-13);
    rslt(13,5) = static_cast<FP>(1.3302466936471004337839050694931139316e-7);
    rslt(13,6) = static_cast<FP>(0.000020494705503053118958102497983959467378);
    rslt(13,7) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,9> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,2) = -static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,3) = -static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,4) = 0;
    rslt(1,5) = static_cast<FP>(0.18155873191308907935537603435432960651);
    rslt(1,6) = static_cast<FP>(0.33859313975536887672294271354567122536);
    rslt(1,7) = static_cast<FP>(0.44987899770573007865617262220916897903);
    rslt(1,8) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,2) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,3) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,4) = 0;
    rslt(2,5) = static_cast<FP>(0.032963573133888950909172408488417168368);
    rslt(2,6) = static_cast<FP>(0.11464531428939875971563255331489350652);
    rslt(2,7) = static_cast<FP>(0.20239111257671228937519503819668932511);
    rslt(2,8) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,2) = -static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,3) = -static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,4) = 0;
    rslt(3,5) = static_cast<FP>(0.0059848245375132496670769085177734726747);
    rslt(3,6) = static_cast<FP>(0.038818116923488582751154648047340344867);
    rslt(3,7) = static_cast<FP>(0.091051510870558906099759952478910669314);
    rslt(3,8) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,2) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,3) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,4) = 0;
    rslt(4,5) = static_cast<FP>(0.0010865971537532454323020932891462970775);
    rslt(4,6) = static_cast<FP>(0.013143548088515019441370131691761841034);
    rslt(4,7) = static_cast<FP>(0.040962162450039427434020082711399554196);
    rslt(4,8) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,2) = -static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,3) = -static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,4) = 0;
    rslt(5,5) = static_cast<FP>(0.00019728120133581112257103731870422310018);
    rslt(5,6) = static_cast<FP>(0.0044503152148159774370751104156319947592);
    rslt(5,7) = static_cast<FP>(0.018428016586883030352264484260348133535);
    rslt(5,8) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,2) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,3) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,4) = 0;
    rslt(6,5) = static_cast<FP>(0.000035818124744820682771521351547304517174);
    rslt(6,6) = static_cast<FP>(0.0015068462014856307126510029954178681372);
    rslt(6,7) = static_cast<FP>(0.0082903776318115066465355176110767853876);
    rslt(6,8) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,2) = -static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,3) = -static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,4) = 0;
    rslt(7,5) = static_cast<FP>(6.5030933081744805340353099081561512531e-6);
    rslt(7,6) = static_cast<FP>(0.00051020778648947088900174399908121481328);
    rslt(7,7) = static_cast<FP>(0.0037296667796013647613899408844740863246);
    rslt(7,8) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,2) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,3) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,4) = 0;
    rslt(8,5) = static_cast<FP>(1.1806933745446540940667962891375118141e-6);
    rslt(8,6) = static_cast<FP>(0.00017275285635510682133207169002011830466);
    rslt(8,7) = static_cast<FP>(0.0016778987525834200684146361236961234197);
    rslt(8,8) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,2) = -static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,3) = -static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,4) = 0;
    rslt(9,5) = static_cast<FP>(2.1436519186051332651669254385045646425e-7);
    rslt(9,6) = static_cast<FP>(0.000058492932034983848370775230132613124796);
    rslt(9,7) = static_cast<FP>(0.00075485140906392379784583885012156281375);
    rslt(9,8) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,2) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,3) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,4) = 0;
    rslt(10,5) = static_cast<FP>(3.8919872400500844252714010141998043673e-8);
    rslt(10,6) = static_cast<FP>(0.000019805305511222579401658002264649525182);
    rslt(10,7) = static_cast<FP>(0.00033959179532643609135172241981988303299);
    rslt(10,8) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00015277521651054650078862987348271507340);
    rslt(11,2) = -static_cast<FP>(6.7059405768591642644510312885922379995e-6);
    rslt(11,3) = -static_cast<FP>(7.0662426792541675057534239160018861021e-9);
    rslt(11,4) = 0;
    rslt(11,5) = static_cast<FP>(7.0662426792541675057534239160018861021e-9);
    rslt(11,6) = static_cast<FP>(6.7059405768591642644510312885922379995e-6);
    rslt(11,7) = static_cast<FP>(0.00015277521651054650078862987348271507340);
    rslt(11,8) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000068730361278040565261350300737126400318);
    rslt(12,2) = static_cast<FP>(2.2705854749316739901300101940399910608e-6);
    rslt(12,3) = static_cast<FP>(1.2829380602355357013078803609731331931e-9);
    rslt(12,4) = 0;
    rslt(12,5) = static_cast<FP>(1.2829380602355357013078803609731331931e-9);
    rslt(12,6) = static_cast<FP>(2.2705854749316739901300101940399910608e-6);
    rslt(12,7) = static_cast<FP>(0.000068730361278040565261350300737126400318);
    rslt(12,8) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000030920346043717610895908045355519031988);
    rslt(13,2) = -static_cast<FP>(7.6880466504005090654534315300943160138e-7);
    rslt(13,3) = -static_cast<FP>(2.3292860733940215532509105538567628333e-10);
    rslt(13,4) = 0;
    rslt(13,5) = static_cast<FP>(2.3292860733940215532509105538567628333e-10);
    rslt(13,6) = static_cast<FP>(7.6880466504005090654534315300943160138e-7);
    rslt(13,7) = static_cast<FP>(0.000030920346043717610895908045355519031988);
    rslt(13,8) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,10> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,2) = -static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,3) = -static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,4) = -static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,5) = static_cast<FP>(0.082639478833193512313109882979086766616);
    rslt(1,6) = static_cast<FP>(0.23896247490522224783058754636562899894);
    rslt(1,7) = static_cast<FP>(0.36938693255275253750155308742991536251);
    rslt(1,8) = static_cast<FP>(0.45976695408322940691446633041116906708);
    rslt(1,9) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,2) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,3) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,4) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,5) = static_cast<FP>(0.0068292834618218385552953755327220208002);
    rslt(2,6) = static_cast<FP>(0.057103064412828972542303983873702488100);
    rslt(2,7) = static_cast<FP>(0.13644670594073175227136264811613425384);
    rslt(2,8) = static_cast<FP>(0.21138565206697037780750858071273535491);
    rslt(2,9) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,2) = -static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,3) = -static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,4) = -static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,5) = static_cast<FP>(0.00056436842608910434134705569958372829351);
    rslt(3,6) = static_cast<FP>(0.013645489596761932943382901958571848435);
    rslt(3,7) = static_cast<FP>(0.050401630164374338748970394385681412357);
    rslt(3,8) = static_cast<FP>(0.097188137387728277064549096794926561613);
    rslt(3,9) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,2) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,3) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,4) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,5) = static_cast<FP>(0.000046639112601913275428257102801775111950);
    rslt(4,6) = static_cast<FP>(0.0032607599653356946507026147675243788321);
    rslt(4,7) = static_cast<FP>(0.018617703562076521657583628122590375401);
    rslt(4,8) = static_cast<FP>(0.044683893899778257959538095162792813216);
    rslt(4,9) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,2) = -static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,3) = -static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,4) = -static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,5) = static_cast<FP>(3.8542319586647409226161403878573888461e-6);
    rslt(5,6) = static_cast<FP>(0.00077919927138848429969762890302690957772);
    rslt(5,7) = static_cast<FP>(0.0068771364099719007707158719624117867400);
    rslt(5,8) = static_cast<FP>(0.020544177794879244925390569684658759898);
    rslt(5,9) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,2) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,3) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,4) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,5) = static_cast<FP>(3.1851172036629282975954867346368780436e-7);
    rslt(6,6) = static_cast<FP>(0.00018619938633533813932014263325017249416);
    rslt(6,7) = static_cast<FP>(0.0025403243232263692332594606367236537654);
    rslt(6,8) = static_cast<FP>(0.0094455340488959469705799277605069163186);
    rslt(6,9) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,2) = -static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,3) = -static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,4) = -static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,5) = static_cast<FP>(2.6321642573334307251354584629765642012e-8);
    rslt(7,6) = static_cast<FP>(0.000044494666184526022441648739085568780409);
    rslt(7,7) = static_cast<FP>(0.00093836260944573558831319565094452438350);
    rslt(7,8) = static_cast<FP>(0.0043427444193503227984890684826248018757);
    rslt(7,9) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,2) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,3) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,4) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,5) = static_cast<FP>(2.1752068242939456962702531015079022523e-9);
    rslt(8,6) = static_cast<FP>(0.000010632555551536040580064181608032903852);
    rslt(8,7) = static_cast<FP>(0.00034661888592535680291793557078574775557);
    rslt(8,8) = static_cast<FP>(0.0019966503740466406143817106440571827959);
    rslt(8,9) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,2) = -static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,3) = -static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,4) = -static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,5) = static_cast<FP>(1.7975795831405760484103855245917982437e-10);
    rslt(9,6) = static_cast<FP>(2.5407817891623125937215790983562899758e-6);
    rslt(9,7) = static_cast<FP>(0.00012803648703681999917638720610669442238);
    rslt(9,8) = static_cast<FP>(0.00091799386084456463565441695142653353309);
    rslt(9,9) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,2) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,3) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,4) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,5) = static_cast<FP>(1.4855103991192645179916946993189484017e-11);
    rslt(10,6) = static_cast<FP>(6.0715150453234480738959597444575242488e-7);
    rslt(10,7) = static_cast<FP>(0.000047295005201361203634395159241886862005);
    rslt(10,8) = static_cast<FP>(0.00042206324126760943458016532862397722359);
    rslt(10,9) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00019405073086810396184968532568139273581);
    rslt(11,2) = -static_cast<FP>(0.000017470156896397291370538034589054196169);
    rslt(11,3) = -static_cast<FP>(1.4508642616547837790136366505971039866e-7);
    rslt(11,4) = -static_cast<FP>(1.2276180518450530653058495612202153539e-12);
    rslt(11,5) = static_cast<FP>(1.2276180518450530653058495612202153539e-12);
    rslt(11,6) = static_cast<FP>(1.4508642616547837790136366505971039866e-7);
    rslt(11,7) = static_cast<FP>(0.000017470156896397291370538034589054196169);
    rslt(11,8) = static_cast<FP>(0.00019405073086810396184968532568139273581);
    rslt(11,9) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.000089218113468852661536433044908588285593);
    rslt(12,2) = static_cast<FP>(6.4532476671755108675069798804268054793e-6);
    rslt(12,3) = static_cast<FP>(3.4670211471656507400037699169905996412e-8);
    rslt(12,4) = static_cast<FP>(1.0144971601069551859493250595053282653e-13);
    rslt(12,5) = static_cast<FP>(1.0144971601069551859493250595053282653e-13);
    rslt(12,6) = static_cast<FP>(3.4670211471656507400037699169905996412e-8);
    rslt(12,7) = static_cast<FP>(6.4532476671755108675069798804268054793e-6);
    rslt(12,8) = static_cast<FP>(0.000089218113468852661536433044908588285593);
    rslt(12,9) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000041019540278626332739438948433832205381);
    rslt(13,2) = -static_cast<FP>(2.3837453607811680880383033343239148773e-6);
    rslt(13,3) = -static_cast<FP>(8.2848795387544666476470426059633989272e-9);
    rslt(13,4) = -static_cast<FP>(8.3837516588993652797434531461275056304e-15);
    rslt(13,5) = static_cast<FP>(8.3837516588993652797434531461275056304e-15);
    rslt(13,6) = static_cast<FP>(8.2848795387544666476470426059633989272e-9);
    rslt(13,7) = static_cast<FP>(2.3837453607811680880383033343239148773e-6);
    rslt(13,8) = static_cast<FP>(0.000041019540278626332739438948433832205381);
    rslt(13,9) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,11> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,2) = -static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,3) = -static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,4) = -static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,5) = 0;
    rslt(1,6) = static_cast<FP>(0.14787906779346969571595575777952875447);
    rslt(1,7) = static_cast<FP>(0.28261766349810250323548198473887583214);
    rslt(1,8) = static_cast<FP>(0.39224173683157220931120890805422905175);
    rslt(1,9) = static_cast<FP>(0.46700071520402956716613706804969181727);
    rslt(1,10) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,2) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,3) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,4) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,5) = 0;
    rslt(2,6) = static_cast<FP>(0.021868218691465606220093026967000826852);
    rslt(2,7) = static_cast<FP>(0.079872743721126700045829818140458846929);
    rslt(2,8) = static_cast<FP>(0.15385358011264835067068023200643541016);
    rslt(2,9) = static_cast<FP>(0.21808966800107513253708113341242070553);
    rslt(2,10) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,2) = -static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,3) = -static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,4) = -static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,5) = 0;
    rslt(3,6) = static_cast<FP>(0.0032338517943976635413839442360699518620);
    rslt(3,7) = static_cast<FP>(0.022573448207647565281633751589520030219);
    rslt(3,8) = static_cast<FP>(0.060347795481140626149318440977602324474);
    rslt(3,9) = static_cast<FP>(0.10184803093511144822920254615624844976);
    rslt(3,10) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,2) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,3) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,4) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,5) = 0;
    rslt(4,6) = static_cast<FP>(0.00047821898873776571077098517330925836021);
    rslt(4,7) = static_cast<FP>(0.0063796551895407846864210240911274258023);
    rslt(4,8) = static_cast<FP>(0.023670924113479104076248760367665885260);
    rslt(4,9) = static_cast<FP>(0.047563103288819174596137200059929368006);
    rslt(4,10) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,2) = -static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,3) = -static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,4) = -static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,5) = 0;
    rslt(5,6) = static_cast<FP>(0.000070718578255676576452752170073025225684);
    rslt(5,7) = static_cast<FP>(0.0018030032435915608309519958015742473909);
    rslt(5,8) = static_cast<FP>(0.0092847243866793874440762778324787030242);
    rslt(5,9) = static_cast<FP>(0.022212003253201685419201955327981402396);
    rslt(5,10) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,2) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,3) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,4) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,5) = 0;
    rslt(6,6) = static_cast<FP>(0.000010457797428128988349583858913367566607);
    rslt(6,7) = static_cast<FP>(0.00050956056398334707754064106049224605230);
    rslt(6,8) = static_cast<FP>(0.0036418564194335769775577194630301016907);
    rslt(6,9) = static_cast<FP>(0.010373021405359418539615956203312507292);
    rslt(6,10) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,2) = -static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,3) = -static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,4) = -static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,5) = 0;
    rslt(7,6) = static_cast<FP>(1.5464893348446596959469439831321842379e-6);
    rslt(7,7) = static_cast<FP>(0.00014401081600374891444260492663034810390);
    rslt(7,8) = static_cast<FP>(0.0014284880872498369590694612179613389963);
    rslt(7,9) = static_cast<FP>(0.0048442084151295563575254643794683497307);
    rslt(7,10) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,2) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,3) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,4) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,5) = 0;
    rslt(8,6) = static_cast<FP>(2.2869340118937128771630070267533323627e-7);
    rslt(8,7) = static_cast<FP>(0.000040700000337434665383007696440377667118);
    rslt(8,8) = static_cast<FP>(0.00056031264838608650923145628546256047586);
    rslt(8,9) = static_cast<FP>(0.0022622487944628813827986297115580371857);
    rslt(8,10) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,2) = -static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,3) = -static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,4) = -static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,5) = 0;
    rslt(9,6) = static_cast<FP>(3.3818966978402199798052538856797150810e-8);
    rslt(9,7) = static_cast<FP>(0.000011502538999737768595493803363568573476);
    rslt(9,8) = static_cast<FP>(0.00021977800637165659755055897003785444819);
    rslt(9,9) = static_cast<FP>(0.0010564718049836192890835258443336257994);
    rslt(9,10) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,2) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,3) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,4) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,5) = 0;
    rslt(10,6) = static_cast<FP>(5.0011173105042518946643470545570256837e-9);
    rslt(10,7) = static_cast<FP>(3.2508206964016892426263906318381208561e-6);
    rslt(10,8) = static_cast<FP>(0.000086206106936598927335576023369820971127);
    rslt(10,9) = static_cast<FP>(0.00049337308852024225638383367782648585234);
    rslt(10,10) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00023040558520137412340666889867251922255);
    rslt(11,2) = -static_cast<FP>(0.000033813633110299807995230095325375638610);
    rslt(11,3) = -static_cast<FP>(9.1873934966831984945070471729444686924e-7);
    rslt(11,4) = -static_cast<FP>(7.3956056580315310032155370144097310613e-10);
    rslt(11,5) = 0;
    rslt(11,6) = static_cast<FP>(7.3956056580315310032155370144097310613e-10);
    rslt(11,7) = static_cast<FP>(9.1873934966831984945070471729444686924e-7);
    rslt(11,8) = static_cast<FP>(0.000033813633110299807995230095325375638610);
    rslt(11,9) = static_cast<FP>(0.00023040558520137412340666889867251922255);
    rslt(11,10) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00010759957307604468643470949003962600676);
    rslt(12,2) = static_cast<FP>(0.000013263118179769553758886388134342905232);
    rslt(12,3) = static_cast<FP>(2.5965196836702675087899890323841145346e-7);
    rslt(12,4) = static_cast<FP>(1.0936552704778128324505672722338879356e-10);
    rslt(12,5) = 0;
    rslt(12,6) = static_cast<FP>(1.0936552704778128324505672722338879356e-10);
    rslt(12,7) = static_cast<FP>(2.5965196836702675087899890323841145346e-7);
    rslt(12,8) = static_cast<FP>(0.000013263118179769553758886388134342905232);
    rslt(12,9) = static_cast<FP>(0.00010759957307604468643470949003962600676);
    rslt(12,10) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000050249077582161112258926665705967898079);
    rslt(13,2) = -static_cast<FP>(5.2023485106352103334375497649261463676e-6);
    rslt(13,3) = -static_cast<FP>(7.3382232622572322005542073946013044320e-8);
    rslt(13,4) = -static_cast<FP>(1.6172872188567392054759865219483803875e-11);
    rslt(13,5) = 0;
    rslt(13,6) = static_cast<FP>(1.6172872188567392054759865219483803875e-11);
    rslt(13,7) = static_cast<FP>(7.3382232622572322005542073946013044320e-8);
    rslt(13,8) = static_cast<FP>(5.2023485106352103334375497649261463676e-6);
    rslt(13,9) = static_cast<FP>(0.000050249077582161112258926665705967898079);
    rslt(13,10) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,12> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(0,11) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,2) = -static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,3) = -static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,4) = -static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,5) = -static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,6) = static_cast<FP>(0.068276466427463777432030927869846948449);
    rslt(1,7) = static_cast<FP>(0.19976547048267446613217489578348345026);
    rslt(1,8) = static_cast<FP>(0.31643807651593033883120242722182792912);
    rslt(1,9) = static_cast<FP>(0.40963966082200333917432079085845133035);
    rslt(1,10) = static_cast<FP>(0.47244963611144111170379006915160935681);
    rslt(1,11) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,2) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,3) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,4) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,5) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,6) = static_cast<FP>(0.0046616758678205883148645349317689888047);
    rslt(2,7) = static_cast<FP>(0.039906243197164283400760640612757229858);
    rslt(2,8) = static_cast<FP>(0.10013305626910178380573168419968985333);
    rslt(2,9) = static_cast<FP>(0.16780465171836593743215638861010768749);
    rslt(2,10) = static_cast<FP>(0.22320865866183312133220103735996195480);
    rslt(2,11) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,2) = -static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,3) = -static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,4) = -static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,5) = -static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,6) = static_cast<FP>(0.00031828275588497046780217530391179979690);
    rslt(3,7) = static_cast<FP>(0.0079718894474775503712981544699388767834);
    rslt(3,8) = static_cast<FP>(0.031685911721455988364775233611700807468);
    rslt(3,9) = static_cast<FP>(0.068739440614265822406770543887442557304);
    rslt(3,10) = static_cast<FP>(0.10545484956170592632932870883224421150);
    rslt(3,11) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,2) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,3) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,4) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,5) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,6) = static_cast<FP>(0.000021731221896620835177965764913704190581);
    rslt(4,7) = static_cast<FP>(0.0015925082461112206474969956671921757121);
    rslt(4,8) = static_cast<FP>(0.010026628957791104047454217757310473856);
    rslt(4,9) = static_cast<FP>(0.028158401138322092358231297999059818400);
    rslt(4,10) = static_cast<FP>(0.049822105301614730103046611962973881547);
    rslt(4,11) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,2) = -static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,3) = -static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,4) = -static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,5) = -static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,6) = static_cast<FP>(1.4837310422523981680631891991048647913e-6);
    rslt(5,7) = static_cast<FP>(0.00031812815903194673242376127714748378436);
    rslt(5,8) = static_cast<FP>(0.0031728071813423442502201357363732164698);
    rslt(5,9) = static_cast<FP>(0.011534797891592174645625222645367878751);
    rslt(5,10) = static_cast<FP>(0.023538435520053780251657852865091108786);
    rslt(5,11) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,2) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,3) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,4) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,5) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,6) = static_cast<FP>(1.0130391269373170295460303032602082901e-7);
    rslt(6,7) = static_cast<FP>(0.000063551021362803923339953432976090226326);
    rslt(6,8) = static_cast<FP>(0.0010039970016199019959853503218438179477);
    rslt(6,9) = static_cast<FP>(0.0047251106959621776640842193677026180208);
    rslt(6,10) = static_cast<FP>(0.011120725296082028602442514196027810124);
    rslt(6,11) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,2) = -static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,3) = -static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,4) = -static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,5) = -static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,6) = static_cast<FP>(6.9166731940042942186092747110870749656e-9);
    rslt(7,7) = static_cast<FP>(0.000012695299682195021572295592902961661509);
    rslt(7,8) = static_cast<FP>(0.00031770288002036318414943130901573500474);
    rslt(7,9) = static_cast<FP>(0.0019355927428403666012242627241534183081);
    rslt(7,10) = static_cast<FP>(0.0052539826194292526293133957825737649840);
    rslt(7,11) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,2) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,3) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,4) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,5) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,6) = static_cast<FP>(4.7224600512017284884281881078035389663e-10);
    rslt(8,7) = static_cast<FP>(2.5360825139322361125412197528892739450e-6);
    rslt(8,8) = static_cast<FP>(0.00010053328825721512135003456940836403643);
    rslt(8,9) = static_cast<FP>(0.00079289555466665890669722631397511722555);
    rslt(8,10) = static_cast<FP>(0.0024822421766851865964527436573607337772);
    rslt(8,11) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,2) = -static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,3) = -static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,4) = -static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,5) = -static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,6) = static_cast<FP>(3.2243288514091368653995162512503443231e-11);
    rslt(9,7) = static_cast<FP>(5.0662171657855696865215572609326683825e-7);
    rslt(9,8) = static_cast<FP>(0.000031812560361934719592471403389894425971);
    rslt(9,9) = static_cast<FP>(0.00032480146608092436142789234363667217187);
    rslt(9,10) = static_cast<FP>(0.0011727344131153879217740105168526986118);
    rslt(9,11) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,2) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,3) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,4) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,5) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,6) = static_cast<FP>(2.2014578057433877578622784997036669082e-12);
    rslt(10,7) = static_cast<FP>(1.0120552556905559134509415962139097569e-7);
    rslt(10,8) = static_cast<FP>(0.000010066705409977551352062214575978115130);
    rslt(10,9) = static_cast<FP>(0.00013305156239987927758827365190331105549);
    rslt(10,10) = static_cast<FP>(0.00055405794673172947637179837784865702817);
    rslt(10,11) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,2) = -static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,3) = -static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,4) = -static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,5) = -static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,6) = static_cast<FP>(1.5030775996531648847479877290055252866e-13);
    rslt(11,7) = static_cast<FP>(2.0217369430748730684850750462632327920e-8);
    rslt(11,8) = static_cast<FP>(3.1854888967858062861213824251039330465e-6);
    rslt(11,9) = static_cast<FP>(0.000054503196893324159887367311709599045074);
    rslt(11,10) = static_cast<FP>(0.00026176447531805781429442997672263251794);
    rslt(11,11) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00012367053111091872272436271870282981359);
    rslt(12,2) = static_cast<FP>(0.000022326671089096174968034710487378120864);
    rslt(12,3) = static_cast<FP>(1.0080099792617534911506900107577773063e-6);
    rslt(12,4) = static_cast<FP>(4.0387323162555606337462283070340123000e-9);
    rslt(12,5) = static_cast<FP>(1.0262482727059215256710166442454665581e-14);
    rslt(12,6) = static_cast<FP>(1.0262482727059215256710166442454665581e-14);
    rslt(12,7) = static_cast<FP>(4.0387323162555606337462283070340123000e-9);
    rslt(12,8) = static_cast<FP>(1.0080099792617534911506900107577773063e-6);
    rslt(12,9) = static_cast<FP>(0.000022326671089096174968034710487378120864);
    rslt(12,10) = static_cast<FP>(0.00012367053111091872272436271870282981359);
    rslt(12,11) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000058428097421062207648709033116796009936);
    rslt(13,2) = -static_cast<FP>(9.1458899722217850090900749495885241158e-6);
    rslt(13,3) = -static_cast<FP>(3.1897273894645210527175718366485979537e-7);
    rslt(13,4) = -static_cast<FP>(8.0679926131037367471322802990450155047e-10);
    rslt(13,5) = -static_cast<FP>(7.0068605737648542280115514207161930778e-16);
    rslt(13,6) = static_cast<FP>(7.0068605737648542280115514207161930778e-16);
    rslt(13,7) = static_cast<FP>(8.0679926131037367471322802990450155047e-10);
    rslt(13,8) = static_cast<FP>(3.1897273894645210527175718366485979537e-7);
    rslt(13,9) = static_cast<FP>(9.1458899722217850090900749495885241158e-6);
    rslt(13,10) = static_cast<FP>(0.000058428097421062207648709033116796009936);
    rslt(13,11) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,13> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(0,11) = 1;
    rslt(0,12) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(1,2) = -static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(1,3) = -static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(1,4) = -static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(1,5) = -static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(1,6) = 0;
    rslt(1,7) = static_cast<FP>(0.12464346505311999628433685018711349074);
    rslt(1,8) = static_cast<FP>(0.24145491054566810087346861681846681039);
    rslt(1,9) = static_cast<FP>(0.34309423454087871303637951978317777646);
    rslt(1,10) = static_cast<FP>(0.42317378232593615843296280354937667979);
    rslt(1,11) = static_cast<FP>(0.47665492332108195594845273237772457581);
    rslt(1,12) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.22719991592622651908169188067697197017);
    rslt(2,2) = static_cast<FP>(0.17907605004803879781549050546066293634);
    rslt(2,3) = static_cast<FP>(0.11771365377519149176479467316248463529);
    rslt(2,4) = static_cast<FP>(0.058300473826616584670302248834312701940);
    rslt(2,5) = static_cast<FP>(0.015535993380448345798155474474263408439);
    rslt(2,6) = 0;
    rslt(2,7) = static_cast<FP>(0.015535993380448345798155474474263408439);
    rslt(2,8) = static_cast<FP>(0.058300473826616584670302248834312701940);
    rslt(2,9) = static_cast<FP>(0.11771365377519149176479467316248463529);
    rslt(2,10) = static_cast<FP>(0.17907605004803879781549050546066293634);
    rslt(2,11) = static_cast<FP>(0.22719991592622651908169188067697197017);
    rslt(2,12) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.10829595850437176853035870166962054041);
    rslt(3,2) = -static_cast<FP>(0.075780289422817219574321205253147523592);
    rslt(3,3) = -static_cast<FP>(0.040386875937009342631095068146519983236);
    rslt(3,4) = -static_cast<FP>(0.014076935692575771889068444583815547937);
    rslt(3,5) = -static_cast<FP>(0.0019364600479814169844431869765204083476);
    rslt(3,6) = 0;
    rslt(3,7) = static_cast<FP>(0.0019364600479814169844431869765204083476);
    rslt(3,8) = static_cast<FP>(0.014076935692575771889068444583815547937);
    rslt(3,9) = static_cast<FP>(0.040386875937009342631095068146519983236);
    rslt(3,10) = static_cast<FP>(0.075780289422817219574321205253147523592);
    rslt(3,11) = static_cast<FP>(0.10829595850437176853035870166962054041);
    rslt(3,12) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.051619801796884398670108111342184081708);
    rslt(4,2) = static_cast<FP>(0.032068231700807696321401063156355473401);
    rslt(4,3) = static_cast<FP>(0.013856504285105654141228644450321985532);
    rslt(4,4) = static_cast<FP>(0.0033989452484080054351413183720032251132);
    rslt(4,5) = static_cast<FP>(0.00024136709031733481910438954924055425724);
    rslt(4,6) = 0;
    rslt(4,7) = static_cast<FP>(0.00024136709031733481910438954924055425724);
    rslt(4,8) = static_cast<FP>(0.0033989452484080054351413183720032251132);
    rslt(4,9) = static_cast<FP>(0.013856504285105654141228644450321985532);
    rslt(4,10) = static_cast<FP>(0.032068231700807696321401063156355473401);
    rslt(4,11) = static_cast<FP>(0.051619801796884398670108111342184081708);
    rslt(4,12) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.024604832667343381614616781906533477314);
    rslt(5,2) = -static_cast<FP>(0.013570434901335281555334192972576694939);
    rslt(5,3) = -static_cast<FP>(0.0047540867311107302215647938392381309058);
    rslt(5,4) = -static_cast<FP>(0.00082069202090397859429325422014526225387);
    rslt(5,5) = -static_cast<FP>(0.000030084830486941980359137332648276219260);
    rslt(5,6) = 0;
    rslt(5,7) = static_cast<FP>(0.000030084830486941980359137332648276219260);
    rslt(5,8) = static_cast<FP>(0.00082069202090397859429325422014526225387);
    rslt(5,9) = static_cast<FP>(0.0047540867311107302215647938392381309058);
    rslt(5,10) = static_cast<FP>(0.013570434901335281555334192972576694939);
    rslt(5,11) = static_cast<FP>(0.024604832667343381614616781906533477314);
    rslt(5,12) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.011728014628380611976689776252337248193);
    rslt(6,2) = static_cast<FP>(0.0057426522650059433658114369943834259605);
    rslt(6,3) = static_cast<FP>(0.0016310997479513842673349234386568819810);
    rslt(6,4) = static_cast<FP>(0.00019816011849291372657568721765391578987);
    rslt(6,5) = static_cast<FP>(3.7498775174281917696060835401185543983e-6);
    rslt(6,6) = 0;
    rslt(6,7) = static_cast<FP>(3.7498775174281917696060835401185543983e-6);
    rslt(6,8) = static_cast<FP>(0.00019816011849291372657568721765391578987);
    rslt(6,9) = static_cast<FP>(0.0016310997479513842673349234386568819810);
    rslt(6,10) = static_cast<FP>(0.0057426522650059433658114369943834259605);
    rslt(6,11) = static_cast<FP>(0.011728014628380611976689776252337248193);
    rslt(6,12) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0055902159133992880927144559916705229108);
    rslt(7,2) = -static_cast<FP>(0.0024301398795651693250606251440522667341);
    rslt(7,3) = -static_cast<FP>(0.00055962091948320038694683451326812391038);
    rslt(7,4) = -static_cast<FP>(0.000047846733684425475014986906579840237129);
    rslt(7,5) = -static_cast<FP>(4.6739772729704119064068777650155603134e-7);
    rslt(7,6) = 0;
    rslt(7,7) = static_cast<FP>(4.6739772729704119064068777650155603134e-7);
    rslt(7,8) = static_cast<FP>(0.000047846733684425475014986906579840237129);
    rslt(7,9) = static_cast<FP>(0.00055962091948320038694683451326812391038);
    rslt(7,10) = static_cast<FP>(0.0024301398795651693250606251440522667341);
    rslt(7,11) = static_cast<FP>(0.0055902159133992880927144559916705229108);
    rslt(7,12) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0026646039375496297937360355557585726590);
    rslt(8,2) = static_cast<FP>(0.0010283714844166876755565062971962861067);
    rslt(8,3) = static_cast<FP>(0.00019200271100315135534633657677881488665);
    rslt(8,4) = static_cast<FP>(0.000011552828801675357774029981013055773031);
    rslt(8,5) = static_cast<FP>(5.8258072288256463786507210869224220550e-8);
    rslt(8,6) = 0;
    rslt(8,7) = static_cast<FP>(5.8258072288256463786507210869224220550e-8);
    rslt(8,8) = static_cast<FP>(0.000011552828801675357774029981013055773031);
    rslt(8,9) = static_cast<FP>(0.00019200271100315135534633657677881488665);
    rslt(8,10) = static_cast<FP>(0.0010283714844166876755565062971962861067);
    rslt(8,11) = static_cast<FP>(0.0026646039375496297937360355557585726590);
    rslt(8,12) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0012700965855337718421081398391277678630);
    rslt(9,2) = -static_cast<FP>(0.00043517985069674723865081437753148979020);
    rslt(9,3) = -static_cast<FP>(0.000065875023161399765075493562963404787946);
    rslt(9,4) = -static_cast<FP>(2.7894872448579415124727120899241797611e-6);
    rslt(9,5) = -static_cast<FP>(7.2614879973234330384820899859551827818e-9);
    rslt(9,6) = 0;
    rslt(9,7) = static_cast<FP>(7.2614879973234330384820899859551827818e-9);
    rslt(9,8) = static_cast<FP>(2.7894872448579415124727120899241797611e-6);
    rslt(9,9) = static_cast<FP>(0.000065875023161399765075493562963404787946);
    rslt(9,10) = static_cast<FP>(0.00043517985069674723865081437753148979020);
    rslt(9,11) = static_cast<FP>(0.0012700965855337718421081398391277678630);
    rslt(9,12) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00060539779058796802722625831121383571480);
    rslt(10,2) = static_cast<FP>(0.00018415670341137871284144980378879474931);
    rslt(10,3) = static_cast<FP>(0.000022601340646923108515136014077712878912);
    rslt(10,4) = static_cast<FP>(6.7353539317545643799175985554948785642e-7);
    rslt(10,5) = static_cast<FP>(9.0509702542803363504846343483216753128e-10);
    rslt(10,6) = 0;
    rslt(10,7) = static_cast<FP>(9.0509702542803363504846343483216753128e-10);
    rslt(10,8) = static_cast<FP>(6.7353539317545643799175985554948785642e-7);
    rslt(10,9) = static_cast<FP>(0.000022601340646923108515136014077712878912);
    rslt(10,10) = static_cast<FP>(0.00018415670341137871284144980378879474931);
    rslt(10,11) = static_cast<FP>(0.00060539779058796802722625831121383571480);
    rslt(10,12) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00028856583745146033147285062122763693047);
    rslt(11,2) = -static_cast<FP>(0.000077930288723268760206991553580391203373);
    rslt(11,3) = -static_cast<FP>(7.7543896688537324149040524186233042073e-6);
    rslt(11,4) = -static_cast<FP>(1.6262842810852122730933726607029415195e-7);
    rslt(11,5) = -static_cast<FP>(1.1281442945862197103668740774885574140e-10);
    rslt(11,6) = 0;
    rslt(11,7) = static_cast<FP>(1.1281442945862197103668740774885574140e-10);
    rslt(11,8) = static_cast<FP>(1.6262842810852122730933726607029415195e-7);
    rslt(11,9) = static_cast<FP>(7.7543896688537324149040524186233042073e-6);
    rslt(11,10) = static_cast<FP>(0.000077930288723268760206991553580391203373);
    rslt(11,11) = static_cast<FP>(0.00028856583745146033147285062122763693047);
    rslt(11,12) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00013754632712350962404456424728771623077);
    rslt(12,2) = static_cast<FP>(0.000032978055036777891591277579760998715299);
    rslt(12,3) = static_cast<FP>(2.6604863877670692854046799942476295075e-6);
    rslt(12,4) = static_cast<FP>(3.9267432561125608687079771809514611424e-8);
    rslt(12,5) = static_cast<FP>(1.4061581395713418668803941418587058633e-11);
    rslt(12,6) = 0;
    rslt(12,7) = static_cast<FP>(1.4061581395713418668803941418587058633e-11);
    rslt(12,8) = static_cast<FP>(3.9267432561125608687079771809514611424e-8);
    rslt(12,9) = static_cast<FP>(2.6604863877670692854046799942476295075e-6);
    rslt(12,10) = static_cast<FP>(0.000032978055036777891591277579760998715299);
    rslt(12,11) = static_cast<FP>(0.00013754632712350962404456424728771623077);
    rslt(12,12) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000065562134008152935085062906197836066888);
    rslt(13,2) = -static_cast<FP>(0.000013955448283666190049945137488199001523);
    rslt(13,3) = -static_cast<FP>(9.1279754071737006036710465868967512979e-7);
    rslt(13,4) = -static_cast<FP>(9.4813144164046386960404792238880123793e-9);
    rslt(13,5) = -static_cast<FP>(1.7526842292882078013676076436097656325e-12);
    rslt(13,6) = 0;
    rslt(13,7) = static_cast<FP>(1.7526842292882078013676076436097656325e-12);
    rslt(13,8) = static_cast<FP>(9.4813144164046386960404792238880123793e-9);
    rslt(13,9) = static_cast<FP>(9.1279754071737006036710465868967512979e-7);
    rslt(13,10) = static_cast<FP>(0.000013955448283666190049945137488199001523);
    rslt(13,11) = static_cast<FP>(0.000065562134008152935085062906197836066888);
    rslt(13,12) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll_lower(SArray<FP,2,14,14> &rslt) {
    rslt(0,0) = 1;
    rslt(0,1) = 1;
    rslt(0,2) = 1;
    rslt(0,3) = 1;
    rslt(0,4) = 1;
    rslt(0,5) = 1;
    rslt(0,6) = 1;
    rslt(0,7) = 1;
    rslt(0,8) = 1;
    rslt(0,9) = 1;
    rslt(0,10) = 1;
    rslt(0,11) = 1;
    rslt(0,12) = 1;
    rslt(0,13) = 1;
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.47996752263363045067755008100771219453);
    rslt(1,2) = -static_cast<FP>(0.43390052691517362550011010145413210663);
    rslt(1,3) = -static_cast<FP>(0.36443429954566307029233620026044079783);
    rslt(1,4) = -static_cast<FP>(0.27531970146432352765831135292954031723);
    rslt(1,5) = -static_cast<FP>(0.17136200667135642252195170182083732242);
    rslt(1,6) = -static_cast<FP>(0.058165934441851933829388354868080083971);
    rslt(1,7) = static_cast<FP>(0.058165934441851933829388354868080083971);
    rslt(1,8) = static_cast<FP>(0.17136200667135642252195170182083732242);
    rslt(1,9) = static_cast<FP>(0.27531970146432352765831135292954031723);
    rslt(1,10) = static_cast<FP>(0.36443429954566307029233620026044079783);
    rslt(1,11) = static_cast<FP>(0.43390052691517362550011010145413210663);
    rslt(1,12) = static_cast<FP>(0.47996752263363045067755008100771219453);
    rslt(1,13) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.23036882278306455895238141485017699571);
    rslt(2,2) = static_cast<FP>(0.18826966725726531180919233696873834602);
    rslt(2,3) = static_cast<FP>(0.13281235868533807832209872270933375627);
    rslt(2,4) = static_cast<FP>(0.075800938014404230819899362043991656361);
    rslt(2,5) = static_cast<FP>(0.029364937330434003059409891379738410593);
    rslt(2,6) = static_cast<FP>(0.0033832759294938170370182720480208350421);
    rslt(2,7) = static_cast<FP>(0.0033832759294938170370182720480208350421);
    rslt(2,8) = static_cast<FP>(0.029364937330434003059409891379738410593);
    rslt(2,9) = static_cast<FP>(0.075800938014404230819899362043991656361);
    rslt(2,10) = static_cast<FP>(0.13281235868533807832209872270933375627);
    rslt(2,11) = static_cast<FP>(0.18826966725726531180919233696873834602);
    rslt(2,12) = static_cast<FP>(0.23036882278306455895238141485017699571);
    rslt(2,13) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.11056955316321334092848728709085910488);
    rslt(3,2) = -static_cast<FP>(0.081690307825071830071093432033845321918);
    rslt(3,3) = -static_cast<FP>(0.048401378908498543564329744310206752291);
    rslt(3,4) = -static_cast<FP>(0.020869491624841465461126844523650977879);
    rslt(3,5) = -static_cast<FP>(0.0050320345867217948886120991776588233989);
    rslt(3,6) = -static_cast<FP>(0.00019679140591363302730854479532173220090);
    rslt(3,7) = static_cast<FP>(0.00019679140591363302730854479532173220090);
    rslt(3,8) = static_cast<FP>(0.0050320345867217948886120991776588233989);
    rslt(3,9) = static_cast<FP>(0.020869491624841465461126844523650977879);
    rslt(3,10) = static_cast<FP>(0.048401378908498543564329744310206752291);
    rslt(3,11) = static_cast<FP>(0.081690307825071830071093432033845321918);
    rslt(3,12) = static_cast<FP>(0.11056955316321334092848728709085910488);
    rslt(3,13) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.053069794510455004604809424754744790228);
    rslt(4,2) = static_cast<FP>(0.035445467609161398236121058300393273744);
    rslt(4,3) = static_cast<FP>(0.017639122619562896887981511341856652759);
    rslt(4,4) = static_cast<FP>(0.0057457822038635524148412432825852682804);
    rslt(4,5) = static_cast<FP>(0.00086229954442031647418138781295182846342);
    rslt(4,6) = static_cast<FP>(0.000011446556015092251630591898772534352043);
    rslt(4,7) = static_cast<FP>(0.000011446556015092251630591898772534352043);
    rslt(4,8) = static_cast<FP>(0.00086229954442031647418138781295182846342);
    rslt(4,9) = static_cast<FP>(0.0057457822038635524148412432825852682804);
    rslt(4,10) = static_cast<FP>(0.017639122619562896887981511341856652759);
    rslt(4,11) = static_cast<FP>(0.035445467609161398236121058300393273744);
    rslt(4,12) = static_cast<FP>(0.053069794510455004604809424754744790228);
    rslt(4,13) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.025471777797858929465693546723899210976);
    rslt(5,2) = -static_cast<FP>(0.015379807072369850212971355832143682621);
    rslt(5,3) = -static_cast<FP>(0.0064283012964604658196345100673505262939);
    rslt(5,4) = -static_cast<FP>(0.0015819270410467361577061904033019788223);
    rslt(5,5) = -static_cast<FP>(0.00014776538028366187545490227039496689978);
    rslt(5,6) = -static_cast<FP>(6.6579962675884182321132958350003558527e-7);
    rslt(5,7) = static_cast<FP>(6.6579962675884182321132958350003558527e-7);
    rslt(5,8) = static_cast<FP>(0.00014776538028366187545490227039496689978);
    rslt(5,9) = static_cast<FP>(0.0015819270410467361577061904033019788223);
    rslt(5,10) = static_cast<FP>(0.0064283012964604658196345100673505262939);
    rslt(5,11) = static_cast<FP>(0.015379807072369850212971355832143682621);
    rslt(5,12) = static_cast<FP>(0.025471777797858929465693546723899210976);
    rslt(5,13) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.012225626086712661326837483256676546634);
    rslt(6,2) = static_cast<FP>(0.0066733063925549918718624333539201936194);
    rslt(6,3) = static_cast<FP>(0.0023426934802440476643827862005116828248);
    rslt(6,4) = static_cast<FP>(0.00043553568067932807016245202289803811858);
    rslt(6,5) = static_cast<FP>(0.000025321372081964385083509189061309268362);
    rslt(6,6) = static_cast<FP>(3.8726857441464280031629106142578373424e-8);
    rslt(6,7) = static_cast<FP>(3.8726857441464280031629106142578373424e-8);
    rslt(6,8) = static_cast<FP>(0.000025321372081964385083509189061309268362);
    rslt(6,9) = static_cast<FP>(0.00043553568067932807016245202289803811858);
    rslt(6,10) = static_cast<FP>(0.0023426934802440476643827862005116828248);
    rslt(6,11) = static_cast<FP>(0.0066733063925549918718624333539201936194);
    rslt(6,12) = static_cast<FP>(0.012225626086712661326837483256676546634);
    rslt(6,13) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0058679034654845621502063754980673267486);
    rslt(7,2) = -static_cast<FP>(0.0028955511599960074624744472921389801306);
    rslt(7,3) = -static_cast<FP>(0.00085375785752293117667573346481324227077);
    rslt(7,4) = -static_cast<FP>(0.00011991155358169354483212276109616290964);
    rslt(7,5) = -static_cast<FP>(4.3391211316374792227614457086940630607e-6);
    rslt(7,6) = -static_cast<FP>(2.2525838510791570273232875653835541715e-9);
    rslt(7,7) = static_cast<FP>(2.2525838510791570273232875653835541715e-9);
    rslt(7,8) = static_cast<FP>(4.3391211316374792227614457086940630607e-6);
    rslt(7,9) = static_cast<FP>(0.00011991155358169354483212276109616290964);
    rslt(7,10) = static_cast<FP>(0.00085375785752293117667573346481324227077);
    rslt(7,11) = static_cast<FP>(0.0028955511599960074624744472921389801306);
    rslt(7,12) = static_cast<FP>(0.0058679034654845621502063754980673267486);
    rslt(7,13) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0028164030893819201418568868880816241106);
    rslt(8,2) = static_cast<FP>(0.0012563811740321098487821834609694037418);
    rslt(8,3) = static_cast<FP>(0.00031113864678797543361923562483439672039);
    rslt(8,4) = static_cast<FP>(0.000033014013134235101402850700220121611363);
    rslt(8,5) = static_cast<FP>(7.4356050430748534422126290725931120391e-7);
    rslt(8,6) = static_cast<FP>(1.3102364460664460713909902417339527250e-10);
    rslt(8,7) = static_cast<FP>(1.3102364460664460713909902417339527250e-10);
    rslt(8,8) = static_cast<FP>(7.4356050430748534422126290725931120391e-7);
    rslt(8,9) = static_cast<FP>(0.000033014013134235101402850700220121611363);
    rslt(8,10) = static_cast<FP>(0.00031113864678797543361923562483439672039);
    rslt(8,11) = static_cast<FP>(0.0012563811740321098487821834609694037418);
    rslt(8,12) = static_cast<FP>(0.0028164030893819201418568868880816241106);
    rslt(8,13) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0013517820135483434809036489010167624131);
    rslt(9,2) = -static_cast<FP>(0.00054514445341883691832542061626157748986);
    rslt(9,3) = -static_cast<FP>(0.00011338959480376129807317657180177582335);
    rslt(9,4) = -static_cast<FP>(9.0894082402568640225834017148507245368e-6);
    rslt(9,5) = -static_cast<FP>(1.2741802009969644950184773878522498768e-7);
    rslt(9,6) = -static_cast<FP>(7.6211127225225969271291920170955822759e-12);
    rslt(9,7) = static_cast<FP>(7.6211127225225969271291920170955822759e-12);
    rslt(9,8) = static_cast<FP>(1.2741802009969644950184773878522498768e-7);
    rslt(9,9) = static_cast<FP>(9.0894082402568640225834017148507245368e-6);
    rslt(9,10) = static_cast<FP>(0.00011338959480376129807317657180177582335);
    rslt(9,11) = static_cast<FP>(0.00054514445341883691832542061626157748986);
    rslt(9,12) = static_cast<FP>(0.0013517820135483434809036489010167624131);
    rslt(9,13) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00064881146418349909419662167312303262445);
    rslt(10,2) = static_cast<FP>(0.00023653846558331766302621191830129866704);
    rslt(10,3) = static_cast<FP>(0.000041323057558075305666452475395600552080);
    rslt(10,4) = static_cast<FP>(2.5024931631948820643379105325933298761e-6);
    rslt(10,5) = static_cast<FP>(2.1834607610375209716676673282142555197e-8);
    rslt(10,6) = static_cast<FP>(4.4328914299221308075036362396881370915e-13);
    rslt(10,7) = static_cast<FP>(4.4328914299221308075036362396881370915e-13);
    rslt(10,8) = static_cast<FP>(2.1834607610375209716676673282142555197e-8);
    rslt(10,9) = static_cast<FP>(2.5024931631948820643379105325933298761e-6);
    rslt(10,10) = static_cast<FP>(0.000041323057558075305666452475395600552080);
    rslt(10,11) = static_cast<FP>(0.00023653846558331766302621191830129866704);
    rslt(10,12) = static_cast<FP>(0.00064881146418349909419662167312303262445);
    rslt(10,13) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00031140843112045251398614875896701591946);
    rslt(11,2) = -static_cast<FP>(0.00010263416485230819593028194435730708145);
    rslt(11,3) = -static_cast<FP>(0.000015059539536262292270770635898426512866);
    rslt(11,4) = -static_cast<FP>(6.8898567060732558815923017922051361442e-7);
    rslt(11,5) = -static_cast<FP>(3.7416221749955664021924878607477841489e-9);
    rslt(11,6) = -static_cast<FP>(2.5784327230069793645543927742396812301e-14);
    rslt(11,7) = static_cast<FP>(2.5784327230069793645543927742396812301e-14);
    rslt(11,8) = static_cast<FP>(3.7416221749955664021924878607477841489e-9);
    rslt(11,9) = static_cast<FP>(6.8898567060732558815923017922051361442e-7);
    rslt(11,10) = static_cast<FP>(0.000015059539536262292270770635898426512866);
    rslt(11,11) = static_cast<FP>(0.00010263416485230819593028194435730708145);
    rslt(11,12) = static_cast<FP>(0.00031140843112045251398614875896701591946);
    rslt(11,13) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00014946593321210914121224330053759580652);
    rslt(12,2) = static_cast<FP>(0.000044533018208915319276323258868612620319);
    rslt(12,3) = static_cast<FP>(5.4882127423779681443771221748360770871e-6);
    rslt(12,4) = static_cast<FP>(1.8969132914480562642406913143118654368e-7);
    rslt(12,5) = static_cast<FP>(6.4117188411328537761973490539726923598e-10);
    rslt(12,6) = static_cast<FP>(1.4997694872914972816764222850875496993e-15);
    rslt(12,7) = static_cast<FP>(1.4997694872914972816764222850875496993e-15);
    rslt(12,8) = static_cast<FP>(6.4117188411328537761973490539726923598e-10);
    rslt(12,9) = static_cast<FP>(1.8969132914480562642406913143118654368e-7);
    rslt(12,10) = static_cast<FP>(5.4882127423779681443771221748360770871e-6);
    rslt(12,11) = static_cast<FP>(0.000044533018208915319276323258868612620319);
    rslt(12,12) = static_cast<FP>(0.00014946593321210914121224330053759580652);
    rslt(12,13) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000071738793681939691523317808771316244284);
    rslt(13,2) = -static_cast<FP>(0.000019322900065971378652170053683789667135);
    rslt(13,3) = -static_cast<FP>(2.0000929665260974291638917687744735932e-6);
    rslt(13,4) = -static_cast<FP>(5.2225760110518617884902410187951892057e-8);
    rslt(13,5) = -static_cast<FP>(1.0987250068290697589933994843340237799e-10);
    rslt(13,6) = -static_cast<FP>(8.7235493675687117905228544109543138332e-17);
    rslt(13,7) = static_cast<FP>(8.7235493675687117905228544109543138332e-17);
    rslt(13,8) = static_cast<FP>(1.0987250068290697589933994843340237799e-10);
    rslt(13,9) = static_cast<FP>(5.2225760110518617884902410187951892057e-8);
    rslt(13,10) = static_cast<FP>(2.0000929665260974291638917687744735932e-6);
    rslt(13,11) = static_cast<FP>(0.000019322900065971378652170053683789667135);
    rslt(13,12) = static_cast<FP>(0.000071738793681939691523317808771316244284);
    rslt(13,13) = static_cast<FP>(0.00012207031250000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_points(SArray<FP,1,15> &rslt) {
    rslt(0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1) = -static_cast<FP>(0.48262296325191928639792569603480058885);
    rslt(2) = -static_cast<FP>(0.44254102211148814941270081574111482599);
    rslt(3) = -static_cast<FP>(0.38175984497590760035205923798814580909);
    rslt(4) = -static_cast<FP>(0.30312660273492285556176496931836675359);
    rslt(5) = -static_cast<FP>(0.21031902735683624046094846936929020649);
    rslt(6) = -static_cast<FP>(0.10767697768189711911283972313645885633);
    rslt(7) = static_cast<FP>(0.00000000000000000000000000000000000000);
    rslt(8) = static_cast<FP>(0.10767697768189711911283972313645885633);
    rslt(9) = static_cast<FP>(0.21031902735683624046094846936929020649);
    rslt(10) = static_cast<FP>(0.30312660273492285556176496931836675359);
    rslt(11) = static_cast<FP>(0.38175984497590760035205923798814580909);
    rslt(12) = static_cast<FP>(0.44254102211148814941270081574111482599);
    rslt(13) = static_cast<FP>(0.48262296325191928639792569603480058885);
    rslt(14) = static_cast<FP>(0.50000000000000000000000000000000000000);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void get_gll_weights(SArray<FP,1,15> &rslt) {
    rslt(0) = static_cast<FP>(0.0047619047619047619047619047619047619048);
    rslt(1) = static_cast<FP>(0.029014946514300624548440292012640997718);
    rslt(2) = static_cast<FP>(0.050830035162859033801833085394400357740);
    rslt(3) = static_cast<FP>(0.070255849901214054730223402821836445311);
    rslt(4) = static_cast<FP>(0.086394823626800474526038549704175293678);
    rslt(5) = static_cast<FP>(0.098493617982306678046250173253703297432);
    rslt(6) = static_cast<FP>(0.10598679296341046006371503848861045831);
    rslt(7) = static_cast<FP>(0.10852405817440782475747510712545677581);
    rslt(8) = static_cast<FP>(0.10598679296341046006371503848861045831);
    rslt(9) = static_cast<FP>(0.098493617982306678046250173253703297432);
    rslt(10) = static_cast<FP>(0.086394823626800474526038549704175293678);
    rslt(11) = static_cast<FP>(0.070255849901214054730223402821836445311);
    rslt(12) = static_cast<FP>(0.050830035162859033801833085394400357740);
    rslt(13) = static_cast<FP>(0.029014946514300624548440292012640997718);
    rslt(14) = static_cast<FP>(0.0047619047619047619047619047619047619048);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void gll_to_coefs(SArray<FP,2,15,15> &rslt) {
    rslt(0,0) = static_cast<FP>(1.3858119863203620685680745673256043688e-36);
    rslt(0,1) = -static_cast<FP>(0.41894531250000000000000000000000318385);
    rslt(0,2) = static_cast<FP>(0.83789062499999999999999999999998354632);
    rslt(0,3) = static_cast<FP>(56.976562500000000000000000000000255532);
    rslt(0,4) = -static_cast<FP>(113.95312499999999999999999999999910080);
    rslt(0,5) = -static_cast<FP>(2165.1093750000000000000000000000108299);
    rslt(0,6) = static_cast<FP>(4330.2187499999999999999999999999759808);
    rslt(0,7) = static_cast<FP>(34641.750000000000000000000000000193721);
    rslt(0,8) = -static_cast<FP>(69283.499999999999999999999999999613544);
    rslt(0,9) = -static_cast<FP>(265586.75000000000000000000000000158229);
    rslt(0,10) = static_cast<FP>(531173.49999999999999999999999999688002);
    rslt(0,11) = static_cast<FP>(965770.00000000000000000000000000586190);
    rslt(0,12) = -static_cast<FP>(1.9315399999999999999999999999999883414e6);
    rslt(0,13) = -static_cast<FP>(1.3372200000000000000000000000000080027e6);
    rslt(0,14) = static_cast<FP>(2.6744399999999999999999999999999839049e6);
    rslt(1,0) = -static_cast<FP>(4.1322727749697335406728010071317496362e-36);
    rslt(1,1) = static_cast<FP>(1.0713710145804814494951053721094839271);
    rslt(1,2) = -static_cast<FP>(2.2198923303639983614902687174775947424);
    rslt(1,3) = -static_cast<FP>(145.39230112197434371485863782814040420);
    rslt(1,4) = static_cast<FP>(301.25442051559106000173951763934197113);
    rslt(1,5) = static_cast<FP>(5495.4688175501335450249643704364050188);
    rslt(1,6) = -static_cast<FP>(11386.670830002781187770768047874422469);
    rslt(1,7) = -static_cast<FP>(87143.602946869275113017207710693521935);
    rslt(1,8) = static_cast<FP>(180562.48786774387695087988205776217076);
    rslt(1,9) = static_cast<FP>(659417.04743208638516723808966737121093);
    rslt(1,10) = -static_cast<FP>(1.3663192546598413999244066861959453548e6);
    rslt(1,11) = -static_cast<FP>(2.3554858201695343566886082804189506087e6);
    rslt(1,12) = static_cast<FP>(4.8805920967751778492762052164000173430e6);
    rslt(1,13) = static_cast<FP>(3.1861144737447347597322173951823840935e6);
    rslt(1,14) = -static_cast<FP>(6.6016636512209394472544268433017685698e6);
    rslt(2,0) = static_cast<FP>(5.0601706347484919358680364833438619086e-36);
    rslt(2,1) = -static_cast<FP>(1.5464776850997445352071477817411209776);
    rslt(2,2) = static_cast<FP>(3.4945408624969113968383788549605649742);
    rslt(2,3) = static_cast<FP>(208.61034047907173523564932949987054128);
    rslt(2,4) = -static_cast<FP>(471.39209712973705447555736295181064021);
    rslt(2,5) = -static_cast<FP>(7768.2864116003475594574323397868615174);
    rslt(2,6) = static_cast<FP>(17553.822184744953223704998658329176876);
    rslt(2,7) = static_cast<FP>(120177.95612490964746161388851166433258);
    rslt(2,8) = -static_cast<FP>(271563.42603338034421807670131059400821);
    rslt(2,9) = -static_cast<FP>(878230.94349960565760099938826000041730);
    rslt(2,10) = static_cast<FP>(1.9845187216979747876210073624342744522e6);
    rslt(2,11) = static_cast<FP>(3.0021362495816589723583710304811352696e6);
    rslt(2,12) = -static_cast<FP>(6.7838597996127441433538579299309626529e6);
    rslt(2,13) = -static_cast<FP>(3.8668403890098747334047765316194709308e6);
    rslt(2,14) = static_cast<FP>(8.7378123062130773708692638879939424278e6);
    rslt(3,0) = -static_cast<FP>(5.4032250686243281621260520228701831564e-36);
    rslt(3,1) = static_cast<FP>(2.1075990180995959468492255661048294815);
    rslt(3,2) = -static_cast<FP>(5.5207456882548869390003762288320531707);
    rslt(3,3) = -static_cast<FP>(280.60255718475644698972074983334068081);
    rslt(3,4) = static_cast<FP>(735.02376134521149860269410477128139746);
    rslt(3,5) = static_cast<FP>(10113.249189923659386566853907482069712);
    rslt(3,6) = -static_cast<FP>(26491.128710935782799774964738864424042);
    rslt(3,7) = -static_cast<FP>(148449.30472140991635554431700252839197);
    rslt(3,8) = static_cast<FP>(388855.21008836948653459685124421985938);
    rslt(3,9) = static_cast<FP>(1.0146007833072596218921530290519122452e6);
    rslt(3,10) = -static_cast<FP>(2.6576938267860252397916470237328649365e6);
    rslt(3,11) = -static_cast<FP>(3.2412102970532588433702096274567579940e6);
    rslt(3,12) = static_cast<FP>(8.4901813003874403929062189277218541708e6);
    rslt(3,13) = static_cast<FP>(3.9216966578257139237192913527534187584e6);
    rslt(3,14) = -static_cast<FP>(1.0272679825907849034097344059894852431e7);
    rslt(4,0) = static_cast<FP>(4.3620408045546237949446034098794398443e-36);
    rslt(4,1) = -static_cast<FP>(2.9434509034938782086849438216138585728);
    rslt(4,2) = static_cast<FP>(9.7103021540734165629110672706310893041);
    rslt(4,3) = static_cast<FP>(380.04930937621588181276341457021125660);
    rslt(4,4) = -static_cast<FP>(1253.7642884104109436519198507261275481);
    rslt(4,5) = -static_cast<FP>(12676.883818650350345304179125824837813);
    rslt(4,6) = static_cast<FP>(41820.426528964168772712470127437109360);
    rslt(4,7) = static_cast<FP>(166271.52114614438541241898429983426694);
    rslt(4,8) = -static_cast<FP>(548521.70560412657940270283392895419843);
    rslt(4,9) = -static_cast<FP>(1.0299808891429344679558725041404091995e6);
    rslt(4,10) = static_cast<FP>(3.3978571324656342809969487969798788584e6);
    rslt(4,11) = static_cast<FP>(3.0398987664989432162195989911896206682e6);
    rslt(4,12) = -static_cast<FP>(1.0028478988883940977136185603139155930e7);
    rslt(4,13) = -static_cast<FP>(3.4531100533881064934148772441167360458e6);
    rslt(4,14) = static_cast<FP>(1.1391643037044065380610032875310780590e7);
    rslt(5,0) = -static_cast<FP>(3.4064195758356715504917695499813376386e-36);
    rslt(5,1) = static_cast<FP>(4.5296272838092843702016053994411501511);
    rslt(5,2) = -static_cast<FP>(21.536935296510882716968634187362061997);
    rslt(5,3) = -static_cast<FP>(531.74655073175389431108672453736736894);
    rslt(5,4) = static_cast<FP>(2528.2855166003121332220903679178664647);
    rslt(5,5) = static_cast<FP>(13852.038534035386432005378382646579071);
    rslt(5,6) = -static_cast<FP>(65862.032114352766110892498553515520559);
    rslt(5,7) = -static_cast<FP>(155029.28679783793350011680792994426325);
    rslt(5,8) = static_cast<FP>(737114.89039367145429146068609841781942);
    rslt(5,9) = static_cast<FP>(864954.67004195429112234024490028506780);
    rslt(5,10) = -static_cast<FP>(4.1125840153988315688034719770952686594e6);
    rslt(5,11) = -static_cast<FP>(2.3739279687499398194829136649786709197e6);
    rslt(5,12) = static_cast<FP>(1.1287271525472739483866604955498879091e7);
    rslt(5,13) = static_cast<FP>(2.5581447592718925963825166132791844444e6);
    rslt(5,14) = -static_cast<FP>(1.2163163701454528833686589480186445473e7);
    rslt(6,0) = static_cast<FP>(1.8727380459603842891990679168460982038e-36);
    rslt(6,1) = -static_cast<FP>(9.1778299292499389566718587224353254951);
    rslt(6,2) = static_cast<FP>(85.234839673559440057709833008080064172);
    rslt(6,3) = static_cast<FP>(493.31714034340002058596011494703315188);
    rslt(6,4) = -static_cast<FP>(4581.4541879209666936990467766505540642);
    rslt(6,5) = -static_cast<FP>(9875.6332231440636360353113622661455575);
    rslt(6,6) = static_cast<FP>(91715.364191582208102020762554488156442);
    rslt(6,7) = static_cast<FP>(96856.585318203978453491251220678646789);
    rslt(6,8) = -static_cast<FP>(899510.62337894456082282455082751916801);
    rslt(6,9) = -static_cast<FP>(500003.53905087688623986738824540439328);
    rslt(6,10) = static_cast<FP>(4.6435510154083618671742968003372026653e6);
    rslt(6,11) = static_cast<FP>(1.3051079370798956681503662055277535790e6);
    rslt(6,12) = -static_cast<FP>(1.2120584782157320624207004214569289313e7);
    rslt(6,13) = -static_cast<FP>(1.3585988390671606940754822039465110268e6);
    rslt(6,14) = static_cast<FP>(1.2617356730431069668454168515183244939e7);
    rslt(7,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(7,1) = static_cast<FP>(3.7649115103800241548662783653528681799e-33);
    rslt(7,2) = -static_cast<FP>(139.99999999999999999999999999999998441);
    rslt(7,3) = static_cast<FP>(5.4902846036511505069789211205132757743e-31);
    rslt(7,4) = static_cast<FP>(5712.0000000000000000000000000000026231);
    rslt(7,5) = -static_cast<FP>(1.1094319444642672131528960938260473818e-30);
    rslt(7,6) = -static_cast<FP>(103360.00000000000000000000000000008262);
    rslt(7,7) = -static_cast<FP>(2.5089281978526960181345530255848106671e-28);
    rslt(7,8) = static_cast<FP>(964693.33333333333333333333333333394628);
    rslt(7,9) = static_cast<FP>(3.4644583100890014593754046996277194730e-27);
    rslt(7,10) = -static_cast<FP>(4.8410065454545454545454545454545454092e6);
    rslt(7,11) = -static_cast<FP>(1.6355884556254780502432452883067145924e-26);
    rslt(7,12) = static_cast<FP>(1.2412837296037296037296037296037283147e7);
    rslt(7,13) = static_cast<FP>(2.5777755711326731705152569026851596149e-26);
    rslt(7,14) = -static_cast<FP>(1.2767489790209790209790209790209760386e7);
    rslt(8,0) = -static_cast<FP>(1.8727380459603842891990679168460549114e-36);
    rslt(8,1) = static_cast<FP>(9.1778299292499389566718587224353186379);
    rslt(8,2) = static_cast<FP>(85.234839673559440057709833008080101636);
    rslt(8,3) = -static_cast<FP>(493.31714034340002058596011494703429103);
    rslt(8,4) = -static_cast<FP>(4581.4541879209666936990467766505579869);
    rslt(8,5) = static_cast<FP>(9875.6332231440636360353113622661509602);
    rslt(8,6) = static_cast<FP>(91715.364191582208102020762554488278981);
    rslt(8,7) = -static_cast<FP>(96856.585318203978453491251220678215459);
    rslt(8,8) = -static_cast<FP>(899510.62337894456082282455082752090999);
    rslt(8,9) = static_cast<FP>(500003.53905087688623986738824539810457);
    rslt(8,10) = static_cast<FP>(4.6435510154083618671742968003372147839e6);
    rslt(8,11) = -static_cast<FP>(1.3051079370798956681503662055277234086e6);
    rslt(8,12) = -static_cast<FP>(1.2120584782157320624207004214569329535e7);
    rslt(8,13) = static_cast<FP>(1.3585988390671606940754822039464631304e6);
    rslt(8,14) = static_cast<FP>(1.2617356730431069668454168515183295852e7);
    rslt(9,0) = static_cast<FP>(3.4064195758356715504917695499813029894e-36);
    rslt(9,1) = -static_cast<FP>(4.5296272838092843702016053994411448122);
    rslt(9,2) = -static_cast<FP>(21.536935296510882716968634187362130286);
    rslt(9,3) = static_cast<FP>(531.74655073175389431108672453736856662);
    rslt(9,4) = static_cast<FP>(2528.2855166003121332220903679178734788);
    rslt(9,5) = -static_cast<FP>(13852.038534035386432005378382646591006);
    rslt(9,6) = -static_cast<FP>(65862.032114352766110892498553515739004);
    rslt(9,7) = static_cast<FP>(155029.28679783793350011680792994398942);
    rslt(9,8) = static_cast<FP>(737114.89039367145429146068609842092100);
    rslt(9,9) = -static_cast<FP>(864954.67004195429112234024490028026534);
    rslt(9,10) = -static_cast<FP>(4.1125840153988315688034719770952902082e6);
    rslt(9,11) = static_cast<FP>(2.3739279687499398194829136649786467728e6);
    rslt(9,12) = static_cast<FP>(1.1287271525472739483866604955498950487e7);
    rslt(9,13) = -static_cast<FP>(2.5581447592718925963825166132791453317e6);
    rslt(9,14) = -static_cast<FP>(1.2163163701454528833686589480186535656e7);
    rslt(10,0) = -static_cast<FP>(4.3620408045546237949446034098794161119e-36);
    rslt(10,1) = static_cast<FP>(2.9434509034938782086849438216138552997);
    rslt(10,2) = static_cast<FP>(9.7103021540734165629110672706311760410);
    rslt(10,3) = -static_cast<FP>(380.04930937621588181276341457021250801);
    rslt(10,4) = -static_cast<FP>(1253.7642884104109436519198507261362047);
    rslt(10,5) = static_cast<FP>(12676.883818650350345304179125824857363);
    rslt(10,6) = static_cast<FP>(41820.426528964168772712470127437377239);
    rslt(10,7) = -static_cast<FP>(166271.52114614438541241898429983418576);
    rslt(10,8) = -static_cast<FP>(548521.70560412657940270283392895799009);
    rslt(10,9) = static_cast<FP>(1.0299808891429344679558725041404062544e6);
    rslt(10,10) = static_cast<FP>(3.3978571324656342809969487969799051239e6);
    rslt(10,11) = -static_cast<FP>(3.0398987664989432162195989911896041292e6);
    rslt(10,12) = -static_cast<FP>(1.0028478988883940977136185603139242670e7);
    rslt(10,13) = static_cast<FP>(3.4531100533881064934148772441167080863e6);
    rslt(10,14) = static_cast<FP>(1.1391643037044065380610032875310889766e7);
    rslt(11,0) = static_cast<FP>(4.6509086840980641570260606390479280194e-36);
    rslt(11,1) = -static_cast<FP>(2.1075990180995959468492255661048267056);
    rslt(11,2) = -static_cast<FP>(5.5207456882548869390003762288321476070);
    rslt(11,3) = static_cast<FP>(280.60255718475644698972074983334172225);
    rslt(11,4) = static_cast<FP>(735.02376134521149860269410477129066886);
    rslt(11,5) = -static_cast<FP>(10113.249189923659386566853907482087083);
    rslt(11,6) = -static_cast<FP>(26491.128710935782799774964738864711956);
    rslt(11,7) = static_cast<FP>(148449.30472140991635554431700252835518);
    rslt(11,8) = static_cast<FP>(388855.21008836948653459685124422394023);
    rslt(11,9) = -static_cast<FP>(1.0146007833072596218921530290519101006e6);
    rslt(11,10) = -static_cast<FP>(2.6576938267860252397916470237328931819e6);
    rslt(11,11) = static_cast<FP>(3.2412102970532588433702096274567455173e6);
    rslt(11,12) = static_cast<FP>(8.4901813003874403929062189277219472386e6);
    rslt(11,13) = -static_cast<FP>(3.9216966578257139237192913527533974338e6);
    rslt(11,14) = -static_cast<FP>(1.0272679825907849034097344059894969203e7);
    rslt(12,0) = -static_cast<FP>(4.3078542502222279307680450995216157289e-36);
    rslt(12,1) = static_cast<FP>(1.5464776850997445352071477817411202837);
    rslt(12,2) = static_cast<FP>(3.4945408624969113968383788549606502475);
    rslt(12,3) = -static_cast<FP>(208.61034047907173523564932949987156841);
    rslt(12,4) = -static_cast<FP>(471.39209712973705447555736295181869594);
    rslt(12,5) = static_cast<FP>(7768.2864116003475594574323397868834705);
    rslt(12,6) = static_cast<FP>(17553.822184744953223704998658329424007);
    rslt(12,7) = -static_cast<FP>(120177.95612490964746161388851166443741);
    rslt(12,8) = -static_cast<FP>(271563.42603338034421807670131059749071);
    rslt(12,9) = static_cast<FP>(878230.94349960565760099938825999974153);
    rslt(12,10) = static_cast<FP>(1.9845187216979747876210073624342984419e6);
    rslt(12,11) = -static_cast<FP>(3.0021362495816589723583710304811290353e6);
    rslt(12,12) = -static_cast<FP>(6.7838597996127441433538579299310412888e6);
    rslt(12,13) = static_cast<FP>(3.8668403890098747334047765316194589459e6);
    rslt(12,14) = static_cast<FP>(8.7378123062130773708692638879940405236e6);
    rslt(13,0) = static_cast<FP>(3.3799563904434695355728096233095042482e-36);
    rslt(13,1) = -static_cast<FP>(1.0713710145804814494951053721094825020);
    rslt(13,2) = -static_cast<FP>(2.2198923303639983614902687174776639713);
    rslt(13,3) = static_cast<FP>(145.39230112197434371485863782814102287);
    rslt(13,4) = static_cast<FP>(301.25442051559106000173951763934855138);
    rslt(13,5) = -static_cast<FP>(5495.4688175501335450249643704364168923);
    rslt(13,6) = -static_cast<FP>(11386.670830002781187770768047874625484);
    rslt(13,7) = static_cast<FP>(87143.602946869275113017207710693542683);
    rslt(13,8) = static_cast<FP>(180562.48786774387695087988205776503729);
    rslt(13,9) = -static_cast<FP>(659417.04743208638516723808966737035577);
    rslt(13,10) = -static_cast<FP>(1.3663192546598413999244066861959651082e6);
    rslt(13,11) = static_cast<FP>(2.3554858201695343566886082804189449262e6);
    rslt(13,12) = static_cast<FP>(4.8805920967751778492762052164000820834e6);
    rslt(13,13) = -static_cast<FP>(3.1861144737447347597322173951823739764e6);
    rslt(13,14) = -static_cast<FP>(6.6016636512209394472544268433018493113e6);
    rslt(14,0) = -static_cast<FP>(1.3858119863203620685680745673256019460e-36);
    rslt(14,1) = static_cast<FP>(0.41894531250000000000000000000000303874);
    rslt(14,2) = static_cast<FP>(0.83789062500000000000000000000001108057);
    rslt(14,3) = -static_cast<FP>(56.976562500000000000000000000000552201);
    rslt(14,4) = -static_cast<FP>(113.95312500000000000000000000000164637);
    rslt(14,5) = static_cast<FP>(2165.1093750000000000000000000000173170);
    rslt(14,6) = static_cast<FP>(4330.2187500000000000000000000000539256);
    rslt(14,7) = -static_cast<FP>(34641.750000000000000000000000000227670);
    rslt(14,8) = -static_cast<FP>(69283.500000000000000000000000000714329);
    rslt(14,9) = static_cast<FP>(265586.75000000000000000000000000141887);
    rslt(14,10) = static_cast<FP>(531173.50000000000000000000000000447918);
    rslt(14,11) = -static_cast<FP>(965770.00000000000000000000000000417345);
    rslt(14,12) = -static_cast<FP>(1.9315400000000000000000000000000132927e6);
    rslt(14,13) = static_cast<FP>(1.3372200000000000000000000000000046785e6);
    rslt(14,14) = static_cast<FP>(2.6744400000000000000000000000000150727e6);
  }

  template <class FP> KOKKOS_INLINE_FUNCTION void coefs_to_gll(SArray<FP,2,15,15> &rslt) {
    rslt(0,0) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,1) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,2) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,3) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,4) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,5) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,6) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,7) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,8) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,9) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,10) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,11) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,12) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,13) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(0,14) = static_cast<FP>(1.0000000000000000000000000000000000000);
    rslt(1,0) = -static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(1,1) = -static_cast<FP>(0.48262296325191928639792569603480058885);
    rslt(1,2) = -static_cast<FP>(0.44254102211148814941270081574111482599);
    rslt(1,3) = -static_cast<FP>(0.38175984497590760035205923798814580909);
    rslt(1,4) = -static_cast<FP>(0.30312660273492285556176496931836675359);
    rslt(1,5) = -static_cast<FP>(0.21031902735683624046094846936929020649);
    rslt(1,6) = -static_cast<FP>(0.10767697768189711911283972313645885633);
    rslt(1,7) = 0;
    rslt(1,8) = static_cast<FP>(0.10767697768189711911283972313645885633);
    rslt(1,9) = static_cast<FP>(0.21031902735683624046094846936929020649);
    rslt(1,10) = static_cast<FP>(0.30312660273492285556176496931836675359);
    rslt(1,11) = static_cast<FP>(0.38175984497590760035205923798814580909);
    rslt(1,12) = static_cast<FP>(0.44254102211148814941270081574111482599);
    rslt(1,13) = static_cast<FP>(0.48262296325191928639792569603480058885);
    rslt(1,14) = static_cast<FP>(0.50000000000000000000000000000000000000);
    rslt(2,0) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(2,1) = static_cast<FP>(0.23292492465806343393988831980754573322);
    rslt(2,2) = static_cast<FP>(0.19584255625148064317640024501608198628);
    rslt(2,3) = static_cast<FP>(0.14574057923602900349002860397114140798);
    rslt(2,4) = static_cast<FP>(0.091885737285615740417260836171280395908);
    rslt(2,5) = static_cast<FP>(0.044234093268325630911501529656080677320);
    rslt(2,6) = static_cast<FP>(0.011594331522707770287142687600092021512);
    rslt(2,7) = 0;
    rslt(2,8) = static_cast<FP>(0.011594331522707770287142687600092021512);
    rslt(2,9) = static_cast<FP>(0.044234093268325630911501529656080677320);
    rslt(2,10) = static_cast<FP>(0.091885737285615740417260836171280395908);
    rslt(2,11) = static_cast<FP>(0.14574057923602900349002860397114140798);
    rslt(2,12) = static_cast<FP>(0.19584255625148064317640024501608198628);
    rslt(2,13) = static_cast<FP>(0.23292492465806343393988831980754573322);
    rslt(2,14) = static_cast<FP>(0.25000000000000000000000000000000000000);
    rslt(3,0) = -static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(3,1) = -static_cast<FP>(0.11241491735370461713417361198386752247);
    rslt(3,2) = -static_cast<FP>(0.086668365016456857017231828849344900836);
    rslt(3,3) = -static_cast<FP>(0.055637900935845410507980991003693519711);
    rslt(3,4) = -static_cast<FP>(0.027853011383182331301741198183720575842);
    rslt(3,5) = -static_cast<FP>(0.0093032714722058241545363916423396344832);
    rslt(3,6) = -static_cast<FP>(0.0012484425766071208223035593651243574432);
    rslt(3,7) = 0;
    rslt(3,8) = static_cast<FP>(0.0012484425766071208223035593651243574432);
    rslt(3,9) = static_cast<FP>(0.0093032714722058241545363916423396344832);
    rslt(3,10) = static_cast<FP>(0.027853011383182331301741198183720575842);
    rslt(3,11) = static_cast<FP>(0.055637900935845410507980991003693519711);
    rslt(3,12) = static_cast<FP>(0.086668365016456857017231828849344900836);
    rslt(3,13) = static_cast<FP>(0.11241491735370461713417361198386752247);
    rslt(3,14) = static_cast<FP>(0.12500000000000000000000000000000000000);
    rslt(4,0) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(4,1) = static_cast<FP>(0.054254020526964527108302498008078327697);
    rslt(4,2) = static_cast<FP>(0.038354306839114359951622879618367457711);
    rslt(4,3) = static_cast<FP>(0.021240316436053248314569269427127631094);
    rslt(4,4) = static_cast<FP>(0.0084429887165211946956577500797688399895);
    rslt(4,5) = static_cast<FP>(0.0019566550072709308960447110689540066048);
    rslt(4,6) = static_cast<FP>(0.00013442852345845508318560784708645295269);
    rslt(4,7) = 0;
    rslt(4,8) = static_cast<FP>(0.00013442852345845508318560784708645295269);
    rslt(4,9) = static_cast<FP>(0.0019566550072709308960447110689540066048);
    rslt(4,10) = static_cast<FP>(0.0084429887165211946956577500797688399895);
    rslt(4,11) = static_cast<FP>(0.021240316436053248314569269427127631094);
    rslt(4,12) = static_cast<FP>(0.038354306839114359951622879618367457711);
    rslt(4,13) = static_cast<FP>(0.054254020526964527108302498008078327697);
    rslt(4,14) = static_cast<FP>(0.062500000000000000000000000000000000000);
    rslt(5,0) = -static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(5,1) = -static_cast<FP>(0.026184236155054075604274089786290288498);
    rslt(5,2) = -static_cast<FP>(0.016973354150959309119366814214908984771);
    rslt(5,3) = -static_cast<FP>(0.0081086999098669102960903558776735501381);
    rslt(5,4) = -static_cast<FP>(0.0025592944865683563860966753076810528373);
    rslt(5,5) = -static_cast<FP>(0.00041152177800210552811401055344825514301);
    rslt(5,6) = -static_cast<FP>(0.000014474857120246451320623097665613880954);
    rslt(5,7) = 0;
    rslt(5,8) = static_cast<FP>(0.000014474857120246451320623097665613880954);
    rslt(5,9) = static_cast<FP>(0.00041152177800210552811401055344825514301);
    rslt(5,10) = static_cast<FP>(0.0025592944865683563860966753076810528373);
    rslt(5,11) = static_cast<FP>(0.0081086999098669102960903558776735501381);
    rslt(5,12) = static_cast<FP>(0.016973354150959309119366814214908984771);
    rslt(5,13) = static_cast<FP>(0.026184236155054075604274089786290288498);
    rslt(5,14) = static_cast<FP>(0.031250000000000000000000000000000000000);
    rslt(6,0) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(6,1) = static_cast<FP>(0.012637113643640239480416765091545686850);
    rslt(6,2) = static_cast<FP>(0.0075114054946258027817153470075507202399);
    rslt(6,3) = static_cast<FP>(0.0030955760205469476064106235275802572148);
    rslt(6,4) = static_cast<FP>(0.00077579024311168452433478284616605088827);
    rslt(6,5) = static_cast<FP>(0.000086550860085558722754336227086585718074);
    rslt(6,6) = static_cast<FP>(1.5586088670854267430483835084041048402e-6);
    rslt(6,7) = 0;
    rslt(6,8) = static_cast<FP>(1.5586088670854267430483835084041048402e-6);
    rslt(6,9) = static_cast<FP>(0.000086550860085558722754336227086585718074);
    rslt(6,10) = static_cast<FP>(0.00077579024311168452433478284616605088827);
    rslt(6,11) = static_cast<FP>(0.0030955760205469476064106235275802572148);
    rslt(6,12) = static_cast<FP>(0.0075114054946258027817153470075507202399);
    rslt(6,13) = static_cast<FP>(0.012637113643640239480416765091545686850);
    rslt(6,14) = static_cast<FP>(0.015625000000000000000000000000000000000);
    rslt(7,0) = -static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(7,1) = -static_cast<FP>(0.0060989612336449111353036594566487653467);
    rslt(7,2) = -static_cast<FP>(0.0033241050650855509686749759525729934387);
    rslt(7,3) = -static_cast<FP>(0.0011817666217151396788188414986578400815);
    rslt(7,4) = -static_cast<FP>(0.00023516266082934481714218409116876306015);
    rslt(7,5) = -static_cast<FP>(0.000018203292710092330842647094717595423203);
    rslt(7,6) = -static_cast<FP>(1.6782629219596444873568511693180345006e-7);
    rslt(7,7) = 0;
    rslt(7,8) = static_cast<FP>(1.6782629219596444873568511693180345006e-7);
    rslt(7,9) = static_cast<FP>(0.000018203292710092330842647094717595423203);
    rslt(7,10) = static_cast<FP>(0.00023516266082934481714218409116876306015);
    rslt(7,11) = static_cast<FP>(0.0011817666217151396788188414986578400815);
    rslt(7,12) = static_cast<FP>(0.0033241050650855509686749759525729934387);
    rslt(7,13) = static_cast<FP>(0.0060989612336449111353036594566487653467);
    rslt(7,14) = static_cast<FP>(0.0078125000000000000000000000000000000000);
    rslt(8,0) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(8,1) = static_cast<FP>(0.0029434987433402882637403846164373617881);
    rslt(8,2) = static_cast<FP>(0.0014710528531089345652702873199897845739);
    rslt(8,3) = static_cast<FP>(0.00045115104230367376419827273873006712188);
    rslt(8,4) = static_cast<FP>(0.000071284058467304210524826520153654606569);
    rslt(8,5) = static_cast<FP>(3.8284988174784066376671643683059485880e-6);
    rslt(8,6) = static_cast<FP>(1.8071027919220408599147858780806058395e-8);
    rslt(8,7) = 0;
    rslt(8,8) = static_cast<FP>(1.8071027919220408599147858780806058395e-8);
    rslt(8,9) = static_cast<FP>(3.8284988174784066376671643683059485880e-6);
    rslt(8,10) = static_cast<FP>(0.000071284058467304210524826520153654606569);
    rslt(8,11) = static_cast<FP>(0.00045115104230367376419827273873006712188);
    rslt(8,12) = static_cast<FP>(0.0014710528531089345652702873199897845739);
    rslt(8,13) = static_cast<FP>(0.0029434987433402882637403846164373617881);
    rslt(8,14) = static_cast<FP>(0.0039062500000000000000000000000000000000);
    rslt(9,0) = -static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(9,1) = -static_cast<FP>(0.0014206000858391905420559863470015204938);
    rslt(9,2) = -static_cast<FP>(0.00065100123319484874012722737934237597104);
    rslt(9,3) = -static_cast<FP>(0.00017223135197056962793813401237973457460);
    rslt(9,4) = -static_cast<FP>(0.000021608094472351537241506321163862204958);
    rslt(9,5) = -static_cast<FP>(8.0520614752885620218268113546617914903e-7);
    rslt(9,6) = -static_cast<FP>(1.9458336699468356721851373464979018337e-9);
    rslt(9,7) = 0;
    rslt(9,8) = static_cast<FP>(1.9458336699468356721851373464979018337e-9);
    rslt(9,9) = static_cast<FP>(8.0520614752885620218268113546617914903e-7);
    rslt(9,10) = static_cast<FP>(0.000021608094472351537241506321163862204958);
    rslt(9,11) = static_cast<FP>(0.00017223135197056962793813401237973457460);
    rslt(9,12) = static_cast<FP>(0.00065100123319484874012722737934237597104);
    rslt(9,13) = static_cast<FP>(0.0014206000858391905420559863470015204938);
    rslt(9,14) = static_cast<FP>(0.0019531250000000000000000000000000000000);
    rslt(10,0) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(10,1) = static_cast<FP>(0.00068561422302364104081007711279477439881);
    rslt(10,2) = static_cast<FP>(0.00028809475113388760934559539684030914967);
    rslt(10,3) = static_cast<FP>(0.000065751014228275639159789596983605730770);
    rslt(10,4) = static_cast<FP>(6.5499882689791869263632453373778169995e-6);
    rslt(10,5) = static_cast<FP>(1.6935017377001422534621765258021886374e-7);
    rslt(10,6) = static_cast<FP>(2.0952148865154938970617003441656979667e-10);
    rslt(10,7) = 0;
    rslt(10,8) = static_cast<FP>(2.0952148865154938970617003441656979667e-10);
    rslt(10,9) = static_cast<FP>(1.6935017377001422534621765258021886374e-7);
    rslt(10,10) = static_cast<FP>(6.5499882689791869263632453373778169995e-6);
    rslt(10,11) = static_cast<FP>(0.000065751014228275639159789596983605730770);
    rslt(10,12) = static_cast<FP>(0.00028809475113388760934559539684030914967);
    rslt(10,13) = static_cast<FP>(0.00068561422302364104081007711279477439881);
    rslt(10,14) = static_cast<FP>(0.00097656250000000000000000000000000000000);
    rslt(11,0) = -static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(11,1) = -static_cast<FP>(0.00033089316796333190397254726546471208343);
    rslt(11,2) = -static_cast<FP>(0.00012749374563174543213236625765987039584);
    rslt(11,3) = -static_cast<FP>(0.000025101096998795202910872150734334930935);
    rslt(11,4) = -static_cast<FP>(1.9854756919292590242455607272719873942e-6);
    rslt(11,5) = -static_cast<FP>(3.5617563830020592980475439126664052159e-8);
    rslt(11,6) = -static_cast<FP>(2.2560640657410744153480378051387336780e-11);
    rslt(11,7) = 0;
    rslt(11,8) = static_cast<FP>(2.2560640657410744153480378051387336780e-11);
    rslt(11,9) = static_cast<FP>(3.5617563830020592980475439126664052159e-8);
    rslt(11,10) = static_cast<FP>(1.9854756919292590242455607272719873942e-6);
    rslt(11,11) = static_cast<FP>(0.000025101096998795202910872150734334930935);
    rslt(11,12) = static_cast<FP>(0.00012749374563174543213236625765987039584);
    rslt(11,13) = static_cast<FP>(0.00033089316796333190397254726546471208343);
    rslt(11,14) = static_cast<FP>(0.00048828125000000000000000000000000000000);
    rslt(12,0) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(12,1) = static_cast<FP>(0.00015969664124227828959493377352088061583);
    rslt(12,2) = static_cast<FP>(0.000056421212504694700941865909634868545242);
    rslt(12,3) = static_cast<FP>(9.5825908989852761895014006146088160663e-6);
    rslt(12,4) = static_cast<FP>(6.0185050130728657755851462813467117568e-7);
    rslt(12,5) = static_cast<FP>(7.4910513815499620770990334063519483907e-9);
    rslt(12,6) = static_cast<FP>(2.4292616005573174473955800208582681864e-12);
    rslt(12,7) = 0;
    rslt(12,8) = static_cast<FP>(2.4292616005573174473955800208582681864e-12);
    rslt(12,9) = static_cast<FP>(7.4910513815499620770990334063519483907e-9);
    rslt(12,10) = static_cast<FP>(6.0185050130728657755851462813467117568e-7);
    rslt(12,11) = static_cast<FP>(9.5825908989852761895014006146088160663e-6);
    rslt(12,12) = static_cast<FP>(0.000056421212504694700941865909634868545242);
    rslt(12,13) = static_cast<FP>(0.00015969664124227828959493377352088061583);
    rslt(12,14) = static_cast<FP>(0.00024414062500000000000000000000000000000);
    rslt(13,0) = -static_cast<FP>(0.00012207031250000000000000000000000000000);
    rslt(13,1) = -static_cast<FP>(0.000077073266217727012896779304414228720788);
    rslt(13,2) = -static_cast<FP>(0.000024968701050597069322566848680681851211);
    rslt(13,3) = -static_cast<FP>(3.6582484160641620857851721076969202595e-6);
    rslt(13,4) = -static_cast<FP>(1.8243689781558802713755280767737046590e-7);
    rslt(13,5) = -static_cast<FP>(1.5755106404476723880344501966912083714e-9);
    rslt(13,6) = -static_cast<FP>(2.6157554714669994495639334798801393944e-13);
    rslt(13,7) = 0;
    rslt(13,8) = static_cast<FP>(2.6157554714669994495639334798801393944e-13);
    rslt(13,9) = static_cast<FP>(1.5755106404476723880344501966912083714e-9);
    rslt(13,10) = static_cast<FP>(1.8243689781558802713755280767737046590e-7);
    rslt(13,11) = static_cast<FP>(3.6582484160641620857851721076969202595e-6);
    rslt(13,12) = static_cast<FP>(0.0000249687010505