from netCDF4 import Dataset
import matplotlib.pyplot as plt
import numpy as np
from mpl_toolkits.axes_grid1 import make_axes_locatable
import xarray

def get_ind(arr,val) :
  return np.argmin(np.abs(arr-val))

t1 = 40
t2 = 49
prefixes = ["/lustre/storm/nwp501/scratch/imn/portUrb/build/cubes_periodic_z0-1.000e-05_",\
            "/lustre/storm/nwp501/scratch/imn/portUrb/build/cubes_periodic_z0-1.000e-06_",\
            "/lustre/storm/nwp501/scratch/imn/portUrb/build/cubes_periodic_z0-1.000e-07_"]
fnames = [ [f"{prefix}{i:08}.nc" for i in range(t1,t2+1)] for prefix in prefixes]

u0 = [0. for i in range(len(prefixes))]
u1 = [0. for i in range(len(prefixes))]
u2 = [0. for i in range(len(prefixes))]
u3 = [0. for i in range(len(prefixes))]
for k in range(len(prefixes)) :
  nc   = xarray.open_dataset(fnames[k][0])
  x    = np.array(nc["x"])
  y    = np.array(nc["y"])
  z    = np.array(nc["z"])
  nx   = len(x)
  ny   = len(y)
  nz   = len(z)
  dx   = x[1]-x[0]
  dy   = y[1]-y[0]
  dz   = z[1]-z[0]
  xlen = x[-1]+dx/2
  ylen = y[-1]+dy/2
  zlen = z[-1]+dz/2
  k2   = get_ind(z,.02*3)
  p0_x = [get_ind(x,2*xlen/8),get_ind(x,6*xlen/8),get_ind(x,2*xlen/8),get_ind(x,6*xlen/8)];
  p0_y = [get_ind(y,6*ylen/8),get_ind(y,4*ylen/8),get_ind(y,2*ylen/8),get_ind(y,0*ylen/8)];
  p1_x = [get_ind(x,4*ylen/8),get_ind(x,0*ylen/8),get_ind(x,4*ylen/8),get_ind(x,0*ylen/8)];
  p1_y = [get_ind(y,6*ylen/8),get_ind(y,4*ylen/8),get_ind(y,2*ylen/8),get_ind(y,0*ylen/8)];
  p2_x = [get_ind(x,2*xlen/8),get_ind(x,6*xlen/8),get_ind(x,2*xlen/8),get_ind(x,6*xlen/8)];
  p2_y = [get_ind(y,4*ylen/8),get_ind(y,2*ylen/8),get_ind(y,0*ylen/8),get_ind(y,6*ylen/8)];
  p3_x = [get_ind(x,4*xlen/8),get_ind(x,0*xlen/8),get_ind(x,4*xlen/8),get_ind(x,0*xlen/8)];
  p3_y = [get_ind(y,4*ylen/8),get_ind(y,2*ylen/8),get_ind(y,0*ylen/8),get_ind(y,6*ylen/8)];

  for i in range(len(fnames[k])) :
    nc = xarray.open_dataset(fnames[k][i])
    for j in range(len(p0_x)) :
      u = np.array(nc["avg_u"][:,p0_y[j],p0_x[j]])
      u0[k] += u
      u = np.array(nc["avg_u"][:,p1_y[j],p1_x[j]])
      u1[k] += u
      u = np.array(nc["avg_u"][:,p2_y[j],p2_x[j]])
      u2[k] += u
      u = np.array(nc["avg_u"][:,p3_y[j],p3_x[j]])
      u3[k] += u
  u0[k] /= len(fnames[k])*len(p0_x)
  u1[k] /= len(fnames[k])*len(p0_x)
  u2[k] /= len(fnames[k])*len(p0_x)
  u3[k] /= len(fnames[k])*len(p0_x)

p0_x = [0.390051457975986,\
        0.40377358490566,\
        0.420926243567753,\
        0.439794168096055,\
        0.453516295025729,\
        0.462092624356775,\
        0.472384219554031,\
        0.486106346483705,\
        0.494682675814751,\
        0.503259005145798,\
        0.511835334476844,\
        0.525557461406518,\
        0.534133790737564,\
        0.534133790737564,\
        0.540994854202402,\
        0.549571183533448,\
        0.559862778730703,\
        0.570154373927959,\
        0.577015437392796,\
        0.582161234991424,\
        0.585591766723842]
p0_y = [1.18628571428571,\
        1.23771428571429,\
        1.296,\
        1.392,\
        1.44,\
        1.49485714285714,\
        1.54971428571429,\
        1.59428571428571,\
        1.64228571428571,\
        1.70057142857143,\
        1.752,\
        1.78971428571429,\
        1.84114285714286,\
        1.84114285714286,\
        1.89257142857143,\
        1.94057142857143,\
        1.992,\
        2.04,\
        2.088,\
        2.14285714285714,\
        2.19428571428571]
p1_x = [-0.0355640535372849,\
        -0.0183556405353729,\
        -0.00114722753346083,\
        0.0103250478011472,\
        0.0122370936902486,\
        0.0141491395793499,\
        0.0198852772466539,\
        0.0217973231357552,\
        0.0217973231357552,\
        0.0237093690248566,\
        0.0237093690248566,\
        0.0237093690248566,\
        0.0313575525812619,\
        0.0523900573613766,\
        0.0906309751434034,\
        0.12887189292543,\
        0.169024856596558,\
        0.207265774378585,\
        0.253154875717017,\
        0.320076481835564,\
        0.356405353728489,\
        0.392734225621415,\
        0.419502868068834,\
        0.444359464627151,\
        0.444359464627151,\
        0.469216061185468,\
        0.492160611854684,\
        0.503632887189293,\
        0.526577437858509,\
        0.543785850860421,\
        0.55717017208413,\
        0.574378585086042]
p1_y = [0.252229299363057,\
        0.301910828025478,\
        0.351592356687898,\
        0.401273885350319,\
        0.439490445859873,\
        0.489171974522293,\
        0.538853503184713,\
        0.6,\
        0.653503184713376,\
        0.69171974522293,\
        0.74140127388535,\
        0.78343949044586,\
        0.844585987261147,\
        0.898089171974522,\
        0.943949044585987,\
        0.970700636942675,\
        0.997452229299363,\
        1.02420382165605,\
        1.04713375796178,\
        1.0968152866242,\
        1.15031847133758,\
        1.24203821656051,\
        1.34522292993631,\
        1.44458598726115,\
        1.44458598726115,\
        1.54777070063694,\
        1.64713375796178,\
        1.74649681528662,\
        1.84203821656051,\
        1.94904458598726,\
        2.05222929936306,\
        2.14777070063694]
p2_x = [0.148659003831418,\
        0.162068965517241,\
        0.169731800766283,\
        0.181226053639847,\
        0.19272030651341,\
        0.204214559386973,\
        0.238697318007663,\
        0.273180076628353,\
        0.294252873563218,\
        0.319157088122605,\
        0.361302681992337,\
        0.40536398467433,\
        0.436015325670498,\
        0.468582375478927,\
        0.493486590038314,\
        0.501149425287356,\
        0.531800766283525,\
        0.552873563218391,\
        0.564367816091954,\
        0.579693486590038,\
        0.602681992337165]
p2_y = [0.340996168582375,\
        0.409961685823755,\
        0.494252873563218,\
        0.597701149425287,\
        0.685823754789272,\
        0.781609195402299,\
        0.896551724137931,\
        1,\
        1.03831417624521,\
        1.09195402298851,\
        1.14176245210728,\
        1.24521072796935,\
        1.34865900383142,\
        1.44444444444444,\
        1.54406130268199,\
        1.64367816091954,\
        1.73563218390805,\
        1.83908045977012,\
        1.9272030651341,\
        2.03831417624521,\
        2.13409961685824]
p3_x = [0.0178387650085763,\
        0.0590051457975986,\
        0.0864493996569468,\
        0.115608919382504,\
        0.0950257289879931,\
        0.124185248713551,\
        0.143053173241852,\
        0.14819897084048,\
        0.153344768439108,\
        0.161921097770154,\
        0.179073756432247,\
        0.191080617495712,\
        0.232246998284734,\
        0.251114922813036,\
        0.269982847341338,\
        0.290566037735849,\
        0.307718696397942,\
        0.306003430531732,\
        0.328301886792453,\
        0.343739279588336,\
        0.376329331046312,\
        0.410634648370497,\
        0.436363636363636,\
        0.467238421955403,\
        0.475814751286449,\
        0.49811320754717,\
        0.52041166380789,\
        0.534133790737564,\
        0.556432246998285,\
        0.570154373927959]
p3_y = [0.257142857142857,\
        0.308571428571429,\
        0.325714285714286,\
        0.401142857142857,\
        0.353142857142857,\
        0.449142857142857,\
        0.504,\
        0.558857142857143,\
        0.6,\
        0.641142857142857,\
        0.699428571428571,\
        0.754285714285714,\
        0.850285714285714,\
        0.891428571428571,\
        0.949714285714286,\
        1.00114285714286,\
        1.07314285714286,\
        1.04228571428571,\
        1.09714285714286,\
        1.152,\
        1.25485714285714,\
        1.34742857142857,\
        1.45028571428571,\
        1.55657142857143,\
        1.64914285714286,\
        1.752,\
        1.85142857142857,\
        1.95428571428571,\
        2.05714285714286,\
        2.15657142857143]

for k in range(len(prefixes)) :
  plt.plot(u0[k]/10,z/.02,label=f"${k}$")
plt.scatter(p0_x,p0_y,label="Experiment",facecolors='none',edgecolors='r',s=35)
plt.xlim(-0.2,0.8)
plt.ylim(0,3)
plt.grid()
plt.legend()
plt.show()
plt.close()

for k in range(len(prefixes)) :
  plt.plot(u1[k]/10,z/.02,label=f"${k}$")
plt.scatter(p1_x,p1_y,label="Experiment",facecolors='none',edgecolors='r',s=35)
plt.xlim(-0.2,0.8)
plt.ylim(0,3)
plt.grid()
plt.legend()
plt.show()
plt.close()

for k in range(len(prefixes)) :
  plt.plot(u2[k]/10,z/.02,label=f"${k}$")
plt.scatter(p2_x,p2_y,label="Experiment",facecolors='none',edgecolors='r',s=35)
plt.xlim(-0.2,0.8)
plt.ylim(0,3)
plt.grid()
plt.legend()
plt.show()
plt.close()

for k in range(len(prefixes)) :
  plt.plot(u3[k]/10,z/.02,label=f"${k}$")
plt.scatter(p3_x,p3_y,label="Experiment",facecolors='none',edgecolors='r',s=35)
plt.xlim(-0.2,0.8)
plt.ylim(0,3)
plt.grid()
plt.legend()
plt.show()
plt.close()

