function dfdt= time_derivative(f,t)
% Calculate the time derivative of physical quantity f. Central difference has been used. 
% The first value has been obtained by first order forward difference.
% The last value has been obtained by first order backward difference.
% input: f: time series of physical quantity f. f can be scale or vector.
%        t: time series.
% output: dfdt: the time derivative of physical quantity f.
dfdt=[];
if length(f(:,1))~=length(t)
    disp('Error: Vectors must be the same length. This function returns an empty array.')
    return
end
% zero_rows=find(all(f==0,2));           % Find the rows whose all elements are zero.
% n=length(zero_rows)/2;
dfdt=zeros(size(f));
dfdt(1,:)=(f(2,:)-f(1,:))/(t(2)-t(1));
for ii=2:length(t)-1
    dfdt(ii,:)=(f(ii+1,:)-f(ii-1,:))/(t(ii+1)-t(ii-1));
end
dfdt(end,:)=(f(end,:)-f(end-1,:))/(t(end)-t(end-1));

