clear
clc
sp_num=7;       % The number of spacecrafts
% xc_x=-2:0.04:2;
xc_x=-5:0.08:5;                          % Trajectory of x component of the barycenter and y, z components are invariant constant.
t=repmat((1:length(xc_x))',1,sp_num);    % Time series of the spacecrafts. Columns represent the spacecrafts.
tc=mean(t,2);                            % Time series at the barycenter.
t_num=length(tc);                      % The number of time series.
% xc=[xc_x',zeros(t_num,1),zeros(t_num,1)];  % The Cartesian coordinates of the barycenter of the constellation in the Earth center reference frame.Rows represent the times.
xc=[xc_x',zeros(t_num,1),5*ones(t_num,1)];
[dB,ddB] = GetTheoryGradientsB(xc,'Fluxrope');  % Theory values of the linear and quadratic gradients of magnetic field.
c_num=5;
nondim_divB=zeros(t_num,c_num);
nondim_grad_divB=zeros(t_num,c_num);
L=zeros(1,c_num);
D=zeros(t_num,c_num);
for jj=1:5
    mult=[2,1,0.5,0.25,0.125];
    load x
%     x=(rand(sp_num,3)-0.5)/10;             % The Cartesian coordinates of the spacecrafts in the barycenter reference frame.
    x=mult(jj)*x/3;                                   % Regulate the size of the constellation.
    x=x-mean(x);                             % Ensure the barycenter at (0,0,0)
    x=repmat(permute(x,[3,2,1]),[t_num,1,1]);    % Rows represent the times. Columns represent the vector components. Pages represent the spacecrafts.
    x0=x+repmat(xc,[1,1,sp_num]);             % The Cartesian coordinates of the spacecrafts in the Earth center reference frame.
    B=zeros(t_num,3,sp_num);
    for ii=1:sp_num
        B(:,:,ii)=GetTheoryB(x0(:,:,ii),'Dipole'); % Theory values of magnetic field.
    end
    iteration_n=100;
    [R2,gB,GB,error_gB,error_GB] = ALQG7(x,B,tc,iteration_n,dB,ddB);
    [~,eigv]=eig(R2(:,:,1));
    L(jj)=2*sqrt(max(diag(eigv)));
    for nn=1:t_num
        divB=gB(1,1,nn)+gB(2,2,nn)+gB(3,3,nn);
        DD=sqrt(xc(nn,:)*xc(nn,:)');
        D(nn,jj)=DD;
        B0=GetTheoryB(xc(nn,:),'Dipole');   % Theory values of magnetic field.
        Norm_B0=sqrt(B0*B0');
        nondim_divB(nn,jj)=DD*divB/Norm_B0;
        grad_divB=[GB(1,1,1,nn)+GB(1,2,2,nn)+GB(1,3,3,nn),...
            GB(2,1,1,nn)+GB(2,2,2,nn)+GB(2,3,3,nn),...
            GB(3,1,1,nn)+GB(3,2,2,nn)+GB(3,3,3,nn)];
        Norm_grad_divB=sqrt(grad_divB*grad_divB');
        nondim_grad_divB(nn,jj)=DD^2*Norm_grad_divB/Norm_B0;
    end
end

L=round(L,4);
figure('Color','w','units','pixels','position',[50,50,900,500],'paperunits','centimeters','papersize',[21,29.7])
panel_width=0.36;
panel_height=0.8;
panel_gap=0.1;
left=0.1;
bottom=0.1;
subplot('position',[left,bottom,panel_width,panel_height]);
plot(tc,nondim_divB)
xlim([0,130])
ylim([-6 8]*1e-4)
legend(['L=' num2str(L(1)) ' R_E'],['L=' num2str(L(2)) ' R_E'],['L=' num2str(L(3)) ' R_E'],...
       ['L=' num2str(L(4)) ' R_E'],['L=' num2str(L(5)) ' R_E'],'Location','northeast')
xlabel('Time (s)')
ylabel({'$ (\overline{\nabla}\cdot \overline{\overrightarrow{B}})_c $'},'interpreter','latex')

subplot('position',[left+(panel_width+panel_gap),bottom,panel_width,panel_height]);
plot(tc,nondim_grad_divB)
xlim([0,130])
ylim([0 0.4])
legend(['L=' num2str(L(1)) ' R_E'],['L=' num2str(L(2)) ' R_E'],['L=' num2str(L(3)) ' R_E'],...
       ['L=' num2str(L(4)) ' R_E'],['L=' num2str(L(5)) ' R_E'], 'Location','northeast')
xlabel('Time (s)')
ylabel({'$ |\overline{\nabla}(\overline{\nabla}\cdot \overline{\overrightarrow{B}})_c| $'},'interpreter','latex')
print('Dipole_dimensionless','-dpdf','-bestfit')