function gf=linear_gradient(x,f)
%calculate the linear gradient of physical quantity f.
%input: x:The Cartesian coordinates of the spacecrafts in the barycenter
%         reference frame.The row represents one spacecraft.
%       f:the physical quantity at the positions of spacecrafts. It can be scale or vector.
%         The column represents one vector component. It can be one or three. 
%         The row represents one spacecraft.
%output: gf: the linear gradient of f.
N=length(x(:,1));
R=x'*x/N;
gf=R^(-1)*x'*f/N;
end