function Gfk=calculateGBk(x,fc,f,gf,G3f)
% Calculate quadratic gradient Grs (r,s=1,2), and return all components of quadratic gradient of physical scalar quantity f.
% input: x: The Cartesian coordinates of the spacecrafts in the barycenter reference frame.
%        fc: Magnitude of physical scalar quantity f at the barycenter.
%        f: Magnitude of physical scalar quantity f at the positions of spacecrafts.
%        gf: The linear gradients of physical scalar quantity f at the barycenter.
%        G3f: The gradient of the linear magnetic gradient along the x3 direction.
% output: Gfk: The quadratic gradient of physical scalar quantity f.
N=length(f);            % The number of spacecrafts
R2=x(:,1:2)'*x(:,1:2)/N; % The second-order volumetric tensor that is composed of x,y components. 
R3=zeros(2,2,3);
for m=1:2
    for l=1:2
        for kk=1:3
            for jj=1:N
                R3(m,l,kk)=R3(m,l,kk)+x(jj,m)*x(jj,l)*x(jj,kk);
            end
            R3(m,l,kk)=R3(m,l,kk)/N;
        end
    end
end
c1=fc*R2;
c2=sum(R3.*reshape(gf,1,1,3),3);
c3=(f.*x(:,1:2))'*x(:,1:2)/N;
c41=zeros(2);
for p=1:2
    for q=1:2
        for n=1:N
            for ii=1:2
                c41(p,q)=c41(p,q)+x(n,ii)*x(n,3)*x(n,p)*x(n,q)*G3f(ii);
            end
        end
        c41(p,q)=c41(p,q)/N;
    end
end
c42=zeros(2);
for p=1:2
    for q=1:2
        for n=1:N
                c42(p,q)=c42(p,q)+0.5*x(n,3)*x(n,3)*x(n,p)*x(n,q)*G3f(3);
        end
        c42(p,q)=c42(p,q)/N;
    end
end
c=2*(-c1-c2+c3-c41-c42);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Reconstruct equation to obtain Grs conveniently with matrix operation.
% Reconstruct the matrix c
c_double=(2-diag(ones(1,2))).*c;         %While i is not equal j, the value is doubled.
c_triangular_index=tril(true(size(c)));  %The indices of the lower triangular part of c.
c_reconstruct=c_double(c_triangular_index);   %The matrix c is reconstructed.
% Reconstruct the fourth-order volumetric tensor
R4_reconstruct=zeros(3,3);
m=1;
for ii=1:2
    for jj=ii:2
        n=1;
        for kk=1:2
            for l=kk:2
                for p=1:N
                    R4_reconstruct(m,n)=R4_reconstruct(m,n)+x(p,ii)*x(p,jj)*x(p,l)*x(p,kk);
                end
                R4_reconstruct(m,n)=R4_reconstruct(m,n)/N;
                if kk~=l
                    R4_reconstruct(m,n)=2*R4_reconstruct(m,n);
                end
                if ii~=jj
                    R4_reconstruct(m,n)=2*R4_reconstruct(m,n);
                end
                n=n+1;
            end
        end
        m=m+1;
    end
end
% Calculate reconstructed quadratic gradient Grs (r,s=1,2)
Gf_reconstruct=R4_reconstruct^(-1)*c_reconstruct;   % Calculate the reconstructed quadratic gradient (the elements of Grs).
% Reconstructed the quadratic gradient of f contained all components
Gfk=[Gf_reconstruct(1),Gf_reconstruct(2),G3f(1);
     Gf_reconstruct(2),Gf_reconstruct(3),G3f(2);
         G3f(1),           G3f(2),       G3f(3)];  
end