function v= STD(dBcdt,gB)
% Calculate the apparent velocity using STD method.
% input: dBcdt: Time derivative of the linear gradients of magnetic field at the barycenter.
%        gB: Linear gradients of magnetic field at the barycenter.
% output: v: The apparent velocity
gBgB=gB*gB';                                % Symmetrical matrix L
[V,D]=eig(gBgB);                            % The eigenvalues and eigenvectors of the symmetrical matrix L. 
[lambda,ind]=sort(diag(D),'descend');       % Sort eigenvalues in descending order
T=V(:,ind);                                 % Sort eigenvectors with eigenvalues
T(:,3)=cross(T(:,1),T(:,2));                % Orthogonal coordinate system
k=T';                                       % Transformation matrix from the original to the MDD eigenvector-based coordinate system.k=[k1;k2;k2]
a=dBcdt*gB'*k';
b=(k^-1)'*(gB*gB')*k';
v_MDD=-a*b^-1;                              % Calcilate the velocity in the eigenvector coordinate system with matrix operation.
if lambda(2)>100*lambda(3)                  % If lambda2 >> lambda3, it can be regarded as a quasi-2-D structure.
    v_MDD(3)=0;
end
if lambda(1)>100*lambda(2)                  % If lambda1 >> lambda2, it can be regarded as a quasi-1-D structure.
    v_MDD(2:3)=0;
end    
v=v_MDD*(k')^-1;                            % Transform velocity from the eigenvector to original coordinate system.
end

