function X3= MRA(Bc,gB)
% Calculate the magnetic rotational tensor and its eigenvectors.
% input: Bc: magnetic field vector at the barycenter of the constellation.
%        gB: Linear gradient of magnetic field vector at the barycenter of the constellation.
%        X3: Eigenvector that corresponds to the minimum value of eigenvalues
Btc=sqrt(sum(Bc.*Bc,2));            % Magnitude of magnetic field
gb=gB/Btc-gB*(Bc'*Bc)/Btc^3;        % Gradient of the magnetic unit vector
S=gb*gb';                           % The magnetic rotational tensor
[V,D]=eig(S);                       % Calculate eigenvalues and eigenvectors
[~,index]=min(diag(D));             % Find the minimum eigenvalue and returns the index into eigenvalues 
                                    % that corresponds to the minimum value of eigenvalues
X3=(V(:,index))';                   % Returns the eigenvector that corresponds to the minimum value of eigenvalues
end