function [dB,ddB] = GetTheoryGradientsB(xc,ModelOption)
% Return the theory values of the linear and quadratic gradients of magnetic field with different model.
% input: xc: The Cartesian coordinates of the barycenter of the constellation in the Earth center reference frame.
%           xc can be a row vector or a matrix.
%           If xc is a matrix, columns represent the vector components and rows can represent times.       
%        ModelOption: 'Diople' or 'Fluxrope'
% output: dB: The linear gradients that correspond to xc.
%         ddB: The quadratic gradients that correspond to xc.
switch ModelOption
    case 'Dipole'
        [dB,ddB]= DipoleGradients(xc);
    case 'Fluxrope'
        [dB,ddB]=FluxropeGradients(xc);
    otherwise
        dB=[];
        ddB=[];
        warning('Unexpected magntic field model. The B is a empty array.')
end