function B = GetTheoryB(x,ModelOption)
% Return the theory values of magnetic field with different model.
% input: x: The Cartesian coordinates of the spacecrafts in the Earth center reference frame.
%           x can be a row vector or a matrix.
%           If x is a matrix, columns represent the vector components and rows can represent times.       
%        ModelOption: 'Diople' or 'Fluxrope'
% output: B: The magnetic field that corresponds to x.
switch ModelOption
    case 'Dipole'
        B=DipoleB(x);
    case 'Fluxrope'
        B=FluxropeB(x);
    otherwise
        B=[];
        warning('Unexpected magntic field model. The B is a empty array.')
end

