function [dB_fluxrope,ddB_fluxrope]=FluxropeGradients(xc)
%calculate the theoretical linear and quadratic gradients 
%of magnetic field of flux rope at the barycenter of the constellation.
%input: xc:%The Cartesian coordinates of the barycenter of the constellation in the Earth center reference frame.
%output: dB_fluxrope: the theoretical linear gradients at the barycenter
%        ddB_fluxrope: the theoretical quadratic gradients at the barycenter
B0=60;     %unit: nT
alpha=1;   %unit: 1/Re
syms xx yy zz
Bx=-B0*besselj(1,alpha*sqrt(xx^2+yy^2))*yy/sqrt(xx^2+yy^2);
By=B0*besselj(1,alpha*sqrt(xx^2+yy^2))*xx/sqrt(xx^2+yy^2);
Bz=B0*besselj(0,alpha*sqrt(xx^2+yy^2));
dB=[diff(Bx,xx) diff(By,xx) diff(Bz,xx);
    diff(Bx,yy) diff(By,yy) diff(Bz,yy);
    diff(Bx,zz) diff(By,zz) diff(Bz,zz)];
dB=simplify(dB);
ddBx=[diff(Bx,xx,2)  diff(Bx,yy,xx) diff(Bx,zz,xx);
      diff(Bx,xx,yy) diff(Bx,yy,2)  diff(Bx,zz,yy);
      diff(Bx,xx,zz) diff(Bx,yy,zz) diff(Bx,zz,2)  ];
ddBx=simplify(ddBx);
ddBy=[diff(By,xx,2)  diff(By,yy,xx) diff(By,zz,xx);
      diff(By,xx,yy) diff(By,yy,2)  diff(By,zz,yy);
      diff(By,xx,zz) diff(By,yy,zz) diff(By,zz,2)  ];
ddBy=simplify(ddBy);
ddBz=[diff(Bz,xx,2)  diff(Bz,yy,xx) diff(Bz,zz,xx);
      diff(Bz,xx,yy) diff(Bz,yy,2)  diff(Bz,zz,yy);
      diff(Bz,xx,zz) diff(Bz,yy,zz) diff(Bz,zz,2)  ];
ddBz=simplify(ddBz);
n=length(xc(:,1));
dB_fluxrope=zeros(3,3,n);
ddB_fluxrope=zeros(3,3,3,n);
for ii=1:n
    xx=xc(ii,1);
    yy=xc(ii,2);
    zz=xc(ii,3);
    dB_fluxrope(:,:,ii)=eval(dB);
    ddB_fluxrope(:,:,1,ii)=eval(ddBx);
    ddB_fluxrope(:,:,2,ii)=eval(ddBy);
    ddB_fluxrope(:,:,3,ii)=eval(ddBz);
end
end