function B_fluxrope=FluxropeB(x)
%calculte the magnetic field of flux rope
%input:  x:The Cartesian coordinates of the spacecrafts in the Earth center reference frame.
%output: B_dipole: The dipole field at the position of the spacecrafts in the Cartesian coordinates
B0=60;     %unit: nT
alpha=1;   %unit: 1/Re
r=sqrt(x(:,1).^2+x(:,2).^2);
Bx=-B0*besselj(1,alpha*r).*x(:,2)./r;
By=B0*besselj(1,alpha*r).*x(:,1)./r;
Bz=B0*besselj(0,alpha*r);
B_fluxrope=[Bx,By,Bz];
end

