function [dB_dipole,ddB_dipole,db_dipole]= DipoleGradients(xc)
%calculate the tTheoretical linear and quadratic gradients 
%of diople field at the barycenter of the constellation.
%input: xc:%The Cartesian coordinates of the barycenter of the constellation in the Earth center reference frame.
%output: dB_dipole: the theoretical linear gradients at the barycenter
%        ddB_dipole: the theoretical quadratic gradients at the barycenter
B0=30008;   %unit:nT. B0=mu0*M/(4*pi*Re^3). Magnetic field at the Earth equator. Magnetic Moment in year 2005: M2005=7.76*10^22 Am^2.
syms xx yy zz
Bx=-3*B0*xx*zz/(sqrt(xx^2+yy^2+zz^2))^5;
By=-3*B0*yy*zz/(sqrt(xx^2+yy^2+zz^2))^5;
Bz=B0*(xx^2+yy^2-2*zz^2)/(sqrt(xx^2+yy^2+zz^2))^5;
dB=[diff(Bx,xx) diff(By,xx) diff(Bz,xx);
    diff(Bx,yy) diff(By,yy) diff(Bz,yy);
    diff(Bx,zz) diff(By,zz) diff(Bz,zz)];
dB=simplify(dB);
ddBx=[diff(Bx,xx,2)  diff(Bx,yy,xx) diff(Bx,zz,xx);
      diff(Bx,xx,yy) diff(Bx,yy,2)  diff(Bx,zz,yy);
      diff(Bx,xx,zz) diff(Bx,yy,zz) diff(Bx,zz,2)  ];
ddBx=simplify(ddBx);
ddBy=[diff(By,xx,2)  diff(By,yy,xx) diff(By,zz,xx);
      diff(By,xx,yy) diff(By,yy,2)  diff(By,zz,yy);
      diff(By,xx,zz) diff(By,yy,zz) diff(By,zz,2)  ];
ddBy=simplify(ddBy);
ddBz=[diff(Bz,xx,2)  diff(Bz,yy,xx) diff(Bz,zz,xx);
      diff(Bz,xx,yy) diff(Bz,yy,2)  diff(Bz,zz,yy);
      diff(Bz,xx,zz) diff(Bz,yy,zz) diff(Bz,zz,2)  ];
ddBz=simplify(ddBz);
Bt=sqrt(Bx^2+By^2+Bz^2);
Bt=simplify(Bt);
bx=Bx/Bt;
by=By/Bt;
bz=Bz/Bt;
db=[diff(bx,xx) diff(by,xx) diff(bz,xx);
    diff(bx,yy) diff(by,yy) diff(bz,yy);
    diff(bx,zz) diff(by,zz) diff(bz,zz)];
db=simplify(db);
% B=[Bx,By,Bz];
% db1=dB/Bt-dB*(B'*B)/Bt^3;
% db1=simplify(db1);
n=length(xc(:,1));
dB_dipole=zeros(3,3,n);
db_dipole=zeros(3,3,n);
ddB_dipole=zeros(3,3,3,n);
for ii=1:n
    xx=xc(ii,1);
    yy=xc(ii,2);
    zz=xc(ii,3);
    dB_dipole(:,:,ii)=eval(dB);
    db_dipole(:,:,ii)=eval(db);
    % db_dipole1=eval(db1);
    ddB_dipole(:,:,1,ii)=eval(ddBx);
    ddB_dipole(:,:,2,ii)=eval(ddBy);
    ddB_dipole(:,:,3,ii)=eval(ddBz);
end
end