function B_dipole= DipoleB(x)
%calculte the dipole field
%input: x:The Cartesian coordinates of the spacecrafts in the Earth center reference frame.
%output: B_dipole: The dipole field at the position of the spacecrafts in the Cartesian coordinates
B0=30008;                     %unit:nT. B0=mu0*M/(4*pi*Re^3). Magnetic field at the Earth equator. Magnetic Moment in year 2005: M2005=7.76*10^22 Am^2.
r=sqrt(diag(x*x'));
Bx=-3*B0*x(:,1).*x(:,3)./r.^5;
By=-3*B0*x(:,2).*x(:,3)./r.^5;
Bz=B0*(x(:,1).^2+x(:,2).^2-2*x(:,3).^2)./r.^5;
B_dipole=[Bx,By,Bz];
end

