function [R2,gB,GB,error_gB,error_GB] = ALQG7(x,B,tc,iteration_n,dB,ddB)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% xc=mean(x0,3);                        
% x=x0-xc;
sp_num=length(x(1,1,:));
t_num=length(tc);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gB0=zeros(3,3,t_num);
R2=zeros(3,3,t_num);
R3=zeros(3,3,3,t_num);
for ii=1:t_num
    B_temp=permute(B(ii,:,:),[3,2,1]);                    % Columns represent the vector components and rows represent spacecrafts.
    x_temp=permute(x(ii,:,:),[3,2,1]);                    % Columns represent the vector components and rows represent spacecrafts.
    gB0(:,:,ii)=linear_gradient(x_temp,B_temp);           % Initial values of the linear gradients of magnetic field at the barycenter
    R2(:,:,ii)=x_temp'*x_temp/sp_num;                     % The second-order volumetric tensor.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate the third-order volumetric tensor.
    for m=1:3
        for l=1:3
            for k=1:3
                for n=1:sp_num
                    R3(m,l,k,ii)=R3(m,l,k,ii)+x_temp(n,m)*x_temp(n,l)*x_temp(n,k);
                end
                R3(m,l,k,ii)=R3(m,l,k,ii)/sp_num;
            end
        end
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Bc0=mean(B,3);                                            % Initial values of magnetic field at the barycenter.
Bc=Bc0;                                                   % Bc is values of magnetic field at the barycenter with interation.
gB=gB0;                                                   % gB is values of the linear gradients of magnetic field with interation.
error_gB=zeros(3,3,t_num,iteration_n);
error_GB=zeros(3,3,3,t_num,iteration_n);
for iter=1:iteration_n
    dBcdt=time_derivative(Bc,tc);                         % Time derivative of magnetic field at the barycenter.
    dgBdt=zeros(size(gB));
    for ii=1:3
        gB_temp=permute(gB(ii,:,:),[3,2,1]);
        dgBdt_temp=time_derivative(gB_temp,tc);           % Time derivative of the linear gradients of magnetic field at the barycenter.
        dgBdt(ii,:,:)=permute(dgBdt_temp,[3,2,1]);
    end
    GBx=zeros(size(gB));
    GBy=zeros(size(gB));
    GBz=zeros(size(gB));
    GB=zeros(3,3,3,t_num);
    error_gB_temp=zeros(size(gB));
    error_GB_temp=zeros(size(GB));
    for tt=1:t_num
%         v=-dBcdt(tt,:)*gB(:,:,tt)^-1;                     % The apparent velocity
        v= STD(dBcdt(tt,:),gB(:,:,tt));         % calculate the apparent velocity using STD method.      
        v_norm=sqrt(sum(v.*v,2));                         % Magnitude of The apparent velocity
        k3=-v/v_norm;                                     % The directional vector of the x3 axis in the constellation reference frame.
        X3=MRA(Bc(tt,:),gB(:,:,tt));                      % The characteristic direction corresponding to zero eigenvalue using MRA.
        k1=cross(X3,k3);                                  % The x1 axis in the constellation reference frame.
        k1=k1./sqrt(sum(k1.*k1,2));                       % Unit vector
        k2=cross(k3,k1);                                  % The x2 axis in the constellation reference frame and x1,x2,x3 are orthogonal.
        k=[k1;k2;k3];                                     % Transformation matrix from the original to the new Cartesian coordinate system.
        dgBdtk=k*dgBdt(:,:,tt)*k';                        % Transform the time derivative of the linear gradients to the new Cartesian coordinate system.
        G3Bk=dgBdtk/v_norm;                               % Calculate the gradient of the linear magnetic gradient along the x3 direction.
        Bk=permute(B(tt,:,:),[3,2,1])*k';                 % Transform the magnetic field to the new Cartesian coordinate system.
        Bck=Bc(tt,:)*k';                                  % Transform the magnetic field at the barycenter to the new Cartesian coordinate system.
        xk=permute(x(tt,:,:),[3,2,1])*k';                 % Transform the coordinates of the spacecrafts at the barycenter reference frame to the new Cartesian coordinate system.
                                                          % For Bk, Bck, xk, columns represent the vector components and rows represent spacecrafts.
        gBk=k*gB(:,:,tt)*k';                              % Transform the linear gradients to the new Cartesian coordinate system.
        GBk(:,:,1)=calculateGBk(xk,Bck(1),Bk(:,1),gBk(:,1),G3Bk(:,1)); % Calculate the quadratic gradient of the x component of magnetic field in the new Cartesian coordinate system.
        GBk(:,:,2)=calculateGBk(xk,Bck(2),Bk(:,2),gBk(:,2),G3Bk(:,2)); % Calculate the quadratic gradient of the y component of magnetic field in the new Cartesian coordinate system.
        GBk(:,:,3)=calculateGBk(xk,Bck(3),Bk(:,3),gBk(:,3),G3Bk(:,3)); % Calculate the quadratic gradient of the z component of magnetic field in the new Cartesian coordinate system.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Transform the quadratic gradients from the new to original Cartesian coordinate system 
        GB_temp=zeros(size(GBk));
        for ii=1:length(GBk(1,1,:))
            GB_temp(:,:,ii)=k^-1*GBk(:,:,ii)*(k^-1)';
        end
        for ii=1:length(GB_temp(1,:,1))
            GB_temp(:,ii,:)=permute(permute(GB_temp(:,ii,:),[1,3,2])*(k^-1)',[1,3,2]);
        end
        GBx(:,:,tt)=GB_temp(:,:,1);
        GBy(:,:,tt)=GB_temp(:,:,2);
        GBz(:,:,tt)=GB_temp(:,:,3);
        GB(:,:,:,tt)=GB_temp;              % The quadratic gradients in the original Cartesian coordinate system.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Interation
        for ii=1:3
            Bc(tt,ii)=Bc0(tt,ii)-0.5*sum(R2(:,:,tt).*GB(:,:,ii,tt),'all');           %Iterate physical scalar quantity f at the barycenter.
            R3G=reshape(sum(R3(:,:,:,tt).*GB(:,:,ii,tt),[1,2]),[],1);
            gB(:,ii,tt)=gB0(:,ii,tt)-0.5*R2(:,:,tt)^(-1)*R3G;                        %Iterate the linear gradient of physical scalar quantity f at the barycenter.
        end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        error_gB_temp(:,:,tt)=100*abs((gB(:,:,tt)-dB(:,:,tt))./dB(:,:,tt));           %calculate relative errors of the linear gradient between algorithm and theory values.
        error_GB_temp(:,:,:,tt)=100*abs((GB(:,:,:,tt)-ddB(:,:,:,tt))./ddB(:,:,:,tt)); %calculate relative errors of the quadratic gradient between algorithm and theory values.
    end
    error_gB(:,:,:,iter)=error_gB_temp;
    error_GB(:,:,:,:,iter)=error_GB_temp;
end
end

