function [out] = viscosity_air(T)

% FUNCTION [OUT] = VISCOSITY_AIR(T)
% (Kg m-1 s-1) dynamic viscosity of air, Graf 2017, eq. C3.10
% Inputs: T, absolute temperature [K]
  
if T<160
  error('Input temperature should be in Kelvin');
end

out = ( 1.458e-6 .* (T.^1.5) ) ./ ( T + 110.4 ); 

% $$$ % molecular viscosity [units kg/(m*s)]
% $$$ % from Salamalikis et al (2016)
% $$$ out = 1.72e-5*(393./(T+120)).*(T/273.15).^1.5;
