function [out] = thermal_conductivity_air(T)

% FUNCTION [OUT] = THERMAL_CONDUCTIVITY_AIR(T)
%(J m-1 s-1 K-1) Thermal conductivity of moist air, Graf 2017...
%  ...(unit corrected from Pruppacher-Klett 2010), eq. C3.12
% Input: T, absolute temperature [K]

if T<160
  error('Input temperature should be in Kelvin');
end

out = (5.69+(.017.*(T-273.15))).*418.68e-5; 

% $$$ % thermal conductivity of air [units, J/(m*s*K)]
% $$$ % from Thompson microphysics
% $$$ out = 418.936e-5*(5.69 + 0.0168*(T-273.15)); % Thompson microphysics
