function [Df,ht,dDl,d18l,vf] = evap(Ta,rhs,dDv,dDva,d18v,d18va,dz,grid_no)



% clc
%clear all
%close all
%% %e.g. input values to test the code
%Ta=290; %cloud base temperature (K)
%rhs=.69; %Surface relative humidity from dropsonde
%dDv=-73; %mean dD vapor isotope ratio at flight level
%d18v=-11.7; %mean d18O vapor isotope ratio at flight level
%dDva=-70; %background dD vapor isotope ratio from nearest 150 m altitude
%d18va=-10.5; %background d18O vapor isotope ratio from nearest 150 m altitude
%grid_no=71; %Number of vertical levels from cloud base (700m) to surface
%dz=10; %vertical spacing (deltaz=1)

ht=[700:-dz:0]; %(m) Altitude from cloud base to surface
rh=linspace(1,rhs,length(ht)); %(fraction) linearly decreasing RH from cb to sf
Tas=linspace(Ta,9.8e-3*ht(1)+Ta,length(ht)); %(K) Air temperature using lapse rate =9.8K/km
esa=exp(54.842763-(6763.22./Tas)-(4.21.*log(Tas))+(.000367.*Tas)+(tanh(.0415.*(Tas-218.8)).*...
                                                  (53.878-(1331.22./Tas)-(9.44523.*log(Tas))+(.014025.*Tas)))); %saturation vapor pressure (Pa) (Graf 2017, C3.15)
pa=101325.*((1-(2.25577e-5.*ht)).^5.2559); %Air pressure(Pa) Salamalikis et al. (2019)
rhoa=(pa-(0.378.*rh.*esa))./(287*Tas); %(kg/m3) Air density, (Salamalikis et al. 2019)
Df=[2.25,2.75,3.25,3.75,4.5,5.75,6.85,7.55,9.05,11.35,13.75,17.5,22.5,27.5,...
    32.5,37.5,42.5,47.5,75,125,175,225,275,325,375,500,700,900,1100,1300,...
    1500,1700,2000,2400,2800,3200,3600,4000,4400,4800,5500,6500,7500,8500,...
    9500,12500,17500,22500,27500]'.*1e-6;%(m), bins from CIP+PIP stitched
Df(1:19)=NaN;Df(43:end)=NaN;% unusable bins
vf=(9.43.*(1-exp(-(((Df.*1e3)./1.77).^1.147))).*((1.2038./rhoa(1)).^.4)); %(m/s) Terminal velocity, +dn,-up, Graf 2017, eq. 3.10
Dva=.211e-4.*(101325./pa).*((Tas./273.15).^1.94); %(m2s-1) Diffusivity of vapor, Graf 2017, eq. C3.1
mua=(1.458e-6.*(Tas.^1.5))./(Tas+110.4); %(Kgm-1s-1) dynamic viscosity of air, Graf 2017, eq. C3.10
ka=(5.69+(.017.*(Tas-273.15))).*418.68e-5; %(Jm-1s-1K-1) Thermal conductivity of moist air, Graf 2017...
...(unit corrected from Pruppacher-Klett 2010), eq. C3.12
Pr=(mua.*1005)./ka; %Pratt Number, eq. C3.8


alphaDvl=exp((24844./(Tas.^2))-(76.248./Tas)+.05261); %Majoube (1971b)
alpha18vl=exp((1137./(Tas.^2))-(.4156./Tas)-.00207); %Majoube (1971b)

%Obtaining cloud base liquid isotope ratios from vapor measurements
dDl(1:49,1)=(alphaDvl(1).*(dDv+1e3))-1e3;
d18l(1:49,1)=(alpha18vl(1).*(d18v+1e3))-1e3;

z=1;
Sc=mua./(rhoa.*Dva);    %Schmidt number, Graf 2017, eq. C3.7
Re=(vf.*Df.*rhoa)./mua; %Reynolds number, Graf 2017, eq. C3.6

%Mass ventilation coefficient (eq. 3.2-3.3) Graf 2017
if(Df(:,1)<.12e-3)
  fv(:,z)=1+(.108.*(((Re(:,z).^.5).*(Sc(z).^(1/3))).^2));
  fh(:,z)=1+(.108.*(((Re(:,z).^.5).*(Pr(z).^(1/3))).^2));
else
  fv(:,z)=.708+(.308.*(((Re(:,z).^.5).*(Sc(z).^(1/3)))));
  fh(:,z)=.708+(.308.*(((Re(:,z).^.5).*(Pr(z).^(1/3)))));
end

%Assuming drop surface temperature equal to air temperature at cloud base
Tr(1:49,1)=Tas(1);
%Assuming esa=esr at cloud base
esr(1:49,1)=exp(54.842763-(6763.22./Tr(1))-(4.21.*log(Tr(1)))+(.000367.*Tr(1))+(tanh(.0415.*(Tr(1)-218.8)).*...
                                                  (53.878-(1331.22./Tr(1))-(9.44523.*log(Tr(1)))+(.014025.*Tr(1)))));



L=2.25e6;%(J/kg) Latent heat of vaporization
Rv=461;%specific gas constant for water vapor (J/kg/K)
cw=4187;%specific heat of liq water (J/Kg/K)
rhol=1e3;%J/kg, density of water


%dD/dz obtained from Salamalikis et al. 2016, 
%dTr/dz obtained from Graf et al. 2019
%dDl/dz & d18Ol/dz obtained from Salamalikis et al. 2016 with the
%correction using '12' instead of '3'

for z=2:grid_no
  x=(esr(:,z-1)./Tr(:,z-1))-((esa(z-1).*rh(z-1))./Tas(z-1));
  y=Tr(:,z-1)-Tas(z-1);
  
  dDdz(:,z)=-(4.*fv(:,z-1).*Dva(z-1).*x)./(Df(:,z-1).*vf(:,z-1).*rhol.*Rv);
  dTdz(:,z)=-((12.*fh(:,z-1).*ka(z-1))./((Df(:,z-1).^2).*vf(:,z-1).*rhol.*cw)).*(y+((Dva(z).*L.*x.*fv(:,z-1))./(fh(:,z-1).*ka(z-1).*Rv)));
  
  Df(:,z)=Df(:,z-1)+(dDdz(:,z).*dz);
  Tr(:,z)=Tr(:,z-1)+(dTdz(:,z).*dz);
  
  dDl(:,z)=dDl(:,z-1)+(((12.*esr(z-1).*fv(:,z-1).*Dva(z-1)./(rhol.*Rv.*(Df(:,z-1).^2).*Tr(:,z-1).*vf(:,z-1))).*...
                        (((.9755^.58).*(((dDva+1e3).*rh(z-1).*(esa(z-1).*Tr(:,z-1)./(esr(:,z-1).*Tas(z-1))))-((dDl(:,z-1)+1e3)./alphaDvl(1,z-1))))...
                         -((dDl(:,z-1)+1e3).*((rh(z-1).*((esa(z-1).*Tr(:,z-1))./(esr(:,z-1).*Tas(z-1))))-1)))).*dz);

  d18l(:,z)=d18l(:,z-1)+(((12.*esr(z-1).*fv(:,z-1).*Dva(z-1)./(rhol.*Rv.*(Df(:,z-1).^2).*Tr(:,z-1).*vf(:,z-1))).*...
                          (((.9723^.58).*(((d18va+1e3).*rh(z-1).*(esa(z-1).*Tr(:,z-1)./(esr(:,z-1).*Tas(z-1))))-((d18l(:,z-1)+1e3)./alpha18vl(1,z-1))))...
                           -((d18l(:,z-1)+1e3).*((rh(z-1).*((esa(z-1).*Tr(:,z-1))./(esr(:,z-1).*Tas(z-1))))-1)))).*dz);        


  esr(:,z)=exp(54.842763-(6763.22./Tr(:,z))-(4.21.*log(Tr(:,z)))+(.000367.*Tr(:,z))+(tanh(.0415.*(Tr(:,z)-218.8)).*...
                                                    (53.878-(1331.22./Tr(:,z))-(9.44523.*log(Tr(:,z)))+(.014025.*Tr(:,z)))));

  vf(:,z)=(9.43.*(1-exp(-(((Df(:,z).*1e3)./1.77).^1.147))).*((1.2038./rhoa(z)).^.4)); 
  Re(:,z)=(vf(:,z).*Df(:,z).*rhoa(z))./mua(z);

  
  if(Df(:,1)<.12e-3)
    fv(:,z)=1+(.108.*(((Re(:,z).^.5).*(Sc(z).^(1/3))).^2));
    fh(:,z)=1+(.108.*(((Re(:,z).^.5).*(Pr(z).^(1/3))).^2));
  else
    fv(:,z)=.708+(.308.*(((Re(:,z).^.5).*(Sc(z).^(1/3)))));
    fh(:,z)=.708+(.308.*(((Re(:,z).^.5).*(Pr(z).^(1/3)))));
  end    
end

%Drops with radius <0 is ignored and only the real part of Df, Tr, dDl and
%d18l are considered.

Df(Df<0)=NaN;
Df=real(Df);
Tr=real(Tr);
dDl=real(dDl);
d18l=real(d18l);

for i=1:42
  index=find(abs(diff(dDl(i,:)))'>.1,1,'first');    
  dDl(i,index+1:find(~isnan(dDl(i,:)),1,'last'))=NaN;
end
d18l(isnan(dDl))=NaN;
dDl(isnan(d18l))=NaN;

