function esat = es(T)

 %  saturation vapor pressure (Pa) (Graf 2017, C3.15)
 % NOTE: Looks like Murphy and Koop (2005, QJRMS)  
  esat = exp( ...
	      54.842763 - 6763.22./T - 4.21.*log(T) + .000367.*T ...
	     + tanh( .0415 .* (T-218.8) ) .* ...
		(53.878 - 1331.22./T - 9.44523.*log(T) + .014025.*T ) );


%	   %  es(Temp) = 611.2*exp(17.67*(Temp-273)/(Temp-29.5))  [Pa]
%%   Saturation vapor pressure (Wexler's formula)
%%   From Bolton, 1980, MWR, 108, 1046-1053.
%
%  esat = 611.2*exp(17.67*(Temp-273)./(Temp-29.5));
