function [out] = alpha18(T)

% FUNCTION [OUT] = ALPHA18(T)
% alpha18, equilibrium fractionation factor of H_2^18O over liquid
% (Majoube, 1971b)
  
if T<160
  error('Input temperature should be in Kelvin');
end

out = exp( (1137./(T.^2)) - (.4156./T) - .00207); %Majoube (1971b)
